# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDatastoreClusterDetails(object):
    """
    Details of the Datastore Cluster.
    """

    #: A constant which can be used with the datastore_cluster_type property of a CreateDatastoreClusterDetails.
    #: This constant has a value of "MANAGEMENT"
    DATASTORE_CLUSTER_TYPE_MANAGEMENT = "MANAGEMENT"

    #: A constant which can be used with the datastore_cluster_type property of a CreateDatastoreClusterDetails.
    #: This constant has a value of "WORKLOAD"
    DATASTORE_CLUSTER_TYPE_WORKLOAD = "WORKLOAD"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDatastoreClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param datastore_ids:
            The value to assign to the datastore_ids property of this CreateDatastoreClusterDetails.
        :type datastore_ids: list[str]

        :param display_name:
            The value to assign to the display_name property of this CreateDatastoreClusterDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDatastoreClusterDetails.
        :type compartment_id: str

        :param datastore_cluster_type:
            The value to assign to the datastore_cluster_type property of this CreateDatastoreClusterDetails.
            Allowed values for this property are: "MANAGEMENT", "WORKLOAD"
        :type datastore_cluster_type: str

        :param availability_domain:
            The value to assign to the availability_domain property of this CreateDatastoreClusterDetails.
        :type availability_domain: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDatastoreClusterDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDatastoreClusterDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'datastore_ids': 'list[str]',
            'display_name': 'str',
            'compartment_id': 'str',
            'datastore_cluster_type': 'str',
            'availability_domain': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'datastore_ids': 'datastoreIds',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'datastore_cluster_type': 'datastoreClusterType',
            'availability_domain': 'availabilityDomain',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._datastore_ids = None
        self._display_name = None
        self._compartment_id = None
        self._datastore_cluster_type = None
        self._availability_domain = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def datastore_ids(self):
        """
        Gets the datastore_ids of this CreateDatastoreClusterDetails.
        The `OCIDs`__ of the Datastores that belong to the Datastore Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The datastore_ids of this CreateDatastoreClusterDetails.
        :rtype: list[str]
        """
        return self._datastore_ids

    @datastore_ids.setter
    def datastore_ids(self, datastore_ids):
        """
        Sets the datastore_ids of this CreateDatastoreClusterDetails.
        The `OCIDs`__ of the Datastores that belong to the Datastore Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param datastore_ids: The datastore_ids of this CreateDatastoreClusterDetails.
        :type: list[str]
        """
        self._datastore_ids = datastore_ids

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateDatastoreClusterDetails.
        A descriptive name for the Datastore Cluster. It must be unique within a SDDC, start with a letter, and contain only letters, digits,
        whitespaces, dashes and underscores.
        Avoid entering confidential information.


        :return: The display_name of this CreateDatastoreClusterDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDatastoreClusterDetails.
        A descriptive name for the Datastore Cluster. It must be unique within a SDDC, start with a letter, and contain only letters, digits,
        whitespaces, dashes and underscores.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreateDatastoreClusterDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateDatastoreClusterDetails.
        The `OCID`__ of the compartment to contain the Datastore Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateDatastoreClusterDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateDatastoreClusterDetails.
        The `OCID`__ of the compartment to contain the Datastore Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateDatastoreClusterDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def datastore_cluster_type(self):
        """
        **[Required]** Gets the datastore_cluster_type of this CreateDatastoreClusterDetails.
        Type of the datastore.

        Allowed values for this property are: "MANAGEMENT", "WORKLOAD"


        :return: The datastore_cluster_type of this CreateDatastoreClusterDetails.
        :rtype: str
        """
        return self._datastore_cluster_type

    @datastore_cluster_type.setter
    def datastore_cluster_type(self, datastore_cluster_type):
        """
        Sets the datastore_cluster_type of this CreateDatastoreClusterDetails.
        Type of the datastore.


        :param datastore_cluster_type: The datastore_cluster_type of this CreateDatastoreClusterDetails.
        :type: str
        """
        allowed_values = ["MANAGEMENT", "WORKLOAD"]
        if not value_allowed_none_or_none_sentinel(datastore_cluster_type, allowed_values):
            raise ValueError(
                f"Invalid value for `datastore_cluster_type`, must be None or one of {allowed_values}"
            )
        self._datastore_cluster_type = datastore_cluster_type

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this CreateDatastoreClusterDetails.
        The availability domain to create the Datastore Cluster in.


        :return: The availability_domain of this CreateDatastoreClusterDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this CreateDatastoreClusterDetails.
        The availability domain to create the Datastore Cluster in.


        :param availability_domain: The availability_domain of this CreateDatastoreClusterDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDatastoreClusterDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateDatastoreClusterDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDatastoreClusterDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateDatastoreClusterDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDatastoreClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateDatastoreClusterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDatastoreClusterDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateDatastoreClusterDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
