# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ForcePatchClusterDetails(object):
    """
    force patching a cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ForcePatchClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cluster_id:
            The value to assign to the cluster_id property of this ForcePatchClusterDetails.
        :type cluster_id: str

        :param flex_shape:
            The value to assign to the flex_shape property of this ForcePatchClusterDetails.
        :type flex_shape: str

        """
        self.swagger_types = {
            'cluster_id': 'str',
            'flex_shape': 'str'
        }
        self.attribute_map = {
            'cluster_id': 'clusterId',
            'flex_shape': 'flexShape'
        }
        self._cluster_id = None
        self._flex_shape = None

    @property
    def cluster_id(self):
        """
        **[Required]** Gets the cluster_id of this ForcePatchClusterDetails.
        OCID of the Opensearch Cluster.


        :return: The cluster_id of this ForcePatchClusterDetails.
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """
        Sets the cluster_id of this ForcePatchClusterDetails.
        OCID of the Opensearch Cluster.


        :param cluster_id: The cluster_id of this ForcePatchClusterDetails.
        :type: str
        """
        self._cluster_id = cluster_id

    @property
    def flex_shape(self):
        """
        Gets the flex_shape of this ForcePatchClusterDetails.
        flex shape name for the instances in the cluster


        :return: The flex_shape of this ForcePatchClusterDetails.
        :rtype: str
        """
        return self._flex_shape

    @flex_shape.setter
    def flex_shape(self, flex_shape):
        """
        Sets the flex_shape of this ForcePatchClusterDetails.
        flex shape name for the instances in the cluster


        :param flex_shape: The flex_shape of this ForcePatchClusterDetails.
        :type: str
        """
        self._flex_shape = flex_shape

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
