# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReclaimClusterDetails(object):
    """
    Reclaim Clusters from de-activated customer tenant accounts
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReclaimClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tenant_id:
            The value to assign to the tenant_id property of this ReclaimClusterDetails.
        :type tenant_id: str

        :param is_reclamation_run:
            The value to assign to the is_reclamation_run property of this ReclaimClusterDetails.
        :type is_reclamation_run: bool

        """
        self.swagger_types = {
            'tenant_id': 'str',
            'is_reclamation_run': 'bool'
        }
        self.attribute_map = {
            'tenant_id': 'tenantId',
            'is_reclamation_run': 'isReclamationRun'
        }
        self._tenant_id = None
        self._is_reclamation_run = None

    @property
    def tenant_id(self):
        """
        **[Required]** Gets the tenant_id of this ReclaimClusterDetails.
        The tenant ID of the customer whose account has been de-activated


        :return: The tenant_id of this ReclaimClusterDetails.
        :rtype: str
        """
        return self._tenant_id

    @tenant_id.setter
    def tenant_id(self, tenant_id):
        """
        Sets the tenant_id of this ReclaimClusterDetails.
        The tenant ID of the customer whose account has been de-activated


        :param tenant_id: The tenant_id of this ReclaimClusterDetails.
        :type: str
        """
        self._tenant_id = tenant_id

    @property
    def is_reclamation_run(self):
        """
        **[Required]** Gets the is_reclamation_run of this ReclaimClusterDetails.
        A boolean flag which indicates whether or not to execute the reclamation of the resulting non-deleted clusterIds in the de-activated tenant


        :return: The is_reclamation_run of this ReclaimClusterDetails.
        :rtype: bool
        """
        return self._is_reclamation_run

    @is_reclamation_run.setter
    def is_reclamation_run(self, is_reclamation_run):
        """
        Sets the is_reclamation_run of this ReclaimClusterDetails.
        A boolean flag which indicates whether or not to execute the reclamation of the resulting non-deleted clusterIds in the de-activated tenant


        :param is_reclamation_run: The is_reclamation_run of this ReclaimClusterDetails.
        :type: bool
        """
        self._is_reclamation_run = is_reclamation_run

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
