# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .opsi_data_object_details_in_query import OpsiDataObjectDetailsInQuery
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OpsiDataObjectTypeOpsiDataObjectDetailsInQuery(OpsiDataObjectDetailsInQuery):
    """
    Details applicable for all OPSI data objects of a specific OpsiDataObjectType used in a data object query.
    """

    #: A constant which can be used with the data_object_type property of a OpsiDataObjectTypeOpsiDataObjectDetailsInQuery.
    #: This constant has a value of "DATABASE_INSIGHTS_DATA_OBJECT"
    DATA_OBJECT_TYPE_DATABASE_INSIGHTS_DATA_OBJECT = "DATABASE_INSIGHTS_DATA_OBJECT"

    #: A constant which can be used with the data_object_type property of a OpsiDataObjectTypeOpsiDataObjectDetailsInQuery.
    #: This constant has a value of "HOST_INSIGHTS_DATA_OBJECT"
    DATA_OBJECT_TYPE_HOST_INSIGHTS_DATA_OBJECT = "HOST_INSIGHTS_DATA_OBJECT"

    #: A constant which can be used with the data_object_type property of a OpsiDataObjectTypeOpsiDataObjectDetailsInQuery.
    #: This constant has a value of "EXADATA_INSIGHTS_DATA_OBJECT"
    DATA_OBJECT_TYPE_EXADATA_INSIGHTS_DATA_OBJECT = "EXADATA_INSIGHTS_DATA_OBJECT"

    def __init__(self, **kwargs):
        """
        Initializes a new OpsiDataObjectTypeOpsiDataObjectDetailsInQuery object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.OpsiDataObjectTypeOpsiDataObjectDetailsInQuery.data_object_details_target` attribute
        of this class is ``OPSIDATAOBJECTTYPE_OPSIDATAOBJECTS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param data_object_details_target:
            The value to assign to the data_object_details_target property of this OpsiDataObjectTypeOpsiDataObjectDetailsInQuery.
            Allowed values for this property are: "INDIVIDUAL_OPSIDATAOBJECT", "OPSIDATAOBJECTTYPE_OPSIDATAOBJECTS"
        :type data_object_details_target: str

        :param _query_params:
            The value to assign to the _query_params property of this OpsiDataObjectTypeOpsiDataObjectDetailsInQuery.
        :type _query_params: list[oci.opsi.models.OpsiDataObjectQueryParam]

        :param data_object_type:
            The value to assign to the data_object_type property of this OpsiDataObjectTypeOpsiDataObjectDetailsInQuery.
            Allowed values for this property are: "DATABASE_INSIGHTS_DATA_OBJECT", "HOST_INSIGHTS_DATA_OBJECT", "EXADATA_INSIGHTS_DATA_OBJECT"
        :type data_object_type: str

        """
        self.swagger_types = {
            'data_object_details_target': 'str',
            '_query_params': 'list[OpsiDataObjectQueryParam]',
            'data_object_type': 'str'
        }
        self.attribute_map = {
            'data_object_details_target': 'dataObjectDetailsTarget',
            '_query_params': 'queryParams',
            'data_object_type': 'dataObjectType'
        }
        self._data_object_details_target = None
        self.__query_params = None
        self._data_object_type = None
        self._data_object_details_target = 'OPSIDATAOBJECTTYPE_OPSIDATAOBJECTS'

    @property
    def data_object_type(self):
        """
        **[Required]** Gets the data_object_type of this OpsiDataObjectTypeOpsiDataObjectDetailsInQuery.
        Type of OPSI data object.

        Allowed values for this property are: "DATABASE_INSIGHTS_DATA_OBJECT", "HOST_INSIGHTS_DATA_OBJECT", "EXADATA_INSIGHTS_DATA_OBJECT"


        :return: The data_object_type of this OpsiDataObjectTypeOpsiDataObjectDetailsInQuery.
        :rtype: str
        """
        return self._data_object_type

    @data_object_type.setter
    def data_object_type(self, data_object_type):
        """
        Sets the data_object_type of this OpsiDataObjectTypeOpsiDataObjectDetailsInQuery.
        Type of OPSI data object.


        :param data_object_type: The data_object_type of this OpsiDataObjectTypeOpsiDataObjectDetailsInQuery.
        :type: str
        """
        allowed_values = ["DATABASE_INSIGHTS_DATA_OBJECT", "HOST_INSIGHTS_DATA_OBJECT", "EXADATA_INSIGHTS_DATA_OBJECT"]
        if not value_allowed_none_or_none_sentinel(data_object_type, allowed_values):
            raise ValueError(
                f"Invalid value for `data_object_type`, must be None or one of {allowed_values}"
            )
        self._data_object_type = data_object_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
