# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AttachManagementStationToProfileDetails(object):
    """
    Provides the information used to attach a management station to a profile.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AttachManagementStationToProfileDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param management_station_id:
            The value to assign to the management_station_id property of this AttachManagementStationToProfileDetails.
        :type management_station_id: str

        """
        self.swagger_types = {
            'management_station_id': 'str'
        }
        self.attribute_map = {
            'management_station_id': 'managementStationId'
        }
        self._management_station_id = None

    @property
    def management_station_id(self):
        """
        **[Required]** Gets the management_station_id of this AttachManagementStationToProfileDetails.
        The `OCID`__ of the management station that the instance will be associated with.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The management_station_id of this AttachManagementStationToProfileDetails.
        :rtype: str
        """
        return self._management_station_id

    @management_station_id.setter
    def management_station_id(self, management_station_id):
        """
        Sets the management_station_id of this AttachManagementStationToProfileDetails.
        The `OCID`__ of the management station that the instance will be associated with.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param management_station_id: The management_station_id of this AttachManagementStationToProfileDetails.
        :type: str
        """
        self._management_station_id = management_station_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
