# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230401

from .assigned_subscription_summary import AssignedSubscriptionSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ClassicAssignedSubscriptionSummary(AssignedSubscriptionSummary):
    """
    Summary of assigned subscription information.
    """

    #: A constant which can be used with the lifecycle_state property of a ClassicAssignedSubscriptionSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ClassicAssignedSubscriptionSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ClassicAssignedSubscriptionSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ClassicAssignedSubscriptionSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ClassicAssignedSubscriptionSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ClassicAssignedSubscriptionSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ClassicAssignedSubscriptionSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the managed_by property of a ClassicAssignedSubscriptionSummary.
    #: This constant has a value of "APPSMANAGER"
    MANAGED_BY_APPSMANAGER = "APPSMANAGER"

    #: A constant which can be used with the managed_by property of a ClassicAssignedSubscriptionSummary.
    #: This constant has a value of "SERVICEMANAGERPROXY"
    MANAGED_BY_SERVICEMANAGERPROXY = "SERVICEMANAGERPROXY"

    #: A constant which can be used with the managed_by property of a ClassicAssignedSubscriptionSummary.
    #: This constant has a value of "FUSIONAPPS"
    MANAGED_BY_FUSIONAPPS = "FUSIONAPPS"

    #: A constant which can be used with the managed_by property of a ClassicAssignedSubscriptionSummary.
    #: This constant has a value of "MYSERVICES"
    MANAGED_BY_MYSERVICES = "MYSERVICES"

    def __init__(self, **kwargs):
        """
        Initializes a new ClassicAssignedSubscriptionSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.tenant_manager_control_plane.models.ClassicAssignedSubscriptionSummary.entity_version` attribute
        of this class is ``V1`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entity_version:
            The value to assign to the entity_version property of this ClassicAssignedSubscriptionSummary.
            Allowed values for this property are: "V1", "V2", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type entity_version: str

        :param id:
            The value to assign to the id property of this ClassicAssignedSubscriptionSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ClassicAssignedSubscriptionSummary.
        :type compartment_id: str

        :param service_name:
            The value to assign to the service_name property of this ClassicAssignedSubscriptionSummary.
        :type service_name: str

        :param time_created:
            The value to assign to the time_created property of this ClassicAssignedSubscriptionSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ClassicAssignedSubscriptionSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ClassicAssignedSubscriptionSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ClassicAssignedSubscriptionSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ClassicAssignedSubscriptionSummary.
        :type system_tags: dict(str, dict(str, object))

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ClassicAssignedSubscriptionSummary.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param classic_subscription_id:
            The value to assign to the classic_subscription_id property of this ClassicAssignedSubscriptionSummary.
        :type classic_subscription_id: str

        :param is_classic_subscription:
            The value to assign to the is_classic_subscription property of this ClassicAssignedSubscriptionSummary.
        :type is_classic_subscription: bool

        :param region_assignment:
            The value to assign to the region_assignment property of this ClassicAssignedSubscriptionSummary.
        :type region_assignment: str

        :param start_date:
            The value to assign to the start_date property of this ClassicAssignedSubscriptionSummary.
        :type start_date: datetime

        :param end_date:
            The value to assign to the end_date property of this ClassicAssignedSubscriptionSummary.
        :type end_date: datetime

        :param csi_number:
            The value to assign to the csi_number property of this ClassicAssignedSubscriptionSummary.
        :type csi_number: str

        :param managed_by:
            The value to assign to the managed_by property of this ClassicAssignedSubscriptionSummary.
            Allowed values for this property are: "APPSMANAGER", "SERVICEMANAGERPROXY", "FUSIONAPPS", "MYSERVICES", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type managed_by: str

        """
        self.swagger_types = {
            'entity_version': 'str',
            'id': 'str',
            'compartment_id': 'str',
            'service_name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'lifecycle_state': 'str',
            'classic_subscription_id': 'str',
            'is_classic_subscription': 'bool',
            'region_assignment': 'str',
            'start_date': 'datetime',
            'end_date': 'datetime',
            'csi_number': 'str',
            'managed_by': 'str'
        }
        self.attribute_map = {
            'entity_version': 'entityVersion',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'service_name': 'serviceName',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'lifecycle_state': 'lifecycleState',
            'classic_subscription_id': 'classicSubscriptionId',
            'is_classic_subscription': 'isClassicSubscription',
            'region_assignment': 'regionAssignment',
            'start_date': 'startDate',
            'end_date': 'endDate',
            'csi_number': 'csiNumber',
            'managed_by': 'managedBy'
        }
        self._entity_version = None
        self._id = None
        self._compartment_id = None
        self._service_name = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._lifecycle_state = None
        self._classic_subscription_id = None
        self._is_classic_subscription = None
        self._region_assignment = None
        self._start_date = None
        self._end_date = None
        self._csi_number = None
        self._managed_by = None
        self._entity_version = 'V1'

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ClassicAssignedSubscriptionSummary.
        Lifecycle state of the subscription.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ClassicAssignedSubscriptionSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ClassicAssignedSubscriptionSummary.
        Lifecycle state of the subscription.


        :param lifecycle_state: The lifecycle_state of this ClassicAssignedSubscriptionSummary.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def classic_subscription_id(self):
        """
        **[Required]** Gets the classic_subscription_id of this ClassicAssignedSubscriptionSummary.
        Subscription ID.


        :return: The classic_subscription_id of this ClassicAssignedSubscriptionSummary.
        :rtype: str
        """
        return self._classic_subscription_id

    @classic_subscription_id.setter
    def classic_subscription_id(self, classic_subscription_id):
        """
        Sets the classic_subscription_id of this ClassicAssignedSubscriptionSummary.
        Subscription ID.


        :param classic_subscription_id: The classic_subscription_id of this ClassicAssignedSubscriptionSummary.
        :type: str
        """
        self._classic_subscription_id = classic_subscription_id

    @property
    def is_classic_subscription(self):
        """
        Gets the is_classic_subscription of this ClassicAssignedSubscriptionSummary.
        Specifies whether or not the subscription is legacy.


        :return: The is_classic_subscription of this ClassicAssignedSubscriptionSummary.
        :rtype: bool
        """
        return self._is_classic_subscription

    @is_classic_subscription.setter
    def is_classic_subscription(self, is_classic_subscription):
        """
        Sets the is_classic_subscription of this ClassicAssignedSubscriptionSummary.
        Specifies whether or not the subscription is legacy.


        :param is_classic_subscription: The is_classic_subscription of this ClassicAssignedSubscriptionSummary.
        :type: bool
        """
        self._is_classic_subscription = is_classic_subscription

    @property
    def region_assignment(self):
        """
        Gets the region_assignment of this ClassicAssignedSubscriptionSummary.
        Region for the subscription.


        :return: The region_assignment of this ClassicAssignedSubscriptionSummary.
        :rtype: str
        """
        return self._region_assignment

    @region_assignment.setter
    def region_assignment(self, region_assignment):
        """
        Sets the region_assignment of this ClassicAssignedSubscriptionSummary.
        Region for the subscription.


        :param region_assignment: The region_assignment of this ClassicAssignedSubscriptionSummary.
        :type: str
        """
        self._region_assignment = region_assignment

    @property
    def start_date(self):
        """
        Gets the start_date of this ClassicAssignedSubscriptionSummary.
        Subscription start time.


        :return: The start_date of this ClassicAssignedSubscriptionSummary.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """
        Sets the start_date of this ClassicAssignedSubscriptionSummary.
        Subscription start time.


        :param start_date: The start_date of this ClassicAssignedSubscriptionSummary.
        :type: datetime
        """
        self._start_date = start_date

    @property
    def end_date(self):
        """
        Gets the end_date of this ClassicAssignedSubscriptionSummary.
        Subscription end time.


        :return: The end_date of this ClassicAssignedSubscriptionSummary.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """
        Sets the end_date of this ClassicAssignedSubscriptionSummary.
        Subscription end time.


        :param end_date: The end_date of this ClassicAssignedSubscriptionSummary.
        :type: datetime
        """
        self._end_date = end_date

    @property
    def csi_number(self):
        """
        Gets the csi_number of this ClassicAssignedSubscriptionSummary.
        Customer service identifier for the customer associated with the subscription.


        :return: The csi_number of this ClassicAssignedSubscriptionSummary.
        :rtype: str
        """
        return self._csi_number

    @csi_number.setter
    def csi_number(self, csi_number):
        """
        Sets the csi_number of this ClassicAssignedSubscriptionSummary.
        Customer service identifier for the customer associated with the subscription.


        :param csi_number: The csi_number of this ClassicAssignedSubscriptionSummary.
        :type: str
        """
        self._csi_number = csi_number

    @property
    def managed_by(self):
        """
        Gets the managed_by of this ClassicAssignedSubscriptionSummary.
        Service or component which is used to provision and manage the subscription.

        Allowed values for this property are: "APPSMANAGER", "SERVICEMANAGERPROXY", "FUSIONAPPS", "MYSERVICES", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The managed_by of this ClassicAssignedSubscriptionSummary.
        :rtype: str
        """
        return self._managed_by

    @managed_by.setter
    def managed_by(self, managed_by):
        """
        Sets the managed_by of this ClassicAssignedSubscriptionSummary.
        Service or component which is used to provision and manage the subscription.


        :param managed_by: The managed_by of this ClassicAssignedSubscriptionSummary.
        :type: str
        """
        allowed_values = ["APPSMANAGER", "SERVICEMANAGERPROXY", "FUSIONAPPS", "MYSERVICES"]
        if not value_allowed_none_or_none_sentinel(managed_by, allowed_values):
            managed_by = 'UNKNOWN_ENUM_VALUE'
        self._managed_by = managed_by

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
