# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210930

from .http_response_body import HttpResponseBody
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DynamicHttpResponseBody(HttpResponseBody):
    """
    Allows returning dynamically generated HTTP response body based on the provided template.
    The template allows variable interpolation by specifying variable name between the '${' and '}' delimiters.
    Escape sequences using '\\' are supported to allow usage of '\\\\' and '\\${' in the template to return '\\' and '\\${' in final response.

    The following variables are supported:

    * http.request.id - the HTTP request ID. For example: \"d5fa953f75ef417e4c8008ef9336d779\".

    Example:
    {
    \"type\": \"DYNAMIC\",
    \"template\": \"{\
    \\\"code\\\": 403,\
    \\\"message\\\":\\\"Unauthorised\\\",\
    \\\"incidentId\\\": \\\"${http.request.id}\\\"\
    }\"
    }

    Example with escape sequence:
    {
    \"type\": \"DYNAMIC\",
    \"template\": \"\\\\${Returned as plain text}\"
    }
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DynamicHttpResponseBody object with values from keyword arguments. The default value of the :py:attr:`~oci.waf.models.DynamicHttpResponseBody.type` attribute
        of this class is ``DYNAMIC`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this DynamicHttpResponseBody.
            Allowed values for this property are: "STATIC_TEXT", "DYNAMIC"
        :type type: str

        :param template:
            The value to assign to the template property of this DynamicHttpResponseBody.
        :type template: str

        """
        self.swagger_types = {
            'type': 'str',
            'template': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'template': 'template'
        }
        self._type = None
        self._template = None
        self._type = 'DYNAMIC'

    @property
    def template(self):
        """
        **[Required]** Gets the template of this DynamicHttpResponseBody.
        Dynamic response body


        :return: The template of this DynamicHttpResponseBody.
        :rtype: str
        """
        return self._template

    @template.setter
    def template(self, template):
        """
        Sets the template of this DynamicHttpResponseBody.
        Dynamic response body


        :param template: The template of this DynamicHttpResponseBody.
        :type: str
        """
        self._template = template

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
