# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101

from .backup_content import BackupContent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BinaryBackupContent(BackupContent):
    """
    Information of the content of a binary backup. A binary backup contains middleware binaries.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BinaryBackupContent object with values from keyword arguments. The default value of the :py:attr:`~oci.wlms.models.BinaryBackupContent.content_type` attribute
        of this class is ``BINARY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param content_type:
            The value to assign to the content_type property of this BinaryBackupContent.
            Allowed values for this property are: "BINARY"
        :type content_type: str

        :param middleware:
            The value to assign to the middleware property of this BinaryBackupContent.
        :type middleware: oci.wlms.models.MiddlewareBinaryBackupContent

        """
        self.swagger_types = {
            'content_type': 'str',
            'middleware': 'MiddlewareBinaryBackupContent'
        }
        self.attribute_map = {
            'content_type': 'contentType',
            'middleware': 'middleware'
        }
        self._content_type = None
        self._middleware = None
        self._content_type = 'BINARY'

    @property
    def middleware(self):
        """
        **[Required]** Gets the middleware of this BinaryBackupContent.

        :return: The middleware of this BinaryBackupContent.
        :rtype: oci.wlms.models.MiddlewareBinaryBackupContent
        """
        return self._middleware

    @middleware.setter
    def middleware(self, middleware):
        """
        Sets the middleware of this BinaryBackupContent.

        :param middleware: The middleware of this BinaryBackupContent.
        :type: oci.wlms.models.MiddlewareBinaryBackupContent
        """
        self._middleware = middleware

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
