# coding: utf-8
# Modified Work: Copyright (c) 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
# Original Work: Copyright (c) 2018 Character Encoding Detector contributors.  https://github.com/chardet

#!/usr/bin/env python
# -*- coding: utf-8 -*-

from ..chardet.sbcharsetprober import SingleByteCharSetModel


# 3: Positive
# 2: Likely
# 1: Unlikely
# 0: Negative

THAI_LANG_MODEL = {
    5: {  # 'ก'
        5: 2,  # 'ก'
        30: 2,  # 'ข'
        24: 2,  # 'ค'
        8: 2,  # 'ง'
        26: 2,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 3,  # 'ฎ'
        57: 2,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 2,  # 'ณ'
        20: 2,  # 'ด'
        19: 3,  # 'ต'
        44: 0,  # 'ถ'
        14: 2,  # 'ท'
        48: 0,  # 'ธ'
        3: 2,  # 'น'
        17: 1,  # 'บ'
        25: 2,  # 'ป'
        39: 1,  # 'ผ'
        62: 1,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 2,  # 'ม'
        16: 1,  # 'ย'
        2: 3,  # 'ร'
        61: 2,  # 'ฤ'
        15: 3,  # 'ล'
        12: 3,  # 'ว'
        42: 2,  # 'ศ'
        46: 3,  # 'ษ'
        18: 2,  # 'ส'
        21: 2,  # 'ห'
        4: 3,  # 'อ'
        63: 1,  # 'ฯ'
        22: 2,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 3,  # 'ำ'
        23: 3,  # 'ิ'
        13: 3,  # 'ี'
        40: 0,  # 'ึ'
        27: 2,  # 'ื'
        32: 2,  # 'ุ'
        35: 1,  # 'ู'
        11: 2,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 1,  # 'ใ'
        33: 2,  # 'ไ'
        50: 1,  # 'ๆ'
        37: 3,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 2,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    30: {  # 'ข'
        5: 1,  # 'ก'
        30: 0,  # 'ข'
        24: 1,  # 'ค'
        8: 1,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 2,  # 'ณ'
        20: 0,  # 'ด'
        19: 2,  # 'ต'
        44: 0,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 2,  # 'น'
        17: 1,  # 'บ'
        25: 1,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 2,  # 'ย'
        2: 1,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 2,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 1,  # 'ห'
        4: 3,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 2,  # 'ี'
        40: 3,  # 'ึ'
        27: 1,  # 'ื'
        32: 1,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 1,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 1,  # '็'
        6: 2,  # '่'
        7: 3,  # '้'
        38: 1,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    24: {  # 'ค'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 2,  # 'ค'
        8: 2,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 2,  # 'ณ'
        20: 2,  # 'ด'
        19: 2,  # 'ต'
        44: 0,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 0,  # 'บ'
        25: 1,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 2,  # 'ม'
        16: 2,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 3,  # 'ล'
        12: 3,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 0,  # 'ห'
        4: 2,  # 'อ'
        63: 0,  # 'ฯ'
        22: 2,  # 'ะ'
        10: 3,  # 'ั'
        1: 2,  # 'า'
        36: 3,  # 'ำ'
        23: 3,  # 'ิ'
        13: 2,  # 'ี'
        40: 0,  # 'ึ'
        27: 3,  # 'ื'
        32: 3,  # 'ุ'
        35: 2,  # 'ู'
        11: 1,  # 'เ'
        28: 0,  # 'แ'
        41: 3,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 1,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 3,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    8: {  # 'ง'
        5: 3,  # 'ก'
        30: 2,  # 'ข'
        24: 3,  # 'ค'
        8: 2,  # 'ง'
        26: 2,  # 'จ'
        52: 1,  # 'ฉ'
        34: 2,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 2,  # 'ด'
        19: 2,  # 'ต'
        44: 1,  # 'ถ'
        14: 3,  # 'ท'
        48: 1,  # 'ธ'
        3: 3,  # 'น'
        17: 2,  # 'บ'
        25: 2,  # 'ป'
        39: 2,  # 'ผ'
        62: 1,  # 'ฝ'
        31: 2,  # 'พ'
        54: 0,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 2,  # 'ม'
        16: 1,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 2,  # 'ว'
        42: 2,  # 'ศ'
        46: 1,  # 'ษ'
        18: 3,  # 'ส'
        21: 3,  # 'ห'
        4: 2,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 1,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 2,  # 'ิ'
        13: 1,  # 'ี'
        40: 0,  # 'ึ'
        27: 1,  # 'ื'
        32: 1,  # 'ุ'
        35: 0,  # 'ู'
        11: 3,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 2,  # 'ไ'
        50: 3,  # 'ๆ'
        37: 0,  # '็'
        6: 2,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    26: {  # 'จ'
        5: 2,  # 'ก'
        30: 1,  # 'ข'
        24: 0,  # 'ค'
        8: 2,  # 'ง'
        26: 3,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 2,  # 'ด'
        19: 1,  # 'ต'
        44: 1,  # 'ถ'
        14: 2,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 1,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 1,  # 'ม'
        16: 1,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 1,  # 'ห'
        4: 2,  # 'อ'
        63: 0,  # 'ฯ'
        22: 3,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 3,  # 'ำ'
        23: 2,  # 'ิ'
        13: 1,  # 'ี'
        40: 3,  # 'ึ'
        27: 1,  # 'ื'
        32: 3,  # 'ุ'
        35: 2,  # 'ู'
        11: 1,  # 'เ'
        28: 1,  # 'แ'
        41: 0,  # 'โ'
        29: 1,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 2,  # '่'
        7: 2,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    52: {  # 'ฉ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 3,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 3,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 1,  # 'ม'
        16: 1,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 1,  # 'ะ'
        10: 1,  # 'ั'
        1: 1,  # 'า'
        36: 0,  # 'ำ'
        23: 1,  # 'ิ'
        13: 1,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 1,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    34: {  # 'ช'
        5: 1,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 1,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 1,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 2,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 2,  # 'ม'
        16: 1,  # 'ย'
        2: 1,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 2,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 2,  # 'ั'
        1: 3,  # 'า'
        36: 1,  # 'ำ'
        23: 3,  # 'ิ'
        13: 2,  # 'ี'
        40: 0,  # 'ึ'
        27: 3,  # 'ื'
        32: 3,  # 'ุ'
        35: 1,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 1,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    51: {  # 'ซ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 1,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 1,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 0,  # 'ห'
        4: 2,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 1,  # 'ั'
        1: 1,  # 'า'
        36: 0,  # 'ำ'
        23: 1,  # 'ิ'
        13: 2,  # 'ี'
        40: 3,  # 'ึ'
        27: 2,  # 'ื'
        32: 1,  # 'ุ'
        35: 1,  # 'ู'
        11: 1,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 1,  # '็'
        6: 1,  # '่'
        7: 2,  # '้'
        38: 1,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    47: {  # 'ญ'
        5: 1,  # 'ก'
        30: 1,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 0,  # 'ซ'
        47: 3,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 1,  # 'บ'
        25: 1,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 1,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 1,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 2,  # 'ห'
        4: 1,  # 'อ'
        63: 0,  # 'ฯ'
        22: 1,  # 'ะ'
        10: 2,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 1,  # 'ิ'
        13: 1,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 1,  # 'เ'
        28: 1,  # 'แ'
        41: 0,  # 'โ'
        29: 1,  # 'ใ'
        33: 0,  # 'ไ'
        50: 1,  # 'ๆ'
        37: 0,  # '็'
        6: 2,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    58: {  # 'ฎ'
        5: 2,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 1,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 1,  # 'ิ'
        13: 2,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    57: {  # 'ฏ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 3,  # 'ิ'
        13: 1,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    49: {  # 'ฐ'
        5: 1,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 2,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 2,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 1,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 1,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 1,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    53: {  # 'ฑ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 2,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 3,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    55: {  # 'ฒ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 1,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    43: {  # 'ณ'
        5: 1,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 3,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 3,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 1,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 1,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 3,  # 'ะ'
        10: 0,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 1,  # 'ิ'
        13: 2,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 1,  # 'เ'
        28: 1,  # 'แ'
        41: 0,  # 'โ'
        29: 1,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 3,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    20: {  # 'ด'
        5: 2,  # 'ก'
        30: 2,  # 'ข'
        24: 2,  # 'ค'
        8: 3,  # 'ง'
        26: 2,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 1,  # 'ด'
        19: 2,  # 'ต'
        44: 1,  # 'ถ'
        14: 2,  # 'ท'
        48: 0,  # 'ธ'
        3: 1,  # 'น'
        17: 1,  # 'บ'
        25: 1,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 2,  # 'ม'
        16: 3,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 2,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 2,  # 'ห'
        4: 1,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 3,  # 'ั'
        1: 2,  # 'า'
        36: 2,  # 'ำ'
        23: 3,  # 'ิ'
        13: 3,  # 'ี'
        40: 1,  # 'ึ'
        27: 2,  # 'ื'
        32: 3,  # 'ุ'
        35: 2,  # 'ู'
        11: 2,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 2,  # 'ไ'
        50: 2,  # 'ๆ'
        37: 2,  # '็'
        6: 1,  # '่'
        7: 3,  # '้'
        38: 1,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    19: {  # 'ต'
        5: 2,  # 'ก'
        30: 1,  # 'ข'
        24: 1,  # 'ค'
        8: 0,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 1,  # 'ด'
        19: 1,  # 'ต'
        44: 2,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 2,  # 'น'
        17: 1,  # 'บ'
        25: 1,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 2,  # 'ภ'
        9: 1,  # 'ม'
        16: 1,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 3,  # 'ส'
        21: 0,  # 'ห'
        4: 3,  # 'อ'
        63: 1,  # 'ฯ'
        22: 2,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 2,  # 'ำ'
        23: 3,  # 'ิ'
        13: 2,  # 'ี'
        40: 1,  # 'ึ'
        27: 1,  # 'ื'
        32: 3,  # 'ุ'
        35: 2,  # 'ู'
        11: 1,  # 'เ'
        28: 1,  # 'แ'
        41: 1,  # 'โ'
        29: 1,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 2,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 2,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    44: {  # 'ถ'
        5: 1,  # 'ก'
        30: 0,  # 'ข'
        24: 1,  # 'ค'
        8: 0,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 1,  # 'ต'
        44: 0,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 1,  # 'น'
        17: 2,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 1,  # 'ร'
        61: 0,  # 'ฤ'
        15: 1,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 0,  # 'ห'
        4: 1,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 2,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 2,  # 'ิ'
        13: 1,  # 'ี'
        40: 3,  # 'ึ'
        27: 2,  # 'ื'
        32: 2,  # 'ุ'
        35: 3,  # 'ู'
        11: 1,  # 'เ'
        28: 1,  # 'แ'
        41: 0,  # 'โ'
        29: 1,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 2,  # '่'
        7: 3,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    14: {  # 'ท'
        5: 1,  # 'ก'
        30: 1,  # 'ข'
        24: 3,  # 'ค'
        8: 1,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 2,  # 'ด'
        19: 1,  # 'ต'
        44: 0,  # 'ถ'
        14: 1,  # 'ท'
        48: 3,  # 'ธ'
        3: 3,  # 'น'
        17: 2,  # 'บ'
        25: 2,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 2,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 1,  # 'ม'
        16: 3,  # 'ย'
        2: 3,  # 'ร'
        61: 1,  # 'ฤ'
        15: 1,  # 'ล'
        12: 2,  # 'ว'
        42: 3,  # 'ศ'
        46: 1,  # 'ษ'
        18: 1,  # 'ส'
        21: 0,  # 'ห'
        4: 2,  # 'อ'
        63: 0,  # 'ฯ'
        22: 2,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 3,  # 'ำ'
        23: 2,  # 'ิ'
        13: 3,  # 'ี'
        40: 2,  # 'ึ'
        27: 1,  # 'ื'
        32: 3,  # 'ุ'
        35: 1,  # 'ู'
        11: 0,  # 'เ'
        28: 1,  # 'แ'
        41: 0,  # 'โ'
        29: 1,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 1,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 2,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    48: {  # 'ธ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 1,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 1,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 2,  # 'า'
        36: 0,  # 'ำ'
        23: 3,  # 'ิ'
        13: 3,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 2,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 3,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    3: {  # 'น'
        5: 3,  # 'ก'
        30: 2,  # 'ข'
        24: 3,  # 'ค'
        8: 1,  # 'ง'
        26: 2,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 1,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 3,  # 'ด'
        19: 3,  # 'ต'
        44: 2,  # 'ถ'
        14: 3,  # 'ท'
        48: 3,  # 'ธ'
        3: 2,  # 'น'
        17: 2,  # 'บ'
        25: 2,  # 'ป'
        39: 2,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 2,  # 'พ'
        54: 1,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 2,  # 'ม'
        16: 2,  # 'ย'
        2: 2,  # 'ร'
        61: 1,  # 'ฤ'
        15: 2,  # 'ล'
        12: 3,  # 'ว'
        42: 1,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 2,  # 'ห'
        4: 3,  # 'อ'
        63: 1,  # 'ฯ'
        22: 2,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 3,  # 'ำ'
        23: 3,  # 'ิ'
        13: 3,  # 'ี'
        40: 3,  # 'ึ'
        27: 3,  # 'ื'
        32: 3,  # 'ุ'
        35: 2,  # 'ู'
        11: 3,  # 'เ'
        28: 2,  # 'แ'
        41: 3,  # 'โ'
        29: 3,  # 'ใ'
        33: 3,  # 'ไ'
        50: 2,  # 'ๆ'
        37: 1,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 2,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    17: {  # 'บ'
        5: 3,  # 'ก'
        30: 2,  # 'ข'
        24: 2,  # 'ค'
        8: 1,  # 'ง'
        26: 1,  # 'จ'
        52: 1,  # 'ฉ'
        34: 1,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 1,  # 'ด'
        19: 2,  # 'ต'
        44: 1,  # 'ถ'
        14: 3,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 3,  # 'บ'
        25: 2,  # 'ป'
        39: 2,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 1,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 1,  # 'ม'
        16: 0,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 3,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 2,  # 'ห'
        4: 2,  # 'อ'
        63: 1,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 2,  # 'ำ'
        23: 2,  # 'ิ'
        13: 2,  # 'ี'
        40: 0,  # 'ึ'
        27: 2,  # 'ื'
        32: 3,  # 'ุ'
        35: 2,  # 'ู'
        11: 2,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 2,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 1,  # '็'
        6: 2,  # '่'
        7: 2,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    25: {  # 'ป'
        5: 2,  # 'ก'
        30: 0,  # 'ข'
        24: 1,  # 'ค'
        8: 0,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 1,  # 'ฎ'
        57: 3,  # 'ฏ'
        49: 1,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 1,  # 'ด'
        19: 1,  # 'ต'
        44: 1,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 2,  # 'น'
        17: 0,  # 'บ'
        25: 1,  # 'ป'
        39: 1,  # 'ผ'
        62: 1,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 1,  # 'ม'
        16: 0,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 3,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 1,  # 'ษ'
        18: 2,  # 'ส'
        21: 1,  # 'ห'
        4: 2,  # 'อ'
        63: 0,  # 'ฯ'
        22: 1,  # 'ะ'
        10: 3,  # 'ั'
        1: 1,  # 'า'
        36: 0,  # 'ำ'
        23: 2,  # 'ิ'
        13: 3,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 1,  # 'ุ'
        35: 0,  # 'ู'
        11: 1,  # 'เ'
        28: 2,  # 'แ'
        41: 0,  # 'โ'
        29: 1,  # 'ใ'
        33: 2,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 3,  # '็'
        6: 1,  # '่'
        7: 2,  # '้'
        38: 1,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    39: {  # 'ผ'
        5: 1,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 1,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 2,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 1,  # 'ม'
        16: 2,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 3,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 1,  # 'ะ'
        10: 1,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 2,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 1,  # 'ื'
        32: 0,  # 'ุ'
        35: 3,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 3,  # '่'
        7: 1,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    62: {  # 'ฝ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 1,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 1,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 1,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 1,  # 'ี'
        40: 2,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 2,  # '่'
        7: 1,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    31: {  # 'พ'
        5: 1,  # 'ก'
        30: 1,  # 'ข'
        24: 1,  # 'ค'
        8: 1,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 1,  # 'ณ'
        20: 1,  # 'ด'
        19: 1,  # 'ต'
        44: 0,  # 'ถ'
        14: 2,  # 'ท'
        48: 1,  # 'ธ'
        3: 3,  # 'น'
        17: 2,  # 'บ'
        25: 0,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 1,  # 'ม'
        16: 2,  # 'ย'
        2: 3,  # 'ร'
        61: 2,  # 'ฤ'
        15: 2,  # 'ล'
        12: 2,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 1,  # 'ห'
        4: 2,  # 'อ'
        63: 1,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 3,  # 'ิ'
        13: 2,  # 'ี'
        40: 1,  # 'ึ'
        27: 3,  # 'ื'
        32: 1,  # 'ุ'
        35: 2,  # 'ู'
        11: 1,  # 'เ'
        28: 1,  # 'แ'
        41: 0,  # 'โ'
        29: 1,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 1,  # '็'
        6: 0,  # '่'
        7: 1,  # '้'
        38: 3,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    54: {  # 'ฟ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 1,  # 'ต'
        44: 0,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 2,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 1,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 0,  # 'ห'
        4: 1,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 2,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 1,  # 'ิ'
        13: 1,  # 'ี'
        40: 0,  # 'ึ'
        27: 1,  # 'ื'
        32: 1,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 1,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 2,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    45: {  # 'ภ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 1,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 3,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 1,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 1,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 2,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 1,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    9: {  # 'ม'
        5: 2,  # 'ก'
        30: 2,  # 'ข'
        24: 2,  # 'ค'
        8: 2,  # 'ง'
        26: 2,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 1,  # 'ณ'
        20: 2,  # 'ด'
        19: 2,  # 'ต'
        44: 1,  # 'ถ'
        14: 2,  # 'ท'
        48: 1,  # 'ธ'
        3: 3,  # 'น'
        17: 2,  # 'บ'
        25: 2,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 3,  # 'พ'
        54: 0,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 2,  # 'ม'
        16: 1,  # 'ย'
        2: 2,  # 'ร'
        61: 2,  # 'ฤ'
        15: 2,  # 'ล'
        12: 2,  # 'ว'
        42: 1,  # 'ศ'
        46: 1,  # 'ษ'
        18: 3,  # 'ส'
        21: 3,  # 'ห'
        4: 3,  # 'อ'
        63: 0,  # 'ฯ'
        22: 1,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 3,  # 'ิ'
        13: 3,  # 'ี'
        40: 0,  # 'ึ'
        27: 3,  # 'ื'
        32: 3,  # 'ุ'
        35: 3,  # 'ู'
        11: 2,  # 'เ'
        28: 2,  # 'แ'
        41: 2,  # 'โ'
        29: 2,  # 'ใ'
        33: 2,  # 'ไ'
        50: 1,  # 'ๆ'
        37: 1,  # '็'
        6: 3,  # '่'
        7: 2,  # '้'
        38: 1,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    16: {  # 'ย'
        5: 3,  # 'ก'
        30: 1,  # 'ข'
        24: 2,  # 'ค'
        8: 3,  # 'ง'
        26: 2,  # 'จ'
        52: 0,  # 'ฉ'
        34: 2,  # 'ช'
        51: 0,  # 'ซ'
        47: 2,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 2,  # 'ด'
        19: 2,  # 'ต'
        44: 1,  # 'ถ'
        14: 2,  # 'ท'
        48: 1,  # 'ธ'
        3: 3,  # 'น'
        17: 3,  # 'บ'
        25: 1,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 2,  # 'ม'
        16: 0,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 1,  # 'ล'
        12: 3,  # 'ว'
        42: 1,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 1,  # 'ห'
        4: 2,  # 'อ'
        63: 0,  # 'ฯ'
        22: 2,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 2,  # 'ิ'
        13: 3,  # 'ี'
        40: 1,  # 'ึ'
        27: 2,  # 'ื'
        32: 2,  # 'ุ'
        35: 3,  # 'ู'
        11: 2,  # 'เ'
        28: 1,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 2,  # 'ไ'
        50: 2,  # 'ๆ'
        37: 1,  # '็'
        6: 3,  # '่'
        7: 2,  # '้'
        38: 3,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    2: {  # 'ร'
        5: 3,  # 'ก'
        30: 2,  # 'ข'
        24: 2,  # 'ค'
        8: 3,  # 'ง'
        26: 2,  # 'จ'
        52: 0,  # 'ฉ'
        34: 2,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 3,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 3,  # 'ณ'
        20: 2,  # 'ด'
        19: 2,  # 'ต'
        44: 3,  # 'ถ'
        14: 3,  # 'ท'
        48: 1,  # 'ธ'
        3: 2,  # 'น'
        17: 2,  # 'บ'
        25: 3,  # 'ป'
        39: 2,  # 'ผ'
        62: 1,  # 'ฝ'
        31: 2,  # 'พ'
        54: 1,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 3,  # 'ม'
        16: 2,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 3,  # 'ว'
        42: 2,  # 'ศ'
        46: 2,  # 'ษ'
        18: 2,  # 'ส'
        21: 2,  # 'ห'
        4: 3,  # 'อ'
        63: 1,  # 'ฯ'
        22: 3,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 3,  # 'ิ'
        13: 3,  # 'ี'
        40: 2,  # 'ึ'
        27: 3,  # 'ื'
        32: 3,  # 'ุ'
        35: 3,  # 'ู'
        11: 3,  # 'เ'
        28: 3,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 3,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 3,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    61: {  # 'ฤ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 2,  # 'ต'
        44: 0,  # 'ถ'
        14: 2,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 1,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 2,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    15: {  # 'ล'
        5: 2,  # 'ก'
        30: 3,  # 'ข'
        24: 1,  # 'ค'
        8: 3,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 2,  # 'ด'
        19: 2,  # 'ต'
        44: 1,  # 'ถ'
        14: 2,  # 'ท'
        48: 0,  # 'ธ'
        3: 1,  # 'น'
        17: 2,  # 'บ'
        25: 2,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 1,  # 'ม'
        16: 3,  # 'ย'
        2: 1,  # 'ร'
        61: 0,  # 'ฤ'
        15: 1,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 1,  # 'ห'
        4: 3,  # 'อ'
        63: 2,  # 'ฯ'
        22: 3,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 2,  # 'ำ'
        23: 3,  # 'ิ'
        13: 3,  # 'ี'
        40: 2,  # 'ึ'
        27: 3,  # 'ื'
        32: 2,  # 'ุ'
        35: 3,  # 'ู'
        11: 2,  # 'เ'
        28: 1,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 2,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 2,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    12: {  # 'ว'
        5: 3,  # 'ก'
        30: 2,  # 'ข'
        24: 1,  # 'ค'
        8: 3,  # 'ง'
        26: 2,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 1,  # 'ณ'
        20: 2,  # 'ด'
        19: 1,  # 'ต'
        44: 1,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 2,  # 'บ'
        25: 1,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 1,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 3,  # 'ม'
        16: 3,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 3,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 2,  # 'ห'
        4: 2,  # 'อ'
        63: 0,  # 'ฯ'
        22: 2,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 3,  # 'ิ'
        13: 2,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 2,  # 'ุ'
        35: 0,  # 'ู'
        11: 3,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 1,  # 'ใ'
        33: 2,  # 'ไ'
        50: 1,  # 'ๆ'
        37: 0,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 1,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    42: {  # 'ศ'
        5: 1,  # 'ก'
        30: 0,  # 'ข'
        24: 1,  # 'ค'
        8: 0,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 1,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 1,  # 'ต'
        44: 0,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 2,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 2,  # 'ว'
        42: 1,  # 'ศ'
        46: 2,  # 'ษ'
        18: 1,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 2,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 2,  # 'ิ'
        13: 0,  # 'ี'
        40: 3,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 2,  # 'ู'
        11: 0,  # 'เ'
        28: 1,  # 'แ'
        41: 0,  # 'โ'
        29: 1,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 1,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    46: {  # 'ษ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 2,  # 'ฎ'
        57: 1,  # 'ฏ'
        49: 2,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 3,  # 'ณ'
        20: 0,  # 'ด'
        19: 1,  # 'ต'
        44: 0,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 1,  # 'ม'
        16: 2,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 1,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 2,  # 'ะ'
        10: 2,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 1,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 1,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 2,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    18: {  # 'ส'
        5: 2,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 2,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 3,  # 'ด'
        19: 3,  # 'ต'
        44: 3,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 2,  # 'บ'
        25: 1,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 2,  # 'ภ'
        9: 3,  # 'ม'
        16: 1,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 1,  # 'ล'
        12: 2,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 2,  # 'ห'
        4: 3,  # 'อ'
        63: 0,  # 'ฯ'
        22: 2,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 3,  # 'ำ'
        23: 3,  # 'ิ'
        13: 3,  # 'ี'
        40: 2,  # 'ึ'
        27: 3,  # 'ื'
        32: 3,  # 'ุ'
        35: 3,  # 'ู'
        11: 2,  # 'เ'
        28: 0,  # 'แ'
        41: 1,  # 'โ'
        29: 0,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 3,  # '่'
        7: 1,  # '้'
        38: 2,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    21: {  # 'ห'
        5: 3,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 1,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 2,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 1,  # 'ด'
        19: 3,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 0,  # 'บ'
        25: 1,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 3,  # 'ม'
        16: 2,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 3,  # 'ล'
        12: 2,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 3,  # 'อ'
        63: 0,  # 'ฯ'
        22: 1,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 0,  # 'ำ'
        23: 1,  # 'ิ'
        13: 1,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 1,  # 'ุ'
        35: 1,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 3,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 2,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    4: {  # 'อ'
        5: 3,  # 'ก'
        30: 1,  # 'ข'
        24: 2,  # 'ค'
        8: 3,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 3,  # 'ด'
        19: 2,  # 'ต'
        44: 1,  # 'ถ'
        14: 2,  # 'ท'
        48: 1,  # 'ธ'
        3: 3,  # 'น'
        17: 3,  # 'บ'
        25: 1,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 1,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 3,  # 'ม'
        16: 3,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 2,  # 'ว'
        42: 1,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 2,  # 'ห'
        4: 3,  # 'อ'
        63: 0,  # 'ฯ'
        22: 2,  # 'ะ'
        10: 3,  # 'ั'
        1: 3,  # 'า'
        36: 2,  # 'ำ'
        23: 2,  # 'ิ'
        13: 3,  # 'ี'
        40: 0,  # 'ึ'
        27: 3,  # 'ื'
        32: 3,  # 'ุ'
        35: 0,  # 'ู'
        11: 3,  # 'เ'
        28: 1,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 2,  # 'ไ'
        50: 1,  # 'ๆ'
        37: 1,  # '็'
        6: 2,  # '่'
        7: 2,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    63: {  # 'ฯ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    22: {  # 'ะ'
        5: 3,  # 'ก'
        30: 1,  # 'ข'
        24: 2,  # 'ค'
        8: 1,  # 'ง'
        26: 2,  # 'จ'
        52: 0,  # 'ฉ'
        34: 3,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 3,  # 'ด'
        19: 3,  # 'ต'
        44: 1,  # 'ถ'
        14: 3,  # 'ท'
        48: 1,  # 'ธ'
        3: 2,  # 'น'
        17: 3,  # 'บ'
        25: 2,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 2,  # 'พ'
        54: 0,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 3,  # 'ม'
        16: 2,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 2,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 3,  # 'ส'
        21: 3,  # 'ห'
        4: 2,  # 'อ'
        63: 1,  # 'ฯ'
        22: 1,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 3,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 2,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    10: {  # 'ั'
        5: 3,  # 'ก'
        30: 0,  # 'ข'
        24: 1,  # 'ค'
        8: 3,  # 'ง'
        26: 3,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 0,  # 'ซ'
        47: 3,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 2,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 3,  # 'ฒ'
        43: 3,  # 'ณ'
        20: 3,  # 'ด'
        19: 3,  # 'ต'
        44: 0,  # 'ถ'
        14: 2,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 3,  # 'บ'
        25: 1,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 2,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 3,  # 'ม'
        16: 3,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 3,  # 'ว'
        42: 2,  # 'ศ'
        46: 0,  # 'ษ'
        18: 3,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    1: {  # 'า'
        5: 3,  # 'ก'
        30: 2,  # 'ข'
        24: 3,  # 'ค'
        8: 3,  # 'ง'
        26: 3,  # 'จ'
        52: 0,  # 'ฉ'
        34: 3,  # 'ช'
        51: 1,  # 'ซ'
        47: 2,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 3,  # 'ณ'
        20: 3,  # 'ด'
        19: 3,  # 'ต'
        44: 1,  # 'ถ'
        14: 3,  # 'ท'
        48: 2,  # 'ธ'
        3: 3,  # 'น'
        17: 3,  # 'บ'
        25: 2,  # 'ป'
        39: 1,  # 'ผ'
        62: 1,  # 'ฝ'
        31: 3,  # 'พ'
        54: 1,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 3,  # 'ม'
        16: 3,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 3,  # 'ล'
        12: 3,  # 'ว'
        42: 2,  # 'ศ'
        46: 3,  # 'ษ'
        18: 3,  # 'ส'
        21: 3,  # 'ห'
        4: 2,  # 'อ'
        63: 1,  # 'ฯ'
        22: 3,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 3,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 2,  # 'ไ'
        50: 1,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    36: {  # 'ำ'
        5: 2,  # 'ก'
        30: 1,  # 'ข'
        24: 3,  # 'ค'
        8: 2,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 1,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 1,  # 'ด'
        19: 1,  # 'ต'
        44: 1,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 1,  # 'บ'
        25: 1,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 1,  # 'ม'
        16: 0,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 3,  # 'ห'
        4: 1,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 3,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 2,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    23: {  # 'ิ'
        5: 3,  # 'ก'
        30: 1,  # 'ข'
        24: 2,  # 'ค'
        8: 3,  # 'ง'
        26: 3,  # 'จ'
        52: 0,  # 'ฉ'
        34: 3,  # 'ช'
        51: 0,  # 'ซ'
        47: 2,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 3,  # 'ด'
        19: 3,  # 'ต'
        44: 1,  # 'ถ'
        14: 3,  # 'ท'
        48: 3,  # 'ธ'
        3: 3,  # 'น'
        17: 3,  # 'บ'
        25: 2,  # 'ป'
        39: 2,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 3,  # 'พ'
        54: 1,  # 'ฟ'
        45: 2,  # 'ภ'
        9: 3,  # 'ม'
        16: 2,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 3,  # 'ว'
        42: 3,  # 'ศ'
        46: 2,  # 'ษ'
        18: 2,  # 'ส'
        21: 3,  # 'ห'
        4: 1,  # 'อ'
        63: 1,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 3,  # 'เ'
        28: 1,  # 'แ'
        41: 1,  # 'โ'
        29: 1,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 3,  # '่'
        7: 2,  # '้'
        38: 2,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    13: {  # 'ี'
        5: 3,  # 'ก'
        30: 2,  # 'ข'
        24: 2,  # 'ค'
        8: 0,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 2,  # 'ด'
        19: 1,  # 'ต'
        44: 0,  # 'ถ'
        14: 2,  # 'ท'
        48: 0,  # 'ธ'
        3: 1,  # 'น'
        17: 2,  # 'บ'
        25: 2,  # 'ป'
        39: 1,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 2,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 2,  # 'ม'
        16: 3,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 1,  # 'ล'
        12: 2,  # 'ว'
        42: 1,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 1,  # 'ห'
        4: 2,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 2,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 1,  # 'ใ'
        33: 1,  # 'ไ'
        50: 1,  # 'ๆ'
        37: 0,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    40: {  # 'ึ'
        5: 3,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 3,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 1,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 1,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    27: {  # 'ื'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 1,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 2,  # 'น'
        17: 3,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 2,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 3,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    32: {  # 'ุ'
        5: 3,  # 'ก'
        30: 2,  # 'ข'
        24: 3,  # 'ค'
        8: 3,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 2,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 1,  # 'ฒ'
        43: 3,  # 'ณ'
        20: 3,  # 'ด'
        19: 3,  # 'ต'
        44: 1,  # 'ถ'
        14: 2,  # 'ท'
        48: 1,  # 'ธ'
        3: 2,  # 'น'
        17: 2,  # 'บ'
        25: 2,  # 'ป'
        39: 2,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 3,  # 'ม'
        16: 1,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 1,  # 'ว'
        42: 1,  # 'ศ'
        46: 2,  # 'ษ'
        18: 1,  # 'ส'
        21: 1,  # 'ห'
        4: 1,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 1,  # 'เ'
        28: 0,  # 'แ'
        41: 1,  # 'โ'
        29: 0,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 3,  # '่'
        7: 2,  # '้'
        38: 1,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    35: {  # 'ู'
        5: 3,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 2,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 2,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 1,  # 'ณ'
        20: 2,  # 'ด'
        19: 2,  # 'ต'
        44: 0,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 2,  # 'น'
        17: 0,  # 'บ'
        25: 3,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 2,  # 'ม'
        16: 0,  # 'ย'
        2: 1,  # 'ร'
        61: 0,  # 'ฤ'
        15: 3,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 1,  # 'เ'
        28: 1,  # 'แ'
        41: 1,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 3,  # '่'
        7: 3,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    11: {  # 'เ'
        5: 3,  # 'ก'
        30: 3,  # 'ข'
        24: 3,  # 'ค'
        8: 2,  # 'ง'
        26: 3,  # 'จ'
        52: 3,  # 'ฉ'
        34: 3,  # 'ช'
        51: 2,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 1,  # 'ณ'
        20: 3,  # 'ด'
        19: 3,  # 'ต'
        44: 1,  # 'ถ'
        14: 3,  # 'ท'
        48: 1,  # 'ธ'
        3: 3,  # 'น'
        17: 3,  # 'บ'
        25: 3,  # 'ป'
        39: 2,  # 'ผ'
        62: 1,  # 'ฝ'
        31: 3,  # 'พ'
        54: 1,  # 'ฟ'
        45: 3,  # 'ภ'
        9: 3,  # 'ม'
        16: 2,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 3,  # 'ล'
        12: 3,  # 'ว'
        42: 2,  # 'ศ'
        46: 0,  # 'ษ'
        18: 3,  # 'ส'
        21: 3,  # 'ห'
        4: 3,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    28: {  # 'แ'
        5: 3,  # 'ก'
        30: 2,  # 'ข'
        24: 2,  # 'ค'
        8: 1,  # 'ง'
        26: 2,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 2,  # 'ด'
        19: 3,  # 'ต'
        44: 2,  # 'ถ'
        14: 3,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 3,  # 'บ'
        25: 2,  # 'ป'
        39: 3,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 2,  # 'พ'
        54: 2,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 2,  # 'ม'
        16: 2,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 3,  # 'ล'
        12: 2,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 3,  # 'ส'
        21: 3,  # 'ห'
        4: 1,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    41: {  # 'โ'
        5: 2,  # 'ก'
        30: 1,  # 'ข'
        24: 2,  # 'ค'
        8: 0,  # 'ง'
        26: 1,  # 'จ'
        52: 1,  # 'ฉ'
        34: 1,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 3,  # 'ด'
        19: 2,  # 'ต'
        44: 0,  # 'ถ'
        14: 2,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 1,  # 'บ'
        25: 3,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 1,  # 'ฟ'
        45: 1,  # 'ภ'
        9: 1,  # 'ม'
        16: 2,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 3,  # 'ล'
        12: 0,  # 'ว'
        42: 1,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 0,  # 'ห'
        4: 2,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    29: {  # 'ใ'
        5: 2,  # 'ก'
        30: 0,  # 'ข'
        24: 1,  # 'ค'
        8: 0,  # 'ง'
        26: 3,  # 'จ'
        52: 0,  # 'ฉ'
        34: 3,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 3,  # 'ด'
        19: 1,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 2,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 1,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 3,  # 'ส'
        21: 3,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    33: {  # 'ไ'
        5: 1,  # 'ก'
        30: 2,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 3,  # 'ด'
        19: 1,  # 'ต'
        44: 0,  # 'ถ'
        14: 3,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 1,  # 'บ'
        25: 3,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 2,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 3,  # 'ม'
        16: 0,  # 'ย'
        2: 3,  # 'ร'
        61: 0,  # 'ฤ'
        15: 1,  # 'ล'
        12: 3,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 2,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    50: {  # 'ๆ'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    37: {  # '็'
        5: 2,  # 'ก'
        30: 1,  # 'ข'
        24: 2,  # 'ค'
        8: 2,  # 'ง'
        26: 3,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 1,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 1,  # 'ด'
        19: 2,  # 'ต'
        44: 0,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 3,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 2,  # 'ม'
        16: 1,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 2,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 0,  # 'ห'
        4: 1,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 1,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    6: {  # '่'
        5: 2,  # 'ก'
        30: 1,  # 'ข'
        24: 2,  # 'ค'
        8: 3,  # 'ง'
        26: 2,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 1,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 1,  # 'ด'
        19: 2,  # 'ต'
        44: 1,  # 'ถ'
        14: 2,  # 'ท'
        48: 1,  # 'ธ'
        3: 3,  # 'น'
        17: 1,  # 'บ'
        25: 2,  # 'ป'
        39: 2,  # 'ผ'
        62: 1,  # 'ฝ'
        31: 1,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 3,  # 'ม'
        16: 3,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 2,  # 'ล'
        12: 3,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 1,  # 'ห'
        4: 3,  # 'อ'
        63: 0,  # 'ฯ'
        22: 1,  # 'ะ'
        10: 0,  # 'ั'
        1: 3,  # 'า'
        36: 2,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 3,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 2,  # 'ไ'
        50: 1,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    7: {  # '้'
        5: 2,  # 'ก'
        30: 1,  # 'ข'
        24: 2,  # 'ค'
        8: 3,  # 'ง'
        26: 2,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 1,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 1,  # 'ด'
        19: 2,  # 'ต'
        44: 1,  # 'ถ'
        14: 2,  # 'ท'
        48: 0,  # 'ธ'
        3: 3,  # 'น'
        17: 2,  # 'บ'
        25: 2,  # 'ป'
        39: 2,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 1,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 3,  # 'ม'
        16: 2,  # 'ย'
        2: 2,  # 'ร'
        61: 0,  # 'ฤ'
        15: 1,  # 'ล'
        12: 3,  # 'ว'
        42: 1,  # 'ศ'
        46: 0,  # 'ษ'
        18: 2,  # 'ส'
        21: 2,  # 'ห'
        4: 3,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 3,  # 'า'
        36: 2,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 2,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 2,  # 'ใ'
        33: 2,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    38: {  # '์'
        5: 2,  # 'ก'
        30: 1,  # 'ข'
        24: 1,  # 'ค'
        8: 0,  # 'ง'
        26: 1,  # 'จ'
        52: 0,  # 'ฉ'
        34: 1,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 2,  # 'ด'
        19: 1,  # 'ต'
        44: 1,  # 'ถ'
        14: 1,  # 'ท'
        48: 0,  # 'ธ'
        3: 1,  # 'น'
        17: 1,  # 'บ'
        25: 1,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 1,  # 'พ'
        54: 1,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 2,  # 'ม'
        16: 0,  # 'ย'
        2: 1,  # 'ร'
        61: 1,  # 'ฤ'
        15: 1,  # 'ล'
        12: 1,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 1,  # 'ส'
        21: 1,  # 'ห'
        4: 2,  # 'อ'
        63: 1,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 2,  # 'เ'
        28: 2,  # 'แ'
        41: 1,  # 'โ'
        29: 1,  # 'ใ'
        33: 1,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 0,  # '๑'
        59: 0,  # '๒'
        60: 0,  # '๕'
    },
    56: {  # '๑'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 2,  # '๑'
        59: 1,  # '๒'
        60: 1,  # '๕'
    },
    59: {  # '๒'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 1,  # '๑'
        59: 1,  # '๒'
        60: 3,  # '๕'
    },
    60: {  # '๕'
        5: 0,  # 'ก'
        30: 0,  # 'ข'
        24: 0,  # 'ค'
        8: 0,  # 'ง'
        26: 0,  # 'จ'
        52: 0,  # 'ฉ'
        34: 0,  # 'ช'
        51: 0,  # 'ซ'
        47: 0,  # 'ญ'
        58: 0,  # 'ฎ'
        57: 0,  # 'ฏ'
        49: 0,  # 'ฐ'
        53: 0,  # 'ฑ'
        55: 0,  # 'ฒ'
        43: 0,  # 'ณ'
        20: 0,  # 'ด'
        19: 0,  # 'ต'
        44: 0,  # 'ถ'
        14: 0,  # 'ท'
        48: 0,  # 'ธ'
        3: 0,  # 'น'
        17: 0,  # 'บ'
        25: 0,  # 'ป'
        39: 0,  # 'ผ'
        62: 0,  # 'ฝ'
        31: 0,  # 'พ'
        54: 0,  # 'ฟ'
        45: 0,  # 'ภ'
        9: 0,  # 'ม'
        16: 0,  # 'ย'
        2: 0,  # 'ร'
        61: 0,  # 'ฤ'
        15: 0,  # 'ล'
        12: 0,  # 'ว'
        42: 0,  # 'ศ'
        46: 0,  # 'ษ'
        18: 0,  # 'ส'
        21: 0,  # 'ห'
        4: 0,  # 'อ'
        63: 0,  # 'ฯ'
        22: 0,  # 'ะ'
        10: 0,  # 'ั'
        1: 0,  # 'า'
        36: 0,  # 'ำ'
        23: 0,  # 'ิ'
        13: 0,  # 'ี'
        40: 0,  # 'ึ'
        27: 0,  # 'ื'
        32: 0,  # 'ุ'
        35: 0,  # 'ู'
        11: 0,  # 'เ'
        28: 0,  # 'แ'
        41: 0,  # 'โ'
        29: 0,  # 'ใ'
        33: 0,  # 'ไ'
        50: 0,  # 'ๆ'
        37: 0,  # '็'
        6: 0,  # '่'
        7: 0,  # '้'
        38: 0,  # '์'
        56: 2,  # '๑'
        59: 1,  # '๒'
        60: 0,  # '๕'
    },
}

# 255: Undefined characters that did not exist in training text
# 254: Carriage/Return
# 253: symbol (punctuation) that does not belong to word
# 252: 0 - 9
# 251: Control characters

# Character Mapping Table(s):
TIS_620_THAI_CHAR_TO_ORDER = {
     0: 255,  # '\x00'
     1: 255,  # '\x01'
     2: 255,  # '\x02'
     3: 255,  # '\x03'
     4: 255,  # '\x04'
     5: 255,  # '\x05'
     6: 255,  # '\x06'
     7: 255,  # '\x07'
     8: 255,  # '\x08'
     9: 255,  # '\t'
     10: 254,  # '\n'
     11: 255,  # '\x0b'
     12: 255,  # '\x0c'
     13: 254,  # '\r'
     14: 255,  # '\x0e'
     15: 255,  # '\x0f'
     16: 255,  # '\x10'
     17: 255,  # '\x11'
     18: 255,  # '\x12'
     19: 255,  # '\x13'
     20: 255,  # '\x14'
     21: 255,  # '\x15'
     22: 255,  # '\x16'
     23: 255,  # '\x17'
     24: 255,  # '\x18'
     25: 255,  # '\x19'
     26: 255,  # '\x1a'
     27: 255,  # '\x1b'
     28: 255,  # '\x1c'
     29: 255,  # '\x1d'
     30: 255,  # '\x1e'
     31: 255,  # '\x1f'
     32: 253,  # ' '
     33: 253,  # '!'
     34: 253,  # '"'
     35: 253,  # '#'
     36: 253,  # '$'
     37: 253,  # '%'
     38: 253,  # '&'
     39: 253,  # "'"
     40: 253,  # '('
     41: 253,  # ')'
     42: 253,  # '*'
     43: 253,  # '+'
     44: 253,  # ','
     45: 253,  # '-'
     46: 253,  # '.'
     47: 253,  # '/'
     48: 252,  # '0'
     49: 252,  # '1'
     50: 252,  # '2'
     51: 252,  # '3'
     52: 252,  # '4'
     53: 252,  # '5'
     54: 252,  # '6'
     55: 252,  # '7'
     56: 252,  # '8'
     57: 252,  # '9'
     58: 253,  # ':'
     59: 253,  # ';'
     60: 253,  # '<'
     61: 253,  # '='
     62: 253,  # '>'
     63: 253,  # '?'
     64: 253,  # '@'
     65: 182,  # 'A'
     66: 106,  # 'B'
     67: 107,  # 'C'
     68: 100,  # 'D'
     69: 183,  # 'E'
     70: 184,  # 'F'
     71: 185,  # 'G'
     72: 101,  # 'H'
     73: 94,  # 'I'
     74: 186,  # 'J'
     75: 187,  # 'K'
     76: 108,  # 'L'
     77: 109,  # 'M'
     78: 110,  # 'N'
     79: 111,  # 'O'
     80: 188,  # 'P'
     81: 189,  # 'Q'
     82: 190,  # 'R'
     83: 89,  # 'S'
     84: 95,  # 'T'
     85: 112,  # 'U'
     86: 113,  # 'V'
     87: 191,  # 'W'
     88: 192,  # 'X'
     89: 193,  # 'Y'
     90: 194,  # 'Z'
     91: 253,  # '['
     92: 253,  # '\\'
     93: 253,  # ']'
     94: 253,  # '^'
     95: 253,  # '_'
     96: 253,  # '`'
     97: 64,  # 'a'
     98: 72,  # 'b'
     99: 73,  # 'c'
     100: 114,  # 'd'
     101: 74,  # 'e'
     102: 115,  # 'f'
     103: 116,  # 'g'
     104: 102,  # 'h'
     105: 81,  # 'i'
     106: 201,  # 'j'
     107: 117,  # 'k'
     108: 90,  # 'l'
     109: 103,  # 'm'
     110: 78,  # 'n'
     111: 82,  # 'o'
     112: 96,  # 'p'
     113: 202,  # 'q'
     114: 91,  # 'r'
     115: 79,  # 's'
     116: 84,  # 't'
     117: 104,  # 'u'
     118: 105,  # 'v'
     119: 97,  # 'w'
     120: 98,  # 'x'
     121: 92,  # 'y'
     122: 203,  # 'z'
     123: 253,  # '{'
     124: 253,  # '|'
     125: 253,  # '}'
     126: 253,  # '~'
     127: 253,  # '\x7f'
     128: 209,  # '\x80'
     129: 210,  # '\x81'
     130: 211,  # '\x82'
     131: 212,  # '\x83'
     132: 213,  # '\x84'
     133: 88,  # '\x85'
     134: 214,  # '\x86'
     135: 215,  # '\x87'
     136: 216,  # '\x88'
     137: 217,  # '\x89'
     138: 218,  # '\x8a'
     139: 219,  # '\x8b'
     140: 220,  # '\x8c'
     141: 118,  # '\x8d'
     142: 221,  # '\x8e'
     143: 222,  # '\x8f'
     144: 223,  # '\x90'
     145: 224,  # '\x91'
     146: 99,  # '\x92'
     147: 85,  # '\x93'
     148: 83,  # '\x94'
     149: 225,  # '\x95'
     150: 226,  # '\x96'
     151: 227,  # '\x97'
     152: 228,  # '\x98'
     153: 229,  # '\x99'
     154: 230,  # '\x9a'
     155: 231,  # '\x9b'
     156: 232,  # '\x9c'
     157: 233,  # '\x9d'
     158: 234,  # '\x9e'
     159: 235,  # '\x9f'
     160: 236,  # None
     161: 5,  # 'ก'
     162: 30,  # 'ข'
     163: 237,  # 'ฃ'
     164: 24,  # 'ค'
     165: 238,  # 'ฅ'
     166: 75,  # 'ฆ'
     167: 8,  # 'ง'
     168: 26,  # 'จ'
     169: 52,  # 'ฉ'
     170: 34,  # 'ช'
     171: 51,  # 'ซ'
     172: 119,  # 'ฌ'
     173: 47,  # 'ญ'
     174: 58,  # 'ฎ'
     175: 57,  # 'ฏ'
     176: 49,  # 'ฐ'
     177: 53,  # 'ฑ'
     178: 55,  # 'ฒ'
     179: 43,  # 'ณ'
     180: 20,  # 'ด'
     181: 19,  # 'ต'
     182: 44,  # 'ถ'
     183: 14,  # 'ท'
     184: 48,  # 'ธ'
     185: 3,  # 'น'
     186: 17,  # 'บ'
     187: 25,  # 'ป'
     188: 39,  # 'ผ'
     189: 62,  # 'ฝ'
     190: 31,  # 'พ'
     191: 54,  # 'ฟ'
     192: 45,  # 'ภ'
     193: 9,  # 'ม'
     194: 16,  # 'ย'
     195: 2,  # 'ร'
     196: 61,  # 'ฤ'
     197: 15,  # 'ล'
     198: 239,  # 'ฦ'
     199: 12,  # 'ว'
     200: 42,  # 'ศ'
     201: 46,  # 'ษ'
     202: 18,  # 'ส'
     203: 21,  # 'ห'
     204: 76,  # 'ฬ'
     205: 4,  # 'อ'
     206: 66,  # 'ฮ'
     207: 63,  # 'ฯ'
     208: 22,  # 'ะ'
     209: 10,  # 'ั'
     210: 1,  # 'า'
     211: 36,  # 'ำ'
     212: 23,  # 'ิ'
     213: 13,  # 'ี'
     214: 40,  # 'ึ'
     215: 27,  # 'ื'
     216: 32,  # 'ุ'
     217: 35,  # 'ู'
     218: 86,  # 'ฺ'
     219: 240,  # None
     220: 241,  # None
     221: 242,  # None
     222: 243,  # None
     223: 244,  # '฿'
     224: 11,  # 'เ'
     225: 28,  # 'แ'
     226: 41,  # 'โ'
     227: 29,  # 'ใ'
     228: 33,  # 'ไ'
     229: 245,  # 'ๅ'
     230: 50,  # 'ๆ'
     231: 37,  # '็'
     232: 6,  # '่'
     233: 7,  # '้'
     234: 67,  # '๊'
     235: 77,  # '๋'
     236: 38,  # '์'
     237: 93,  # 'ํ'
     238: 246,  # '๎'
     239: 247,  # '๏'
     240: 68,  # '๐'
     241: 56,  # '๑'
     242: 59,  # '๒'
     243: 65,  # '๓'
     244: 69,  # '๔'
     245: 60,  # '๕'
     246: 70,  # '๖'
     247: 80,  # '๗'
     248: 71,  # '๘'
     249: 87,  # '๙'
     250: 248,  # '๚'
     251: 249,  # '๛'
     252: 250,  # None
     253: 251,  # None
     254: 252,  # None
     255: 253,  # None
}

TIS_620_THAI_MODEL = SingleByteCharSetModel(charset_name='TIS-620',
                                            language='Thai',
                                            char_to_order_map=TIS_620_THAI_CHAR_TO_ORDER,
                                            language_model=THAI_LANG_MODEL,
                                            typical_positive_ratio=0.926386,
                                            keep_ascii_letters=False,
                                            alphabet='กขฃคฅฆงจฉชซฌญฎฏฐฑฒณดตถทธนบปผฝพฟภมยรฤลฦวศษสหฬอฮฯะัาำิีึืฺุู฿เแโใไๅๆ็่้๊๋์ํ๎๏๐๑๒๓๔๕๖๗๘๙๚๛')

