# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221109


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelTypeInfo(object):
    """
    Model information like versions and capabilities
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ModelTypeInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param versions:
            The value to assign to the versions property of this ModelTypeInfo.
        :type versions: list[str]

        :param capabilities:
            The value to assign to the capabilities property of this ModelTypeInfo.
        :type capabilities: dict(str, Capabilities)

        """
        self.swagger_types = {
            'versions': 'list[str]',
            'capabilities': 'dict(str, Capabilities)'
        }
        self.attribute_map = {
            'versions': 'versions',
            'capabilities': 'capabilities'
        }
        self._versions = None
        self._capabilities = None

    @property
    def versions(self):
        """
        Gets the versions of this ModelTypeInfo.
        Model versions available for this model and submodel type


        :return: The versions of this ModelTypeInfo.
        :rtype: list[str]
        """
        return self._versions

    @versions.setter
    def versions(self, versions):
        """
        Sets the versions of this ModelTypeInfo.
        Model versions available for this model and submodel type


        :param versions: The versions of this ModelTypeInfo.
        :type: list[str]
        """
        self._versions = versions

    @property
    def capabilities(self):
        """
        **[Required]** Gets the capabilities of this ModelTypeInfo.
        Model information capabilities related to version


        :return: The capabilities of this ModelTypeInfo.
        :rtype: dict(str, Capabilities)
        """
        return self._capabilities

    @capabilities.setter
    def capabilities(self, capabilities):
        """
        Sets the capabilities of this ModelTypeInfo.
        Model information capabilities related to version


        :param capabilities: The capabilities of this ModelTypeInfo.
        :type: dict(str, Capabilities)
        """
        self._capabilities = capabilities

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
