# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AnalyzeVideoStreamResult(object):
    """
    Video stream analysis results.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AnalyzeVideoStreamResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ontology_classes:
            The value to assign to the ontology_classes property of this AnalyzeVideoStreamResult.
        :type ontology_classes: oci.ai_vision.models.OntologyClass

        :param video_stream_metadata:
            The value to assign to the video_stream_metadata property of this AnalyzeVideoStreamResult.
        :type video_stream_metadata: oci.ai_vision.models.VideoStreamMetadata

        :param image_data:
            The value to assign to the image_data property of this AnalyzeVideoStreamResult.
        :type image_data: str

        :param stream_job_id:
            The value to assign to the stream_job_id property of this AnalyzeVideoStreamResult.
        :type stream_job_id: str

        :param stream_source_id:
            The value to assign to the stream_source_id property of this AnalyzeVideoStreamResult.
        :type stream_source_id: str

        :param timestamp:
            The value to assign to the timestamp property of this AnalyzeVideoStreamResult.
        :type timestamp: str

        :param video_stream_objects:
            The value to assign to the video_stream_objects property of this AnalyzeVideoStreamResult.
        :type video_stream_objects: list[oci.ai_vision.models.VideoStreamObject]

        :param object_tracking_model_versions:
            The value to assign to the object_tracking_model_versions property of this AnalyzeVideoStreamResult.
        :type object_tracking_model_versions: list[oci.ai_vision.models.ModelVersionDetails]

        :param object_detection_model_versions:
            The value to assign to the object_detection_model_versions property of this AnalyzeVideoStreamResult.
        :type object_detection_model_versions: list[oci.ai_vision.models.ModelVersionDetails]

        :param errors:
            The value to assign to the errors property of this AnalyzeVideoStreamResult.
        :type errors: list[oci.ai_vision.models.ProcessingError]

        """
        self.swagger_types = {
            'ontology_classes': 'OntologyClass',
            'video_stream_metadata': 'VideoStreamMetadata',
            'image_data': 'str',
            'stream_job_id': 'str',
            'stream_source_id': 'str',
            'timestamp': 'str',
            'video_stream_objects': 'list[VideoStreamObject]',
            'object_tracking_model_versions': 'list[ModelVersionDetails]',
            'object_detection_model_versions': 'list[ModelVersionDetails]',
            'errors': 'list[ProcessingError]'
        }
        self.attribute_map = {
            'ontology_classes': 'ontologyClasses',
            'video_stream_metadata': 'videoStreamMetadata',
            'image_data': 'imageData',
            'stream_job_id': 'streamJobId',
            'stream_source_id': 'streamSourceId',
            'timestamp': 'timestamp',
            'video_stream_objects': 'videoStreamObjects',
            'object_tracking_model_versions': 'objectTrackingModelVersions',
            'object_detection_model_versions': 'objectDetectionModelVersions',
            'errors': 'errors'
        }
        self._ontology_classes = None
        self._video_stream_metadata = None
        self._image_data = None
        self._stream_job_id = None
        self._stream_source_id = None
        self._timestamp = None
        self._video_stream_objects = None
        self._object_tracking_model_versions = None
        self._object_detection_model_versions = None
        self._errors = None

    @property
    def ontology_classes(self):
        """
        Gets the ontology_classes of this AnalyzeVideoStreamResult.

        :return: The ontology_classes of this AnalyzeVideoStreamResult.
        :rtype: oci.ai_vision.models.OntologyClass
        """
        return self._ontology_classes

    @ontology_classes.setter
    def ontology_classes(self, ontology_classes):
        """
        Sets the ontology_classes of this AnalyzeVideoStreamResult.

        :param ontology_classes: The ontology_classes of this AnalyzeVideoStreamResult.
        :type: oci.ai_vision.models.OntologyClass
        """
        self._ontology_classes = ontology_classes

    @property
    def video_stream_metadata(self):
        """
        **[Required]** Gets the video_stream_metadata of this AnalyzeVideoStreamResult.

        :return: The video_stream_metadata of this AnalyzeVideoStreamResult.
        :rtype: oci.ai_vision.models.VideoStreamMetadata
        """
        return self._video_stream_metadata

    @video_stream_metadata.setter
    def video_stream_metadata(self, video_stream_metadata):
        """
        Sets the video_stream_metadata of this AnalyzeVideoStreamResult.

        :param video_stream_metadata: The video_stream_metadata of this AnalyzeVideoStreamResult.
        :type: oci.ai_vision.models.VideoStreamMetadata
        """
        self._video_stream_metadata = video_stream_metadata

    @property
    def image_data(self):
        """
        Gets the image_data of this AnalyzeVideoStreamResult.
        Base 64 encoded frame


        :return: The image_data of this AnalyzeVideoStreamResult.
        :rtype: str
        """
        return self._image_data

    @image_data.setter
    def image_data(self, image_data):
        """
        Sets the image_data of this AnalyzeVideoStreamResult.
        Base 64 encoded frame


        :param image_data: The image_data of this AnalyzeVideoStreamResult.
        :type: str
        """
        self._image_data = image_data

    @property
    def stream_job_id(self):
        """
        **[Required]** Gets the stream_job_id of this AnalyzeVideoStreamResult.
        `OCID`__ of streamJob.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The stream_job_id of this AnalyzeVideoStreamResult.
        :rtype: str
        """
        return self._stream_job_id

    @stream_job_id.setter
    def stream_job_id(self, stream_job_id):
        """
        Sets the stream_job_id of this AnalyzeVideoStreamResult.
        `OCID`__ of streamJob.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param stream_job_id: The stream_job_id of this AnalyzeVideoStreamResult.
        :type: str
        """
        self._stream_job_id = stream_job_id

    @property
    def stream_source_id(self):
        """
        **[Required]** Gets the stream_source_id of this AnalyzeVideoStreamResult.
        `OCID`__ of StreamSource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The stream_source_id of this AnalyzeVideoStreamResult.
        :rtype: str
        """
        return self._stream_source_id

    @stream_source_id.setter
    def stream_source_id(self, stream_source_id):
        """
        Sets the stream_source_id of this AnalyzeVideoStreamResult.
        `OCID`__ of StreamSource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param stream_source_id: The stream_source_id of this AnalyzeVideoStreamResult.
        :type: str
        """
        self._stream_source_id = stream_source_id

    @property
    def timestamp(self):
        """
        **[Required]** Gets the timestamp of this AnalyzeVideoStreamResult.
        time stamp of frame in utc.


        :return: The timestamp of this AnalyzeVideoStreamResult.
        :rtype: str
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this AnalyzeVideoStreamResult.
        time stamp of frame in utc.


        :param timestamp: The timestamp of this AnalyzeVideoStreamResult.
        :type: str
        """
        self._timestamp = timestamp

    @property
    def video_stream_objects(self):
        """
        Gets the video_stream_objects of this AnalyzeVideoStreamResult.
        Tracked objects in a video stream.


        :return: The video_stream_objects of this AnalyzeVideoStreamResult.
        :rtype: list[oci.ai_vision.models.VideoStreamObject]
        """
        return self._video_stream_objects

    @video_stream_objects.setter
    def video_stream_objects(self, video_stream_objects):
        """
        Sets the video_stream_objects of this AnalyzeVideoStreamResult.
        Tracked objects in a video stream.


        :param video_stream_objects: The video_stream_objects of this AnalyzeVideoStreamResult.
        :type: list[oci.ai_vision.models.VideoStreamObject]
        """
        self._video_stream_objects = video_stream_objects

    @property
    def object_tracking_model_versions(self):
        """
        Gets the object_tracking_model_versions of this AnalyzeVideoStreamResult.
        List of Object Tracking model versions.


        :return: The object_tracking_model_versions of this AnalyzeVideoStreamResult.
        :rtype: list[oci.ai_vision.models.ModelVersionDetails]
        """
        return self._object_tracking_model_versions

    @object_tracking_model_versions.setter
    def object_tracking_model_versions(self, object_tracking_model_versions):
        """
        Sets the object_tracking_model_versions of this AnalyzeVideoStreamResult.
        List of Object Tracking model versions.


        :param object_tracking_model_versions: The object_tracking_model_versions of this AnalyzeVideoStreamResult.
        :type: list[oci.ai_vision.models.ModelVersionDetails]
        """
        self._object_tracking_model_versions = object_tracking_model_versions

    @property
    def object_detection_model_versions(self):
        """
        Gets the object_detection_model_versions of this AnalyzeVideoStreamResult.
        List of Object Detection model versions.


        :return: The object_detection_model_versions of this AnalyzeVideoStreamResult.
        :rtype: list[oci.ai_vision.models.ModelVersionDetails]
        """
        return self._object_detection_model_versions

    @object_detection_model_versions.setter
    def object_detection_model_versions(self, object_detection_model_versions):
        """
        Sets the object_detection_model_versions of this AnalyzeVideoStreamResult.
        List of Object Detection model versions.


        :param object_detection_model_versions: The object_detection_model_versions of this AnalyzeVideoStreamResult.
        :type: list[oci.ai_vision.models.ModelVersionDetails]
        """
        self._object_detection_model_versions = object_detection_model_versions

    @property
    def errors(self):
        """
        Gets the errors of this AnalyzeVideoStreamResult.
        Array of possible errors.


        :return: The errors of this AnalyzeVideoStreamResult.
        :rtype: list[oci.ai_vision.models.ProcessingError]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """
        Sets the errors of this AnalyzeVideoStreamResult.
        Array of possible errors.


        :param errors: The errors of this AnalyzeVideoStreamResult.
        :type: list[oci.ai_vision.models.ProcessingError]
        """
        self._errors = errors

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
