# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200131


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServiceConfiguration(object):
    """
    Configurations that are specific to a service.
    """

    #: A constant which can be used with the service_configuration_type property of a ServiceConfiguration.
    #: This constant has a value of "INSTANCE_SECURITY"
    SERVICE_CONFIGURATION_TYPE_INSTANCE_SECURITY = "INSTANCE_SECURITY"

    def __init__(self, **kwargs):
        """
        Initializes a new ServiceConfiguration object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.cloud_guard.models.InstanceSecurityServiceConfiguration`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param service_configuration_type:
            The value to assign to the service_configuration_type property of this ServiceConfiguration.
            Allowed values for this property are: "INSTANCE_SECURITY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type service_configuration_type: str

        """
        self.swagger_types = {
            'service_configuration_type': 'str'
        }
        self.attribute_map = {
            'service_configuration_type': 'serviceConfigurationType'
        }
        self._service_configuration_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['serviceConfigurationType']

        if type == 'INSTANCE_SECURITY':
            return 'InstanceSecurityServiceConfiguration'
        else:
            return 'ServiceConfiguration'

    @property
    def service_configuration_type(self):
        """
        **[Required]** Gets the service_configuration_type of this ServiceConfiguration.
        Type of service configuration

        Allowed values for this property are: "INSTANCE_SECURITY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The service_configuration_type of this ServiceConfiguration.
        :rtype: str
        """
        return self._service_configuration_type

    @service_configuration_type.setter
    def service_configuration_type(self, service_configuration_type):
        """
        Sets the service_configuration_type of this ServiceConfiguration.
        Type of service configuration


        :param service_configuration_type: The service_configuration_type of this ServiceConfiguration.
        :type: str
        """
        allowed_values = ["INSTANCE_SECURITY"]
        if not value_allowed_none_or_none_sentinel(service_configuration_type, allowed_values):
            service_configuration_type = 'UNKNOWN_ENUM_VALUE'
        self._service_configuration_type = service_configuration_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
