# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstancePoolPreTerminationActionDetails(object):
    """
    The data for pre-termination action for an instance pool
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstancePoolPreTerminationActionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_enabled:
            The value to assign to the is_enabled property of this InstancePoolPreTerminationActionDetails.
        :type is_enabled: bool

        :param timeout:
            The value to assign to the timeout property of this InstancePoolPreTerminationActionDetails.
        :type timeout: int

        :param on_timeout:
            The value to assign to the on_timeout property of this InstancePoolPreTerminationActionDetails.
        :type on_timeout: oci.core.models.InstancePoolPreTerminationActionHandleTimeoutDetails

        """
        self.swagger_types = {
            'is_enabled': 'bool',
            'timeout': 'int',
            'on_timeout': 'InstancePoolPreTerminationActionHandleTimeoutDetails'
        }
        self.attribute_map = {
            'is_enabled': 'isEnabled',
            'timeout': 'timeout',
            'on_timeout': 'onTimeout'
        }
        self._is_enabled = None
        self._timeout = None
        self._on_timeout = None

    @property
    def is_enabled(self):
        """
        **[Required]** Gets the is_enabled of this InstancePoolPreTerminationActionDetails.
        Whether pre-termination action is enabled or not.


        :return: The is_enabled of this InstancePoolPreTerminationActionDetails.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this InstancePoolPreTerminationActionDetails.
        Whether pre-termination action is enabled or not.


        :param is_enabled: The is_enabled of this InstancePoolPreTerminationActionDetails.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def timeout(self):
        """
        **[Required]** Gets the timeout of this InstancePoolPreTerminationActionDetails.
        The timeout in seconds for pre-termination action for an instance pool.


        :return: The timeout of this InstancePoolPreTerminationActionDetails.
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """
        Sets the timeout of this InstancePoolPreTerminationActionDetails.
        The timeout in seconds for pre-termination action for an instance pool.


        :param timeout: The timeout of this InstancePoolPreTerminationActionDetails.
        :type: int
        """
        self._timeout = timeout

    @property
    def on_timeout(self):
        """
        **[Required]** Gets the on_timeout of this InstancePoolPreTerminationActionDetails.

        :return: The on_timeout of this InstancePoolPreTerminationActionDetails.
        :rtype: oci.core.models.InstancePoolPreTerminationActionHandleTimeoutDetails
        """
        return self._on_timeout

    @on_timeout.setter
    def on_timeout(self, on_timeout):
        """
        Sets the on_timeout of this InstancePoolPreTerminationActionDetails.

        :param on_timeout: The on_timeout of this InstancePoolPreTerminationActionDetails.
        :type: oci.core.models.InstancePoolPreTerminationActionHandleTimeoutDetails
        """
        self._on_timeout = on_timeout

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
