# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InventoryVcnSummary(object):
    """
    Provides the summary of a VCN's IP Inventory data under specified compartments.
    """

    #: A constant which can be used with the resource_type property of a InventoryVcnSummary.
    #: This constant has a value of "VCN"
    RESOURCE_TYPE_VCN = "VCN"

    def __init__(self, **kwargs):
        """
        Initializes a new InventoryVcnSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vcn_id:
            The value to assign to the vcn_id property of this InventoryVcnSummary.
        :type vcn_id: str

        :param vcn_name:
            The value to assign to the vcn_name property of this InventoryVcnSummary.
        :type vcn_name: str

        :param resource_type:
            The value to assign to the resource_type property of this InventoryVcnSummary.
            Allowed values for this property are: "VCN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type resource_type: str

        :param inventory_vcn_cidr_block_collection:
            The value to assign to the inventory_vcn_cidr_block_collection property of this InventoryVcnSummary.
        :type inventory_vcn_cidr_block_collection: list[oci.core.models.InventoryVcnCidrBlockSummary]

        :param dns_domain_name:
            The value to assign to the dns_domain_name property of this InventoryVcnSummary.
        :type dns_domain_name: str

        :param region:
            The value to assign to the region property of this InventoryVcnSummary.
        :type region: str

        :param compartment_id:
            The value to assign to the compartment_id property of this InventoryVcnSummary.
        :type compartment_id: str

        :param inventory_subnetcollection:
            The value to assign to the inventory_subnetcollection property of this InventoryVcnSummary.
        :type inventory_subnetcollection: list[oci.core.models.InventorySubnetSummary]

        """
        self.swagger_types = {
            'vcn_id': 'str',
            'vcn_name': 'str',
            'resource_type': 'str',
            'inventory_vcn_cidr_block_collection': 'list[InventoryVcnCidrBlockSummary]',
            'dns_domain_name': 'str',
            'region': 'str',
            'compartment_id': 'str',
            'inventory_subnetcollection': 'list[InventorySubnetSummary]'
        }
        self.attribute_map = {
            'vcn_id': 'vcnId',
            'vcn_name': 'vcnName',
            'resource_type': 'resourceType',
            'inventory_vcn_cidr_block_collection': 'inventoryVcnCidrBlockCollection',
            'dns_domain_name': 'dnsDomainName',
            'region': 'region',
            'compartment_id': 'compartmentId',
            'inventory_subnetcollection': 'inventorySubnetcollection'
        }
        self._vcn_id = None
        self._vcn_name = None
        self._resource_type = None
        self._inventory_vcn_cidr_block_collection = None
        self._dns_domain_name = None
        self._region = None
        self._compartment_id = None
        self._inventory_subnetcollection = None

    @property
    def vcn_id(self):
        """
        Gets the vcn_id of this InventoryVcnSummary.
        The `OCID`__ of the VCN .

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The vcn_id of this InventoryVcnSummary.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this InventoryVcnSummary.
        The `OCID`__ of the VCN .

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param vcn_id: The vcn_id of this InventoryVcnSummary.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def vcn_name(self):
        """
        Gets the vcn_name of this InventoryVcnSummary.
        Name of the VCN.


        :return: The vcn_name of this InventoryVcnSummary.
        :rtype: str
        """
        return self._vcn_name

    @vcn_name.setter
    def vcn_name(self, vcn_name):
        """
        Sets the vcn_name of this InventoryVcnSummary.
        Name of the VCN.


        :param vcn_name: The vcn_name of this InventoryVcnSummary.
        :type: str
        """
        self._vcn_name = vcn_name

    @property
    def resource_type(self):
        """
        Gets the resource_type of this InventoryVcnSummary.
        Resource types of the VCN.

        Allowed values for this property are: "VCN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The resource_type of this InventoryVcnSummary.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this InventoryVcnSummary.
        Resource types of the VCN.


        :param resource_type: The resource_type of this InventoryVcnSummary.
        :type: str
        """
        allowed_values = ["VCN"]
        if not value_allowed_none_or_none_sentinel(resource_type, allowed_values):
            resource_type = 'UNKNOWN_ENUM_VALUE'
        self._resource_type = resource_type

    @property
    def inventory_vcn_cidr_block_collection(self):
        """
        Gets the inventory_vcn_cidr_block_collection of this InventoryVcnSummary.
        Lists `InventoryVcnCidrBlockSummary` objects.


        :return: The inventory_vcn_cidr_block_collection of this InventoryVcnSummary.
        :rtype: list[oci.core.models.InventoryVcnCidrBlockSummary]
        """
        return self._inventory_vcn_cidr_block_collection

    @inventory_vcn_cidr_block_collection.setter
    def inventory_vcn_cidr_block_collection(self, inventory_vcn_cidr_block_collection):
        """
        Sets the inventory_vcn_cidr_block_collection of this InventoryVcnSummary.
        Lists `InventoryVcnCidrBlockSummary` objects.


        :param inventory_vcn_cidr_block_collection: The inventory_vcn_cidr_block_collection of this InventoryVcnSummary.
        :type: list[oci.core.models.InventoryVcnCidrBlockSummary]
        """
        self._inventory_vcn_cidr_block_collection = inventory_vcn_cidr_block_collection

    @property
    def dns_domain_name(self):
        """
        Gets the dns_domain_name of this InventoryVcnSummary.
        DNS domain name of the VCN.


        :return: The dns_domain_name of this InventoryVcnSummary.
        :rtype: str
        """
        return self._dns_domain_name

    @dns_domain_name.setter
    def dns_domain_name(self, dns_domain_name):
        """
        Sets the dns_domain_name of this InventoryVcnSummary.
        DNS domain name of the VCN.


        :param dns_domain_name: The dns_domain_name of this InventoryVcnSummary.
        :type: str
        """
        self._dns_domain_name = dns_domain_name

    @property
    def region(self):
        """
        Gets the region of this InventoryVcnSummary.
        Region name of the VCN.


        :return: The region of this InventoryVcnSummary.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this InventoryVcnSummary.
        Region name of the VCN.


        :param region: The region of this InventoryVcnSummary.
        :type: str
        """
        self._region = region

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this InventoryVcnSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this InventoryVcnSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InventoryVcnSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this InventoryVcnSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def inventory_subnetcollection(self):
        """
        Gets the inventory_subnetcollection of this InventoryVcnSummary.
        Lists `Subnetcollection` objects


        :return: The inventory_subnetcollection of this InventoryVcnSummary.
        :rtype: list[oci.core.models.InventorySubnetSummary]
        """
        return self._inventory_subnetcollection

    @inventory_subnetcollection.setter
    def inventory_subnetcollection(self, inventory_subnetcollection):
        """
        Sets the inventory_subnetcollection of this InventoryVcnSummary.
        Lists `Subnetcollection` objects


        :param inventory_subnetcollection: The inventory_subnetcollection of this InventoryVcnSummary.
        :type: list[oci.core.models.InventorySubnetSummary]
        """
        self._inventory_subnetcollection = inventory_subnetcollection

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
