# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CheckSummary(object):
    """
    The summary of the security rule to be evaluated by security assessment to create finding.
    """

    #: A constant which can be used with the suggested_severity property of a CheckSummary.
    #: This constant has a value of "HIGH"
    SUGGESTED_SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the suggested_severity property of a CheckSummary.
    #: This constant has a value of "MEDIUM"
    SUGGESTED_SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the suggested_severity property of a CheckSummary.
    #: This constant has a value of "LOW"
    SUGGESTED_SEVERITY_LOW = "LOW"

    #: A constant which can be used with the suggested_severity property of a CheckSummary.
    #: This constant has a value of "EVALUATE"
    SUGGESTED_SEVERITY_EVALUATE = "EVALUATE"

    #: A constant which can be used with the suggested_severity property of a CheckSummary.
    #: This constant has a value of "ADVISORY"
    SUGGESTED_SEVERITY_ADVISORY = "ADVISORY"

    #: A constant which can be used with the suggested_severity property of a CheckSummary.
    #: This constant has a value of "PASS"
    SUGGESTED_SEVERITY_PASS = "PASS"

    #: A constant which can be used with the suggested_severity property of a CheckSummary.
    #: This constant has a value of "DEFERRED"
    SUGGESTED_SEVERITY_DEFERRED = "DEFERRED"

    def __init__(self, **kwargs):
        """
        Initializes a new CheckSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this CheckSummary.
        :type key: str

        :param title:
            The value to assign to the title property of this CheckSummary.
        :type title: str

        :param remarks:
            The value to assign to the remarks property of this CheckSummary.
        :type remarks: str

        :param references:
            The value to assign to the references property of this CheckSummary.
        :type references: oci.data_safe.models.References

        :param category:
            The value to assign to the category property of this CheckSummary.
        :type category: str

        :param oneline:
            The value to assign to the oneline property of this CheckSummary.
        :type oneline: str

        :param suggested_severity:
            The value to assign to the suggested_severity property of this CheckSummary.
            Allowed values for this property are: "HIGH", "MEDIUM", "LOW", "EVALUATE", "ADVISORY", "PASS", "DEFERRED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type suggested_severity: str

        """
        self.swagger_types = {
            'key': 'str',
            'title': 'str',
            'remarks': 'str',
            'references': 'References',
            'category': 'str',
            'oneline': 'str',
            'suggested_severity': 'str'
        }
        self.attribute_map = {
            'key': 'key',
            'title': 'title',
            'remarks': 'remarks',
            'references': 'references',
            'category': 'category',
            'oneline': 'oneline',
            'suggested_severity': 'suggestedSeverity'
        }
        self._key = None
        self._title = None
        self._remarks = None
        self._references = None
        self._category = None
        self._oneline = None
        self._suggested_severity = None

    @property
    def key(self):
        """
        **[Required]** Gets the key of this CheckSummary.
        A unique identifier for the check.


        :return: The key of this CheckSummary.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this CheckSummary.
        A unique identifier for the check.


        :param key: The key of this CheckSummary.
        :type: str
        """
        self._key = key

    @property
    def title(self):
        """
        **[Required]** Gets the title of this CheckSummary.
        The short title for the check.


        :return: The title of this CheckSummary.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this CheckSummary.
        The short title for the check.


        :param title: The title of this CheckSummary.
        :type: str
        """
        self._title = title

    @property
    def remarks(self):
        """
        Gets the remarks of this CheckSummary.
        The explanation of the issue in this check. It explains the reason for the rule and, if a risk is reported, it may also explain the recommended actions for remediation.


        :return: The remarks of this CheckSummary.
        :rtype: str
        """
        return self._remarks

    @remarks.setter
    def remarks(self, remarks):
        """
        Sets the remarks of this CheckSummary.
        The explanation of the issue in this check. It explains the reason for the rule and, if a risk is reported, it may also explain the recommended actions for remediation.


        :param remarks: The remarks of this CheckSummary.
        :type: str
        """
        self._remarks = remarks

    @property
    def references(self):
        """
        Gets the references of this CheckSummary.
        Provides information on whether the check is related to a CIS Oracle Database Benchmark recommendation, STIG rule, GDPR Article/Recital or related to the Oracle Recommended Practice.


        :return: The references of this CheckSummary.
        :rtype: oci.data_safe.models.References
        """
        return self._references

    @references.setter
    def references(self, references):
        """
        Sets the references of this CheckSummary.
        Provides information on whether the check is related to a CIS Oracle Database Benchmark recommendation, STIG rule, GDPR Article/Recital or related to the Oracle Recommended Practice.


        :param references: The references of this CheckSummary.
        :type: oci.data_safe.models.References
        """
        self._references = references

    @property
    def category(self):
        """
        Gets the category of this CheckSummary.
        The category to which the check belongs to.


        :return: The category of this CheckSummary.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this CheckSummary.
        The category to which the check belongs to.


        :param category: The category of this CheckSummary.
        :type: str
        """
        self._category = category

    @property
    def oneline(self):
        """
        Gets the oneline of this CheckSummary.
        Provides a recommended approach to take to remediate the check reported.


        :return: The oneline of this CheckSummary.
        :rtype: str
        """
        return self._oneline

    @oneline.setter
    def oneline(self, oneline):
        """
        Sets the oneline of this CheckSummary.
        Provides a recommended approach to take to remediate the check reported.


        :param oneline: The oneline of this CheckSummary.
        :type: str
        """
        self._oneline = oneline

    @property
    def suggested_severity(self):
        """
        Gets the suggested_severity of this CheckSummary.
        The severity of the check as suggested by Data Safe security assessment. This will be the default severity in the template baseline security assessment.

        Allowed values for this property are: "HIGH", "MEDIUM", "LOW", "EVALUATE", "ADVISORY", "PASS", "DEFERRED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The suggested_severity of this CheckSummary.
        :rtype: str
        """
        return self._suggested_severity

    @suggested_severity.setter
    def suggested_severity(self, suggested_severity):
        """
        Sets the suggested_severity of this CheckSummary.
        The severity of the check as suggested by Data Safe security assessment. This will be the default severity in the template baseline security assessment.


        :param suggested_severity: The suggested_severity of this CheckSummary.
        :type: str
        """
        allowed_values = ["HIGH", "MEDIUM", "LOW", "EVALUATE", "ADVISORY", "PASS", "DEFERRED"]
        if not value_allowed_none_or_none_sentinel(suggested_severity, allowed_values):
            suggested_severity = 'UNKNOWN_ENUM_VALUE'
        self._suggested_severity = suggested_severity

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
