# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .autonomous_database_encryption_key_details import AutonomousDatabaseEncryptionKeyDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciKeyDetails(AutonomousDatabaseEncryptionKeyDetails):
    """
    Details for OCI encryption key.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciKeyDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database.models.OciKeyDetails.provider` attribute
        of this class is ``OCI`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param provider:
            The value to assign to the provider property of this OciKeyDetails.
            Allowed values for this property are: "AWS", "AZURE", "OCI", "ORACLE_MANAGED", "OKV"
        :type provider: str

        :param kms_key_id:
            The value to assign to the kms_key_id property of this OciKeyDetails.
        :type kms_key_id: str

        :param vault_id:
            The value to assign to the vault_id property of this OciKeyDetails.
        :type vault_id: str

        """
        self.swagger_types = {
            'provider': 'str',
            'kms_key_id': 'str',
            'vault_id': 'str'
        }
        self.attribute_map = {
            'provider': 'provider',
            'kms_key_id': 'kmsKeyId',
            'vault_id': 'vaultId'
        }
        self._provider = None
        self._kms_key_id = None
        self._vault_id = None
        self._provider = 'OCI'

    @property
    def kms_key_id(self):
        """
        **[Required]** Gets the kms_key_id of this OciKeyDetails.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :return: The kms_key_id of this OciKeyDetails.
        :rtype: str
        """
        return self._kms_key_id

    @kms_key_id.setter
    def kms_key_id(self, kms_key_id):
        """
        Sets the kms_key_id of this OciKeyDetails.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :param kms_key_id: The kms_key_id of this OciKeyDetails.
        :type: str
        """
        self._kms_key_id = kms_key_id

    @property
    def vault_id(self):
        """
        **[Required]** Gets the vault_id of this OciKeyDetails.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `secretId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :return: The vault_id of this OciKeyDetails.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this OciKeyDetails.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `secretId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :param vault_id: The vault_id of this OciKeyDetails.
        :type: str
        """
        self._vault_id = vault_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
