# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FppServer(object):
    """
    Description of FPP Server.
    """

    #: A constant which can be used with the lifecycle_state property of a FppServer.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a FppServer.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a FppServer.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FppServer.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a FppServer.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a FppServer.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new FppServer object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this FppServer.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this FppServer.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this FppServer.
        :type compartment_id: str

        :param management_agent_id:
            The value to assign to the management_agent_id property of this FppServer.
        :type management_agent_id: str

        :param mac_agent_compartment_id:
            The value to assign to the mac_agent_compartment_id property of this FppServer.
        :type mac_agent_compartment_id: str

        :param fpp_rest_url:
            The value to assign to the fpp_rest_url property of this FppServer.
        :type fpp_rest_url: str

        :param trust_store_location:
            The value to assign to the trust_store_location property of this FppServer.
        :type trust_store_location: str

        :param trust_store_password:
            The value to assign to the trust_store_password property of this FppServer.
        :type trust_store_password: str

        :param rest_user_name:
            The value to assign to the rest_user_name property of this FppServer.
        :type rest_user_name: str

        :param rest_user_password:
            The value to assign to the rest_user_password property of this FppServer.
        :type rest_user_password: str

        :param time_created:
            The value to assign to the time_created property of this FppServer.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this FppServer.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this FppServer.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this FppServer.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this FppServer.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this FppServer.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this FppServer.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'management_agent_id': 'str',
            'mac_agent_compartment_id': 'str',
            'fpp_rest_url': 'str',
            'trust_store_location': 'str',
            'trust_store_password': 'str',
            'rest_user_name': 'str',
            'rest_user_password': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'management_agent_id': 'managementAgentId',
            'mac_agent_compartment_id': 'macAgentCompartmentId',
            'fpp_rest_url': 'fppRestUrl',
            'trust_store_location': 'trustStoreLocation',
            'trust_store_password': 'trustStorePassword',
            'rest_user_name': 'restUserName',
            'rest_user_password': 'restUserPassword',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._management_agent_id = None
        self._mac_agent_compartment_id = None
        self._fpp_rest_url = None
        self._trust_store_location = None
        self._trust_store_password = None
        self._rest_user_name = None
        self._rest_user_password = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this FppServer.
        Unique identifier that is immutable on creation


        :return: The id of this FppServer.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FppServer.
        Unique identifier that is immutable on creation


        :param id: The id of this FppServer.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this FppServer.
        FPP Server Identifier, can be renamed


        :return: The display_name of this FppServer.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this FppServer.
        FPP Server Identifier, can be renamed


        :param display_name: The display_name of this FppServer.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this FppServer.
        Compartment Identifier


        :return: The compartment_id of this FppServer.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FppServer.
        Compartment Identifier


        :param compartment_id: The compartment_id of this FppServer.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def management_agent_id(self):
        """
        Gets the management_agent_id of this FppServer.
        Unique Management Agent identifier


        :return: The management_agent_id of this FppServer.
        :rtype: str
        """
        return self._management_agent_id

    @management_agent_id.setter
    def management_agent_id(self, management_agent_id):
        """
        Sets the management_agent_id of this FppServer.
        Unique Management Agent identifier


        :param management_agent_id: The management_agent_id of this FppServer.
        :type: str
        """
        self._management_agent_id = management_agent_id

    @property
    def mac_agent_compartment_id(self):
        """
        Gets the mac_agent_compartment_id of this FppServer.
        Unique Management Agent Compartment identifier


        :return: The mac_agent_compartment_id of this FppServer.
        :rtype: str
        """
        return self._mac_agent_compartment_id

    @mac_agent_compartment_id.setter
    def mac_agent_compartment_id(self, mac_agent_compartment_id):
        """
        Sets the mac_agent_compartment_id of this FppServer.
        Unique Management Agent Compartment identifier


        :param mac_agent_compartment_id: The mac_agent_compartment_id of this FppServer.
        :type: str
        """
        self._mac_agent_compartment_id = mac_agent_compartment_id

    @property
    def fpp_rest_url(self):
        """
        Gets the fpp_rest_url of this FppServer.
        REST endpoint URL of FPP Server


        :return: The fpp_rest_url of this FppServer.
        :rtype: str
        """
        return self._fpp_rest_url

    @fpp_rest_url.setter
    def fpp_rest_url(self, fpp_rest_url):
        """
        Sets the fpp_rest_url of this FppServer.
        REST endpoint URL of FPP Server


        :param fpp_rest_url: The fpp_rest_url of this FppServer.
        :type: str
        """
        self._fpp_rest_url = fpp_rest_url

    @property
    def trust_store_location(self):
        """
        Gets the trust_store_location of this FppServer.
        Absolute path of JKS Trust Store


        :return: The trust_store_location of this FppServer.
        :rtype: str
        """
        return self._trust_store_location

    @trust_store_location.setter
    def trust_store_location(self, trust_store_location):
        """
        Sets the trust_store_location of this FppServer.
        Absolute path of JKS Trust Store


        :param trust_store_location: The trust_store_location of this FppServer.
        :type: str
        """
        self._trust_store_location = trust_store_location

    @property
    def trust_store_password(self):
        """
        Gets the trust_store_password of this FppServer.
        JKS Trust Store Password


        :return: The trust_store_password of this FppServer.
        :rtype: str
        """
        return self._trust_store_password

    @trust_store_password.setter
    def trust_store_password(self, trust_store_password):
        """
        Sets the trust_store_password of this FppServer.
        JKS Trust Store Password


        :param trust_store_password: The trust_store_password of this FppServer.
        :type: str
        """
        self._trust_store_password = trust_store_password

    @property
    def rest_user_name(self):
        """
        Gets the rest_user_name of this FppServer.
        FPP REST User Name


        :return: The rest_user_name of this FppServer.
        :rtype: str
        """
        return self._rest_user_name

    @rest_user_name.setter
    def rest_user_name(self, rest_user_name):
        """
        Sets the rest_user_name of this FppServer.
        FPP REST User Name


        :param rest_user_name: The rest_user_name of this FppServer.
        :type: str
        """
        self._rest_user_name = rest_user_name

    @property
    def rest_user_password(self):
        """
        Gets the rest_user_password of this FppServer.
        FPP REST User Password


        :return: The rest_user_password of this FppServer.
        :rtype: str
        """
        return self._rest_user_password

    @rest_user_password.setter
    def rest_user_password(self, rest_user_password):
        """
        Sets the rest_user_password of this FppServer.
        FPP REST User Password


        :param rest_user_password: The rest_user_password of this FppServer.
        :type: str
        """
        self._rest_user_password = rest_user_password

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this FppServer.
        The time the the FPP server was created. An RFC3339 formatted datetime string


        :return: The time_created of this FppServer.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this FppServer.
        The time the the FPP server was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this FppServer.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this FppServer.
        The time the FPP server was updated. An RFC3339 formatted datetime string


        :return: The time_updated of this FppServer.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this FppServer.
        The time the FPP server was updated. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this FppServer.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this FppServer.
        The current state of the FPP server.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"


        :return: The lifecycle_state of this FppServer.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this FppServer.
        The current state of the FPP server.


        :param lifecycle_state: The lifecycle_state of this FppServer.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            raise ValueError(
                f"Invalid value for `lifecycle_state`, must be None or one of {allowed_values}"
            )
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this FppServer.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this FppServer.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this FppServer.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this FppServer.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this FppServer.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this FppServer.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this FppServer.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this FppServer.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this FppServer.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this FppServer.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this FppServer.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this FppServer.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this FppServer.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this FppServer.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this FppServer.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this FppServer.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
