# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220618


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DesktopPoolSummary(object):
    """
    Provides information about the desktop pool such as number of active desktops, name, OCID, state, and maximum size.
    """

    #: A constant which can be used with the lifecycle_state property of a DesktopPoolSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a DesktopPoolSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DesktopPoolSummary.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DesktopPoolSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a DesktopPoolSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a DesktopPoolSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a DesktopPoolSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new DesktopPoolSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DesktopPoolSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this DesktopPoolSummary.
        :type display_name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DesktopPoolSummary.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param maximum_size:
            The value to assign to the maximum_size property of this DesktopPoolSummary.
        :type maximum_size: int

        :param active_desktops:
            The value to assign to the active_desktops property of this DesktopPoolSummary.
        :type active_desktops: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DesktopPoolSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DesktopPoolSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param contact_details:
            The value to assign to the contact_details property of this DesktopPoolSummary.
        :type contact_details: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DesktopPoolSummary.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this DesktopPoolSummary.
        :type time_created: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'lifecycle_state': 'str',
            'maximum_size': 'int',
            'active_desktops': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'contact_details': 'str',
            'compartment_id': 'str',
            'time_created': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'lifecycle_state': 'lifecycleState',
            'maximum_size': 'maximumSize',
            'active_desktops': 'activeDesktops',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'contact_details': 'contactDetails',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated'
        }
        self._id = None
        self._display_name = None
        self._lifecycle_state = None
        self._maximum_size = None
        self._active_desktops = None
        self._freeform_tags = None
        self._defined_tags = None
        self._contact_details = None
        self._compartment_id = None
        self._time_created = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DesktopPoolSummary.
        The OCID of the desktop pool.


        :return: The id of this DesktopPoolSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DesktopPoolSummary.
        The OCID of the desktop pool.


        :param id: The id of this DesktopPoolSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DesktopPoolSummary.
        A user friendly display name. Avoid entering confidential information.


        :return: The display_name of this DesktopPoolSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DesktopPoolSummary.
        A user friendly display name. Avoid entering confidential information.


        :param display_name: The display_name of this DesktopPoolSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DesktopPoolSummary.
        The current state of the desktop pool.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DesktopPoolSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DesktopPoolSummary.
        The current state of the desktop pool.


        :param lifecycle_state: The lifecycle_state of this DesktopPoolSummary.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def maximum_size(self):
        """
        **[Required]** Gets the maximum_size of this DesktopPoolSummary.
        The maximum number of desktops permitted in the desktop pool.


        :return: The maximum_size of this DesktopPoolSummary.
        :rtype: int
        """
        return self._maximum_size

    @maximum_size.setter
    def maximum_size(self, maximum_size):
        """
        Sets the maximum_size of this DesktopPoolSummary.
        The maximum number of desktops permitted in the desktop pool.


        :param maximum_size: The maximum_size of this DesktopPoolSummary.
        :type: int
        """
        self._maximum_size = maximum_size

    @property
    def active_desktops(self):
        """
        Gets the active_desktops of this DesktopPoolSummary.
        The number of active desktops in the desktop pool.


        :return: The active_desktops of this DesktopPoolSummary.
        :rtype: int
        """
        return self._active_desktops

    @active_desktops.setter
    def active_desktops(self, active_desktops):
        """
        Sets the active_desktops of this DesktopPoolSummary.
        The number of active desktops in the desktop pool.


        :param active_desktops: The active_desktops of this DesktopPoolSummary.
        :type: int
        """
        self._active_desktops = active_desktops

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DesktopPoolSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this DesktopPoolSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DesktopPoolSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this DesktopPoolSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DesktopPoolSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this DesktopPoolSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DesktopPoolSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this DesktopPoolSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def contact_details(self):
        """
        **[Required]** Gets the contact_details of this DesktopPoolSummary.
        Contact information of the desktop pool administrator.
        Avoid entering confidential information.


        :return: The contact_details of this DesktopPoolSummary.
        :rtype: str
        """
        return self._contact_details

    @contact_details.setter
    def contact_details(self, contact_details):
        """
        Sets the contact_details of this DesktopPoolSummary.
        Contact information of the desktop pool administrator.
        Avoid entering confidential information.


        :param contact_details: The contact_details of this DesktopPoolSummary.
        :type: str
        """
        self._contact_details = contact_details

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DesktopPoolSummary.
        The OCID of the compartment which will contain the desktop pool.


        :return: The compartment_id of this DesktopPoolSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DesktopPoolSummary.
        The OCID of the compartment which will contain the desktop pool.


        :param compartment_id: The compartment_id of this DesktopPoolSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DesktopPoolSummary.
        The date and time the resource was created.


        :return: The time_created of this DesktopPoolSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DesktopPoolSummary.
        The date and time the resource was created.


        :param time_created: The time_created of this DesktopPoolSummary.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
