# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DistributedAutonomousDatabaseGsm(object):
    """
    Details of global service manager(GSM also known as shard director) instances for the Globally distributed autonomous database.
    """

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseGsm.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseGsm.
    #: This constant has a value of "DELETING"
    STATUS_DELETING = "DELETING"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseGsm.
    #: This constant has a value of "DELETED"
    STATUS_DELETED = "DELETED"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseGsm.
    #: This constant has a value of "UPDATING"
    STATUS_UPDATING = "UPDATING"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseGsm.
    #: This constant has a value of "CREATING"
    STATUS_CREATING = "CREATING"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseGsm.
    #: This constant has a value of "CREATED"
    STATUS_CREATED = "CREATED"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseGsm.
    #: This constant has a value of "READY_FOR_CONFIGURATION"
    STATUS_READY_FOR_CONFIGURATION = "READY_FOR_CONFIGURATION"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseGsm.
    #: This constant has a value of "CONFIGURED"
    STATUS_CONFIGURED = "CONFIGURED"

    #: A constant which can be used with the status property of a DistributedAutonomousDatabaseGsm.
    #: This constant has a value of "NEEDS_ATTENTION"
    STATUS_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new DistributedAutonomousDatabaseGsm object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this DistributedAutonomousDatabaseGsm.
        :type name: str

        :param compute_count:
            The value to assign to the compute_count property of this DistributedAutonomousDatabaseGsm.
        :type compute_count: float

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this DistributedAutonomousDatabaseGsm.
        :type data_storage_size_in_gbs: float

        :param time_created:
            The value to assign to the time_created property of this DistributedAutonomousDatabaseGsm.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DistributedAutonomousDatabaseGsm.
        :type time_updated: datetime

        :param status:
            The value to assign to the status property of this DistributedAutonomousDatabaseGsm.
            Allowed values for this property are: "FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param time_ssl_certificate_expires:
            The value to assign to the time_ssl_certificate_expires property of this DistributedAutonomousDatabaseGsm.
        :type time_ssl_certificate_expires: datetime

        :param supporting_resource_id:
            The value to assign to the supporting_resource_id property of this DistributedAutonomousDatabaseGsm.
        :type supporting_resource_id: str

        :param gsm_image_details:
            The value to assign to the gsm_image_details property of this DistributedAutonomousDatabaseGsm.
        :type gsm_image_details: oci.distributed_database.models.DistributedAutonomousDatabaseGsmImage

        :param metadata:
            The value to assign to the metadata property of this DistributedAutonomousDatabaseGsm.
        :type metadata: oci.distributed_database.models.DistributedAutonomousDbMetadata

        """
        self.swagger_types = {
            'name': 'str',
            'compute_count': 'float',
            'data_storage_size_in_gbs': 'float',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'status': 'str',
            'time_ssl_certificate_expires': 'datetime',
            'supporting_resource_id': 'str',
            'gsm_image_details': 'DistributedAutonomousDatabaseGsmImage',
            'metadata': 'DistributedAutonomousDbMetadata'
        }
        self.attribute_map = {
            'name': 'name',
            'compute_count': 'computeCount',
            'data_storage_size_in_gbs': 'dataStorageSizeInGbs',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'status': 'status',
            'time_ssl_certificate_expires': 'timeSslCertificateExpires',
            'supporting_resource_id': 'supportingResourceId',
            'gsm_image_details': 'gsmImageDetails',
            'metadata': 'metadata'
        }
        self._name = None
        self._compute_count = None
        self._data_storage_size_in_gbs = None
        self._time_created = None
        self._time_updated = None
        self._status = None
        self._time_ssl_certificate_expires = None
        self._supporting_resource_id = None
        self._gsm_image_details = None
        self._metadata = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this DistributedAutonomousDatabaseGsm.
        Name of the Global service manager instance


        :return: The name of this DistributedAutonomousDatabaseGsm.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DistributedAutonomousDatabaseGsm.
        Name of the Global service manager instance


        :param name: The name of this DistributedAutonomousDatabaseGsm.
        :type: str
        """
        self._name = name

    @property
    def compute_count(self):
        """
        **[Required]** Gets the compute_count of this DistributedAutonomousDatabaseGsm.
        The compute count for the Global service manager instance.


        :return: The compute_count of this DistributedAutonomousDatabaseGsm.
        :rtype: float
        """
        return self._compute_count

    @compute_count.setter
    def compute_count(self, compute_count):
        """
        Sets the compute_count of this DistributedAutonomousDatabaseGsm.
        The compute count for the Global service manager instance.


        :param compute_count: The compute_count of this DistributedAutonomousDatabaseGsm.
        :type: float
        """
        self._compute_count = compute_count

    @property
    def data_storage_size_in_gbs(self):
        """
        **[Required]** Gets the data_storage_size_in_gbs of this DistributedAutonomousDatabaseGsm.
        The data disk group size to be allocated in GBs for the Global service manager instance.


        :return: The data_storage_size_in_gbs of this DistributedAutonomousDatabaseGsm.
        :rtype: float
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this DistributedAutonomousDatabaseGsm.
        The data disk group size to be allocated in GBs for the Global service manager instance.


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this DistributedAutonomousDatabaseGsm.
        :type: float
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DistributedAutonomousDatabaseGsm.
        The time the Global service manager instance was created. An RFC3339 formatted datetime string


        :return: The time_created of this DistributedAutonomousDatabaseGsm.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DistributedAutonomousDatabaseGsm.
        The time the Global service manager instance was created. An RFC3339 formatted datetime string


        :param time_created: The time_created of this DistributedAutonomousDatabaseGsm.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this DistributedAutonomousDatabaseGsm.
        The time the Global service manager instance was last updated. An RFC3339 formatted datetime string


        :return: The time_updated of this DistributedAutonomousDatabaseGsm.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DistributedAutonomousDatabaseGsm.
        The time the Global service manager instance was last updated. An RFC3339 formatted datetime string


        :param time_updated: The time_updated of this DistributedAutonomousDatabaseGsm.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def status(self):
        """
        **[Required]** Gets the status of this DistributedAutonomousDatabaseGsm.
        Status of the gsm for the Globally distributed autonomous database.

        Allowed values for this property are: "FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this DistributedAutonomousDatabaseGsm.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this DistributedAutonomousDatabaseGsm.
        Status of the gsm for the Globally distributed autonomous database.


        :param status: The status of this DistributedAutonomousDatabaseGsm.
        :type: str
        """
        allowed_values = ["FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def time_ssl_certificate_expires(self):
        """
        Gets the time_ssl_certificate_expires of this DistributedAutonomousDatabaseGsm.
        The time the ssl certificate associated with Global service manager expires. An RFC3339 formatted datetime string


        :return: The time_ssl_certificate_expires of this DistributedAutonomousDatabaseGsm.
        :rtype: datetime
        """
        return self._time_ssl_certificate_expires

    @time_ssl_certificate_expires.setter
    def time_ssl_certificate_expires(self, time_ssl_certificate_expires):
        """
        Sets the time_ssl_certificate_expires of this DistributedAutonomousDatabaseGsm.
        The time the ssl certificate associated with Global service manager expires. An RFC3339 formatted datetime string


        :param time_ssl_certificate_expires: The time_ssl_certificate_expires of this DistributedAutonomousDatabaseGsm.
        :type: datetime
        """
        self._time_ssl_certificate_expires = time_ssl_certificate_expires

    @property
    def supporting_resource_id(self):
        """
        Gets the supporting_resource_id of this DistributedAutonomousDatabaseGsm.
        the identifier of the underlying supporting resource.


        :return: The supporting_resource_id of this DistributedAutonomousDatabaseGsm.
        :rtype: str
        """
        return self._supporting_resource_id

    @supporting_resource_id.setter
    def supporting_resource_id(self, supporting_resource_id):
        """
        Sets the supporting_resource_id of this DistributedAutonomousDatabaseGsm.
        the identifier of the underlying supporting resource.


        :param supporting_resource_id: The supporting_resource_id of this DistributedAutonomousDatabaseGsm.
        :type: str
        """
        self._supporting_resource_id = supporting_resource_id

    @property
    def gsm_image_details(self):
        """
        Gets the gsm_image_details of this DistributedAutonomousDatabaseGsm.

        :return: The gsm_image_details of this DistributedAutonomousDatabaseGsm.
        :rtype: oci.distributed_database.models.DistributedAutonomousDatabaseGsmImage
        """
        return self._gsm_image_details

    @gsm_image_details.setter
    def gsm_image_details(self, gsm_image_details):
        """
        Sets the gsm_image_details of this DistributedAutonomousDatabaseGsm.

        :param gsm_image_details: The gsm_image_details of this DistributedAutonomousDatabaseGsm.
        :type: oci.distributed_database.models.DistributedAutonomousDatabaseGsmImage
        """
        self._gsm_image_details = gsm_image_details

    @property
    def metadata(self):
        """
        Gets the metadata of this DistributedAutonomousDatabaseGsm.

        :return: The metadata of this DistributedAutonomousDatabaseGsm.
        :rtype: oci.distributed_database.models.DistributedAutonomousDbMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this DistributedAutonomousDatabaseGsm.

        :param metadata: The metadata of this DistributedAutonomousDatabaseGsm.
        :type: oci.distributed_database.models.DistributedAutonomousDbMetadata
        """
        self._metadata = metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
