# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101

from .distributed_database_shard import DistributedDatabaseShard
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DistributedDatabaseShardWithExadbXs(DistributedDatabaseShard):
    """
    Globally distributed database shard based on exadbxs.
    """

    #: A constant which can be used with the status property of a DistributedDatabaseShardWithExadbXs.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a DistributedDatabaseShardWithExadbXs.
    #: This constant has a value of "DELETING"
    STATUS_DELETING = "DELETING"

    #: A constant which can be used with the status property of a DistributedDatabaseShardWithExadbXs.
    #: This constant has a value of "DELETED"
    STATUS_DELETED = "DELETED"

    #: A constant which can be used with the status property of a DistributedDatabaseShardWithExadbXs.
    #: This constant has a value of "UPDATING"
    STATUS_UPDATING = "UPDATING"

    #: A constant which can be used with the status property of a DistributedDatabaseShardWithExadbXs.
    #: This constant has a value of "CREATING"
    STATUS_CREATING = "CREATING"

    #: A constant which can be used with the status property of a DistributedDatabaseShardWithExadbXs.
    #: This constant has a value of "CREATED"
    STATUS_CREATED = "CREATED"

    #: A constant which can be used with the status property of a DistributedDatabaseShardWithExadbXs.
    #: This constant has a value of "READY_FOR_CONFIGURATION"
    STATUS_READY_FOR_CONFIGURATION = "READY_FOR_CONFIGURATION"

    #: A constant which can be used with the status property of a DistributedDatabaseShardWithExadbXs.
    #: This constant has a value of "CONFIGURED"
    STATUS_CONFIGURED = "CONFIGURED"

    #: A constant which can be used with the status property of a DistributedDatabaseShardWithExadbXs.
    #: This constant has a value of "NEEDS_ATTENTION"
    STATUS_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new DistributedDatabaseShardWithExadbXs object with values from keyword arguments. The default value of the :py:attr:`~oci.distributed_database.models.DistributedDatabaseShardWithExadbXs.source` attribute
        of this class is ``EXADB_XS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source:
            The value to assign to the source property of this DistributedDatabaseShardWithExadbXs.
            Allowed values for this property are: "EXADB_XS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type source: str

        :param name:
            The value to assign to the name property of this DistributedDatabaseShardWithExadbXs.
        :type name: str

        :param time_created:
            The value to assign to the time_created property of this DistributedDatabaseShardWithExadbXs.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DistributedDatabaseShardWithExadbXs.
        :type time_updated: datetime

        :param db_home_id:
            The value to assign to the db_home_id property of this DistributedDatabaseShardWithExadbXs.
        :type db_home_id: str

        :param shard_group:
            The value to assign to the shard_group property of this DistributedDatabaseShardWithExadbXs.
        :type shard_group: str

        :param vm_cluster_id:
            The value to assign to the vm_cluster_id property of this DistributedDatabaseShardWithExadbXs.
        :type vm_cluster_id: str

        :param shard_space:
            The value to assign to the shard_space property of this DistributedDatabaseShardWithExadbXs.
        :type shard_space: str

        :param vault_id:
            The value to assign to the vault_id property of this DistributedDatabaseShardWithExadbXs.
        :type vault_id: str

        :param kms_key_id:
            The value to assign to the kms_key_id property of this DistributedDatabaseShardWithExadbXs.
        :type kms_key_id: str

        :param kms_key_version_id:
            The value to assign to the kms_key_version_id property of this DistributedDatabaseShardWithExadbXs.
        :type kms_key_version_id: str

        :param status:
            The value to assign to the status property of this DistributedDatabaseShardWithExadbXs.
            Allowed values for this property are: "FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param supporting_resource_id:
            The value to assign to the supporting_resource_id property of this DistributedDatabaseShardWithExadbXs.
        :type supporting_resource_id: str

        :param container_database_id:
            The value to assign to the container_database_id property of this DistributedDatabaseShardWithExadbXs.
        :type container_database_id: str

        :param peer_details:
            The value to assign to the peer_details property of this DistributedDatabaseShardWithExadbXs.
        :type peer_details: list[oci.distributed_database.models.ShardPeerWithExadbXs]

        :param metadata:
            The value to assign to the metadata property of this DistributedDatabaseShardWithExadbXs.
        :type metadata: oci.distributed_database.models.DistributedDbMetadata

        """
        self.swagger_types = {
            'source': 'str',
            'name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'db_home_id': 'str',
            'shard_group': 'str',
            'vm_cluster_id': 'str',
            'shard_space': 'str',
            'vault_id': 'str',
            'kms_key_id': 'str',
            'kms_key_version_id': 'str',
            'status': 'str',
            'supporting_resource_id': 'str',
            'container_database_id': 'str',
            'peer_details': 'list[ShardPeerWithExadbXs]',
            'metadata': 'DistributedDbMetadata'
        }
        self.attribute_map = {
            'source': 'source',
            'name': 'name',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'db_home_id': 'dbHomeId',
            'shard_group': 'shardGroup',
            'vm_cluster_id': 'vmClusterId',
            'shard_space': 'shardSpace',
            'vault_id': 'vaultId',
            'kms_key_id': 'kmsKeyId',
            'kms_key_version_id': 'kmsKeyVersionId',
            'status': 'status',
            'supporting_resource_id': 'supportingResourceId',
            'container_database_id': 'containerDatabaseId',
            'peer_details': 'peerDetails',
            'metadata': 'metadata'
        }
        self._source = None
        self._name = None
        self._time_created = None
        self._time_updated = None
        self._db_home_id = None
        self._shard_group = None
        self._vm_cluster_id = None
        self._shard_space = None
        self._vault_id = None
        self._kms_key_id = None
        self._kms_key_version_id = None
        self._status = None
        self._supporting_resource_id = None
        self._container_database_id = None
        self._peer_details = None
        self._metadata = None
        self._source = 'EXADB_XS'

    @property
    def db_home_id(self):
        """
        Gets the db_home_id of this DistributedDatabaseShardWithExadbXs.
        The `OCID`__ of the Database Home.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The db_home_id of this DistributedDatabaseShardWithExadbXs.
        :rtype: str
        """
        return self._db_home_id

    @db_home_id.setter
    def db_home_id(self, db_home_id):
        """
        Sets the db_home_id of this DistributedDatabaseShardWithExadbXs.
        The `OCID`__ of the Database Home.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param db_home_id: The db_home_id of this DistributedDatabaseShardWithExadbXs.
        :type: str
        """
        self._db_home_id = db_home_id

    @property
    def shard_group(self):
        """
        **[Required]** Gets the shard_group of this DistributedDatabaseShardWithExadbXs.
        The name of the shardGroup for the shard.


        :return: The shard_group of this DistributedDatabaseShardWithExadbXs.
        :rtype: str
        """
        return self._shard_group

    @shard_group.setter
    def shard_group(self, shard_group):
        """
        Sets the shard_group of this DistributedDatabaseShardWithExadbXs.
        The name of the shardGroup for the shard.


        :param shard_group: The shard_group of this DistributedDatabaseShardWithExadbXs.
        :type: str
        """
        self._shard_group = shard_group

    @property
    def vm_cluster_id(self):
        """
        **[Required]** Gets the vm_cluster_id of this DistributedDatabaseShardWithExadbXs.
        The `OCID`__ of the VmCluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vm_cluster_id of this DistributedDatabaseShardWithExadbXs.
        :rtype: str
        """
        return self._vm_cluster_id

    @vm_cluster_id.setter
    def vm_cluster_id(self, vm_cluster_id):
        """
        Sets the vm_cluster_id of this DistributedDatabaseShardWithExadbXs.
        The `OCID`__ of the VmCluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vm_cluster_id: The vm_cluster_id of this DistributedDatabaseShardWithExadbXs.
        :type: str
        """
        self._vm_cluster_id = vm_cluster_id

    @property
    def shard_space(self):
        """
        Gets the shard_space of this DistributedDatabaseShardWithExadbXs.
        The shard space name for the Globally distributed database. Shard space for existing shard cannot be changed, once shard is created.
        Shard space name shall be used while creation of new shards.


        :return: The shard_space of this DistributedDatabaseShardWithExadbXs.
        :rtype: str
        """
        return self._shard_space

    @shard_space.setter
    def shard_space(self, shard_space):
        """
        Sets the shard_space of this DistributedDatabaseShardWithExadbXs.
        The shard space name for the Globally distributed database. Shard space for existing shard cannot be changed, once shard is created.
        Shard space name shall be used while creation of new shards.


        :param shard_space: The shard_space of this DistributedDatabaseShardWithExadbXs.
        :type: str
        """
        self._shard_space = shard_space

    @property
    def vault_id(self):
        """
        Gets the vault_id of this DistributedDatabaseShardWithExadbXs.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `kmsKeyId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :return: The vault_id of this DistributedDatabaseShardWithExadbXs.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this DistributedDatabaseShardWithExadbXs.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `kmsKeyId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :param vault_id: The vault_id of this DistributedDatabaseShardWithExadbXs.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def kms_key_id(self):
        """
        Gets the kms_key_id of this DistributedDatabaseShardWithExadbXs.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :return: The kms_key_id of this DistributedDatabaseShardWithExadbXs.
        :rtype: str
        """
        return self._kms_key_id

    @kms_key_id.setter
    def kms_key_id(self, kms_key_id):
        """
        Sets the kms_key_id of this DistributedDatabaseShardWithExadbXs.
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.


        :param kms_key_id: The kms_key_id of this DistributedDatabaseShardWithExadbXs.
        :type: str
        """
        self._kms_key_id = kms_key_id

    @property
    def kms_key_version_id(self):
        """
        Gets the kms_key_version_id of this DistributedDatabaseShardWithExadbXs.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions.


        :return: The kms_key_version_id of this DistributedDatabaseShardWithExadbXs.
        :rtype: str
        """
        return self._kms_key_version_id

    @kms_key_version_id.setter
    def kms_key_version_id(self, kms_key_version_id):
        """
        Sets the kms_key_version_id of this DistributedDatabaseShardWithExadbXs.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions.


        :param kms_key_version_id: The kms_key_version_id of this DistributedDatabaseShardWithExadbXs.
        :type: str
        """
        self._kms_key_version_id = kms_key_version_id

    @property
    def status(self):
        """
        **[Required]** Gets the status of this DistributedDatabaseShardWithExadbXs.
        Status of EXADB_XS based shard.

        Allowed values for this property are: "FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this DistributedDatabaseShardWithExadbXs.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this DistributedDatabaseShardWithExadbXs.
        Status of EXADB_XS based shard.


        :param status: The status of this DistributedDatabaseShardWithExadbXs.
        :type: str
        """
        allowed_values = ["FAILED", "DELETING", "DELETED", "UPDATING", "CREATING", "CREATED", "READY_FOR_CONFIGURATION", "CONFIGURED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def supporting_resource_id(self):
        """
        Gets the supporting_resource_id of this DistributedDatabaseShardWithExadbXs.
        the identifier of the underlying supporting resource.


        :return: The supporting_resource_id of this DistributedDatabaseShardWithExadbXs.
        :rtype: str
        """
        return self._supporting_resource_id

    @supporting_resource_id.setter
    def supporting_resource_id(self, supporting_resource_id):
        """
        Sets the supporting_resource_id of this DistributedDatabaseShardWithExadbXs.
        the identifier of the underlying supporting resource.


        :param supporting_resource_id: The supporting_resource_id of this DistributedDatabaseShardWithExadbXs.
        :type: str
        """
        self._supporting_resource_id = supporting_resource_id

    @property
    def container_database_id(self):
        """
        Gets the container_database_id of this DistributedDatabaseShardWithExadbXs.
        the identifier of the container database for underlying supporting resource.


        :return: The container_database_id of this DistributedDatabaseShardWithExadbXs.
        :rtype: str
        """
        return self._container_database_id

    @container_database_id.setter
    def container_database_id(self, container_database_id):
        """
        Sets the container_database_id of this DistributedDatabaseShardWithExadbXs.
        the identifier of the container database for underlying supporting resource.


        :param container_database_id: The container_database_id of this DistributedDatabaseShardWithExadbXs.
        :type: str
        """
        self._container_database_id = container_database_id

    @property
    def peer_details(self):
        """
        Gets the peer_details of this DistributedDatabaseShardWithExadbXs.
        Peer details for the shard.


        :return: The peer_details of this DistributedDatabaseShardWithExadbXs.
        :rtype: list[oci.distributed_database.models.ShardPeerWithExadbXs]
        """
        return self._peer_details

    @peer_details.setter
    def peer_details(self, peer_details):
        """
        Sets the peer_details of this DistributedDatabaseShardWithExadbXs.
        Peer details for the shard.


        :param peer_details: The peer_details of this DistributedDatabaseShardWithExadbXs.
        :type: list[oci.distributed_database.models.ShardPeerWithExadbXs]
        """
        self._peer_details = peer_details

    @property
    def metadata(self):
        """
        Gets the metadata of this DistributedDatabaseShardWithExadbXs.

        :return: The metadata of this DistributedDatabaseShardWithExadbXs.
        :rtype: oci.distributed_database.models.DistributedDbMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this DistributedDatabaseShardWithExadbXs.

        :param metadata: The metadata of this DistributedDatabaseShardWithExadbXs.
        :type: oci.distributed_database.models.DistributedDbMetadata
        """
        self._metadata = metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
