# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ColumnMetadata(object):
    """
    Column metadata.
    """

    #: A constant which can be used with the type property of a ColumnMetadata.
    #: This constant has a value of "STRING"
    TYPE_STRING = "STRING"

    #: A constant which can be used with the type property of a ColumnMetadata.
    #: This constant has a value of "NUMBER"
    TYPE_NUMBER = "NUMBER"

    #: A constant which can be used with the type property of a ColumnMetadata.
    #: This constant has a value of "DATE_TIME"
    TYPE_DATE_TIME = "DATE_TIME"

    def __init__(self, **kwargs):
        """
        Initializes a new ColumnMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this ColumnMetadata.
        :type name: str

        :param description:
            The value to assign to the description property of this ColumnMetadata.
        :type description: str

        :param type:
            The value to assign to the type property of this ColumnMetadata.
            Allowed values for this property are: "STRING", "NUMBER", "DATE_TIME", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'type': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'type': 'type'
        }
        self._name = None
        self._description = None
        self._type = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ColumnMetadata.
        Column name.


        :return: The name of this ColumnMetadata.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ColumnMetadata.
        Column name.


        :param name: The name of this ColumnMetadata.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        **[Required]** Gets the description of this ColumnMetadata.
        Column description


        :return: The description of this ColumnMetadata.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ColumnMetadata.
        Column description


        :param description: The description of this ColumnMetadata.
        :type: str
        """
        self._description = description

    @property
    def type(self):
        """
        **[Required]** Gets the type of this ColumnMetadata.
        Column value type.

        Allowed values for this property are: "STRING", "NUMBER", "DATE_TIME", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this ColumnMetadata.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ColumnMetadata.
        Column value type.


        :param type: The type of this ColumnMetadata.
        :type: str
        """
        allowed_values = ["STRING", "NUMBER", "DATE_TIME"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
