# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReportTimeRange(object):
    """
    TimeRange Object
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReportTimeRange object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_from:
            The value to assign to the time_from property of this ReportTimeRange.
        :type time_from: datetime

        :param time_until:
            The value to assign to the time_until property of this ReportTimeRange.
        :type time_until: datetime

        """
        self.swagger_types = {
            'time_from': 'datetime',
            'time_until': 'datetime'
        }
        self.attribute_map = {
            'time_from': 'timeFrom',
            'time_until': 'timeUntil'
        }
        self._time_from = None
        self._time_until = None

    @property
    def time_from(self):
        """
        **[Required]** Gets the time_from of this ReportTimeRange.
        Start Date for the report. An RFC3339 formatted datetime string


        :return: The time_from of this ReportTimeRange.
        :rtype: datetime
        """
        return self._time_from

    @time_from.setter
    def time_from(self, time_from):
        """
        Sets the time_from of this ReportTimeRange.
        Start Date for the report. An RFC3339 formatted datetime string


        :param time_from: The time_from of this ReportTimeRange.
        :type: datetime
        """
        self._time_from = time_from

    @property
    def time_until(self):
        """
        **[Required]** Gets the time_until of this ReportTimeRange.
        End Date for the report. An RFC3339 formatted datetime string


        :return: The time_until of this ReportTimeRange.
        :rtype: datetime
        """
        return self._time_until

    @time_until.setter
    def time_until(self, time_until):
        """
        Sets the time_until of this ReportTimeRange.
        End Date for the report. An RFC3339 formatted datetime string


        :param time_until: The time_until of this ReportTimeRange.
        :type: datetime
        """
        self._time_until = time_until

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
