# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDataSourceDetails(object):
    """
    The data to create a data source.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDataSourceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateDataSourceDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateDataSourceDetails.
        :type description: str

        :param knowledge_base_id:
            The value to assign to the knowledge_base_id property of this CreateDataSourceDetails.
        :type knowledge_base_id: str

        :param data_source_config:
            The value to assign to the data_source_config property of this CreateDataSourceDetails.
        :type data_source_config: oci.generative_ai_agent.models.DataSourceConfig

        :param metadata:
            The value to assign to the metadata property of this CreateDataSourceDetails.
        :type metadata: dict(str, str)

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDataSourceDetails.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDataSourceDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDataSourceDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'knowledge_base_id': 'str',
            'data_source_config': 'DataSourceConfig',
            'metadata': 'dict(str, str)',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'knowledge_base_id': 'knowledgeBaseId',
            'data_source_config': 'dataSourceConfig',
            'metadata': 'metadata',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._knowledge_base_id = None
        self._data_source_config = None
        self._metadata = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateDataSourceDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateDataSourceDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDataSourceDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateDataSourceDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateDataSourceDetails.
        A description of the data source.


        :return: The description of this CreateDataSourceDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateDataSourceDetails.
        A description of the data source.


        :param description: The description of this CreateDataSourceDetails.
        :type: str
        """
        self._description = description

    @property
    def knowledge_base_id(self):
        """
        **[Required]** Gets the knowledge_base_id of this CreateDataSourceDetails.
        The `OCID`__ of the parent KnowledgeBase.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The knowledge_base_id of this CreateDataSourceDetails.
        :rtype: str
        """
        return self._knowledge_base_id

    @knowledge_base_id.setter
    def knowledge_base_id(self, knowledge_base_id):
        """
        Sets the knowledge_base_id of this CreateDataSourceDetails.
        The `OCID`__ of the parent KnowledgeBase.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param knowledge_base_id: The knowledge_base_id of this CreateDataSourceDetails.
        :type: str
        """
        self._knowledge_base_id = knowledge_base_id

    @property
    def data_source_config(self):
        """
        **[Required]** Gets the data_source_config of this CreateDataSourceDetails.

        :return: The data_source_config of this CreateDataSourceDetails.
        :rtype: oci.generative_ai_agent.models.DataSourceConfig
        """
        return self._data_source_config

    @data_source_config.setter
    def data_source_config(self, data_source_config):
        """
        Sets the data_source_config of this CreateDataSourceDetails.

        :param data_source_config: The data_source_config of this CreateDataSourceDetails.
        :type: oci.generative_ai_agent.models.DataSourceConfig
        """
        self._data_source_config = data_source_config

    @property
    def metadata(self):
        """
        Gets the metadata of this CreateDataSourceDetails.
        Key-value pairs to allow additional configurations.


        :return: The metadata of this CreateDataSourceDetails.
        :rtype: dict(str, str)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this CreateDataSourceDetails.
        Key-value pairs to allow additional configurations.


        :param metadata: The metadata of this CreateDataSourceDetails.
        :type: dict(str, str)
        """
        self._metadata = metadata

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateDataSourceDetails.
        The `OCID`__ of the compartment to create the data source in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateDataSourceDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateDataSourceDetails.
        The `OCID`__ of the compartment to create the data source in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateDataSourceDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDataSourceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateDataSourceDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDataSourceDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateDataSourceDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDataSourceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateDataSourceDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDataSourceDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateDataSourceDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
