# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .trace import Trace
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GenerationTrace(Trace):
    """
    The trace information about the generated response.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GenerationTrace object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent_runtime.models.GenerationTrace.trace_type` attribute
        of this class is ``GENERATION_TRACE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this GenerationTrace.
        :type key: str

        :param parent_key:
            The value to assign to the parent_key property of this GenerationTrace.
        :type parent_key: str

        :param source:
            The value to assign to the source property of this GenerationTrace.
        :type source: oci.generative_ai_agent_runtime.models.SourceDetails

        :param time_created:
            The value to assign to the time_created property of this GenerationTrace.
        :type time_created: datetime

        :param time_finished:
            The value to assign to the time_finished property of this GenerationTrace.
        :type time_finished: datetime

        :param trace_type:
            The value to assign to the trace_type property of this GenerationTrace.
            Allowed values for this property are: "ERROR_TRACE", "RETRIEVAL_TRACE", "GENERATION_TRACE", "TOOL_INVOCATION_TRACE", "PLANNING_TRACE", "EXECUTION_TRACE"
        :type trace_type: str

        :param generation:
            The value to assign to the generation property of this GenerationTrace.
        :type generation: str

        :param input:
            The value to assign to the input property of this GenerationTrace.
        :type input: str

        :param usage:
            The value to assign to the usage property of this GenerationTrace.
        :type usage: list[oci.generative_ai_agent_runtime.models.Usage]

        """
        self.swagger_types = {
            'key': 'str',
            'parent_key': 'str',
            'source': 'SourceDetails',
            'time_created': 'datetime',
            'time_finished': 'datetime',
            'trace_type': 'str',
            'generation': 'str',
            'input': 'str',
            'usage': 'list[Usage]'
        }
        self.attribute_map = {
            'key': 'key',
            'parent_key': 'parentKey',
            'source': 'source',
            'time_created': 'timeCreated',
            'time_finished': 'timeFinished',
            'trace_type': 'traceType',
            'generation': 'generation',
            'input': 'input',
            'usage': 'usage'
        }
        self._key = None
        self._parent_key = None
        self._source = None
        self._time_created = None
        self._time_finished = None
        self._trace_type = None
        self._generation = None
        self._input = None
        self._usage = None
        self._trace_type = 'GENERATION_TRACE'

    @property
    def generation(self):
        """
        Gets the generation of this GenerationTrace.
        The generated response that's returned to the user.


        :return: The generation of this GenerationTrace.
        :rtype: str
        """
        return self._generation

    @generation.setter
    def generation(self, generation):
        """
        Sets the generation of this GenerationTrace.
        The generated response that's returned to the user.


        :param generation: The generation of this GenerationTrace.
        :type: str
        """
        self._generation = generation

    @property
    def input(self):
        """
        Gets the input of this GenerationTrace.
        The input to the generation operation.


        :return: The input of this GenerationTrace.
        :rtype: str
        """
        return self._input

    @input.setter
    def input(self, input):
        """
        Sets the input of this GenerationTrace.
        The input to the generation operation.


        :param input: The input of this GenerationTrace.
        :type: str
        """
        self._input = input

    @property
    def usage(self):
        """
        Gets the usage of this GenerationTrace.
        Details of model and its usage.


        :return: The usage of this GenerationTrace.
        :rtype: list[oci.generative_ai_agent_runtime.models.Usage]
        """
        return self._usage

    @usage.setter
    def usage(self, usage):
        """
        Sets the usage of this GenerationTrace.
        Details of model and its usage.


        :param usage: The usage of this GenerationTrace.
        :type: list[oci.generative_ai_agent_runtime.models.Usage]
        """
        self._usage = usage

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
