# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppCloudControlProperties(object):
    """
    A collection of arbitrary properties that scope the privileges of a cloud-control App.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AppCloudControlProperties object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this AppCloudControlProperties.
        :type name: str

        :param values:
            The value to assign to the values property of this AppCloudControlProperties.
        :type values: list[str]

        """
        self.swagger_types = {
            'name': 'str',
            'values': 'list[str]'
        }
        self.attribute_map = {
            'name': 'name',
            'values': 'values'
        }
        self._name = None
        self._values = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this AppCloudControlProperties.
        The name of the property.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The name of this AppCloudControlProperties.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AppCloudControlProperties.
        The name of the property.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param name: The name of this AppCloudControlProperties.
        :type: str
        """
        self._name = name

    @property
    def values(self):
        """
        **[Required]** Gets the values of this AppCloudControlProperties.
        The value(s) of the property.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The values of this AppCloudControlProperties.
        :rtype: list[str]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this AppCloudControlProperties.
        The value(s) of the property.

        **Added In:** 18.4.2

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param values: The values of this AppCloudControlProperties.
        :type: list[str]
        """
        self._values = values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
