# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDigitalTwinRelationshipDetails(object):
    """
    The information about new digital twin relationship to be created.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDigitalTwinRelationshipDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param iot_domain_id:
            The value to assign to the iot_domain_id property of this CreateDigitalTwinRelationshipDetails.
        :type iot_domain_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateDigitalTwinRelationshipDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateDigitalTwinRelationshipDetails.
        :type description: str

        :param content_path:
            The value to assign to the content_path property of this CreateDigitalTwinRelationshipDetails.
        :type content_path: str

        :param source_digital_twin_instance_id:
            The value to assign to the source_digital_twin_instance_id property of this CreateDigitalTwinRelationshipDetails.
        :type source_digital_twin_instance_id: str

        :param target_digital_twin_instance_id:
            The value to assign to the target_digital_twin_instance_id property of this CreateDigitalTwinRelationshipDetails.
        :type target_digital_twin_instance_id: str

        :param content:
            The value to assign to the content property of this CreateDigitalTwinRelationshipDetails.
        :type content: dict(str, object)

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDigitalTwinRelationshipDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDigitalTwinRelationshipDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'iot_domain_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'content_path': 'str',
            'source_digital_twin_instance_id': 'str',
            'target_digital_twin_instance_id': 'str',
            'content': 'dict(str, object)',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'iot_domain_id': 'iotDomainId',
            'display_name': 'displayName',
            'description': 'description',
            'content_path': 'contentPath',
            'source_digital_twin_instance_id': 'sourceDigitalTwinInstanceId',
            'target_digital_twin_instance_id': 'targetDigitalTwinInstanceId',
            'content': 'content',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._iot_domain_id = None
        self._display_name = None
        self._description = None
        self._content_path = None
        self._source_digital_twin_instance_id = None
        self._target_digital_twin_instance_id = None
        self._content = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def iot_domain_id(self):
        """
        **[Required]** Gets the iot_domain_id of this CreateDigitalTwinRelationshipDetails.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The iot_domain_id of this CreateDigitalTwinRelationshipDetails.
        :rtype: str
        """
        return self._iot_domain_id

    @iot_domain_id.setter
    def iot_domain_id(self, iot_domain_id):
        """
        Sets the iot_domain_id of this CreateDigitalTwinRelationshipDetails.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param iot_domain_id: The iot_domain_id of this CreateDigitalTwinRelationshipDetails.
        :type: str
        """
        self._iot_domain_id = iot_domain_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateDigitalTwinRelationshipDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateDigitalTwinRelationshipDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDigitalTwinRelationshipDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateDigitalTwinRelationshipDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateDigitalTwinRelationshipDetails.
        A short description of the resource.


        :return: The description of this CreateDigitalTwinRelationshipDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateDigitalTwinRelationshipDetails.
        A short description of the resource.


        :param description: The description of this CreateDigitalTwinRelationshipDetails.
        :type: str
        """
        self._description = description

    @property
    def content_path(self):
        """
        **[Required]** Gets the content_path of this CreateDigitalTwinRelationshipDetails.
        Its the name of the relationship that links two digital twin instances. Here, it is the relationship name of the source digital twin model.


        :return: The content_path of this CreateDigitalTwinRelationshipDetails.
        :rtype: str
        """
        return self._content_path

    @content_path.setter
    def content_path(self, content_path):
        """
        Sets the content_path of this CreateDigitalTwinRelationshipDetails.
        Its the name of the relationship that links two digital twin instances. Here, it is the relationship name of the source digital twin model.


        :param content_path: The content_path of this CreateDigitalTwinRelationshipDetails.
        :type: str
        """
        self._content_path = content_path

    @property
    def source_digital_twin_instance_id(self):
        """
        **[Required]** Gets the source_digital_twin_instance_id of this CreateDigitalTwinRelationshipDetails.
        The `OCID`__ of source digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The source_digital_twin_instance_id of this CreateDigitalTwinRelationshipDetails.
        :rtype: str
        """
        return self._source_digital_twin_instance_id

    @source_digital_twin_instance_id.setter
    def source_digital_twin_instance_id(self, source_digital_twin_instance_id):
        """
        Sets the source_digital_twin_instance_id of this CreateDigitalTwinRelationshipDetails.
        The `OCID`__ of source digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param source_digital_twin_instance_id: The source_digital_twin_instance_id of this CreateDigitalTwinRelationshipDetails.
        :type: str
        """
        self._source_digital_twin_instance_id = source_digital_twin_instance_id

    @property
    def target_digital_twin_instance_id(self):
        """
        **[Required]** Gets the target_digital_twin_instance_id of this CreateDigitalTwinRelationshipDetails.
        The `OCID`__ of target digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The target_digital_twin_instance_id of this CreateDigitalTwinRelationshipDetails.
        :rtype: str
        """
        return self._target_digital_twin_instance_id

    @target_digital_twin_instance_id.setter
    def target_digital_twin_instance_id(self, target_digital_twin_instance_id):
        """
        Sets the target_digital_twin_instance_id of this CreateDigitalTwinRelationshipDetails.
        The `OCID`__ of target digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param target_digital_twin_instance_id: The target_digital_twin_instance_id of this CreateDigitalTwinRelationshipDetails.
        :type: str
        """
        self._target_digital_twin_instance_id = target_digital_twin_instance_id

    @property
    def content(self):
        """
        Gets the content of this CreateDigitalTwinRelationshipDetails.
        The value(s) of the relationship properties defined in the source digital twin model.


        :return: The content of this CreateDigitalTwinRelationshipDetails.
        :rtype: dict(str, object)
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this CreateDigitalTwinRelationshipDetails.
        The value(s) of the relationship properties defined in the source digital twin model.


        :param content: The content of this CreateDigitalTwinRelationshipDetails.
        :type: dict(str, object)
        """
        self._content = content

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDigitalTwinRelationshipDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateDigitalTwinRelationshipDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDigitalTwinRelationshipDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateDigitalTwinRelationshipDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDigitalTwinRelationshipDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateDigitalTwinRelationshipDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDigitalTwinRelationshipDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateDigitalTwinRelationshipDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
