# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportDataFilters(object):
    """
    Filters applied when exporting data
    """

    #: A constant which can be used with the security_statuses property of a ExportDataFilters.
    #: This constant has a value of "EARLY_ACCESS"
    SECURITY_STATUSES_EARLY_ACCESS = "EARLY_ACCESS"

    #: A constant which can be used with the security_statuses property of a ExportDataFilters.
    #: This constant has a value of "UNKNOWN"
    SECURITY_STATUSES_UNKNOWN = "UNKNOWN"

    #: A constant which can be used with the security_statuses property of a ExportDataFilters.
    #: This constant has a value of "UP_TO_DATE"
    SECURITY_STATUSES_UP_TO_DATE = "UP_TO_DATE"

    #: A constant which can be used with the security_statuses property of a ExportDataFilters.
    #: This constant has a value of "UPDATE_REQUIRED"
    SECURITY_STATUSES_UPDATE_REQUIRED = "UPDATE_REQUIRED"

    #: A constant which can be used with the security_statuses property of a ExportDataFilters.
    #: This constant has a value of "UPGRADE_REQUIRED"
    SECURITY_STATUSES_UPGRADE_REQUIRED = "UPGRADE_REQUIRED"

    def __init__(self, **kwargs):
        """
        Initializes a new ExportDataFilters object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param java_versions:
            The value to assign to the java_versions property of this ExportDataFilters.
        :type java_versions: list[str]

        :param java_major_versions:
            The value to assign to the java_major_versions property of this ExportDataFilters.
        :type java_major_versions: list[str]

        :param java_vendors:
            The value to assign to the java_vendors property of this ExportDataFilters.
        :type java_vendors: list[str]

        :param application_name_equal_to:
            The value to assign to the application_name_equal_to property of this ExportDataFilters.
        :type application_name_equal_to: list[str]

        :param application_name_contains:
            The value to assign to the application_name_contains property of this ExportDataFilters.
        :type application_name_contains: list[str]

        :param security_statuses:
            The value to assign to the security_statuses property of this ExportDataFilters.
            Allowed values for items in this list are: "EARLY_ACCESS", "UNKNOWN", "UP_TO_DATE", "UPDATE_REQUIRED", "UPGRADE_REQUIRED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type security_statuses: list[str]

        """
        self.swagger_types = {
            'java_versions': 'list[str]',
            'java_major_versions': 'list[str]',
            'java_vendors': 'list[str]',
            'application_name_equal_to': 'list[str]',
            'application_name_contains': 'list[str]',
            'security_statuses': 'list[str]'
        }
        self.attribute_map = {
            'java_versions': 'javaVersions',
            'java_major_versions': 'javaMajorVersions',
            'java_vendors': 'javaVendors',
            'application_name_equal_to': 'applicationNameEqualTo',
            'application_name_contains': 'applicationNameContains',
            'security_statuses': 'securityStatuses'
        }
        self._java_versions = None
        self._java_major_versions = None
        self._java_vendors = None
        self._application_name_equal_to = None
        self._application_name_contains = None
        self._security_statuses = None

    @property
    def java_versions(self):
        """
        Gets the java_versions of this ExportDataFilters.
        List of Java versions to filter by


        :return: The java_versions of this ExportDataFilters.
        :rtype: list[str]
        """
        return self._java_versions

    @java_versions.setter
    def java_versions(self, java_versions):
        """
        Sets the java_versions of this ExportDataFilters.
        List of Java versions to filter by


        :param java_versions: The java_versions of this ExportDataFilters.
        :type: list[str]
        """
        self._java_versions = java_versions

    @property
    def java_major_versions(self):
        """
        Gets the java_major_versions of this ExportDataFilters.
        List of Java major versions to filter by


        :return: The java_major_versions of this ExportDataFilters.
        :rtype: list[str]
        """
        return self._java_major_versions

    @java_major_versions.setter
    def java_major_versions(self, java_major_versions):
        """
        Sets the java_major_versions of this ExportDataFilters.
        List of Java major versions to filter by


        :param java_major_versions: The java_major_versions of this ExportDataFilters.
        :type: list[str]
        """
        self._java_major_versions = java_major_versions

    @property
    def java_vendors(self):
        """
        Gets the java_vendors of this ExportDataFilters.
        List of Java vendors to filter by


        :return: The java_vendors of this ExportDataFilters.
        :rtype: list[str]
        """
        return self._java_vendors

    @java_vendors.setter
    def java_vendors(self, java_vendors):
        """
        Sets the java_vendors of this ExportDataFilters.
        List of Java vendors to filter by


        :param java_vendors: The java_vendors of this ExportDataFilters.
        :type: list[str]
        """
        self._java_vendors = java_vendors

    @property
    def application_name_equal_to(self):
        """
        Gets the application_name_equal_to of this ExportDataFilters.
        List of application names to filter by exact match


        :return: The application_name_equal_to of this ExportDataFilters.
        :rtype: list[str]
        """
        return self._application_name_equal_to

    @application_name_equal_to.setter
    def application_name_equal_to(self, application_name_equal_to):
        """
        Sets the application_name_equal_to of this ExportDataFilters.
        List of application names to filter by exact match


        :param application_name_equal_to: The application_name_equal_to of this ExportDataFilters.
        :type: list[str]
        """
        self._application_name_equal_to = application_name_equal_to

    @property
    def application_name_contains(self):
        """
        Gets the application_name_contains of this ExportDataFilters.
        List of application names to filter by partial match


        :return: The application_name_contains of this ExportDataFilters.
        :rtype: list[str]
        """
        return self._application_name_contains

    @application_name_contains.setter
    def application_name_contains(self, application_name_contains):
        """
        Sets the application_name_contains of this ExportDataFilters.
        List of application names to filter by partial match


        :param application_name_contains: The application_name_contains of this ExportDataFilters.
        :type: list[str]
        """
        self._application_name_contains = application_name_contains

    @property
    def security_statuses(self):
        """
        Gets the security_statuses of this ExportDataFilters.
        The security statuses of the Java Runtime

        Allowed values for items in this list are: "EARLY_ACCESS", "UNKNOWN", "UP_TO_DATE", "UPDATE_REQUIRED", "UPGRADE_REQUIRED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The security_statuses of this ExportDataFilters.
        :rtype: list[str]
        """
        return self._security_statuses

    @security_statuses.setter
    def security_statuses(self, security_statuses):
        """
        Sets the security_statuses of this ExportDataFilters.
        The security statuses of the Java Runtime


        :param security_statuses: The security_statuses of this ExportDataFilters.
        :type: list[str]
        """
        allowed_values = ["EARLY_ACCESS", "UNKNOWN", "UP_TO_DATE", "UPDATE_REQUIRED", "UPGRADE_REQUIRED"]
        if security_statuses:
            security_statuses[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in security_statuses]
        self._security_statuses = security_statuses

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
