# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ListingProductAdditionalFilter(object):
    """
    Additional filters attached to a product of listing
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ListingProductAdditionalFilter object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param filter_code:
            The value to assign to the filter_code property of this ListingProductAdditionalFilter.
        :type filter_code: str

        :param filter_properties:
            The value to assign to the filter_properties property of this ListingProductAdditionalFilter.
        :type filter_properties: list[str]

        """
        self.swagger_types = {
            'filter_code': 'str',
            'filter_properties': 'list[str]'
        }
        self.attribute_map = {
            'filter_code': 'filterCode',
            'filter_properties': 'filterProperties'
        }
        self._filter_code = None
        self._filter_properties = None

    @property
    def filter_code(self):
        """
        Gets the filter_code of this ListingProductAdditionalFilter.
        filter code for the product


        :return: The filter_code of this ListingProductAdditionalFilter.
        :rtype: str
        """
        return self._filter_code

    @filter_code.setter
    def filter_code(self, filter_code):
        """
        Sets the filter_code of this ListingProductAdditionalFilter.
        filter code for the product


        :param filter_code: The filter_code of this ListingProductAdditionalFilter.
        :type: str
        """
        self._filter_code = filter_code

    @property
    def filter_properties(self):
        """
        Gets the filter_properties of this ListingProductAdditionalFilter.
        additional properties attached to a filter


        :return: The filter_properties of this ListingProductAdditionalFilter.
        :rtype: list[str]
        """
        return self._filter_properties

    @filter_properties.setter
    def filter_properties(self, filter_properties):
        """
        Sets the filter_properties of this ListingProductAdditionalFilter.
        additional properties attached to a filter


        :param filter_properties: The filter_properties of this ListingProductAdditionalFilter.
        :type: list[str]
        """
        self._filter_properties = filter_properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
