# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828

from __future__ import absolute_import

from oci._vendor import requests  # noqa: F401
from oci._vendor import six

from oci import retry, circuit_breaker  # noqa: F401
from oci.base_client import BaseClient
from oci.config import get_config_value_or_default, validate_config
from oci.signer import Signer
from oci.util import Sentinel, get_signer_from_authentication_type, AUTHENTICATION_TYPE_FIELD_NAME
from oci.exceptions import InvalidAlloyConfig
from oci.alloy import OCI_SDK_ENABLED_SERVICES_SET
from .models import multicloud_type_mapping
missing = Sentinel("Missing")


class MetadataClient(object):
    """
    Use the Oracle Multicloud API to retrieve resource anchors and network anchors, and the metadata mappings related a Cloud Service Provider. For more information, see <link to docs>.
    """

    def __init__(self, config, **kwargs):
        """
        Creates a new service client

        :param dict config:
            Configuration keys and values as per `SDK and Tool Configuration <https://docs.cloud.oracle.com/Content/API/Concepts/sdkconfig.htm>`__.
            The :py:meth:`~oci.config.from_file` method can be used to load configuration from a file. Alternatively, a ``dict`` can be passed. You can validate_config
            the dict using :py:meth:`~oci.config.validate_config`

        :param str service_endpoint: (optional)
            The endpoint of the service to call using this client. For example ``https://iaas.us-ashburn-1.oraclecloud.com``. If this keyword argument is
            not provided then it will be derived using the region in the config parameter. You should only provide this keyword argument if you have an explicit
            need to specify a service endpoint.

        :param timeout: (optional)
            The connection and read timeouts for the client. The default values are connection timeout 10 seconds and read timeout 60 seconds. This keyword argument can be provided
            as a single float, in which case the value provided is used for both the read and connection timeouts, or as a tuple of two floats. If
            a tuple is provided then the first value is used as the connection timeout and the second value as the read timeout.
        :type timeout: float or tuple(float, float)

        :param signer: (optional)
            The signer to use when signing requests made by the service client. The default is to use a :py:class:`~oci.signer.Signer` based on the values
            provided in the config parameter.

            One use case for this parameter is for `Instance Principals authentication <https://docs.cloud.oracle.com/Content/Identity/Tasks/callingservicesfrominstances.htm>`__
            by passing an instance of :py:class:`~oci.auth.signers.InstancePrincipalsSecurityTokenSigner` as the value for this keyword argument
        :type signer: :py:class:`~oci.signer.AbstractBaseSigner`

        :param obj retry_strategy: (optional)
            A retry strategy to apply to all calls made by this service client (i.e. at the client level). There is no retry strategy applied by default.
            Retry strategies can also be applied at the operation level by passing a ``retry_strategy`` keyword argument as part of calling the operation.
            Any value provided at the operation level will override whatever is specified at the client level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. A convenience :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY`
            is also available. The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

        :param obj circuit_breaker_strategy: (optional)
            A circuit breaker strategy to apply to all calls made by this service client (i.e. at the client level).
            This client uses :py:data:`~oci.circuit_breaker.DEFAULT_CIRCUIT_BREAKER_STRATEGY` as default if no circuit breaker strategy is provided.
            The specifics of circuit breaker strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/circuit_breakers.html>`__.

        :param function circuit_breaker_callback: (optional)
            Callback function to receive any exceptions triggerred by the circuit breaker.

        :param bool client_level_realm_specific_endpoint_template_enabled: (optional)
            A boolean flag to indicate whether or not this client should be created with realm specific endpoint template enabled or disable. By default, this will be set as None.

        :param allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this client should allow control characters in the response object. By default, the client will not
            allow control characters to be in the response object.
        """
        if not OCI_SDK_ENABLED_SERVICES_SET.is_service_enabled("multicloud"):
            raise InvalidAlloyConfig("The Alloy configuration has disabled this service, this behavior is controlled by OCI_SDK_ENABLED_SERVICES_SET variable. Please check if your local alloy-config file configured the service you're targeting or contact the cloud provider on the availability of this service")

        validate_config(config, signer=kwargs.get('signer'))
        if 'signer' in kwargs:
            signer = kwargs['signer']

        elif AUTHENTICATION_TYPE_FIELD_NAME in config:
            signer = get_signer_from_authentication_type(config)

        else:
            signer = Signer(
                tenancy=config["tenancy"],
                user=config["user"],
                fingerprint=config["fingerprint"],
                private_key_file_location=config.get("key_file"),
                pass_phrase=get_config_value_or_default(config, "pass_phrase"),
                private_key_content=config.get("key_content")
            )

        base_client_init_kwargs = {
            'regional_client': True,
            'service_endpoint': kwargs.get('service_endpoint'),
            'base_path': '/20180828',
            'service_endpoint_template': 'https://multicloud.{region}.oci.{secondLevelDomain}',
            'service_endpoint_template_per_realm': {  },  # noqa: E201 E202
            'service_uses_dualstack_endpoints_by_default': False,
            'skip_deserialization': kwargs.get('skip_deserialization', False),
            'circuit_breaker_strategy': kwargs.get('circuit_breaker_strategy', circuit_breaker.GLOBAL_CIRCUIT_BREAKER_STRATEGY),
            'client_level_realm_specific_endpoint_template_enabled': kwargs.get('client_level_realm_specific_endpoint_template_enabled'),
            'client_level_dualstack_endpoints_enabled': kwargs.get('client_level_dualstack_endpoints_enabled')
        }
        if 'timeout' in kwargs:
            base_client_init_kwargs['timeout'] = kwargs.get('timeout')
        if base_client_init_kwargs.get('circuit_breaker_strategy') is None:
            base_client_init_kwargs['circuit_breaker_strategy'] = circuit_breaker.DEFAULT_CIRCUIT_BREAKER_STRATEGY
        if 'allow_control_chars' in kwargs:
            base_client_init_kwargs['allow_control_chars'] = kwargs.get('allow_control_chars')
        self.base_client = BaseClient("metadata", config, signer, multicloud_type_mapping, **base_client_init_kwargs)
        self.retry_strategy = kwargs.get('retry_strategy')
        self.circuit_breaker_callback = kwargs.get('circuit_breaker_callback')

    def list_external_location_details_metadata(self, subscription_id, compartment_id, subscription_service_name, **kwargs):
        """
        List externalLocationDetail metadata from OCI to Cloud  Service Provider for regions, Availability Zones, and Cluster Placement Group ID.
        examples:
          application-json: |
            [
              {
                  \"externalLocation\": {
                    \"cspRegion\": \"East US\",
                    \"cspPhysicalAz\": \"az1-xyz\",
                    \"cspPhysicalAzDisplayName\": \"(US) East US 2\",
                    \"cspLogicalAz\": \"az1\",
                    \"serviceName\": \"ORACLEDBATAZURE\",
                    \"cspZoneKeyReferenceId\": {
                      \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",
                      \"keyValue\": \"azure-subscriptionId-1 or aws-account-id-1, gcp-project-id-1\"
                    }
                  },
                  \"ociPhysicalAd\": \"ad1-xyb\",
                  \"ociLogicalAd\": \"ad2\",
                  \"ociRegion\": \"us-ashburn-1\",
                  \"cpgId\": \"cpg-1\"
              },
                {
                  \"externalLocation\": {
                    \"cspRegion\": \"East US\",
                    \"cspPhysicalAz\": \"az2-abc\",
                    \"cspPhysicalAzDisplayName\": \"(US) East US 2\",
                    \"cspLogicalAz\": \"az2\",
                    \"serviceName\": \"ORACLEDBATAZURE\",
                    \"cspZoneKeyReferenceId\": {
                      \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",
                      \"keyValue\": \"azure-subscriptionId-2 or aws-account-id-2, gcp-project-id-2\"
                    }
                  },
                  \"ociPhysicalAd\": \"ad2-xby\",
                  \"ociLogicalAd\": \"ad1\",
                  \"ociRegion\": \"us-ashburn-1\",
                  \"cpgId\": \"cpg-2\"
                },
                {
                  \"externalLocation\": {
                    \"cspRegion\": \"East US\",
                    \"cspPhysicalAz\": \"az3-abz\",
                    \"cspPhysicalAzDisplayName\": \"(US) East US 2\",
                    \"cspLogicalAz\": \"az3\",
                    \"serviceName\": \"ORACLEDBATAZURE\",
                    \"cspZoneKeyReferenceId\": {
                      \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",
                      \"keyValue\": \"azure-subscriptionId-3 or aws-account-id-3, gcp-project-id-3\"
                    }
                  },
                  \"ociPhysicalAd\": \"ad3-cde\",
                  \"ociLogicalAd\": \"ad3\",
                  \"ociRegion\": \"us-ashburn-1\",
                  \"cpgId\": \"cpg-3\"
                },
                {
                  \"externalLocation\": {
                    \"cspRegion\": \"East US 2\",
                    \"cspPhysicalAz\": \"az1-def\",
                    \"cspPhysicalAzDisplayName\": \"(US) East US 2\",
                    \"cspLogicalAz\": \"az1\",
                    \"serviceName\": \"ORACLEDBATAZURE\",
                    \"cspZoneKeyReferenceId\": {
                      \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",
                      \"keyValue\": \"azure-subscriptionId-4 or aws-account-id-4, gcp-project-id-4\"
                    }
                  },
                  \"ociPhysicalAd\": \"ad1-bce\",
                  \"ociLogicalAd\": \"ad2\",
                  \"ociRegion\": \"us-ashburn-1\",
                  \"cpgId\": \"cpg-4\"
                },
                {
                  \"externalLocation\": {
                    \"cspRegion\": \"East US 2\",
                    \"cspPhysicalAz\": \"az2-uvw\",
                    \"cspPhysicalAzDisplayName\": \"(US) East US 2\",
                    \"cspLogicalAz\": \"az2\",
                    \"serviceName\": \"ORACLEDBATAZURE\",
                    \"cspZoneKeyReferenceId\": {
                      \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",
                      \"keyValue\": \"azure-subscriptionId-3 or aws-account-id-3, gcp-project-id-3\"
                    }
                  },
                  \"ociPhysicalAd\": \"ad2-ftc\",
                  \"ociLogicalAd\": \"ad1\",
                  \"ociRegion\": \"us-ashburn-1\",
                  \"cpgId\": \"cpg-5\"
                },
                {
                  \"externalLocation\": {
                    \"cspRegion\": \"East US 2\",
                    \"cspPhysicalAz\": \"az3-uvw\",
                    \"cspPhysicalAzDisplayName\": \"(US) East US 2\",
                    \"cspLogicalAz\": \"az3\",
                    \"serviceName\": \"ORACLEDBATAZURE\",
                    \"cspZoneKeyReferenceId\": {
                      \"keyName\": \"AzureSubscriptionId or AwsAccountId, GcpProjectName\",
                      \"keyValue\": \"azure-subscriptionId-3 or aws-account-id-3, gcp-project-id-3\"
                    }
                  },
                  \"ociPhysicalAd\": \"ad3-stc\",
                  \"ociLogicalAd\": \"ad3\",
                  \"ociRegion\": \"us-ashburn-1\",
                  \"cpgId\": \"cpg-6\"
                }
              ]


        :param str subscription_id: (required)
            The `OCID`__ of the subscription in which to list resources.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param str compartment_id: (required)
            The `OCID`__ of the compartment in which to list resources.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param str subscription_service_name: (required)
            The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]

            Allowed values are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"

        :param str entity_type: (optional)
            The resource type query (i.e. dbsystem, instance etc.)

            Allowed values are: "dbsystem"

        :param str linked_compartment_id: (optional)
            The `OCID`__ of the compartment in which linked to Resource.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param int limit: (optional)
            For list pagination. The maximum number of results per page, or items to return in a
            paginated \"List\" call. For important details about how pagination works, see
            `List Pagination`__.

            __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine

        :param str page: (optional)
            For list pagination. The value of the opc-next-page response header from the previous
            \"List\" call. For important details about how pagination works, see
            `List Pagination`__.

            __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine

        :param str sort_order: (optional)
            The sort order to use, either ascending (`ASC`) or descending (`DESC`).

            Allowed values are: "ASC", "DESC"

        :param str sort_by: (optional)
            The field to sort by. You can provide only one sort order. Default order for `timeCreated`
            is descending. Default order for `displayName` is ascending.

            Allowed values are: "timeCreated", "displayName"

        :param str opc_request_id: (optional)
            Unique Oracle-assigned identifier for the request. If you need to contact
            Oracle about a particular request, please provide the request ID.
            The only valid characters for request IDs are letters, numbers,
            underscore, and dash.

        :param obj retry_strategy: (optional)
            A retry strategy to apply to this specific operation/call. This will override any retry strategy set at the client-level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. This operation uses :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY` as default if no retry strategy is provided.
            The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

            To have this operation explicitly not perform any retries, pass an instance of :py:class:`~oci.retry.NoneRetryStrategy`.

        :param bool allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this request should allow control characters in the response object.
            By default, the response will not allow control characters in strings

        :return: A :class:`~oci.response.Response` object with data of type :class:`~oci.multicloud.models.ExternalLocationsMetadatumCollection`
        :rtype: :class:`~oci.response.Response`

        :example:
        Click `here <https://docs.cloud.oracle.com/en-us/iaas/tools/python-sdk-examples/latest/multicloud/list_external_location_details_metadata.py.html>`__ to see an example of how to use list_external_location_details_metadata API.
        """
        # Required path and query arguments. These are in camelCase to replace values in service endpoints.
        required_arguments = ['subscriptionId', 'compartmentId', 'subscriptionServiceName']
        resource_path = "/externalLocationsMetadata"
        method = "GET"
        operation_name = "list_external_location_details_metadata"
        api_reference_link = "https://docs.oracle.com/iaas/api/#/en/multicloud-omhub-cp/20180828/ExternalLocationsMetadatumCollection/ListExternalLocationDetailsMetadata"

        # Don't accept unknown kwargs
        expected_kwargs = [
            "allow_control_chars",
            "retry_strategy",
            "entity_type",
            "linked_compartment_id",
            "limit",
            "page",
            "sort_order",
            "sort_by",
            "opc_request_id"
        ]
        extra_kwargs = [_key for _key in six.iterkeys(kwargs) if _key not in expected_kwargs]
        if extra_kwargs:
            raise ValueError(
                f"list_external_location_details_metadata got unknown kwargs: {extra_kwargs!r}")

        if 'entity_type' in kwargs:
            entity_type_allowed_values = ["dbsystem"]
            if kwargs['entity_type'] not in entity_type_allowed_values:
                raise ValueError(
                    f"Invalid value for `entity_type`, must be one of { entity_type_allowed_values }"
                )

        subscription_service_name_allowed_values = ["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]
        if subscription_service_name not in subscription_service_name_allowed_values:
            raise ValueError(
                f"Invalid value for `subscription_service_name`, must be one of { subscription_service_name_allowed_values }"
            )

        if 'sort_order' in kwargs:
            sort_order_allowed_values = ["ASC", "DESC"]
            if kwargs['sort_order'] not in sort_order_allowed_values:
                raise ValueError(
                    f"Invalid value for `sort_order`, must be one of { sort_order_allowed_values }"
                )

        if 'sort_by' in kwargs:
            sort_by_allowed_values = ["timeCreated", "displayName"]
            if kwargs['sort_by'] not in sort_by_allowed_values:
                raise ValueError(
                    f"Invalid value for `sort_by`, must be one of { sort_by_allowed_values }"
                )

        query_params = {
            "subscriptionId": subscription_id,
            "entityType": kwargs.get("entity_type", missing),
            "compartmentId": compartment_id,
            "linkedCompartmentId": kwargs.get("linked_compartment_id", missing),
            "subscriptionServiceName": subscription_service_name,
            "limit": kwargs.get("limit", missing),
            "page": kwargs.get("page", missing),
            "sortOrder": kwargs.get("sort_order", missing),
            "sortBy": kwargs.get("sort_by", missing)
        }
        query_params = {k: v for (k, v) in six.iteritems(query_params) if v is not missing and v is not None}

        header_params = {
            "accept": "application/json",
            "content-type": "application/json",
            "opc-request-id": kwargs.get("opc_request_id", missing)
        }
        header_params = {k: v for (k, v) in six.iteritems(header_params) if v is not missing and v is not None}

        retry_strategy = self.base_client.get_preferred_retry_strategy(
            operation_retry_strategy=kwargs.get('retry_strategy'),
            client_retry_strategy=self.retry_strategy
        )
        if retry_strategy is None:
            retry_strategy = retry.DEFAULT_RETRY_STRATEGY

        if retry_strategy:
            if not isinstance(retry_strategy, retry.NoneRetryStrategy):
                self.base_client.add_opc_client_retries_header(header_params)
                retry_strategy.add_circuit_breaker_callback(self.circuit_breaker_callback)
            return retry_strategy.make_retrying_call(
                self.base_client.call_api,
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="ExternalLocationsMetadatumCollection",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
        else:
            return self.base_client.call_api(
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="ExternalLocationsMetadatumCollection",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)

    def list_external_location_mapping_metadata(self, subscription_service_name, compartment_id, **kwargs):
        """
        List externalLocation metadata from OCI to the Cloud Service Provider for regions, Physical Availability Zones.
        examples:
          application-json: |
            [
              {
                \"externalLocation\": {
                  \"cspRegion\": \"eastus\",
                  \"cspPhysicalAz\": \"eastus-az1\",
                  \"cspPhysicalAzDisplayName\": \"(US) East US 1\",
                  \"serviceName\": \"ORACLEDBATAZURE\"
                },
                \"ociPhysicalAd\": \"iad-ad-1\",
                \"ociLogicalAd\": \"ad1\",
                \"ociRegion\": \"us-ashburn-1\"
            },
              {
                \"externalLocation\": {
                  \"cspRegion\": \"eastus\",
                  \"cspPhysicalAz\": \"eastus-az1\",
                  \"cspPhysicalAzDisplayName\": \"(US) East US 1\",
                  \"serviceName\": \"ORACLEDBATAZURE\"
                },
                \"ociPhysicalAd\": \"iad-ad-1\",
                \"ociLogicalAd\": \"ad1\",
                \"ociRegion\": \"us-ashburn-1\"
              },
              {
                \"externalLocation\": {
                  \"cspRegion\": \"eastus2\",
                  \"cspPhysicalAz\": \"eastus2-az3\",
                  \"cspPhysicalAzDisplayName\": \"(US) East US 1\",
                  \"serviceName\": \"ORACLEDBATAZURE\"
                },
                \"ociPhysicalAd\": \"iad-ad-2\",
                \"ociLogicalAd\": \"ad1\",
                \"ociRegion\": \"us-ashburn-1\"
              },
              {
                \"externalLocation\": {
                  \"cspRegion\": \"eastus\",
                  \"cspPhysicalAz\": \"eastus-az3\"
                  \"cspPhysicalAzDisplayName\": \"(US) East US 1\",
                  \"serviceName\": \"ORACLEDBATAZURE\"
                },
                \"ociPhysicalAd\": \"iad-ad-333\",
                \"ociLogicalAd\": \"ad1\",
                \"ociRegion\": \"us-ashburn-1\"
              }
            ]


        :param oci.multicloud.models.list[str] subscription_service_name: (required)
            The subscription type values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]

            Allowed values are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"

        :param str compartment_id: (required)
            The `OCID`__ of the compartment in which to list resources.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param str subscription_id: (optional)
            The `OCID`__ of the subscription in which to list resources.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param int limit: (optional)
            For list pagination. The maximum number of results per page, or items to return in a
            paginated \"List\" call. For important details about how pagination works, see
            `List Pagination`__.

            __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine

        :param str page: (optional)
            For list pagination. The value of the opc-next-page response header from the previous
            \"List\" call. For important details about how pagination works, see
            `List Pagination`__.

            __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine

        :param str sort_order: (optional)
            The sort order to use, either ascending (`ASC`) or descending (`DESC`).

            Allowed values are: "ASC", "DESC"

        :param str sort_by: (optional)
            The field to sort by. You can provide only one sort order. Default order for `timeCreated`
            is descending. Default order for `displayName` is ascending.

            Allowed values are: "timeCreated", "displayName"

        :param str opc_request_id: (optional)
            Unique Oracle-assigned identifier for the request. If you need to contact
            Oracle about a particular request, please provide the request ID.
            The only valid characters for request IDs are letters, numbers,
            underscore, and dash.

        :param obj retry_strategy: (optional)
            A retry strategy to apply to this specific operation/call. This will override any retry strategy set at the client-level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. This operation uses :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY` as default if no retry strategy is provided.
            The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

            To have this operation explicitly not perform any retries, pass an instance of :py:class:`~oci.retry.NoneRetryStrategy`.

        :param bool allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this request should allow control characters in the response object.
            By default, the response will not allow control characters in strings

        :return: A :class:`~oci.response.Response` object with data of type :class:`~oci.multicloud.models.ExternalLocationMappingMetadatumSummaryCollection`
        :rtype: :class:`~oci.response.Response`

        :example:
        Click `here <https://docs.cloud.oracle.com/en-us/iaas/tools/python-sdk-examples/latest/multicloud/list_external_location_mapping_metadata.py.html>`__ to see an example of how to use list_external_location_mapping_metadata API.
        """
        # Required path and query arguments. These are in camelCase to replace values in service endpoints.
        required_arguments = ['subscriptionServiceName', 'compartmentId']
        resource_path = "/externalLocationMappingMetadata"
        method = "GET"
        operation_name = "list_external_location_mapping_metadata"
        api_reference_link = "https://docs.oracle.com/iaas/api/#/en/multicloud-omhub-cp/20180828/ExternalLocationMappingMetadatumSummaryCollection/ListExternalLocationMappingMetadata"

        # Don't accept unknown kwargs
        expected_kwargs = [
            "allow_control_chars",
            "retry_strategy",
            "subscription_id",
            "limit",
            "page",
            "sort_order",
            "sort_by",
            "opc_request_id"
        ]
        extra_kwargs = [_key for _key in six.iterkeys(kwargs) if _key not in expected_kwargs]
        if extra_kwargs:
            raise ValueError(
                f"list_external_location_mapping_metadata got unknown kwargs: {extra_kwargs!r}")

        subscription_service_name_allowed_values = ["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]
        for subscription_service_name_item in subscription_service_name:
            if subscription_service_name_item not in subscription_service_name_allowed_values:
                raise ValueError(
                    f"Invalid value for `subscription_service_name`, must be one of { subscription_service_name_allowed_values }"
                )

        if 'sort_order' in kwargs:
            sort_order_allowed_values = ["ASC", "DESC"]
            if kwargs['sort_order'] not in sort_order_allowed_values:
                raise ValueError(
                    f"Invalid value for `sort_order`, must be one of { sort_order_allowed_values }"
                )

        if 'sort_by' in kwargs:
            sort_by_allowed_values = ["timeCreated", "displayName"]
            if kwargs['sort_by'] not in sort_by_allowed_values:
                raise ValueError(
                    f"Invalid value for `sort_by`, must be one of { sort_by_allowed_values }"
                )

        query_params = {
            "subscriptionId": kwargs.get("subscription_id", missing),
            "subscriptionServiceName": self.base_client.generate_collection_format_param(subscription_service_name, 'multi'),
            "compartmentId": compartment_id,
            "limit": kwargs.get("limit", missing),
            "page": kwargs.get("page", missing),
            "sortOrder": kwargs.get("sort_order", missing),
            "sortBy": kwargs.get("sort_by", missing)
        }
        query_params = {k: v for (k, v) in six.iteritems(query_params) if v is not missing and v is not None}

        header_params = {
            "accept": "application/json",
            "content-type": "application/json",
            "opc-request-id": kwargs.get("opc_request_id", missing)
        }
        header_params = {k: v for (k, v) in six.iteritems(header_params) if v is not missing and v is not None}

        retry_strategy = self.base_client.get_preferred_retry_strategy(
            operation_retry_strategy=kwargs.get('retry_strategy'),
            client_retry_strategy=self.retry_strategy
        )
        if retry_strategy is None:
            retry_strategy = retry.DEFAULT_RETRY_STRATEGY

        if retry_strategy:
            if not isinstance(retry_strategy, retry.NoneRetryStrategy):
                self.base_client.add_opc_client_retries_header(header_params)
                retry_strategy.add_circuit_breaker_callback(self.circuit_breaker_callback)
            return retry_strategy.make_retrying_call(
                self.base_client.call_api,
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="ExternalLocationMappingMetadatumSummaryCollection",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
        else:
            return self.base_client.call_api(
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="ExternalLocationMappingMetadatumSummaryCollection",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)

    def list_external_location_summaries_metadata(self, subscription_service_name, compartment_id, **kwargs):
        """
        List externalLocationSummary metadata from OCI Region to the Cloud Service Provider region across all regions.
        examples:
          application-json: |
            [
              {
                  \"externalLocation\": {
                    \"cspRegion\": \"East US\"
                  },
                  \"ociRegion\": \"us-ashburn-1\"
              },
                {
                  \"externalLocation\": {
                    \"cspRegion\": \"East US 2\"
                  },
                  \"ociRegion\": \"us-ashburn-1\"
                },
                {
                  \"externalLocation\": {
                    \"cspRegion\": \"Germany West Central\"
                  },
                  \"ociRegion\": \"eu-frankfurt-1\",
                }
              ]


        :param str subscription_service_name: (required)
            The subscription service name values from [ORACLEDBATAZURE, ORACLEDBATGOOGLE, ORACLEDBATAWS]

            Allowed values are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"

        :param str compartment_id: (required)
            The `OCID`__ of the compartment in which to list resources.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param str subscription_id: (optional)
            The `OCID`__ of the subscription in which to list resources.

            __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm

        :param str entity_type: (optional)
            The resource type query (i.e. dbsystem, instance etc.)

            Allowed values are: "dbsystem"

        :param int limit: (optional)
            For list pagination. The maximum number of results per page, or items to return in a
            paginated \"List\" call. For important details about how pagination works, see
            `List Pagination`__.

            __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine

        :param str page: (optional)
            For list pagination. The value of the opc-next-page response header from the previous
            \"List\" call. For important details about how pagination works, see
            `List Pagination`__.

            __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine

        :param str sort_order: (optional)
            The sort order to use, either ascending (`ASC`) or descending (`DESC`).

            Allowed values are: "ASC", "DESC"

        :param str sort_by: (optional)
            The field to sort by. You can provide only one sort order. Default order for `timeCreated`
            is descending. Default order for `displayName` is ascending.

            Allowed values are: "timeCreated", "displayName"

        :param str opc_request_id: (optional)
            Unique Oracle-assigned identifier for the request. If you need to contact
            Oracle about a particular request, please provide the request ID.
            The only valid characters for request IDs are letters, numbers,
            underscore, and dash.

        :param obj retry_strategy: (optional)
            A retry strategy to apply to this specific operation/call. This will override any retry strategy set at the client-level.

            This should be one of the strategies available in the :py:mod:`~oci.retry` module. This operation uses :py:data:`~oci.retry.DEFAULT_RETRY_STRATEGY` as default if no retry strategy is provided.
            The specifics of the default retry strategy are described `here <https://docs.oracle.com/en-us/iaas/tools/python/latest/sdk_behaviors/retries.html>`__.

            To have this operation explicitly not perform any retries, pass an instance of :py:class:`~oci.retry.NoneRetryStrategy`.

        :param bool allow_control_chars: (optional)
            allow_control_chars is a boolean to indicate whether or not this request should allow control characters in the response object.
            By default, the response will not allow control characters in strings

        :return: A :class:`~oci.response.Response` object with data of type :class:`~oci.multicloud.models.ExternalLocationSummariesMetadatumSummaryCollection`
        :rtype: :class:`~oci.response.Response`

        :example:
        Click `here <https://docs.cloud.oracle.com/en-us/iaas/tools/python-sdk-examples/latest/multicloud/list_external_location_summaries_metadata.py.html>`__ to see an example of how to use list_external_location_summaries_metadata API.
        """
        # Required path and query arguments. These are in camelCase to replace values in service endpoints.
        required_arguments = ['subscriptionServiceName', 'compartmentId']
        resource_path = "/externalLocationSummariesMetadata"
        method = "GET"
        operation_name = "list_external_location_summaries_metadata"
        api_reference_link = "https://docs.oracle.com/iaas/api/#/en/multicloud-omhub-cp/20180828/ExternalLocationSummariesMetadatumSummaryCollection/ListExternalLocationSummariesMetadata"

        # Don't accept unknown kwargs
        expected_kwargs = [
            "allow_control_chars",
            "retry_strategy",
            "subscription_id",
            "entity_type",
            "limit",
            "page",
            "sort_order",
            "sort_by",
            "opc_request_id"
        ]
        extra_kwargs = [_key for _key in six.iterkeys(kwargs) if _key not in expected_kwargs]
        if extra_kwargs:
            raise ValueError(
                f"list_external_location_summaries_metadata got unknown kwargs: {extra_kwargs!r}")

        subscription_service_name_allowed_values = ["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]
        if subscription_service_name not in subscription_service_name_allowed_values:
            raise ValueError(
                f"Invalid value for `subscription_service_name`, must be one of { subscription_service_name_allowed_values }"
            )

        if 'entity_type' in kwargs:
            entity_type_allowed_values = ["dbsystem"]
            if kwargs['entity_type'] not in entity_type_allowed_values:
                raise ValueError(
                    f"Invalid value for `entity_type`, must be one of { entity_type_allowed_values }"
                )

        if 'sort_order' in kwargs:
            sort_order_allowed_values = ["ASC", "DESC"]
            if kwargs['sort_order'] not in sort_order_allowed_values:
                raise ValueError(
                    f"Invalid value for `sort_order`, must be one of { sort_order_allowed_values }"
                )

        if 'sort_by' in kwargs:
            sort_by_allowed_values = ["timeCreated", "displayName"]
            if kwargs['sort_by'] not in sort_by_allowed_values:
                raise ValueError(
                    f"Invalid value for `sort_by`, must be one of { sort_by_allowed_values }"
                )

        query_params = {
            "subscriptionId": kwargs.get("subscription_id", missing),
            "subscriptionServiceName": subscription_service_name,
            "entityType": kwargs.get("entity_type", missing),
            "compartmentId": compartment_id,
            "limit": kwargs.get("limit", missing),
            "page": kwargs.get("page", missing),
            "sortOrder": kwargs.get("sort_order", missing),
            "sortBy": kwargs.get("sort_by", missing)
        }
        query_params = {k: v for (k, v) in six.iteritems(query_params) if v is not missing and v is not None}

        header_params = {
            "accept": "application/json",
            "content-type": "application/json",
            "opc-request-id": kwargs.get("opc_request_id", missing)
        }
        header_params = {k: v for (k, v) in six.iteritems(header_params) if v is not missing and v is not None}

        retry_strategy = self.base_client.get_preferred_retry_strategy(
            operation_retry_strategy=kwargs.get('retry_strategy'),
            client_retry_strategy=self.retry_strategy
        )
        if retry_strategy is None:
            retry_strategy = retry.DEFAULT_RETRY_STRATEGY

        if retry_strategy:
            if not isinstance(retry_strategy, retry.NoneRetryStrategy):
                self.base_client.add_opc_client_retries_header(header_params)
                retry_strategy.add_circuit_breaker_callback(self.circuit_breaker_callback)
            return retry_strategy.make_retrying_call(
                self.base_client.call_api,
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="ExternalLocationSummariesMetadatumSummaryCollection",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
        else:
            return self.base_client.call_api(
                resource_path=resource_path,
                method=method,
                query_params=query_params,
                header_params=header_params,
                response_type="ExternalLocationSummariesMetadatumSummaryCollection",
                allow_control_chars=kwargs.get('allow_control_chars'),
                operation_name=operation_name,
                api_reference_link=api_reference_link,
                required_arguments=required_arguments)
