# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EncryptDataDetails(object):
    """
    Encrypt data details.
    """

    #: A constant which can be used with the key_generation_type property of a EncryptDataDetails.
    #: This constant has a value of "SYSTEM"
    KEY_GENERATION_TYPE_SYSTEM = "SYSTEM"

    #: A constant which can be used with the key_generation_type property of a EncryptDataDetails.
    #: This constant has a value of "BYOK"
    KEY_GENERATION_TYPE_BYOK = "BYOK"

    def __init__(self, **kwargs):
        """
        Initializes a new EncryptDataDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key_id:
            The value to assign to the key_id property of this EncryptDataDetails.
        :type key_id: str

        :param key_generation_type:
            The value to assign to the key_generation_type property of this EncryptDataDetails.
            Allowed values for this property are: "SYSTEM", "BYOK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type key_generation_type: str

        """
        self.swagger_types = {
            'key_id': 'str',
            'key_generation_type': 'str'
        }
        self.attribute_map = {
            'key_id': 'keyId',
            'key_generation_type': 'keyGenerationType'
        }
        self._key_id = None
        self._key_generation_type = None

    @property
    def key_id(self):
        """
        Gets the key_id of this EncryptDataDetails.
        The OCID of the key to use.


        :return: The key_id of this EncryptDataDetails.
        :rtype: str
        """
        return self._key_id

    @key_id.setter
    def key_id(self, key_id):
        """
        Sets the key_id of this EncryptDataDetails.
        The OCID of the key to use.


        :param key_id: The key_id of this EncryptDataDetails.
        :type: str
        """
        self._key_id = key_id

    @property
    def key_generation_type(self):
        """
        **[Required]** Gets the key_generation_type of this EncryptDataDetails.
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).

        Allowed values for this property are: "SYSTEM", "BYOK", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The key_generation_type of this EncryptDataDetails.
        :rtype: str
        """
        return self._key_generation_type

    @key_generation_type.setter
    def key_generation_type(self, key_generation_type):
        """
        Sets the key_generation_type of this EncryptDataDetails.
        Select whether to use Oracle-managed key (SYSTEM) or your own key (BYOK).


        :param key_generation_type: The key_generation_type of this EncryptDataDetails.
        :type: str
        """
        allowed_values = ["SYSTEM", "BYOK"]
        if not value_allowed_none_or_none_sentinel(key_generation_type, allowed_values):
            key_generation_type = 'UNKNOWN_ENUM_VALUE'
        self._key_generation_type = key_generation_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
