# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NatConfigurationResponse(object):
    """
    Nat Configuration response.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NatConfigurationResponse object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param must_enable_private_nat:
            The value to assign to the must_enable_private_nat property of this NatConfigurationResponse.
        :type must_enable_private_nat: bool

        :param nat_ip_address_list:
            The value to assign to the nat_ip_address_list property of this NatConfigurationResponse.
        :type nat_ip_address_list: list[str]

        """
        self.swagger_types = {
            'must_enable_private_nat': 'bool',
            'nat_ip_address_list': 'list[str]'
        }
        self.attribute_map = {
            'must_enable_private_nat': 'mustEnablePrivateNat',
            'nat_ip_address_list': 'natIpAddressList'
        }
        self._must_enable_private_nat = None
        self._nat_ip_address_list = None

    @property
    def must_enable_private_nat(self):
        """
        Gets the must_enable_private_nat of this NatConfigurationResponse.
        To allocate private NAT IPs to the firewall. The attached network firewall policy must also have NAT rules to enable NAT on any traffic passing through the firewall.


        :return: The must_enable_private_nat of this NatConfigurationResponse.
        :rtype: bool
        """
        return self._must_enable_private_nat

    @must_enable_private_nat.setter
    def must_enable_private_nat(self, must_enable_private_nat):
        """
        Sets the must_enable_private_nat of this NatConfigurationResponse.
        To allocate private NAT IPs to the firewall. The attached network firewall policy must also have NAT rules to enable NAT on any traffic passing through the firewall.


        :param must_enable_private_nat: The must_enable_private_nat of this NatConfigurationResponse.
        :type: bool
        """
        self._must_enable_private_nat = must_enable_private_nat

    @property
    def nat_ip_address_list(self):
        """
        Gets the nat_ip_address_list of this NatConfigurationResponse.
        An array of NAT IP addresses that are associated with the Network Firewall. These IPs are reserved for NAT and shouldn't be used for any other purpose in the subnet.


        :return: The nat_ip_address_list of this NatConfigurationResponse.
        :rtype: list[str]
        """
        return self._nat_ip_address_list

    @nat_ip_address_list.setter
    def nat_ip_address_list(self, nat_ip_address_list):
        """
        Sets the nat_ip_address_list of this NatConfigurationResponse.
        An array of NAT IP addresses that are associated with the Network Firewall. These IPs are reserved for NAT and shouldn't be used for any other purpose in the subnet.


        :param nat_ip_address_list: The nat_ip_address_list of this NatConfigurationResponse.
        :type: list[str]
        """
        self._nat_ip_address_list = nat_ip_address_list

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
