/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtBluetooth.h"

#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtBluetooth/qbluetoothdeviceinfo.sip"
#include <qbluetoothdeviceinfo.h>
#line 29 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"

#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtBluetooth/qbluetoothaddress.sip"
#include <qbluetoothaddress.h>
#line 33 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 27 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 36 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtBluetooth/qbluetoothuuid.sip"
#include <qbluetoothuuid.h>
#line 39 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 30 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 42 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 390 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpycore_qhash.sip"
#include <qhash.h>
#line 45 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 549 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 48 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtBluetooth/qbluetoothdeviceinfo.sip"
#include <qbluetoothdeviceinfo.h>
#line 51 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 38 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 54 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 57 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"
#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtBluetooth/qbluetoothdeviceinfo.sip"
#include <qbluetoothdeviceinfo.h>
#line 60 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtBluetooth/sipQtBluetoothQBluetoothDeviceInfo.cpp"


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_isValid(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_isValid, doc_QBluetoothDeviceInfo_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_isCached, "isCached(self) -> bool");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_isCached(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_isCached(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isCached();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_isCached, doc_QBluetoothDeviceInfo_isCached);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setCached, "setCached(self, cached: bool)");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setCached(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setCached(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, &a0))
        {
            sipCpp->setCached(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setCached, doc_QBluetoothDeviceInfo_setCached);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_address, "address(self) -> QBluetoothAddress");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_address(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_address(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QBluetoothAddress*sipRes;

            sipRes = new ::QBluetoothAddress(sipCpp->address());

            return sipConvertFromNewType(sipRes, sipType_QBluetoothAddress, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_address, doc_QBluetoothDeviceInfo_address);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_name, "name(self) -> str");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_name(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_name(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->name());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_name, doc_QBluetoothDeviceInfo_name);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_serviceClasses, "serviceClasses(self) -> QBluetoothDeviceInfo.ServiceClasses");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_serviceClasses(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_serviceClasses(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QBluetoothDeviceInfo::ServiceClasses*sipRes;

            sipRes = new ::QBluetoothDeviceInfo::ServiceClasses(sipCpp->serviceClasses());

            return sipConvertFromNewType(sipRes, sipType_QBluetoothDeviceInfo_ServiceClasses, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_serviceClasses, doc_QBluetoothDeviceInfo_serviceClasses);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_majorDeviceClass, "majorDeviceClass(self) -> QBluetoothDeviceInfo.MajorDeviceClass");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_majorDeviceClass(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_majorDeviceClass(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QBluetoothDeviceInfo::MajorDeviceClass sipRes;

            sipRes = sipCpp->majorDeviceClass();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QBluetoothDeviceInfo_MajorDeviceClass);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_majorDeviceClass, doc_QBluetoothDeviceInfo_majorDeviceClass);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_minorDeviceClass, "minorDeviceClass(self) -> int");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_minorDeviceClass(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_minorDeviceClass(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::quint8 sipRes;

            sipRes = sipCpp->minorDeviceClass();

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_minorDeviceClass, doc_QBluetoothDeviceInfo_minorDeviceClass);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_rssi, "rssi(self) -> int");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_rssi(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_rssi(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::qint16 sipRes;

            sipRes = sipCpp->rssi();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_rssi, doc_QBluetoothDeviceInfo_rssi);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setRssi, "setRssi(self, signal: int)");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setRssi(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setRssi(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint16 a0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bh", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, &a0))
        {
            sipCpp->setRssi(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setRssi, doc_QBluetoothDeviceInfo_setRssi);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setServiceUuids, "setServiceUuids(self, uuids: Iterable[QBluetoothUuid], completeness: QBluetoothDeviceInfo.DataCompleteness)\n"
"setServiceUuids(self, uuids: Iterable[QBluetoothUuid])");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setServiceUuids(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setServiceUuids(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const QList< ::QBluetoothUuid>* a0;
        int a0State = 0;
        ::QBluetoothDeviceInfo::DataCompleteness a1;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1E", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, sipType_QList_0100QBluetoothUuid, &a0, &a0State, sipType_QBluetoothDeviceInfo_DataCompleteness, &a1))
        {
            sipCpp->setServiceUuids(*a0, a1);
            sipReleaseType(const_cast<QList< ::QBluetoothUuid> *>(a0), sipType_QList_0100QBluetoothUuid, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QVector< ::QBluetoothUuid>* a0;
        int a0State = 0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, sipType_QVector_0100QBluetoothUuid, &a0, &a0State))
        {
            sipCpp->setServiceUuids(*a0);
            sipReleaseType(const_cast<QVector< ::QBluetoothUuid> *>(a0), sipType_QVector_0100QBluetoothUuid, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setServiceUuids, doc_QBluetoothDeviceInfo_setServiceUuids);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_serviceUuids, "serviceUuids(self) -> (list[QBluetoothUuid], Optional[QBluetoothDeviceInfo.DataCompleteness])");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_serviceUuids(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_serviceUuids(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBluetoothDeviceInfo::DataCompleteness a0;
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            QList< ::QBluetoothUuid>*sipRes;

            sipRes = new QList< ::QBluetoothUuid>(sipCpp->serviceUuids(&a0));

            PyObject *sipResObj = sipConvertFromNewType(sipRes, sipType_QList_0100QBluetoothUuid, SIP_NULLPTR);
            return sipBuildResult(0, "(RF)", sipResObj, a0, sipType_QBluetoothDeviceInfo_DataCompleteness);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_serviceUuids, doc_QBluetoothDeviceInfo_serviceUuids);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_serviceUuidsCompleteness, "serviceUuidsCompleteness(self) -> QBluetoothDeviceInfo.DataCompleteness");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_serviceUuidsCompleteness(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_serviceUuidsCompleteness(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QBluetoothDeviceInfo::DataCompleteness sipRes;

            sipRes = sipCpp->serviceUuidsCompleteness();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QBluetoothDeviceInfo_DataCompleteness);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_serviceUuidsCompleteness, doc_QBluetoothDeviceInfo_serviceUuidsCompleteness);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setCoreConfigurations, "setCoreConfigurations(self, coreConfigs: Union[QBluetoothDeviceInfo.CoreConfigurations, QBluetoothDeviceInfo.CoreConfiguration])");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setCoreConfigurations(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setCoreConfigurations(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QBluetoothDeviceInfo::CoreConfigurations* a0;
        int a0State = 0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, sipType_QBluetoothDeviceInfo_CoreConfigurations, &a0, &a0State))
        {
            sipCpp->setCoreConfigurations(*a0);
            sipReleaseType(a0, sipType_QBluetoothDeviceInfo_CoreConfigurations, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setCoreConfigurations, doc_QBluetoothDeviceInfo_setCoreConfigurations);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_coreConfigurations, "coreConfigurations(self) -> QBluetoothDeviceInfo.CoreConfigurations");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_coreConfigurations(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_coreConfigurations(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QBluetoothDeviceInfo::CoreConfigurations*sipRes;

            sipRes = new ::QBluetoothDeviceInfo::CoreConfigurations(sipCpp->coreConfigurations());

            return sipConvertFromNewType(sipRes, sipType_QBluetoothDeviceInfo_CoreConfigurations, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_coreConfigurations, doc_QBluetoothDeviceInfo_coreConfigurations);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setDeviceUuid, "setDeviceUuid(self, uuid: QBluetoothUuid)");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setDeviceUuid(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setDeviceUuid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothUuid* a0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, sipType_QBluetoothUuid, &a0))
        {
            sipCpp->setDeviceUuid(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setDeviceUuid, doc_QBluetoothDeviceInfo_setDeviceUuid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_deviceUuid, "deviceUuid(self) -> QBluetoothUuid");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_deviceUuid(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_deviceUuid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QBluetoothUuid*sipRes;

            sipRes = new ::QBluetoothUuid(sipCpp->deviceUuid());

            return sipConvertFromNewType(sipRes, sipType_QBluetoothUuid, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_deviceUuid, doc_QBluetoothDeviceInfo_deviceUuid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_manufacturerIds, "manufacturerIds(self) -> list[int]");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_manufacturerIds(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_manufacturerIds(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            ::QVector< ::quint16>*sipRes;

            sipRes = new ::QVector< ::quint16>(sipCpp->manufacturerIds());

            return sipConvertFromNewType(sipRes, sipType_QVector_1600, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_manufacturerIds, doc_QBluetoothDeviceInfo_manufacturerIds);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_manufacturerData, "manufacturerData(self, manufacturerId: int) -> QByteArray\n"
"manufacturerData(self) -> dict[int, QByteArray]");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_manufacturerData(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_manufacturerData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::quint16 a0;
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bt", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, &a0))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->manufacturerData(a0));

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    {
        const ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp))
        {
            QHash< ::quint16, QByteArray>*sipRes;

            sipRes = new QHash< ::quint16, QByteArray>(sipCpp->manufacturerData());

            return sipConvertFromNewType(sipRes, sipType_QHash_1600_0100QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_manufacturerData, doc_QBluetoothDeviceInfo_manufacturerData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QBluetoothDeviceInfo_setManufacturerData, "setManufacturerData(self, manufacturerId: int, data: Union[QByteArray, bytes, bytearray]) -> bool");

extern "C" {static PyObject *meth_QBluetoothDeviceInfo_setManufacturerData(PyObject *, PyObject *);}
static PyObject *meth_QBluetoothDeviceInfo_setManufacturerData(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::quint16 a0;
        const ::QByteArray* a1;
        int a1State = 0;
        ::QBluetoothDeviceInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BtJ1", &sipSelf, sipType_QBluetoothDeviceInfo, &sipCpp, &a0, sipType_QByteArray, &a1, &a1State))
        {
            bool sipRes;

            sipRes = sipCpp->setManufacturerData(a0, *a1);
            sipReleaseType(const_cast< ::QByteArray *>(a1), sipType_QByteArray, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QBluetoothDeviceInfo, sipName_setManufacturerData, doc_QBluetoothDeviceInfo_setManufacturerData);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QBluetoothDeviceInfo___ne__(PyObject *, PyObject *);}
static PyObject *slot_QBluetoothDeviceInfo___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QBluetoothDeviceInfo *sipCpp = reinterpret_cast< ::QBluetoothDeviceInfo *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBluetoothDeviceInfo));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBluetoothDeviceInfo, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QBluetoothDeviceInfo::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtBluetooth, ne_slot, sipType_QBluetoothDeviceInfo, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QBluetoothDeviceInfo___eq__(PyObject *, PyObject *);}
static PyObject *slot_QBluetoothDeviceInfo___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QBluetoothDeviceInfo *sipCpp = reinterpret_cast< ::QBluetoothDeviceInfo *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QBluetoothDeviceInfo));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QBluetoothDeviceInfo* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QBluetoothDeviceInfo, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QBluetoothDeviceInfo::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtBluetooth, eq_slot, sipType_QBluetoothDeviceInfo, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QBluetoothDeviceInfo(void *, int);}
static void release_QBluetoothDeviceInfo(void *sipCppV, int)
{
    delete reinterpret_cast< ::QBluetoothDeviceInfo *>(sipCppV);
}


extern "C" {static void *array_QBluetoothDeviceInfo(Py_ssize_t);}
static void *array_QBluetoothDeviceInfo(Py_ssize_t sipNrElem)
{
    return new ::QBluetoothDeviceInfo[sipNrElem];
}


extern "C" {static void array_delete_QBluetoothDeviceInfo(void *);}
static void array_delete_QBluetoothDeviceInfo(void *sipCpp)
{
    delete[] reinterpret_cast< ::QBluetoothDeviceInfo *>(sipCpp);
}


extern "C" {static void assign_QBluetoothDeviceInfo(void *, Py_ssize_t, void *);}
static void assign_QBluetoothDeviceInfo(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QBluetoothDeviceInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QBluetoothDeviceInfo *>(sipSrc);
}


extern "C" {static void *copy_QBluetoothDeviceInfo(const void *, Py_ssize_t);}
static void *copy_QBluetoothDeviceInfo(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QBluetoothDeviceInfo(reinterpret_cast<const ::QBluetoothDeviceInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QBluetoothDeviceInfo(sipSimpleWrapper *);}
static void dealloc_QBluetoothDeviceInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QBluetoothDeviceInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QBluetoothDeviceInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QBluetoothDeviceInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QBluetoothDeviceInfo *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QBluetoothDeviceInfo();

            return sipCpp;
        }
    }

    {
        const ::QBluetoothAddress* a0;
        const ::QString* a1;
        int a1State = 0;
        ::quint32 a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J1u", sipType_QBluetoothAddress, &a0, sipType_QString, &a1, &a1State, &a2))
        {
            sipCpp = new ::QBluetoothDeviceInfo(*a0, *a1, a2);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipCpp;
        }
    }

    {
        const ::QBluetoothUuid* a0;
        const ::QString* a1;
        int a1State = 0;
        ::quint32 a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J1u", sipType_QBluetoothUuid, &a0, sipType_QString, &a1, &a1State, &a2))
        {
            sipCpp = new ::QBluetoothDeviceInfo(*a0, *a1, a2);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipCpp;
        }
    }

    {
        const ::QBluetoothDeviceInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QBluetoothDeviceInfo, &a0))
        {
            sipCpp = new ::QBluetoothDeviceInfo(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QBluetoothDeviceInfo[] = {
    {(void *)slot_QBluetoothDeviceInfo___ne__, ne_slot},
    {(void *)slot_QBluetoothDeviceInfo___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QBluetoothDeviceInfo[] = {
    {sipName_address, meth_QBluetoothDeviceInfo_address, METH_VARARGS, doc_QBluetoothDeviceInfo_address},
    {sipName_coreConfigurations, meth_QBluetoothDeviceInfo_coreConfigurations, METH_VARARGS, doc_QBluetoothDeviceInfo_coreConfigurations},
    {sipName_deviceUuid, meth_QBluetoothDeviceInfo_deviceUuid, METH_VARARGS, doc_QBluetoothDeviceInfo_deviceUuid},
    {sipName_isCached, meth_QBluetoothDeviceInfo_isCached, METH_VARARGS, doc_QBluetoothDeviceInfo_isCached},
    {sipName_isValid, meth_QBluetoothDeviceInfo_isValid, METH_VARARGS, doc_QBluetoothDeviceInfo_isValid},
    {sipName_majorDeviceClass, meth_QBluetoothDeviceInfo_majorDeviceClass, METH_VARARGS, doc_QBluetoothDeviceInfo_majorDeviceClass},
    {sipName_manufacturerData, meth_QBluetoothDeviceInfo_manufacturerData, METH_VARARGS, doc_QBluetoothDeviceInfo_manufacturerData},
    {sipName_manufacturerIds, meth_QBluetoothDeviceInfo_manufacturerIds, METH_VARARGS, doc_QBluetoothDeviceInfo_manufacturerIds},
    {sipName_minorDeviceClass, meth_QBluetoothDeviceInfo_minorDeviceClass, METH_VARARGS, doc_QBluetoothDeviceInfo_minorDeviceClass},
    {sipName_name, meth_QBluetoothDeviceInfo_name, METH_VARARGS, doc_QBluetoothDeviceInfo_name},
    {sipName_rssi, meth_QBluetoothDeviceInfo_rssi, METH_VARARGS, doc_QBluetoothDeviceInfo_rssi},
    {sipName_serviceClasses, meth_QBluetoothDeviceInfo_serviceClasses, METH_VARARGS, doc_QBluetoothDeviceInfo_serviceClasses},
    {sipName_serviceUuids, SIP_MLMETH_CAST(meth_QBluetoothDeviceInfo_serviceUuids), METH_VARARGS|METH_KEYWORDS, doc_QBluetoothDeviceInfo_serviceUuids},
    {sipName_serviceUuidsCompleteness, meth_QBluetoothDeviceInfo_serviceUuidsCompleteness, METH_VARARGS, doc_QBluetoothDeviceInfo_serviceUuidsCompleteness},
    {sipName_setCached, meth_QBluetoothDeviceInfo_setCached, METH_VARARGS, doc_QBluetoothDeviceInfo_setCached},
    {sipName_setCoreConfigurations, meth_QBluetoothDeviceInfo_setCoreConfigurations, METH_VARARGS, doc_QBluetoothDeviceInfo_setCoreConfigurations},
    {sipName_setDeviceUuid, meth_QBluetoothDeviceInfo_setDeviceUuid, METH_VARARGS, doc_QBluetoothDeviceInfo_setDeviceUuid},
    {sipName_setManufacturerData, meth_QBluetoothDeviceInfo_setManufacturerData, METH_VARARGS, doc_QBluetoothDeviceInfo_setManufacturerData},
    {sipName_setRssi, meth_QBluetoothDeviceInfo_setRssi, METH_VARARGS, doc_QBluetoothDeviceInfo_setRssi},
    {sipName_setServiceUuids, meth_QBluetoothDeviceInfo_setServiceUuids, METH_VARARGS, doc_QBluetoothDeviceInfo_setServiceUuids}
};

static sipEnumMemberDef enummembers_QBluetoothDeviceInfo[] = {
    {sipName_All, static_cast<int>(::QBluetoothDeviceInfo::Field::All), 15},
    {sipName_AllServices, static_cast<int>(::QBluetoothDeviceInfo::AllServices), 28},
    {sipName_AudioService, static_cast<int>(::QBluetoothDeviceInfo::AudioService), 28},
    {sipName_AudioVideoDevice, static_cast<int>(::QBluetoothDeviceInfo::AudioVideoDevice), 17},
    {sipName_BaseRateAndLowEnergyCoreConfiguration, static_cast<int>(::QBluetoothDeviceInfo::BaseRateAndLowEnergyCoreConfiguration), 12},
    {sipName_BaseRateCoreConfiguration, static_cast<int>(::QBluetoothDeviceInfo::BaseRateCoreConfiguration), 12},
    {sipName_Camcorder, static_cast<int>(::QBluetoothDeviceInfo::Camcorder), 18},
    {sipName_CapturingService, static_cast<int>(::QBluetoothDeviceInfo::CapturingService), 28},
    {sipName_CarAudio, static_cast<int>(::QBluetoothDeviceInfo::CarAudio), 18},
    {sipName_CardReaderPeripheral, static_cast<int>(::QBluetoothDeviceInfo::CardReaderPeripheral), 24},
    {sipName_CellularPhone, static_cast<int>(::QBluetoothDeviceInfo::CellularPhone), 25},
    {sipName_CommonIsdnAccessPhone, static_cast<int>(::QBluetoothDeviceInfo::CommonIsdnAccessPhone), 25},
    {sipName_ComputerDevice, static_cast<int>(::QBluetoothDeviceInfo::ComputerDevice), 17},
    {sipName_CordlessPhone, static_cast<int>(::QBluetoothDeviceInfo::CordlessPhone), 25},
    {sipName_DataComplete, static_cast<int>(::QBluetoothDeviceInfo::DataComplete), 14},
    {sipName_DataIncomplete, static_cast<int>(::QBluetoothDeviceInfo::DataIncomplete), 14},
    {sipName_DataUnavailable, static_cast<int>(::QBluetoothDeviceInfo::DataUnavailable), 14},
    {sipName_DesktopComputer, static_cast<int>(::QBluetoothDeviceInfo::DesktopComputer), 19},
    {sipName_DigitizerTabletPeripheral, static_cast<int>(::QBluetoothDeviceInfo::DigitizerTabletPeripheral), 24},
    {sipName_GamepadPeripheral, static_cast<int>(::QBluetoothDeviceInfo::GamepadPeripheral), 24},
    {sipName_GamingDevice, static_cast<int>(::QBluetoothDeviceInfo::GamingDevice), 18},
    {sipName_HandheldClamShellComputer, static_cast<int>(::QBluetoothDeviceInfo::HandheldClamShellComputer), 19},
    {sipName_HandheldComputer, static_cast<int>(::QBluetoothDeviceInfo::HandheldComputer), 19},
    {sipName_HandsFreeDevice, static_cast<int>(::QBluetoothDeviceInfo::HandsFreeDevice), 18},
    {sipName_Headphones, static_cast<int>(::QBluetoothDeviceInfo::Headphones), 18},
    {sipName_HealthBloodPressureMonitor, static_cast<int>(::QBluetoothDeviceInfo::HealthBloodPressureMonitor), 20},
    {sipName_HealthDataDisplay, static_cast<int>(::QBluetoothDeviceInfo::HealthDataDisplay), 20},
    {sipName_HealthDevice, static_cast<int>(::QBluetoothDeviceInfo::HealthDevice), 17},
    {sipName_HealthGlucoseMeter, static_cast<int>(::QBluetoothDeviceInfo::HealthGlucoseMeter), 20},
    {sipName_HealthPulseOximeter, static_cast<int>(::QBluetoothDeviceInfo::HealthPulseOximeter), 20},
    {sipName_HealthStepCounter, static_cast<int>(::QBluetoothDeviceInfo::HealthStepCounter), 20},
    {sipName_HealthThermometer, static_cast<int>(::QBluetoothDeviceInfo::HealthThermometer), 20},
    {sipName_HealthWeightScale, static_cast<int>(::QBluetoothDeviceInfo::HealthWeightScale), 20},
    {sipName_HiFiAudioDevice, static_cast<int>(::QBluetoothDeviceInfo::HiFiAudioDevice), 18},
    {sipName_ImageCamera, static_cast<int>(::QBluetoothDeviceInfo::ImageCamera), 21},
    {sipName_ImageDisplay, static_cast<int>(::QBluetoothDeviceInfo::ImageDisplay), 21},
    {sipName_ImagePrinter, static_cast<int>(::QBluetoothDeviceInfo::ImagePrinter), 21},
    {sipName_ImageScanner, static_cast<int>(::QBluetoothDeviceInfo::ImageScanner), 21},
    {sipName_ImagingDevice, static_cast<int>(::QBluetoothDeviceInfo::ImagingDevice), 17},
    {sipName_InformationService, static_cast<int>(::QBluetoothDeviceInfo::InformationService), 28},
    {sipName_JoystickPeripheral, static_cast<int>(::QBluetoothDeviceInfo::JoystickPeripheral), 24},
    {sipName_KeyboardPeripheral, static_cast<int>(::QBluetoothDeviceInfo::KeyboardPeripheral), 24},
    {sipName_KeyboardWithPointingDevicePeripheral, static_cast<int>(::QBluetoothDeviceInfo::KeyboardWithPointingDevicePeripheral), 24},
    {sipName_LANAccessDevice, static_cast<int>(::QBluetoothDeviceInfo::LANAccessDevice), 17},
    {sipName_LaptopComputer, static_cast<int>(::QBluetoothDeviceInfo::LaptopComputer), 19},
    {sipName_Loudspeaker, static_cast<int>(::QBluetoothDeviceInfo::Loudspeaker), 18},
    {sipName_LowEnergyCoreConfiguration, static_cast<int>(::QBluetoothDeviceInfo::LowEnergyCoreConfiguration), 12},
    {sipName_ManufacturerData, static_cast<int>(::QBluetoothDeviceInfo::Field::ManufacturerData), 15},
    {sipName_Microphone, static_cast<int>(::QBluetoothDeviceInfo::Microphone), 18},
    {sipName_MiscellaneousDevice, static_cast<int>(::QBluetoothDeviceInfo::MiscellaneousDevice), 17},
    {sipName_NetworkDevice, static_cast<int>(::QBluetoothDeviceInfo::NetworkDevice), 17},
    {sipName_NetworkFullService, static_cast<int>(::QBluetoothDeviceInfo::NetworkFullService), 23},
    {sipName_NetworkLoadFactorFive, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorFive), 23},
    {sipName_NetworkLoadFactorFour, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorFour), 23},
    {sipName_NetworkLoadFactorOne, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorOne), 23},
    {sipName_NetworkLoadFactorSix, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorSix), 23},
    {sipName_NetworkLoadFactorThree, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorThree), 23},
    {sipName_NetworkLoadFactorTwo, static_cast<int>(::QBluetoothDeviceInfo::NetworkLoadFactorTwo), 23},
    {sipName_NetworkNoService, static_cast<int>(::QBluetoothDeviceInfo::NetworkNoService), 23},
    {sipName_NetworkingService, static_cast<int>(::QBluetoothDeviceInfo::NetworkingService), 28},
    {sipName_NoService, static_cast<int>(::QBluetoothDeviceInfo::NoService), 28},
    {sipName_None_, static_cast<int>(::QBluetoothDeviceInfo::Field::None), 15},
    {sipName_ObjectTransferService, static_cast<int>(::QBluetoothDeviceInfo::ObjectTransferService), 28},
    {sipName_PeripheralDevice, static_cast<int>(::QBluetoothDeviceInfo::PeripheralDevice), 17},
    {sipName_PhoneDevice, static_cast<int>(::QBluetoothDeviceInfo::PhoneDevice), 17},
    {sipName_PointingDevicePeripheral, static_cast<int>(::QBluetoothDeviceInfo::PointingDevicePeripheral), 24},
    {sipName_PortableAudioDevice, static_cast<int>(::QBluetoothDeviceInfo::PortableAudioDevice), 18},
    {sipName_PositioningService, static_cast<int>(::QBluetoothDeviceInfo::PositioningService), 28},
    {sipName_RSSI, static_cast<int>(::QBluetoothDeviceInfo::Field::RSSI), 15},
    {sipName_RemoteControlPeripheral, static_cast<int>(::QBluetoothDeviceInfo::RemoteControlPeripheral), 24},
    {sipName_RenderingService, static_cast<int>(::QBluetoothDeviceInfo::RenderingService), 28},
    {sipName_SensingDevicePeripheral, static_cast<int>(::QBluetoothDeviceInfo::SensingDevicePeripheral), 24},
    {sipName_ServerComputer, static_cast<int>(::QBluetoothDeviceInfo::ServerComputer), 19},
    {sipName_SetTopBox, static_cast<int>(::QBluetoothDeviceInfo::SetTopBox), 18},
    {sipName_SmartPhone, static_cast<int>(::QBluetoothDeviceInfo::SmartPhone), 25},
    {sipName_TelephonyService, static_cast<int>(::QBluetoothDeviceInfo::TelephonyService), 28},
    {sipName_ToyController, static_cast<int>(::QBluetoothDeviceInfo::ToyController), 26},
    {sipName_ToyDevice, static_cast<int>(::QBluetoothDeviceInfo::ToyDevice), 17},
    {sipName_ToyDoll, static_cast<int>(::QBluetoothDeviceInfo::ToyDoll), 26},
    {sipName_ToyGame, static_cast<int>(::QBluetoothDeviceInfo::ToyGame), 26},
    {sipName_ToyRobot, static_cast<int>(::QBluetoothDeviceInfo::ToyRobot), 26},
    {sipName_ToyVehicle, static_cast<int>(::QBluetoothDeviceInfo::ToyVehicle), 26},
    {sipName_UncategorizedAudioVideoDevice, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedAudioVideoDevice), 18},
    {sipName_UncategorizedComputer, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedComputer), 19},
    {sipName_UncategorizedDevice, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedDevice), 17},
    {sipName_UncategorizedHealthDevice, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedHealthDevice), 20},
    {sipName_UncategorizedImagingDevice, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedImagingDevice), 21},
    {sipName_UncategorizedMiscellaneous, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedMiscellaneous), 22},
    {sipName_UncategorizedPeripheral, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedPeripheral), 24},
    {sipName_UncategorizedPhone, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedPhone), 25},
    {sipName_UncategorizedToy, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedToy), 26},
    {sipName_UncategorizedWearableDevice, static_cast<int>(::QBluetoothDeviceInfo::UncategorizedWearableDevice), 27},
    {sipName_UnknownCoreConfiguration, static_cast<int>(::QBluetoothDeviceInfo::UnknownCoreConfiguration), 12},
    {sipName_Vcr, static_cast<int>(::QBluetoothDeviceInfo::Vcr), 18},
    {sipName_VideoCamera, static_cast<int>(::QBluetoothDeviceInfo::VideoCamera), 18},
    {sipName_VideoConferencing, static_cast<int>(::QBluetoothDeviceInfo::VideoConferencing), 18},
    {sipName_VideoDisplayAndLoudspeaker, static_cast<int>(::QBluetoothDeviceInfo::VideoDisplayAndLoudspeaker), 18},
    {sipName_VideoMonitor, static_cast<int>(::QBluetoothDeviceInfo::VideoMonitor), 18},
    {sipName_WearableComputer, static_cast<int>(::QBluetoothDeviceInfo::WearableComputer), 19},
    {sipName_WearableDevice, static_cast<int>(::QBluetoothDeviceInfo::WearableDevice), 17},
    {sipName_WearableGlasses, static_cast<int>(::QBluetoothDeviceInfo::WearableGlasses), 27},
    {sipName_WearableHeadsetDevice, static_cast<int>(::QBluetoothDeviceInfo::WearableHeadsetDevice), 18},
    {sipName_WearableHelmet, static_cast<int>(::QBluetoothDeviceInfo::WearableHelmet), 27},
    {sipName_WearableJacket, static_cast<int>(::QBluetoothDeviceInfo::WearableJacket), 27},
    {sipName_WearablePager, static_cast<int>(::QBluetoothDeviceInfo::WearablePager), 27},
    {sipName_WearableWristWatch, static_cast<int>(::QBluetoothDeviceInfo::WearableWristWatch), 27},
    {sipName_WiredModemOrVoiceGatewayPhone, static_cast<int>(::QBluetoothDeviceInfo::WiredModemOrVoiceGatewayPhone), 25},
};

PyDoc_STRVAR(doc_QBluetoothDeviceInfo, "\1QBluetoothDeviceInfo()\n"
"QBluetoothDeviceInfo(address: QBluetoothAddress, name: Optional[str], classOfDevice: int)\n"
"QBluetoothDeviceInfo(uuid: QBluetoothUuid, name: Optional[str], classOfDevice: int)\n"
"QBluetoothDeviceInfo(other: QBluetoothDeviceInfo)");


static pyqt5ClassPluginDef plugin_QBluetoothDeviceInfo = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtBluetooth_QBluetoothDeviceInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QBluetoothDeviceInfo,
        SIP_NULLPTR,
        &plugin_QBluetoothDeviceInfo,
    },
    {
        sipNameNr_QBluetoothDeviceInfo,
        {0, 0, 1},
        20, methods_QBluetoothDeviceInfo,
        107, enummembers_QBluetoothDeviceInfo,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QBluetoothDeviceInfo,
    -1,
    -1,
    SIP_NULLPTR,
    slots_QBluetoothDeviceInfo,
    init_type_QBluetoothDeviceInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QBluetoothDeviceInfo,
    assign_QBluetoothDeviceInfo,
    array_QBluetoothDeviceInfo,
    copy_QBluetoothDeviceInfo,
    release_QBluetoothDeviceInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QBluetoothDeviceInfo,
    sizeof (::QBluetoothDeviceInfo),
};
