/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qfontdatabase.sip"
#include <qfontdatabase.h>
#line 29 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFontDatabase.cpp"

#line 27 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFontDatabase.cpp"
#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qfont.sip"
#include <qfont.h>
#line 36 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFontDatabase.cpp"
#line 36 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 39 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFontDatabase.cpp"
#line 30 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 42 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFontDatabase.cpp"
#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qfontinfo.sip"
#include <qfontinfo.h>
#line 45 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFontDatabase.cpp"
#line 646 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 48 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFontDatabase.cpp"
#line 28 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qpygui_qlist.sip"
#include <qfontdatabase.h>
#line 51 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtGui/sipQtGuiQFontDatabase.cpp"


PyDoc_STRVAR(doc_QFontDatabase_standardSizes, "standardSizes() -> list[int]");

extern "C" {static PyObject *meth_QFontDatabase_standardSizes(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_standardSizes(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QList<int>*sipRes;

            sipRes = new ::QList<int>(::QFontDatabase::standardSizes());

            return sipConvertFromNewType(sipRes, sipType_QList_1800, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_standardSizes, doc_QFontDatabase_standardSizes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_writingSystems, "writingSystems(self) -> list[QFontDatabase.WritingSystem]\n"
"writingSystems(self, family: Optional[str]) -> list[QFontDatabase.WritingSystem]");

extern "C" {static PyObject *meth_QFontDatabase_writingSystems(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_writingSystems(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFontDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QFontDatabase, &sipCpp))
        {
            ::QList< ::QFontDatabase::WritingSystem>*sipRes;

            sipRes = new ::QList< ::QFontDatabase::WritingSystem>(sipCpp->writingSystems());

            return sipConvertFromNewType(sipRes, sipType_QList_0100QFontDatabase_WritingSystem, SIP_NULLPTR);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QFontDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QList< ::QFontDatabase::WritingSystem>*sipRes;

            sipRes = new ::QList< ::QFontDatabase::WritingSystem>(sipCpp->writingSystems(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QList_0100QFontDatabase_WritingSystem, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_writingSystems, doc_QFontDatabase_writingSystems);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_families, "families(self, writingSystem: QFontDatabase.WritingSystem = QFontDatabase.Any) -> list[str]");

extern "C" {static PyObject *meth_QFontDatabase_families(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_families(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QFontDatabase::WritingSystem a0 = QFontDatabase::Any;
        const ::QFontDatabase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_writingSystem,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QFontDatabase_WritingSystem, &a0))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(sipCpp->families(a0));

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_families, doc_QFontDatabase_families);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_styles, "styles(self, family: Optional[str]) -> list[str]");

extern "C" {static PyObject *meth_QFontDatabase_styles(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_styles(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QFontDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(sipCpp->styles(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_styles, doc_QFontDatabase_styles);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_pointSizes, "pointSizes(self, family: Optional[str], style: Optional[str] = '') -> list[int]");

extern "C" {static PyObject *meth_QFontDatabase_pointSizes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_pointSizes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;
        ::QFontDatabase *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            ::QList<int>*sipRes;

            sipRes = new ::QList<int>(sipCpp->pointSizes(*a0, *a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QList_1800, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_pointSizes, doc_QFontDatabase_pointSizes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_smoothSizes, "smoothSizes(self, family: Optional[str], style: Optional[str]) -> list[int]");

extern "C" {static PyObject *meth_QFontDatabase_smoothSizes(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_smoothSizes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        ::QFontDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            ::QList<int>*sipRes;

            sipRes = new ::QList<int>(sipCpp->smoothSizes(*a0, *a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QList_1800, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_smoothSizes, doc_QFontDatabase_smoothSizes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_styleString, "styleString(self, font: QFont) -> str\n"
"styleString(self, fontInfo: QFontInfo) -> str");

extern "C" {static PyObject *meth_QFontDatabase_styleString(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_styleString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QFont* a0;
        ::QFontDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QFont, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->styleString(*a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    {
        const ::QFontInfo* a0;
        ::QFontDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QFontInfo, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->styleString(*a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_styleString, doc_QFontDatabase_styleString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_font, "font(self, family: Optional[str], style: Optional[str], pointSize: int) -> QFont");

extern "C" {static PyObject *meth_QFontDatabase_font(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_font(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        int a2;
        const ::QFontDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1i", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, &a2))
        {
            ::QFont*sipRes;

            sipRes = new ::QFont(sipCpp->font(*a0, *a1, a2));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_font, doc_QFontDatabase_font);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_isBitmapScalable, "isBitmapScalable(self, family: Optional[str], style: Optional[str] = '') -> bool");

extern "C" {static PyObject *meth_QFontDatabase_isBitmapScalable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_isBitmapScalable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;
        const ::QFontDatabase *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            bool sipRes;

            sipRes = sipCpp->isBitmapScalable(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_isBitmapScalable, doc_QFontDatabase_isBitmapScalable);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_isSmoothlyScalable, "isSmoothlyScalable(self, family: Optional[str], style: Optional[str] = '') -> bool");

extern "C" {static PyObject *meth_QFontDatabase_isSmoothlyScalable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_isSmoothlyScalable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;
        const ::QFontDatabase *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            bool sipRes;

            sipRes = sipCpp->isSmoothlyScalable(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_isSmoothlyScalable, doc_QFontDatabase_isSmoothlyScalable);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_isScalable, "isScalable(self, family: Optional[str], style: Optional[str] = '') -> bool");

extern "C" {static PyObject *meth_QFontDatabase_isScalable(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_isScalable(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;
        const ::QFontDatabase *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            bool sipRes;

            sipRes = sipCpp->isScalable(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_isScalable, doc_QFontDatabase_isScalable);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_isFixedPitch, "isFixedPitch(self, family: Optional[str], style: Optional[str] = '') -> bool");

extern "C" {static PyObject *meth_QFontDatabase_isFixedPitch(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_isFixedPitch(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;
        const ::QFontDatabase *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_style,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|J1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            bool sipRes;

            sipRes = sipCpp->isFixedPitch(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_isFixedPitch, doc_QFontDatabase_isFixedPitch);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_italic, "italic(self, family: Optional[str], style: Optional[str]) -> bool");

extern "C" {static PyObject *meth_QFontDatabase_italic(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_italic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        const ::QFontDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            bool sipRes;

            sipRes = sipCpp->italic(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_italic, doc_QFontDatabase_italic);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_bold, "bold(self, family: Optional[str], style: Optional[str]) -> bool");

extern "C" {static PyObject *meth_QFontDatabase_bold(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_bold(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        const ::QFontDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            bool sipRes;

            sipRes = sipCpp->bold(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_bold, doc_QFontDatabase_bold);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_weight, "weight(self, family: Optional[str], style: Optional[str]) -> int");

extern "C" {static PyObject *meth_QFontDatabase_weight(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_weight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        const ::QFontDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            int sipRes;

            sipRes = sipCpp->weight(*a0, *a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_weight, doc_QFontDatabase_weight);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_writingSystemName, "writingSystemName(writingSystem: QFontDatabase.WritingSystem) -> str");

extern "C" {static PyObject *meth_QFontDatabase_writingSystemName(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_writingSystemName(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QFontDatabase::WritingSystem a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "E", sipType_QFontDatabase_WritingSystem, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QFontDatabase::writingSystemName(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_writingSystemName, doc_QFontDatabase_writingSystemName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_writingSystemSample, "writingSystemSample(writingSystem: QFontDatabase.WritingSystem) -> str");

extern "C" {static PyObject *meth_QFontDatabase_writingSystemSample(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_writingSystemSample(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QFontDatabase::WritingSystem a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "E", sipType_QFontDatabase_WritingSystem, &a0))
        {
            ::QString*sipRes;

            sipRes = new ::QString(::QFontDatabase::writingSystemSample(a0));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_writingSystemSample, doc_QFontDatabase_writingSystemSample);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_addApplicationFont, "addApplicationFont(fileName: Optional[str]) -> int");

extern "C" {static PyObject *meth_QFontDatabase_addApplicationFont(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_addApplicationFont(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QString, &a0, &a0State))
        {
            int sipRes;

            sipRes = ::QFontDatabase::addApplicationFont(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_addApplicationFont, doc_QFontDatabase_addApplicationFont);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_addApplicationFontFromData, "addApplicationFontFromData(fontData: Union[QByteArray, bytes, bytearray]) -> int");

extern "C" {static PyObject *meth_QFontDatabase_addApplicationFontFromData(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_addApplicationFontFromData(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QByteArray, &a0, &a0State))
        {
            int sipRes;

            sipRes = ::QFontDatabase::addApplicationFontFromData(*a0);
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_addApplicationFontFromData, doc_QFontDatabase_addApplicationFontFromData);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_applicationFontFamilies, "applicationFontFamilies(id: int) -> list[str]");

extern "C" {static PyObject *meth_QFontDatabase_applicationFontFamilies(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_applicationFontFamilies(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "i", &a0))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(::QFontDatabase::applicationFontFamilies(a0));

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_applicationFontFamilies, doc_QFontDatabase_applicationFontFamilies);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_removeApplicationFont, "removeApplicationFont(id: int) -> bool");

extern "C" {static PyObject *meth_QFontDatabase_removeApplicationFont(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_removeApplicationFont(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "i", &a0))
        {
            bool sipRes;

            sipRes = ::QFontDatabase::removeApplicationFont(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_removeApplicationFont, doc_QFontDatabase_removeApplicationFont);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_removeAllApplicationFonts, "removeAllApplicationFonts() -> bool");

extern "C" {static PyObject *meth_QFontDatabase_removeAllApplicationFonts(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_removeAllApplicationFonts(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            bool sipRes;

            sipRes = ::QFontDatabase::removeAllApplicationFonts();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_removeAllApplicationFonts, doc_QFontDatabase_removeAllApplicationFonts);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_supportsThreadedFontRendering, "supportsThreadedFontRendering() -> bool");

extern "C" {static PyObject *meth_QFontDatabase_supportsThreadedFontRendering(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_supportsThreadedFontRendering(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            bool sipRes;

            sipRes = ::QFontDatabase::supportsThreadedFontRendering();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_supportsThreadedFontRendering, doc_QFontDatabase_supportsThreadedFontRendering);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_systemFont, "systemFont(type: QFontDatabase.SystemFont) -> QFont");

extern "C" {static PyObject *meth_QFontDatabase_systemFont(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_systemFont(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QFontDatabase::SystemFont a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "E", sipType_QFontDatabase_SystemFont, &a0))
        {
            ::QFont*sipRes;

            sipRes = new ::QFont(::QFontDatabase::systemFont(a0));

            return sipConvertFromNewType(sipRes, sipType_QFont, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_systemFont, doc_QFontDatabase_systemFont);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QFontDatabase_isPrivateFamily, "isPrivateFamily(self, family: Optional[str]) -> bool");

extern "C" {static PyObject *meth_QFontDatabase_isPrivateFamily(PyObject *, PyObject *);}
static PyObject *meth_QFontDatabase_isPrivateFamily(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QFontDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QFontDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->isPrivateFamily(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QFontDatabase, sipName_isPrivateFamily, doc_QFontDatabase_isPrivateFamily);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QFontDatabase(void *, int);}
static void release_QFontDatabase(void *sipCppV, int)
{
    delete reinterpret_cast< ::QFontDatabase *>(sipCppV);
}


extern "C" {static void *array_QFontDatabase(Py_ssize_t);}
static void *array_QFontDatabase(Py_ssize_t sipNrElem)
{
    return new ::QFontDatabase[sipNrElem];
}


extern "C" {static void array_delete_QFontDatabase(void *);}
static void array_delete_QFontDatabase(void *sipCpp)
{
    delete[] reinterpret_cast< ::QFontDatabase *>(sipCpp);
}


extern "C" {static void assign_QFontDatabase(void *, Py_ssize_t, void *);}
static void assign_QFontDatabase(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QFontDatabase *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QFontDatabase *>(sipSrc);
}


extern "C" {static void *copy_QFontDatabase(const void *, Py_ssize_t);}
static void *copy_QFontDatabase(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QFontDatabase(reinterpret_cast<const ::QFontDatabase *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QFontDatabase(sipSimpleWrapper *);}
static void dealloc_QFontDatabase(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QFontDatabase(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QFontDatabase(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QFontDatabase(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QFontDatabase *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QFontDatabase();

            return sipCpp;
        }
    }

    {
        const ::QFontDatabase* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QFontDatabase, &a0))
        {
            sipCpp = new ::QFontDatabase(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QFontDatabase[] = {
    {sipName_addApplicationFont, meth_QFontDatabase_addApplicationFont, METH_VARARGS, doc_QFontDatabase_addApplicationFont},
    {sipName_addApplicationFontFromData, meth_QFontDatabase_addApplicationFontFromData, METH_VARARGS, doc_QFontDatabase_addApplicationFontFromData},
    {sipName_applicationFontFamilies, meth_QFontDatabase_applicationFontFamilies, METH_VARARGS, doc_QFontDatabase_applicationFontFamilies},
    {sipName_bold, meth_QFontDatabase_bold, METH_VARARGS, doc_QFontDatabase_bold},
    {sipName_families, SIP_MLMETH_CAST(meth_QFontDatabase_families), METH_VARARGS|METH_KEYWORDS, doc_QFontDatabase_families},
    {sipName_font, meth_QFontDatabase_font, METH_VARARGS, doc_QFontDatabase_font},
    {sipName_isBitmapScalable, SIP_MLMETH_CAST(meth_QFontDatabase_isBitmapScalable), METH_VARARGS|METH_KEYWORDS, doc_QFontDatabase_isBitmapScalable},
    {sipName_isFixedPitch, SIP_MLMETH_CAST(meth_QFontDatabase_isFixedPitch), METH_VARARGS|METH_KEYWORDS, doc_QFontDatabase_isFixedPitch},
    {sipName_isPrivateFamily, meth_QFontDatabase_isPrivateFamily, METH_VARARGS, doc_QFontDatabase_isPrivateFamily},
    {sipName_isScalable, SIP_MLMETH_CAST(meth_QFontDatabase_isScalable), METH_VARARGS|METH_KEYWORDS, doc_QFontDatabase_isScalable},
    {sipName_isSmoothlyScalable, SIP_MLMETH_CAST(meth_QFontDatabase_isSmoothlyScalable), METH_VARARGS|METH_KEYWORDS, doc_QFontDatabase_isSmoothlyScalable},
    {sipName_italic, meth_QFontDatabase_italic, METH_VARARGS, doc_QFontDatabase_italic},
    {sipName_pointSizes, SIP_MLMETH_CAST(meth_QFontDatabase_pointSizes), METH_VARARGS|METH_KEYWORDS, doc_QFontDatabase_pointSizes},
    {sipName_removeAllApplicationFonts, meth_QFontDatabase_removeAllApplicationFonts, METH_VARARGS, doc_QFontDatabase_removeAllApplicationFonts},
    {sipName_removeApplicationFont, meth_QFontDatabase_removeApplicationFont, METH_VARARGS, doc_QFontDatabase_removeApplicationFont},
    {sipName_smoothSizes, meth_QFontDatabase_smoothSizes, METH_VARARGS, doc_QFontDatabase_smoothSizes},
    {sipName_standardSizes, meth_QFontDatabase_standardSizes, METH_VARARGS, doc_QFontDatabase_standardSizes},
    {sipName_styleString, meth_QFontDatabase_styleString, METH_VARARGS, doc_QFontDatabase_styleString},
    {sipName_styles, meth_QFontDatabase_styles, METH_VARARGS, doc_QFontDatabase_styles},
    {sipName_supportsThreadedFontRendering, meth_QFontDatabase_supportsThreadedFontRendering, METH_VARARGS, doc_QFontDatabase_supportsThreadedFontRendering},
    {sipName_systemFont, meth_QFontDatabase_systemFont, METH_VARARGS, doc_QFontDatabase_systemFont},
    {sipName_weight, meth_QFontDatabase_weight, METH_VARARGS, doc_QFontDatabase_weight},
    {sipName_writingSystemName, meth_QFontDatabase_writingSystemName, METH_VARARGS, doc_QFontDatabase_writingSystemName},
    {sipName_writingSystemSample, meth_QFontDatabase_writingSystemSample, METH_VARARGS, doc_QFontDatabase_writingSystemSample},
    {sipName_writingSystems, meth_QFontDatabase_writingSystems, METH_VARARGS, doc_QFontDatabase_writingSystems}
};

static sipEnumMemberDef enummembers_QFontDatabase[] = {
    {sipName_Any, static_cast<int>(::QFontDatabase::Any), 49},
    {sipName_Arabic, static_cast<int>(::QFontDatabase::Arabic), 49},
    {sipName_Armenian, static_cast<int>(::QFontDatabase::Armenian), 49},
    {sipName_Bengali, static_cast<int>(::QFontDatabase::Bengali), 49},
    {sipName_Cyrillic, static_cast<int>(::QFontDatabase::Cyrillic), 49},
    {sipName_Devanagari, static_cast<int>(::QFontDatabase::Devanagari), 49},
    {sipName_FixedFont, static_cast<int>(::QFontDatabase::FixedFont), 48},
    {sipName_GeneralFont, static_cast<int>(::QFontDatabase::GeneralFont), 48},
    {sipName_Georgian, static_cast<int>(::QFontDatabase::Georgian), 49},
    {sipName_Greek, static_cast<int>(::QFontDatabase::Greek), 49},
    {sipName_Gujarati, static_cast<int>(::QFontDatabase::Gujarati), 49},
    {sipName_Gurmukhi, static_cast<int>(::QFontDatabase::Gurmukhi), 49},
    {sipName_Hebrew, static_cast<int>(::QFontDatabase::Hebrew), 49},
    {sipName_Japanese, static_cast<int>(::QFontDatabase::Japanese), 49},
    {sipName_Kannada, static_cast<int>(::QFontDatabase::Kannada), 49},
    {sipName_Khmer, static_cast<int>(::QFontDatabase::Khmer), 49},
    {sipName_Korean, static_cast<int>(::QFontDatabase::Korean), 49},
    {sipName_Lao, static_cast<int>(::QFontDatabase::Lao), 49},
    {sipName_Latin, static_cast<int>(::QFontDatabase::Latin), 49},
    {sipName_Malayalam, static_cast<int>(::QFontDatabase::Malayalam), 49},
    {sipName_Myanmar, static_cast<int>(::QFontDatabase::Myanmar), 49},
    {sipName_Nko, static_cast<int>(::QFontDatabase::Nko), 49},
    {sipName_Ogham, static_cast<int>(::QFontDatabase::Ogham), 49},
    {sipName_Oriya, static_cast<int>(::QFontDatabase::Oriya), 49},
    {sipName_Other, static_cast<int>(::QFontDatabase::Other), 49},
    {sipName_Runic, static_cast<int>(::QFontDatabase::Runic), 49},
    {sipName_SimplifiedChinese, static_cast<int>(::QFontDatabase::SimplifiedChinese), 49},
    {sipName_Sinhala, static_cast<int>(::QFontDatabase::Sinhala), 49},
    {sipName_SmallestReadableFont, static_cast<int>(::QFontDatabase::SmallestReadableFont), 48},
    {sipName_Symbol, static_cast<int>(::QFontDatabase::Symbol), 49},
    {sipName_Syriac, static_cast<int>(::QFontDatabase::Syriac), 49},
    {sipName_Tamil, static_cast<int>(::QFontDatabase::Tamil), 49},
    {sipName_Telugu, static_cast<int>(::QFontDatabase::Telugu), 49},
    {sipName_Thaana, static_cast<int>(::QFontDatabase::Thaana), 49},
    {sipName_Thai, static_cast<int>(::QFontDatabase::Thai), 49},
    {sipName_Tibetan, static_cast<int>(::QFontDatabase::Tibetan), 49},
    {sipName_TitleFont, static_cast<int>(::QFontDatabase::TitleFont), 48},
    {sipName_TraditionalChinese, static_cast<int>(::QFontDatabase::TraditionalChinese), 49},
    {sipName_Vietnamese, static_cast<int>(::QFontDatabase::Vietnamese), 49},
};

PyDoc_STRVAR(doc_QFontDatabase, "\1QFontDatabase()\n"
"QFontDatabase(a0: QFontDatabase)");


static pyqt5ClassPluginDef plugin_QFontDatabase = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtGui_QFontDatabase = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QFontDatabase,
        SIP_NULLPTR,
        &plugin_QFontDatabase,
    },
    {
        sipNameNr_QFontDatabase,
        {0, 0, 1},
        25, methods_QFontDatabase,
        39, enummembers_QFontDatabase,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QFontDatabase,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QFontDatabase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QFontDatabase,
    assign_QFontDatabase,
    array_QFontDatabase,
    copy_QFontDatabase,
    release_QFontDatabase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QFontDatabase,
    sizeof (::QFontDatabase),
};
