/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtOpenGL.h"

#line 179 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtOpenGL/qgl.sip"
#include <qgl.h>
#line 29 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtOpenGL/sipQtOpenGLQGLContext.cpp"

#line 69 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtOpenGL/qgl.sip"
#include <qgl.h>
#line 33 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtOpenGL/sipQtOpenGLQGLContext.cpp"
#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qthread.sip"
#include <qthread.h>
#line 36 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtOpenGL/sipQtOpenGLQGLContext.cpp"
#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qcolor.sip"
#include <qcolor.h>
#line 39 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtOpenGL/sipQtOpenGLQGLContext.cpp"
#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qpaintdevice.sip"
#include <qpaintdevice.h>
#line 42 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtOpenGL/sipQtOpenGLQGLContext.cpp"
#line 27 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 45 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtOpenGL/sipQtOpenGLQGLContext.cpp"
#line 164 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 48 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtOpenGL/sipQtOpenGLQGLContext.cpp"
#line 98 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 51 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtOpenGL/sipQtOpenGLQGLContext.cpp"
#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qimage.sip"
#include <qimage.h>
#line 54 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtOpenGL/sipQtOpenGLQGLContext.cpp"
#line 26 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtGui/qpixmap.sip"
#include <qpixmap.h>
#line 57 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtOpenGL/sipQtOpenGLQGLContext.cpp"
#line 179 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/sip/QtOpenGL/qgl.sip"
#include <qgl.h>
#line 60 "/build/python-pyqt5-webkit/src/PyQt5-5.15.11/build/QtOpenGL/sipQtOpenGLQGLContext.cpp"


class sipQGLContext : public ::QGLContext
{
public:
    sipQGLContext(const ::QGLFormat&);
    virtual ~sipQGLContext();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool chooseContext(const ::QGLContext*) SIP_OVERRIDE;
    void swapBuffers() const SIP_OVERRIDE;
    void doneCurrent() SIP_OVERRIDE;
    void makeCurrent() SIP_OVERRIDE;
    bool create(const ::QGLContext*) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQGLContext(const sipQGLContext &);
    sipQGLContext &operator = (const sipQGLContext &);

    char sipPyMethods[5];
};

sipQGLContext::sipQGLContext(const ::QGLFormat& a0): ::QGLContext(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQGLContext::~sipQGLContext()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipQGLContext::chooseContext(const ::QGLContext*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_chooseContext);

    if (!sipMeth)
        return ::QGLContext::chooseContext(a0);

    extern bool sipVH_QtOpenGL_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QGLContext*);

    return sipVH_QtOpenGL_0(sipGILState, sipImportedVirtErrorHandlers_QtOpenGL_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQGLContext::swapBuffers() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_swapBuffers);

    if (!sipMeth)
    {
        ::QGLContext::swapBuffers();
        return;
    }

    extern void sipVH_QtOpenGL_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH_QtOpenGL_1(sipGILState, sipImportedVirtErrorHandlers_QtOpenGL_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQGLContext::doneCurrent()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_doneCurrent);

    if (!sipMeth)
    {
        ::QGLContext::doneCurrent();
        return;
    }

    extern void sipVH_QtOpenGL_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH_QtOpenGL_1(sipGILState, sipImportedVirtErrorHandlers_QtOpenGL_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQGLContext::makeCurrent()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_makeCurrent);

    if (!sipMeth)
    {
        ::QGLContext::makeCurrent();
        return;
    }

    extern void sipVH_QtOpenGL_1(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH_QtOpenGL_1(sipGILState, sipImportedVirtErrorHandlers_QtOpenGL_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQGLContext::create(const ::QGLContext*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_create);

    if (!sipMeth)
        return ::QGLContext::create(a0);

    extern bool sipVH_QtOpenGL_0(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QGLContext*);

    return sipVH_QtOpenGL_0(sipGILState, sipImportedVirtErrorHandlers_QtOpenGL_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}


PyDoc_STRVAR(doc_QGLContext_create, "create(self, shareContext: Optional[QGLContext] = None) -> bool");

extern "C" {static PyObject *meth_QGLContext_create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QGLContext_create(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QGLContext* a0 = 0;
        ::QGLContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_shareContext,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J8", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QGLContext, &a0))
        {
            bool sipRes;

            sipRes = (sipSelfWasArg ? sipCpp->::QGLContext::create(a0) : sipCpp->create(a0));

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_create, doc_QGLContext_create);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QGLContext_isValid(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_isValid, doc_QGLContext_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_isSharing, "isSharing(self) -> bool");

extern "C" {static PyObject *meth_QGLContext_isSharing(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_isSharing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isSharing();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_isSharing, doc_QGLContext_isSharing);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_reset, "reset(self)");

extern "C" {static PyObject *meth_QGLContext_reset(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_reset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            sipCpp->reset();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_reset, doc_QGLContext_reset);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_format, "format(self) -> QGLFormat");

extern "C" {static PyObject *meth_QGLContext_format(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_format(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            ::QGLFormat*sipRes;

            sipRes = new ::QGLFormat(sipCpp->format());

            return sipConvertFromNewType(sipRes, sipType_QGLFormat, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_format, doc_QGLContext_format);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_requestedFormat, "requestedFormat(self) -> QGLFormat");

extern "C" {static PyObject *meth_QGLContext_requestedFormat(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_requestedFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            ::QGLFormat*sipRes;

            sipRes = new ::QGLFormat(sipCpp->requestedFormat());

            return sipConvertFromNewType(sipRes, sipType_QGLFormat, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_requestedFormat, doc_QGLContext_requestedFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_setFormat, "setFormat(self, format: QGLFormat)");

extern "C" {static PyObject *meth_QGLContext_setFormat(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_setFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGLFormat* a0;
        ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QGLFormat, &a0))
        {
            sipCpp->setFormat(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_setFormat, doc_QGLContext_setFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_makeCurrent, "makeCurrent(self)");

extern "C" {static PyObject *meth_QGLContext_makeCurrent(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_makeCurrent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            (sipSelfWasArg ? sipCpp->::QGLContext::makeCurrent() : sipCpp->makeCurrent());

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_makeCurrent, doc_QGLContext_makeCurrent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_doneCurrent, "doneCurrent(self)");

extern "C" {static PyObject *meth_QGLContext_doneCurrent(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_doneCurrent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            (sipSelfWasArg ? sipCpp->::QGLContext::doneCurrent() : sipCpp->doneCurrent());

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_doneCurrent, doc_QGLContext_doneCurrent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_swapBuffers, "swapBuffers(self)");

extern "C" {static PyObject *meth_QGLContext_swapBuffers(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_swapBuffers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            (sipSelfWasArg ? sipCpp->::QGLContext::swapBuffers() : sipCpp->swapBuffers());

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_swapBuffers, doc_QGLContext_swapBuffers);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_bindTexture, "bindTexture(self, image: QImage, target: int = GL_TEXTURE_2D, format: int = GL_RGBA) -> int\n"
"bindTexture(self, pixmap: QPixmap, target: int = GL_TEXTURE_2D, format: int = GL_RGBA) -> int\n"
"bindTexture(self, fileName: Optional[str]) -> int\n"
"bindTexture(self, image: QImage, target: int, format: int, options: Union[QGLContext.BindOptions, QGLContext.BindOption]) -> int\n"
"bindTexture(self, pixmap: QPixmap, target: int, format: int, options: Union[QGLContext.BindOptions, QGLContext.BindOption]) -> int");

extern "C" {static PyObject *meth_QGLContext_bindTexture(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QGLContext_bindTexture(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QImage* a0;
        ::GLenum a1 = GL_TEXTURE_2D;
        ::GLint a2 = GL_RGBA;
        ::QGLContext *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_target,
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|ui", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QImage, &a0, &a1, &a2))
        {
            ::GLuint sipRes;

            sipRes = sipCpp->bindTexture(*a0, a1, a2);

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    {
        const ::QPixmap* a0;
        ::GLenum a1 = GL_TEXTURE_2D;
        ::GLint a2 = GL_RGBA;
        ::QGLContext *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_target,
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|ui", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QPixmap, &a0, &a1, &a2))
        {
            ::GLuint sipRes;

            sipRes = sipCpp->bindTexture(*a0, a1, a2);

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        ::QGLContext *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::GLuint sipRes;

            sipRes = sipCpp->bindTexture(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    {
        const ::QImage* a0;
        ::GLenum a1;
        ::GLint a2;
        ::QGLContext::BindOptions* a3;
        int a3State = 0;
        ::QGLContext *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "BJ9uiJ1", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QImage, &a0, &a1, &a2, sipType_QGLContext_BindOptions, &a3, &a3State))
        {
            ::GLuint sipRes;

            sipRes = sipCpp->bindTexture(*a0, a1, a2, *a3);
            sipReleaseType(a3, sipType_QGLContext_BindOptions, a3State);

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    {
        const ::QPixmap* a0;
        ::GLenum a1;
        ::GLint a2;
        ::QGLContext::BindOptions* a3;
        int a3State = 0;
        ::QGLContext *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "BJ9uiJ1", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QPixmap, &a0, &a1, &a2, sipType_QGLContext_BindOptions, &a3, &a3State))
        {
            ::GLuint sipRes;

            sipRes = sipCpp->bindTexture(*a0, a1, a2, *a3);
            sipReleaseType(a3, sipType_QGLContext_BindOptions, a3State);

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_bindTexture, doc_QGLContext_bindTexture);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_drawTexture, "drawTexture(self, target: QRectF, textureId: int, textureTarget: int = GL_TEXTURE_2D)\n"
"drawTexture(self, point: Union[QPointF, QPoint], textureId: int, textureTarget: int = GL_TEXTURE_2D)");

extern "C" {static PyObject *meth_QGLContext_drawTexture(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QGLContext_drawTexture(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF* a0;
        ::GLuint a1;
        ::GLenum a2 = GL_TEXTURE_2D;
        ::QGLContext *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_textureTarget,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9u|u", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QRectF, &a0, &a1, &a2))
        {
            sipCpp->drawTexture(*a0, a1, a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::QPointF* a0;
        int a0State = 0;
        ::GLuint a1;
        ::GLenum a2 = GL_TEXTURE_2D;
        ::QGLContext *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_textureTarget,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1u|u", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QPointF, &a0, &a0State, &a1, &a2))
        {
            sipCpp->drawTexture(*a0, a1, a2);
            sipReleaseType(const_cast< ::QPointF *>(a0), sipType_QPointF, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_drawTexture, doc_QGLContext_drawTexture);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_deleteTexture, "deleteTexture(self, tx_id: int)");

extern "C" {static PyObject *meth_QGLContext_deleteTexture(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_deleteTexture(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::GLuint a0;
        ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bu", &sipSelf, sipType_QGLContext, &sipCpp, &a0))
        {
            sipCpp->deleteTexture(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_deleteTexture, doc_QGLContext_deleteTexture);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_setTextureCacheLimit, "setTextureCacheLimit(size: int)");

extern "C" {static PyObject *meth_QGLContext_setTextureCacheLimit(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_setTextureCacheLimit(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "i", &a0))
        {
            ::QGLContext::setTextureCacheLimit(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_setTextureCacheLimit, doc_QGLContext_setTextureCacheLimit);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_textureCacheLimit, "textureCacheLimit() -> int");

extern "C" {static PyObject *meth_QGLContext_textureCacheLimit(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_textureCacheLimit(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            int sipRes;

            sipRes = ::QGLContext::textureCacheLimit();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_textureCacheLimit, doc_QGLContext_textureCacheLimit);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_getProcAddress, "getProcAddress(self, proc: Optional[str]) -> Optional[PyQt5.sip.voidptr]");

extern "C" {static PyObject *meth_QGLContext_getProcAddress(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_getProcAddress(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QFunctionPointer sipRes;

            sipRes = sipCpp->getProcAddress(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromVoidPtr((void *)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_getProcAddress, doc_QGLContext_getProcAddress);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_device, "device(self) -> Optional[QPaintDevice]");

extern "C" {static PyObject *meth_QGLContext_device(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_device(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            ::QPaintDevice*sipRes;

            sipRes = sipCpp->device();

            return sipConvertFromType(sipRes, sipType_QPaintDevice, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_device, doc_QGLContext_device);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_overlayTransparentColor, "overlayTransparentColor(self) -> QColor");

extern "C" {static PyObject *meth_QGLContext_overlayTransparentColor(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_overlayTransparentColor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            ::QColor*sipRes;

            sipRes = new ::QColor(sipCpp->overlayTransparentColor());

            return sipConvertFromNewType(sipRes, sipType_QColor, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_overlayTransparentColor, doc_QGLContext_overlayTransparentColor);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_currentContext, "currentContext() -> Optional[QGLContext]");

extern "C" {static PyObject *meth_QGLContext_currentContext(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_currentContext(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            const ::QGLContext*sipRes;

            sipRes = ::QGLContext::currentContext();

            return sipConvertFromType(const_cast< ::QGLContext *>(sipRes), sipType_QGLContext, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_currentContext, doc_QGLContext_currentContext);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_chooseContext, "chooseContext(self, shareContext: Optional[QGLContext] = None) -> bool");

extern "C" {static PyObject *meth_QGLContext_chooseContext(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QGLContext_chooseContext(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QGLContext* a0 = 0;
        ::QGLContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_shareContext,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "p|J8", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QGLContext, &a0))
        {
            bool sipRes;

            sipRes = (sipSelfWasArg ? sipCpp->::QGLContext::chooseContext(a0) : sipCpp->chooseContext(a0));

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_chooseContext, doc_QGLContext_chooseContext);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_deviceIsPixmap, "deviceIsPixmap(self) -> bool");

extern "C" {static PyObject *meth_QGLContext_deviceIsPixmap(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_deviceIsPixmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "p", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->deviceIsPixmap();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_deviceIsPixmap, doc_QGLContext_deviceIsPixmap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_windowCreated, "windowCreated(self) -> bool");

extern "C" {static PyObject *meth_QGLContext_windowCreated(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_windowCreated(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "p", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->windowCreated();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_windowCreated, doc_QGLContext_windowCreated);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_setWindowCreated, "setWindowCreated(self, on: bool)");

extern "C" {static PyObject *meth_QGLContext_setWindowCreated(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_setWindowCreated(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "pb", &sipSelf, sipType_QGLContext, &sipCpp, &a0))
        {
            sipCpp->setWindowCreated(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_setWindowCreated, doc_QGLContext_setWindowCreated);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_initialized, "initialized(self) -> bool");

extern "C" {static PyObject *meth_QGLContext_initialized(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_initialized(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "p", &sipSelf, sipType_QGLContext, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->initialized();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_initialized, doc_QGLContext_initialized);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_setInitialized, "setInitialized(self, on: bool)");

extern "C" {static PyObject *meth_QGLContext_setInitialized(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_setInitialized(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "pb", &sipSelf, sipType_QGLContext, &sipCpp, &a0))
        {
            sipCpp->setInitialized(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_setInitialized, doc_QGLContext_setInitialized);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_areSharing, "areSharing(context1: Optional[QGLContext], context2: Optional[QGLContext]) -> bool");

extern "C" {static PyObject *meth_QGLContext_areSharing(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_areSharing(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QGLContext* a0;
        const ::QGLContext* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J8J8", sipType_QGLContext, &a0, sipType_QGLContext, &a1))
        {
            bool sipRes;

            sipRes = ::QGLContext::areSharing(a0, a1);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_areSharing, doc_QGLContext_areSharing);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QGLContext_moveToThread, "moveToThread(self, thread: Optional[QThread])");

extern "C" {static PyObject *meth_QGLContext_moveToThread(PyObject *, PyObject *);}
static PyObject *meth_QGLContext_moveToThread(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QThread* a0;
        ::QGLContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QGLContext, &sipCpp, sipType_QThread, &a0))
        {
            sipCpp->moveToThread(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QGLContext, sipName_moveToThread, doc_QGLContext_moveToThread);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QGLContext(void *, int);}
static void release_QGLContext(void *sipCppV, int sipState)
{
    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQGLContext *>(sipCppV);
    else
        delete reinterpret_cast< ::QGLContext *>(sipCppV);
}


extern "C" {static void dealloc_QGLContext(sipSimpleWrapper *);}
static void dealloc_QGLContext(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQGLContext *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QGLContext(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QGLContext(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QGLContext(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQGLContext *sipCpp = SIP_NULLPTR;

    {
        const ::QGLFormat* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QGLFormat, &a0))
        {
            sipCpp = new sipQGLContext(*a0);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QGLContext[] = {
    {sipName_areSharing, meth_QGLContext_areSharing, METH_VARARGS, doc_QGLContext_areSharing},
    {sipName_bindTexture, SIP_MLMETH_CAST(meth_QGLContext_bindTexture), METH_VARARGS|METH_KEYWORDS, doc_QGLContext_bindTexture},
    {sipName_chooseContext, SIP_MLMETH_CAST(meth_QGLContext_chooseContext), METH_VARARGS|METH_KEYWORDS, doc_QGLContext_chooseContext},
    {sipName_create, SIP_MLMETH_CAST(meth_QGLContext_create), METH_VARARGS|METH_KEYWORDS, doc_QGLContext_create},
    {sipName_currentContext, meth_QGLContext_currentContext, METH_VARARGS, doc_QGLContext_currentContext},
    {sipName_deleteTexture, meth_QGLContext_deleteTexture, METH_VARARGS, doc_QGLContext_deleteTexture},
    {sipName_device, meth_QGLContext_device, METH_VARARGS, doc_QGLContext_device},
    {sipName_deviceIsPixmap, meth_QGLContext_deviceIsPixmap, METH_VARARGS, doc_QGLContext_deviceIsPixmap},
    {sipName_doneCurrent, meth_QGLContext_doneCurrent, METH_VARARGS, doc_QGLContext_doneCurrent},
    {sipName_drawTexture, SIP_MLMETH_CAST(meth_QGLContext_drawTexture), METH_VARARGS|METH_KEYWORDS, doc_QGLContext_drawTexture},
    {sipName_format, meth_QGLContext_format, METH_VARARGS, doc_QGLContext_format},
    {sipName_getProcAddress, meth_QGLContext_getProcAddress, METH_VARARGS, doc_QGLContext_getProcAddress},
    {sipName_initialized, meth_QGLContext_initialized, METH_VARARGS, doc_QGLContext_initialized},
    {sipName_isSharing, meth_QGLContext_isSharing, METH_VARARGS, doc_QGLContext_isSharing},
    {sipName_isValid, meth_QGLContext_isValid, METH_VARARGS, doc_QGLContext_isValid},
    {sipName_makeCurrent, meth_QGLContext_makeCurrent, METH_VARARGS, doc_QGLContext_makeCurrent},
    {sipName_moveToThread, meth_QGLContext_moveToThread, METH_VARARGS, doc_QGLContext_moveToThread},
    {sipName_overlayTransparentColor, meth_QGLContext_overlayTransparentColor, METH_VARARGS, doc_QGLContext_overlayTransparentColor},
    {sipName_requestedFormat, meth_QGLContext_requestedFormat, METH_VARARGS, doc_QGLContext_requestedFormat},
    {sipName_reset, meth_QGLContext_reset, METH_VARARGS, doc_QGLContext_reset},
    {sipName_setFormat, meth_QGLContext_setFormat, METH_VARARGS, doc_QGLContext_setFormat},
    {sipName_setInitialized, meth_QGLContext_setInitialized, METH_VARARGS, doc_QGLContext_setInitialized},
    {sipName_setTextureCacheLimit, meth_QGLContext_setTextureCacheLimit, METH_VARARGS, doc_QGLContext_setTextureCacheLimit},
    {sipName_setWindowCreated, meth_QGLContext_setWindowCreated, METH_VARARGS, doc_QGLContext_setWindowCreated},
    {sipName_swapBuffers, meth_QGLContext_swapBuffers, METH_VARARGS, doc_QGLContext_swapBuffers},
    {sipName_textureCacheLimit, meth_QGLContext_textureCacheLimit, METH_VARARGS, doc_QGLContext_textureCacheLimit},
    {sipName_windowCreated, meth_QGLContext_windowCreated, METH_VARARGS, doc_QGLContext_windowCreated}
};

static sipEnumMemberDef enummembers_QGLContext[] = {
    {sipName_DefaultBindOption, static_cast<int>(::QGLContext::DefaultBindOption), 4},
    {sipName_InvertedYBindOption, static_cast<int>(::QGLContext::InvertedYBindOption), 4},
    {sipName_LinearFilteringBindOption, static_cast<int>(::QGLContext::LinearFilteringBindOption), 4},
    {sipName_MipmapBindOption, static_cast<int>(::QGLContext::MipmapBindOption), 4},
    {sipName_NoBindOption, static_cast<int>(::QGLContext::NoBindOption), 4},
    {sipName_PremultipliedAlphaBindOption, static_cast<int>(::QGLContext::PremultipliedAlphaBindOption), 4},
};

PyDoc_STRVAR(doc_QGLContext, "\1QGLContext(format: QGLFormat)");


static pyqt5ClassPluginDef plugin_QGLContext = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtOpenGL_QGLContext = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QGLContext,
        SIP_NULLPTR,
        &plugin_QGLContext,
    },
    {
        sipNameNr_QGLContext,
        {0, 0, 1},
        27, methods_QGLContext,
        6, enummembers_QGLContext,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QGLContext,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QGLContext,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QGLContext,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QGLContext,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QGLContext),
};
