// components/printing/common/print.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_H_
#define COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/printing/common/print.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "printing/mojom/print.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace printing {
namespace mojom {
class PreviewIdsDataView;

class PrintFrameContentParamsDataView;

class OptionsFromDocumentParamsDataView;

class DidPrintContentParamsDataView;

class DidStartPreviewParamsDataView;

class DidPreviewPageParamsDataView;

class DidPreviewDocumentParamsDataView;

class PrintParamsDataView;

class PrintPagesParamsDataView;

class DidPrintDocumentParamsDataView;

class ScriptedPrintParamsDataView;



}  // namespace mojom
}  // namespace printing

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::printing::mojom::PreviewIdsDataView> {
  using Data = ::printing::mojom::internal::PreviewIds_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintFrameContentParamsDataView> {
  using Data = ::printing::mojom::internal::PrintFrameContentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::OptionsFromDocumentParamsDataView> {
  using Data = ::printing::mojom::internal::OptionsFromDocumentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPrintContentParamsDataView> {
  using Data = ::printing::mojom::internal::DidPrintContentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidStartPreviewParamsDataView> {
  using Data = ::printing::mojom::internal::DidStartPreviewParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPreviewPageParamsDataView> {
  using Data = ::printing::mojom::internal::DidPreviewPageParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPreviewDocumentParamsDataView> {
  using Data = ::printing::mojom::internal::DidPreviewDocumentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintParamsDataView> {
  using Data = ::printing::mojom::internal::PrintParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintPagesParamsDataView> {
  using Data = ::printing::mojom::internal::PrintPagesParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::DidPrintDocumentParamsDataView> {
  using Data = ::printing::mojom::internal::DidPrintDocumentParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::ScriptedPrintParamsDataView> {
  using Data = ::printing::mojom::internal::ScriptedPrintParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace printing {
namespace mojom {
// Interface base classes. They are used for type safety check.
class PrintRendererInterfaceBase {};

using PrintRendererPtrDataView =
    mojo::InterfacePtrDataView<PrintRendererInterfaceBase>;
using PrintRendererRequestDataView =
    mojo::InterfaceRequestDataView<PrintRendererInterfaceBase>;
using PrintRendererAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrintRendererInterfaceBase>;
using PrintRendererAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrintRendererInterfaceBase>;
class PrintPreviewUIInterfaceBase {};

using PrintPreviewUIPtrDataView =
    mojo::InterfacePtrDataView<PrintPreviewUIInterfaceBase>;
using PrintPreviewUIRequestDataView =
    mojo::InterfaceRequestDataView<PrintPreviewUIInterfaceBase>;
using PrintPreviewUIAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrintPreviewUIInterfaceBase>;
using PrintPreviewUIAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrintPreviewUIInterfaceBase>;
class PrintRenderFrameInterfaceBase {};

using PrintRenderFramePtrDataView =
    mojo::InterfacePtrDataView<PrintRenderFrameInterfaceBase>;
using PrintRenderFrameRequestDataView =
    mojo::InterfaceRequestDataView<PrintRenderFrameInterfaceBase>;
using PrintRenderFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrintRenderFrameInterfaceBase>;
using PrintRenderFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrintRenderFrameInterfaceBase>;
class PrintManagerHostInterfaceBase {};

using PrintManagerHostPtrDataView =
    mojo::InterfacePtrDataView<PrintManagerHostInterfaceBase>;
using PrintManagerHostRequestDataView =
    mojo::InterfaceRequestDataView<PrintManagerHostInterfaceBase>;
using PrintManagerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrintManagerHostInterfaceBase>;
using PrintManagerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrintManagerHostInterfaceBase>;


class PreviewIdsDataView {
 public:
  PreviewIdsDataView() {}

  PreviewIdsDataView(
      internal::PreviewIds_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t request_id() const {
    return data_->request_id;
  }
  int32_t ui_id() const {
    return data_->ui_id;
  }
 private:
  internal::PreviewIds_Data* data_ = nullptr;
};



class PrintFrameContentParamsDataView {
 public:
  PrintFrameContentParamsDataView() {}

  PrintFrameContentParamsDataView(
      internal::PrintFrameContentParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPrintableAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrintableArea(UserType* output) {
    
    auto* pointer = data_->printable_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
 private:
  internal::PrintFrameContentParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class OptionsFromDocumentParamsDataView {
 public:
  OptionsFromDocumentParamsDataView() {}

  OptionsFromDocumentParamsDataView(
      internal::OptionsFromDocumentParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_scaling_disabled() const {
    return data_->is_scaling_disabled;
  }
  int32_t copies() const {
    return data_->copies;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDuplex(UserType* output) const {
    auto data_value = data_->duplex;
    return mojo::internal::Deserialize<::printing::mojom::DuplexMode>(
        data_value, output);
  }

  ::printing::mojom::DuplexMode duplex() const {
    return static_cast<::printing::mojom::DuplexMode>(data_->duplex);
  }
 private:
  internal::OptionsFromDocumentParams_Data* data_ = nullptr;
};



class DidPrintContentParamsDataView {
 public:
  DidPrintContentParamsDataView() {}

  DidPrintContentParamsDataView(
      internal::DidPrintContentParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetMetafileDataRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMetafileDataRegion(UserType* output) {
    
    auto* pointer = data_->metafile_data_region.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        pointer, output, context_);
  }
  inline void GetSubframeContentInfoDataView(
      mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubframeContentInfo(UserType* output) {
    
    auto* pointer = data_->subframe_content_info.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
        pointer, output, context_);
  }
 private:
  internal::DidPrintContentParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DidStartPreviewParamsDataView {
 public:
  DidStartPreviewParamsDataView() {}

  DidStartPreviewParamsDataView(
      internal::DidStartPreviewParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t page_count() const {
    return data_->page_count;
  }
  inline void GetPagesToRenderDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPagesToRender(UserType* output) {
    
    auto* pointer = data_->pages_to_render.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, context_);
  }
  int32_t pages_per_sheet() const {
    return data_->pages_per_sheet;
  }
  inline void GetPageSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPageSize(UserType* output) {
    
    auto* pointer = data_->page_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  int32_t fit_to_page_scaling() const {
    return data_->fit_to_page_scaling;
  }
 private:
  internal::DidStartPreviewParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DidPreviewPageParamsDataView {
 public:
  DidPreviewPageParamsDataView() {}

  DidPreviewPageParamsDataView(
      internal::DidPreviewPageParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetContentDataView(
      DidPrintContentParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintContentParamsDataView>(
        pointer, output, context_);
  }
  uint32_t page_number() const {
    return data_->page_number;
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
 private:
  internal::DidPreviewPageParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DidPreviewDocumentParamsDataView {
 public:
  DidPreviewDocumentParamsDataView() {}

  DidPreviewDocumentParamsDataView(
      internal::DidPreviewDocumentParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetContentDataView(
      DidPrintContentParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintContentParamsDataView>(
        pointer, output, context_);
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  uint32_t expected_pages_count() const {
    return data_->expected_pages_count;
  }
 private:
  internal::DidPreviewDocumentParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintParamsDataView {
 public:
  PrintParamsDataView() {}

  PrintParamsDataView(
      internal::PrintParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPageSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPageSize(UserType* output) {
    
    auto* pointer = data_->page_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetContentSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContentSize(UserType* output) {
    
    auto* pointer = data_->content_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetPrintableAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrintableArea(UserType* output) {
    
    auto* pointer = data_->printable_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  int32_t margin_top() const {
    return data_->margin_top;
  }
  int32_t margin_left() const {
    return data_->margin_left;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPageOrientation(UserType* output) const {
    auto data_value = data_->page_orientation;
    return mojo::internal::Deserialize<::printing::mojom::PageOrientation>(
        data_value, output);
  }

  ::printing::mojom::PageOrientation page_orientation() const {
    return static_cast<::printing::mojom::PageOrientation>(data_->page_orientation);
  }
  inline void GetDpiDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDpi(UserType* output) {
    
    auto* pointer = data_->dpi.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  double scale_factor() const {
    return data_->scale_factor;
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  bool selection_only() const {
    return data_->selection_only;
  }
  bool supports_alpha_blend() const {
    return data_->supports_alpha_blend;
  }
  int32_t preview_ui_id() const {
    return data_->preview_ui_id;
  }
  int32_t preview_request_id() const {
    return data_->preview_request_id;
  }
  bool is_first_request() const {
    return data_->is_first_request;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrintScalingOption(UserType* output) const {
    auto data_value = data_->print_scaling_option;
    return mojo::internal::Deserialize<::printing::mojom::PrintScalingOption>(
        data_value, output);
  }

  ::printing::mojom::PrintScalingOption print_scaling_option() const {
    return static_cast<::printing::mojom::PrintScalingOption>(data_->print_scaling_option);
  }
  bool print_to_pdf() const {
    return data_->print_to_pdf;
  }
  bool display_header_footer() const {
    return data_->display_header_footer;
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  inline void GetUrlDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  inline void GetHeaderTemplateDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeaderTemplate(UserType* output) {
    
    auto* pointer = data_->header_template.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  inline void GetFooterTemplateDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFooterTemplate(UserType* output) {
    
    auto* pointer = data_->footer_template.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, context_);
  }
  bool rasterize_pdf() const {
    return data_->rasterize_pdf;
  }
  bool should_print_backgrounds() const {
    return data_->should_print_backgrounds;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrintedDocType(UserType* output) const {
    auto data_value = data_->printed_doc_type;
    return mojo::internal::Deserialize<::printing::mojom::SkiaDocumentType>(
        data_value, output);
  }

  ::printing::mojom::SkiaDocumentType printed_doc_type() const {
    return static_cast<::printing::mojom::SkiaDocumentType>(data_->printed_doc_type);
  }
  bool prefer_css_page_size() const {
    return data_->prefer_css_page_size;
  }
  uint32_t pages_per_sheet() const {
    return data_->pages_per_sheet;
  }
 private:
  internal::PrintParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PrintPagesParamsDataView {
 public:
  PrintPagesParamsDataView() {}

  PrintPagesParamsDataView(
      internal::PrintPagesParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      PrintParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::printing::mojom::PrintParamsDataView>(
        pointer, output, context_);
  }
  inline void GetPagesDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPages(UserType* output) {
    
    auto* pointer = data_->pages.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, context_);
  }
 private:
  internal::PrintPagesParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class DidPrintDocumentParamsDataView {
 public:
  DidPrintDocumentParamsDataView() {}

  DidPrintDocumentParamsDataView(
      internal::DidPrintDocumentParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetContentDataView(
      DidPrintContentParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContent(UserType* output) {
    
    auto* pointer = data_->content.Get();
    return mojo::internal::Deserialize<::printing::mojom::DidPrintContentParamsDataView>(
        pointer, output, context_);
  }
  int32_t document_cookie() const {
    return data_->document_cookie;
  }
  inline void GetPageSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPageSize(UserType* output) {
    
    auto* pointer = data_->page_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetContentAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContentArea(UserType* output) {
    
    auto* pointer = data_->content_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  inline void GetPhysicalOffsetsDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPhysicalOffsets(UserType* output) {
    
    auto* pointer = data_->physical_offsets.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, context_);
  }
 private:
  internal::DidPrintDocumentParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ScriptedPrintParamsDataView {
 public:
  ScriptedPrintParamsDataView() {}

  ScriptedPrintParamsDataView(
      internal::ScriptedPrintParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t cookie() const {
    return data_->cookie;
  }
  uint32_t expected_pages_count() const {
    return data_->expected_pages_count;
  }
  bool has_selection() const {
    return data_->has_selection;
  }
  bool is_scripted() const {
    return data_->is_scripted;
  }
  bool is_modifiable() const {
    return data_->is_modifiable;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMarginType(UserType* output) const {
    auto data_value = data_->margin_type;
    return mojo::internal::Deserialize<::printing::mojom::MarginType>(
        data_value, output);
  }

  ::printing::mojom::MarginType margin_type() const {
    return static_cast<::printing::mojom::MarginType>(data_->margin_type);
  }
 private:
  internal::ScriptedPrintParams_Data* data_ = nullptr;
};



}  // namespace mojom
}  // namespace printing

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PreviewIdsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PreviewIdsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::PreviewIds_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->request_id = Traits::request_id(input);
    (*output)->ui_id = Traits::ui_id(input);
  }

  static bool Deserialize(::printing::mojom::internal::PreviewIds_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PreviewIdsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintFrameContentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintFrameContentParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::PrintFrameContentParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::printable_area(input)) in_printable_area = Traits::printable_area(input);
    typename decltype((*output)->printable_area)::BaseType::BufferWriter
        printable_area_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_printable_area, buffer, &printable_area_writer, context);
    (*output)->printable_area.Set(
        printable_area_writer.is_null() ? nullptr : printable_area_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->printable_area.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printable_area in PrintFrameContentParams struct");
    (*output)->document_cookie = Traits::document_cookie(input);
  }

  static bool Deserialize(::printing::mojom::internal::PrintFrameContentParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintFrameContentParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::OptionsFromDocumentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::OptionsFromDocumentParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::OptionsFromDocumentParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->is_scaling_disabled = Traits::is_scaling_disabled(input);
    (*output)->copies = Traits::copies(input);
    mojo::internal::Serialize<::printing::mojom::DuplexMode>(
        Traits::duplex(input), &(*output)->duplex);
  }

  static bool Deserialize(::printing::mojom::internal::OptionsFromDocumentParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::OptionsFromDocumentParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPrintContentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPrintContentParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::DidPrintContentParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::metafile_data_region(input)) in_metafile_data_region = Traits::metafile_data_region(input);
    typename decltype((*output)->metafile_data_region)::BaseType::BufferWriter
        metafile_data_region_writer;
    mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        in_metafile_data_region, buffer, &metafile_data_region_writer, context);
    (*output)->metafile_data_region.Set(
        metafile_data_region_writer.is_null() ? nullptr : metafile_data_region_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->metafile_data_region.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metafile_data_region in DidPrintContentParams struct");
    decltype(Traits::subframe_content_info(input)) in_subframe_content_info = Traits::subframe_content_info(input);
    typename decltype((*output)->subframe_content_info)::BaseType::BufferWriter
        subframe_content_info_writer;
    const mojo::internal::ContainerValidateParams subframe_content_info_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>>(
        in_subframe_content_info, buffer, &subframe_content_info_writer, &subframe_content_info_validate_params,
        context);
    (*output)->subframe_content_info.Set(
        subframe_content_info_writer.is_null() ? nullptr : subframe_content_info_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->subframe_content_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null subframe_content_info in DidPrintContentParams struct");
  }

  static bool Deserialize(::printing::mojom::internal::DidPrintContentParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPrintContentParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidStartPreviewParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidStartPreviewParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::DidStartPreviewParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->page_count = Traits::page_count(input);
    decltype(Traits::pages_to_render(input)) in_pages_to_render = Traits::pages_to_render(input);
    typename decltype((*output)->pages_to_render)::BaseType::BufferWriter
        pages_to_render_writer;
    const mojo::internal::ContainerValidateParams pages_to_render_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_pages_to_render, buffer, &pages_to_render_writer, &pages_to_render_validate_params,
        context);
    (*output)->pages_to_render.Set(
        pages_to_render_writer.is_null() ? nullptr : pages_to_render_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->pages_to_render.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pages_to_render in DidStartPreviewParams struct");
    (*output)->pages_per_sheet = Traits::pages_per_sheet(input);
    decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
    typename decltype((*output)->page_size)::BaseType::BufferWriter
        page_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_page_size, buffer, &page_size_writer, context);
    (*output)->page_size.Set(
        page_size_writer.is_null() ? nullptr : page_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->page_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_size in DidStartPreviewParams struct");
    (*output)->fit_to_page_scaling = Traits::fit_to_page_scaling(input);
  }

  static bool Deserialize(::printing::mojom::internal::DidStartPreviewParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidStartPreviewParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPreviewPageParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPreviewPageParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::DidPreviewPageParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::content(input)) in_content = Traits::content(input);
    typename decltype((*output)->content)::BaseType::BufferWriter
        content_writer;
    mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView>(
        in_content, buffer, &content_writer, context);
    (*output)->content.Set(
        content_writer.is_null() ? nullptr : content_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->content.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in DidPreviewPageParams struct");
    (*output)->page_number = Traits::page_number(input);
    (*output)->document_cookie = Traits::document_cookie(input);
  }

  static bool Deserialize(::printing::mojom::internal::DidPreviewPageParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPreviewPageParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPreviewDocumentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPreviewDocumentParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::DidPreviewDocumentParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::content(input)) in_content = Traits::content(input);
    typename decltype((*output)->content)::BaseType::BufferWriter
        content_writer;
    mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView>(
        in_content, buffer, &content_writer, context);
    (*output)->content.Set(
        content_writer.is_null() ? nullptr : content_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->content.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in DidPreviewDocumentParams struct");
    (*output)->document_cookie = Traits::document_cookie(input);
    (*output)->expected_pages_count = Traits::expected_pages_count(input);
  }

  static bool Deserialize(::printing::mojom::internal::DidPreviewDocumentParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPreviewDocumentParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::PrintParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
    typename decltype((*output)->page_size)::BaseType::BufferWriter
        page_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_page_size, buffer, &page_size_writer, context);
    (*output)->page_size.Set(
        page_size_writer.is_null() ? nullptr : page_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->page_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_size in PrintParams struct");
    decltype(Traits::content_size(input)) in_content_size = Traits::content_size(input);
    typename decltype((*output)->content_size)::BaseType::BufferWriter
        content_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_content_size, buffer, &content_size_writer, context);
    (*output)->content_size.Set(
        content_size_writer.is_null() ? nullptr : content_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->content_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_size in PrintParams struct");
    decltype(Traits::printable_area(input)) in_printable_area = Traits::printable_area(input);
    typename decltype((*output)->printable_area)::BaseType::BufferWriter
        printable_area_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_printable_area, buffer, &printable_area_writer, context);
    (*output)->printable_area.Set(
        printable_area_writer.is_null() ? nullptr : printable_area_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->printable_area.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null printable_area in PrintParams struct");
    (*output)->margin_top = Traits::margin_top(input);
    (*output)->margin_left = Traits::margin_left(input);
    mojo::internal::Serialize<::printing::mojom::PageOrientation>(
        Traits::page_orientation(input), &(*output)->page_orientation);
    decltype(Traits::dpi(input)) in_dpi = Traits::dpi(input);
    typename decltype((*output)->dpi)::BaseType::BufferWriter
        dpi_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_dpi, buffer, &dpi_writer, context);
    (*output)->dpi.Set(
        dpi_writer.is_null() ? nullptr : dpi_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->dpi.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dpi in PrintParams struct");
    (*output)->scale_factor = Traits::scale_factor(input);
    (*output)->document_cookie = Traits::document_cookie(input);
    (*output)->selection_only = Traits::selection_only(input);
    (*output)->supports_alpha_blend = Traits::supports_alpha_blend(input);
    (*output)->preview_ui_id = Traits::preview_ui_id(input);
    (*output)->preview_request_id = Traits::preview_request_id(input);
    (*output)->is_first_request = Traits::is_first_request(input);
    mojo::internal::Serialize<::printing::mojom::PrintScalingOption>(
        Traits::print_scaling_option(input), &(*output)->print_scaling_option);
    (*output)->print_to_pdf = Traits::print_to_pdf(input);
    (*output)->display_header_footer = Traits::display_header_footer(input);
    decltype(Traits::title(input)) in_title = Traits::title(input);
    typename decltype((*output)->title)::BaseType::BufferWriter
        title_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title, buffer, &title_writer, context);
    (*output)->title.Set(
        title_writer.is_null() ? nullptr : title_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in PrintParams struct");
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in PrintParams struct");
    decltype(Traits::header_template(input)) in_header_template = Traits::header_template(input);
    typename decltype((*output)->header_template)::BaseType::BufferWriter
        header_template_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_header_template, buffer, &header_template_writer, context);
    (*output)->header_template.Set(
        header_template_writer.is_null() ? nullptr : header_template_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->header_template.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null header_template in PrintParams struct");
    decltype(Traits::footer_template(input)) in_footer_template = Traits::footer_template(input);
    typename decltype((*output)->footer_template)::BaseType::BufferWriter
        footer_template_writer;
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_footer_template, buffer, &footer_template_writer, context);
    (*output)->footer_template.Set(
        footer_template_writer.is_null() ? nullptr : footer_template_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->footer_template.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null footer_template in PrintParams struct");
    (*output)->rasterize_pdf = Traits::rasterize_pdf(input);
    (*output)->should_print_backgrounds = Traits::should_print_backgrounds(input);
    mojo::internal::Serialize<::printing::mojom::SkiaDocumentType>(
        Traits::printed_doc_type(input), &(*output)->printed_doc_type);
    (*output)->prefer_css_page_size = Traits::prefer_css_page_size(input);
    (*output)->pages_per_sheet = Traits::pages_per_sheet(input);
  }

  static bool Deserialize(::printing::mojom::internal::PrintParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintPagesParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrintPagesParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::PrintPagesParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::params(input)) in_params = Traits::params(input);
    typename decltype((*output)->params)::BaseType::BufferWriter
        params_writer;
    mojo::internal::Serialize<::printing::mojom::PrintParamsDataView>(
        in_params, buffer, &params_writer, context);
    (*output)->params.Set(
        params_writer.is_null() ? nullptr : params_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in PrintPagesParams struct");
    decltype(Traits::pages(input)) in_pages = Traits::pages(input);
    typename decltype((*output)->pages)::BaseType::BufferWriter
        pages_writer;
    const mojo::internal::ContainerValidateParams pages_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_pages, buffer, &pages_writer, &pages_validate_params,
        context);
    (*output)->pages.Set(
        pages_writer.is_null() ? nullptr : pages_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->pages.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pages in PrintPagesParams struct");
  }

  static bool Deserialize(::printing::mojom::internal::PrintPagesParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrintPagesParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DidPrintDocumentParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::DidPrintDocumentParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::DidPrintDocumentParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::content(input)) in_content = Traits::content(input);
    typename decltype((*output)->content)::BaseType::BufferWriter
        content_writer;
    mojo::internal::Serialize<::printing::mojom::DidPrintContentParamsDataView>(
        in_content, buffer, &content_writer, context);
    (*output)->content.Set(
        content_writer.is_null() ? nullptr : content_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->content.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in DidPrintDocumentParams struct");
    (*output)->document_cookie = Traits::document_cookie(input);
    decltype(Traits::page_size(input)) in_page_size = Traits::page_size(input);
    typename decltype((*output)->page_size)::BaseType::BufferWriter
        page_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_page_size, buffer, &page_size_writer, context);
    (*output)->page_size.Set(
        page_size_writer.is_null() ? nullptr : page_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->page_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_size in DidPrintDocumentParams struct");
    decltype(Traits::content_area(input)) in_content_area = Traits::content_area(input);
    typename decltype((*output)->content_area)::BaseType::BufferWriter
        content_area_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_content_area, buffer, &content_area_writer, context);
    (*output)->content_area.Set(
        content_area_writer.is_null() ? nullptr : content_area_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->content_area.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_area in DidPrintDocumentParams struct");
    decltype(Traits::physical_offsets(input)) in_physical_offsets = Traits::physical_offsets(input);
    typename decltype((*output)->physical_offsets)::BaseType::BufferWriter
        physical_offsets_writer;
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_physical_offsets, buffer, &physical_offsets_writer, context);
    (*output)->physical_offsets.Set(
        physical_offsets_writer.is_null() ? nullptr : physical_offsets_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->physical_offsets.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null physical_offsets in DidPrintDocumentParams struct");
  }

  static bool Deserialize(::printing::mojom::internal::DidPrintDocumentParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::DidPrintDocumentParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::ScriptedPrintParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::ScriptedPrintParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::printing::mojom::internal::ScriptedPrintParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->cookie = Traits::cookie(input);
    (*output)->expected_pages_count = Traits::expected_pages_count(input);
    (*output)->has_selection = Traits::has_selection(input);
    (*output)->is_scripted = Traits::is_scripted(input);
    (*output)->is_modifiable = Traits::is_modifiable(input);
    mojo::internal::Serialize<::printing::mojom::MarginType>(
        Traits::margin_type(input), &(*output)->margin_type);
  }

  static bool Deserialize(::printing::mojom::internal::ScriptedPrintParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::ScriptedPrintParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace printing {
namespace mojom {



inline void PrintFrameContentParamsDataView::GetPrintableAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->printable_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}




inline void DidPrintContentParamsDataView::GetMetafileDataRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->metafile_data_region.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, context_);
}
inline void DidPrintContentParamsDataView::GetSubframeContentInfoDataView(
    mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>* output) {
  auto pointer = data_->subframe_content_info.Get();
  *output = mojo::MapDataView<uint32_t, ::mojo_base::mojom::UnguessableTokenDataView>(pointer, context_);
}


inline void DidStartPreviewParamsDataView::GetPagesToRenderDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->pages_to_render.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, context_);
}
inline void DidStartPreviewParamsDataView::GetPageSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->page_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}


inline void DidPreviewPageParamsDataView::GetContentDataView(
    DidPrintContentParamsDataView* output) {
  auto pointer = data_->content.Get();
  *output = DidPrintContentParamsDataView(pointer, context_);
}


inline void DidPreviewDocumentParamsDataView::GetContentDataView(
    DidPrintContentParamsDataView* output) {
  auto pointer = data_->content.Get();
  *output = DidPrintContentParamsDataView(pointer, context_);
}


inline void PrintParamsDataView::GetPageSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->page_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void PrintParamsDataView::GetContentSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->content_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void PrintParamsDataView::GetPrintableAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->printable_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}
inline void PrintParamsDataView::GetDpiDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->dpi.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void PrintParamsDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}
inline void PrintParamsDataView::GetUrlDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->url.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}
inline void PrintParamsDataView::GetHeaderTemplateDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->header_template.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}
inline void PrintParamsDataView::GetFooterTemplateDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->footer_template.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, context_);
}


inline void PrintPagesParamsDataView::GetParamsDataView(
    PrintParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = PrintParamsDataView(pointer, context_);
}
inline void PrintPagesParamsDataView::GetPagesDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->pages.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, context_);
}


inline void DidPrintDocumentParamsDataView::GetContentDataView(
    DidPrintContentParamsDataView* output) {
  auto pointer = data_->content.Get();
  *output = DidPrintContentParamsDataView(pointer, context_);
}
inline void DidPrintDocumentParamsDataView::GetPageSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->page_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void DidPrintDocumentParamsDataView::GetContentAreaDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->content_area.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}
inline void DidPrintDocumentParamsDataView::GetPhysicalOffsetsDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->physical_offsets.Get();
  *output = ::gfx::mojom::PointDataView(pointer, context_);
}





}  // namespace mojom
}  // namespace printing

#endif  // COMPONENTS_PRINTING_COMMON_PRINT_MOJOM_SHARED_H_