// components/services/storage/public/mojom/local_storage_control.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_LOCAL_STORAGE_CONTROL_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_LOCAL_STORAGE_CONTROL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/services/storage/public/mojom/local_storage_control.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/dom_storage/storage_area.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace storage {
namespace mojom {
class LocalStorageUsageInfoDataView;

class LocalStoragePolicyUpdateDataView;



}  // namespace mojom
}  // namespace storage

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::LocalStorageUsageInfoDataView> {
  using Data = ::storage::mojom::internal::LocalStorageUsageInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::LocalStoragePolicyUpdateDataView> {
  using Data = ::storage::mojom::internal::LocalStoragePolicyUpdate_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage {
namespace mojom {
// Interface base classes. They are used for type safety check.
class LocalStorageControlInterfaceBase {};

using LocalStorageControlPtrDataView =
    mojo::InterfacePtrDataView<LocalStorageControlInterfaceBase>;
using LocalStorageControlRequestDataView =
    mojo::InterfaceRequestDataView<LocalStorageControlInterfaceBase>;
using LocalStorageControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<LocalStorageControlInterfaceBase>;
using LocalStorageControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<LocalStorageControlInterfaceBase>;


class LocalStorageUsageInfoDataView {
 public:
  LocalStorageUsageInfoDataView() {}

  LocalStorageUsageInfoDataView(
      internal::LocalStorageUsageInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  uint64_t size_in_bytes() const {
    return data_->size_in_bytes;
  }
  inline void GetLastModifiedTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLastModifiedTime(UserType* output) {
    
    auto* pointer = data_->last_modified_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
 private:
  internal::LocalStorageUsageInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class LocalStoragePolicyUpdateDataView {
 public:
  LocalStoragePolicyUpdateDataView() {}

  LocalStoragePolicyUpdateDataView(
      internal::LocalStoragePolicyUpdate_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  bool purge_on_shutdown() const {
    return data_->purge_on_shutdown;
  }
 private:
  internal::LocalStoragePolicyUpdate_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace storage

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::LocalStorageUsageInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::LocalStorageUsageInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::LocalStorageUsageInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    typename decltype((*output)->origin)::BaseType::BufferWriter
        origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, buffer, &origin_writer, context);
    (*output)->origin.Set(
        origin_writer.is_null() ? nullptr : origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in LocalStorageUsageInfo struct");
    (*output)->size_in_bytes = Traits::size_in_bytes(input);
    decltype(Traits::last_modified_time(input)) in_last_modified_time = Traits::last_modified_time(input);
    typename decltype((*output)->last_modified_time)::BaseType::BufferWriter
        last_modified_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_last_modified_time, buffer, &last_modified_time_writer, context);
    (*output)->last_modified_time.Set(
        last_modified_time_writer.is_null() ? nullptr : last_modified_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->last_modified_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_modified_time in LocalStorageUsageInfo struct");
  }

  static bool Deserialize(::storage::mojom::internal::LocalStorageUsageInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::LocalStorageUsageInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::LocalStoragePolicyUpdateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::LocalStoragePolicyUpdateDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::LocalStoragePolicyUpdate_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    typename decltype((*output)->origin)::BaseType::BufferWriter
        origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, buffer, &origin_writer, context);
    (*output)->origin.Set(
        origin_writer.is_null() ? nullptr : origin_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in LocalStoragePolicyUpdate struct");
    (*output)->purge_on_shutdown = Traits::purge_on_shutdown(input);
  }

  static bool Deserialize(::storage::mojom::internal::LocalStoragePolicyUpdate_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::LocalStoragePolicyUpdateDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage {
namespace mojom {

inline void LocalStorageUsageInfoDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void LocalStorageUsageInfoDataView::GetLastModifiedTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_modified_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}


inline void LocalStoragePolicyUpdateDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace storage

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_LOCAL_STORAGE_CONTROL_MOJOM_SHARED_H_