// This file is generated by TypeBuilder_cpp.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/audits.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace Audits {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Audits";
const char Metainfo::commandPrefix[] = "Audits.";
const char Metainfo::version[] = "1.3";

CRDTP_BEGIN_DESERIALIZER(AffectedCookie)
    CRDTP_DESERIALIZE_FIELD("domain", m_domain),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("path", m_path),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AffectedCookie)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("path", m_path);
    CRDTP_SERIALIZE_FIELD("domain", m_domain);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AffectedRequest)
    CRDTP_DESERIALIZE_FIELD("requestId", m_requestId),
    CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AffectedRequest)
    CRDTP_SERIALIZE_FIELD("requestId", m_requestId);
    CRDTP_SERIALIZE_FIELD("url", m_url);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AffectedFrame)
    CRDTP_DESERIALIZE_FIELD("frameId", m_frameId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AffectedFrame)
    CRDTP_SERIALIZE_FIELD("frameId", m_frameId);
CRDTP_END_SERIALIZER();


namespace SameSiteCookieExclusionReasonEnum {
const char ExcludeSameSiteUnspecifiedTreatedAsLax[] = "ExcludeSameSiteUnspecifiedTreatedAsLax";
const char ExcludeSameSiteNoneInsecure[] = "ExcludeSameSiteNoneInsecure";
const char ExcludeSameSiteLax[] = "ExcludeSameSiteLax";
const char ExcludeSameSiteStrict[] = "ExcludeSameSiteStrict";
} // namespace SameSiteCookieExclusionReasonEnum


namespace SameSiteCookieWarningReasonEnum {
const char WarnSameSiteUnspecifiedCrossSiteContext[] = "WarnSameSiteUnspecifiedCrossSiteContext";
const char WarnSameSiteNoneInsecure[] = "WarnSameSiteNoneInsecure";
const char WarnSameSiteUnspecifiedLaxAllowUnsafe[] = "WarnSameSiteUnspecifiedLaxAllowUnsafe";
const char WarnSameSiteStrictLaxDowngradeStrict[] = "WarnSameSiteStrictLaxDowngradeStrict";
const char WarnSameSiteStrictCrossDowngradeStrict[] = "WarnSameSiteStrictCrossDowngradeStrict";
const char WarnSameSiteStrictCrossDowngradeLax[] = "WarnSameSiteStrictCrossDowngradeLax";
const char WarnSameSiteLaxCrossDowngradeStrict[] = "WarnSameSiteLaxCrossDowngradeStrict";
const char WarnSameSiteLaxCrossDowngradeLax[] = "WarnSameSiteLaxCrossDowngradeLax";
} // namespace SameSiteCookieWarningReasonEnum


namespace SameSiteCookieOperationEnum {
const char SetCookie[] = "SetCookie";
const char ReadCookie[] = "ReadCookie";
} // namespace SameSiteCookieOperationEnum


CRDTP_BEGIN_DESERIALIZER(SameSiteCookieIssueDetails)
    CRDTP_DESERIALIZE_FIELD("cookie", m_cookie),
    CRDTP_DESERIALIZE_FIELD("cookieExclusionReasons", m_cookieExclusionReasons),
    CRDTP_DESERIALIZE_FIELD_OPT("cookieUrl", m_cookieUrl),
    CRDTP_DESERIALIZE_FIELD("cookieWarningReasons", m_cookieWarningReasons),
    CRDTP_DESERIALIZE_FIELD("operation", m_operation),
    CRDTP_DESERIALIZE_FIELD_OPT("request", m_request),
    CRDTP_DESERIALIZE_FIELD_OPT("siteForCookies", m_siteForCookies),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SameSiteCookieIssueDetails)
    CRDTP_SERIALIZE_FIELD("cookie", m_cookie);
    CRDTP_SERIALIZE_FIELD("cookieWarningReasons", m_cookieWarningReasons);
    CRDTP_SERIALIZE_FIELD("cookieExclusionReasons", m_cookieExclusionReasons);
    CRDTP_SERIALIZE_FIELD("operation", m_operation);
    CRDTP_SERIALIZE_FIELD("siteForCookies", m_siteForCookies);
    CRDTP_SERIALIZE_FIELD("cookieUrl", m_cookieUrl);
    CRDTP_SERIALIZE_FIELD("request", m_request);
CRDTP_END_SERIALIZER();


namespace MixedContentResolutionStatusEnum {
const char MixedContentBlocked[] = "MixedContentBlocked";
const char MixedContentAutomaticallyUpgraded[] = "MixedContentAutomaticallyUpgraded";
const char MixedContentWarning[] = "MixedContentWarning";
} // namespace MixedContentResolutionStatusEnum


namespace MixedContentResourceTypeEnum {
const char Audio[] = "Audio";
const char Beacon[] = "Beacon";
const char CSPReport[] = "CSPReport";
const char Download[] = "Download";
const char EventSource[] = "EventSource";
const char Favicon[] = "Favicon";
const char Font[] = "Font";
const char Form[] = "Form";
const char Frame[] = "Frame";
const char Image[] = "Image";
const char Import[] = "Import";
const char Manifest[] = "Manifest";
const char Ping[] = "Ping";
const char PluginData[] = "PluginData";
const char PluginResource[] = "PluginResource";
const char Prefetch[] = "Prefetch";
const char Resource[] = "Resource";
const char Script[] = "Script";
const char ServiceWorker[] = "ServiceWorker";
const char SharedWorker[] = "SharedWorker";
const char Stylesheet[] = "Stylesheet";
const char Track[] = "Track";
const char Video[] = "Video";
const char Worker[] = "Worker";
const char XMLHttpRequest[] = "XMLHttpRequest";
const char XSLT[] = "XSLT";
} // namespace MixedContentResourceTypeEnum


CRDTP_BEGIN_DESERIALIZER(MixedContentIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("frame", m_frame),
    CRDTP_DESERIALIZE_FIELD("insecureURL", m_insecureURL),
    CRDTP_DESERIALIZE_FIELD("mainResourceURL", m_mainResourceURL),
    CRDTP_DESERIALIZE_FIELD_OPT("request", m_request),
    CRDTP_DESERIALIZE_FIELD("resolutionStatus", m_resolutionStatus),
    CRDTP_DESERIALIZE_FIELD_OPT("resourceType", m_resourceType),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(MixedContentIssueDetails)
    CRDTP_SERIALIZE_FIELD("resourceType", m_resourceType);
    CRDTP_SERIALIZE_FIELD("resolutionStatus", m_resolutionStatus);
    CRDTP_SERIALIZE_FIELD("insecureURL", m_insecureURL);
    CRDTP_SERIALIZE_FIELD("mainResourceURL", m_mainResourceURL);
    CRDTP_SERIALIZE_FIELD("request", m_request);
    CRDTP_SERIALIZE_FIELD("frame", m_frame);
CRDTP_END_SERIALIZER();


namespace BlockedByResponseReasonEnum {
const char CoepFrameResourceNeedsCoepHeader[] = "CoepFrameResourceNeedsCoepHeader";
const char CoopSandboxedIFrameCannotNavigateToCoopPage[] = "CoopSandboxedIFrameCannotNavigateToCoopPage";
const char CorpNotSameOrigin[] = "CorpNotSameOrigin";
const char CorpNotSameOriginAfterDefaultedToSameOriginByCoep[] = "CorpNotSameOriginAfterDefaultedToSameOriginByCoep";
const char CorpNotSameSite[] = "CorpNotSameSite";
} // namespace BlockedByResponseReasonEnum


CRDTP_BEGIN_DESERIALIZER(BlockedByResponseIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("blockedFrame", m_blockedFrame),
    CRDTP_DESERIALIZE_FIELD_OPT("parentFrame", m_parentFrame),
    CRDTP_DESERIALIZE_FIELD("reason", m_reason),
    CRDTP_DESERIALIZE_FIELD("request", m_request),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BlockedByResponseIssueDetails)
    CRDTP_SERIALIZE_FIELD("request", m_request);
    CRDTP_SERIALIZE_FIELD("parentFrame", m_parentFrame);
    CRDTP_SERIALIZE_FIELD("blockedFrame", m_blockedFrame);
    CRDTP_SERIALIZE_FIELD("reason", m_reason);
CRDTP_END_SERIALIZER();


namespace HeavyAdResolutionStatusEnum {
const char HeavyAdBlocked[] = "HeavyAdBlocked";
const char HeavyAdWarning[] = "HeavyAdWarning";
} // namespace HeavyAdResolutionStatusEnum


namespace HeavyAdReasonEnum {
const char NetworkTotalLimit[] = "NetworkTotalLimit";
const char CpuTotalLimit[] = "CpuTotalLimit";
const char CpuPeakLimit[] = "CpuPeakLimit";
} // namespace HeavyAdReasonEnum


CRDTP_BEGIN_DESERIALIZER(HeavyAdIssueDetails)
    CRDTP_DESERIALIZE_FIELD("frame", m_frame),
    CRDTP_DESERIALIZE_FIELD("reason", m_reason),
    CRDTP_DESERIALIZE_FIELD("resolution", m_resolution),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(HeavyAdIssueDetails)
    CRDTP_SERIALIZE_FIELD("resolution", m_resolution);
    CRDTP_SERIALIZE_FIELD("reason", m_reason);
    CRDTP_SERIALIZE_FIELD("frame", m_frame);
CRDTP_END_SERIALIZER();


namespace ContentSecurityPolicyViolationTypeEnum {
const char KInlineViolation[] = "kInlineViolation";
const char KEvalViolation[] = "kEvalViolation";
const char KURLViolation[] = "kURLViolation";
const char KTrustedTypesSinkViolation[] = "kTrustedTypesSinkViolation";
const char KTrustedTypesPolicyViolation[] = "kTrustedTypesPolicyViolation";
} // namespace ContentSecurityPolicyViolationTypeEnum


CRDTP_BEGIN_DESERIALIZER(SourceCodeLocation)
    CRDTP_DESERIALIZE_FIELD("columnNumber", m_columnNumber),
    CRDTP_DESERIALIZE_FIELD("lineNumber", m_lineNumber),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SourceCodeLocation)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ContentSecurityPolicyIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("blockedURL", m_blockedURL),
    CRDTP_DESERIALIZE_FIELD("contentSecurityPolicyViolationType", m_contentSecurityPolicyViolationType),
    CRDTP_DESERIALIZE_FIELD_OPT("frameAncestor", m_frameAncestor),
    CRDTP_DESERIALIZE_FIELD_OPT("sourceCodeLocation", m_sourceCodeLocation),
    CRDTP_DESERIALIZE_FIELD("violatedDirective", m_violatedDirective),
    CRDTP_DESERIALIZE_FIELD_OPT("violatingNodeId", m_violatingNodeId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ContentSecurityPolicyIssueDetails)
    CRDTP_SERIALIZE_FIELD("blockedURL", m_blockedURL);
    CRDTP_SERIALIZE_FIELD("violatedDirective", m_violatedDirective);
    CRDTP_SERIALIZE_FIELD("contentSecurityPolicyViolationType", m_contentSecurityPolicyViolationType);
    CRDTP_SERIALIZE_FIELD("frameAncestor", m_frameAncestor);
    CRDTP_SERIALIZE_FIELD("sourceCodeLocation", m_sourceCodeLocation);
    CRDTP_SERIALIZE_FIELD("violatingNodeId", m_violatingNodeId);
CRDTP_END_SERIALIZER();


namespace InspectorIssueCodeEnum {
const char SameSiteCookieIssue[] = "SameSiteCookieIssue";
const char MixedContentIssue[] = "MixedContentIssue";
const char BlockedByResponseIssue[] = "BlockedByResponseIssue";
const char HeavyAdIssue[] = "HeavyAdIssue";
const char ContentSecurityPolicyIssue[] = "ContentSecurityPolicyIssue";
} // namespace InspectorIssueCodeEnum


CRDTP_BEGIN_DESERIALIZER(InspectorIssueDetails)
    CRDTP_DESERIALIZE_FIELD_OPT("blockedByResponseIssueDetails", m_blockedByResponseIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("contentSecurityPolicyIssueDetails", m_contentSecurityPolicyIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("heavyAdIssueDetails", m_heavyAdIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("mixedContentIssueDetails", m_mixedContentIssueDetails),
    CRDTP_DESERIALIZE_FIELD_OPT("sameSiteCookieIssueDetails", m_sameSiteCookieIssueDetails),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InspectorIssueDetails)
    CRDTP_SERIALIZE_FIELD("sameSiteCookieIssueDetails", m_sameSiteCookieIssueDetails);
    CRDTP_SERIALIZE_FIELD("mixedContentIssueDetails", m_mixedContentIssueDetails);
    CRDTP_SERIALIZE_FIELD("blockedByResponseIssueDetails", m_blockedByResponseIssueDetails);
    CRDTP_SERIALIZE_FIELD("heavyAdIssueDetails", m_heavyAdIssueDetails);
    CRDTP_SERIALIZE_FIELD("contentSecurityPolicyIssueDetails", m_contentSecurityPolicyIssueDetails);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(InspectorIssue)
    CRDTP_DESERIALIZE_FIELD("code", m_code),
    CRDTP_DESERIALIZE_FIELD("details", m_details),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(InspectorIssue)
    CRDTP_SERIALIZE_FIELD("code", m_code);
    CRDTP_SERIALIZE_FIELD("details", m_details);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


namespace GetEncodedResponse {
namespace EncodingEnum {
const char* Webp = "webp";
const char* Jpeg = "jpeg";
const char* Png = "png";
} // namespace EncodingEnum
} // namespace GetEncodedResponse

// ------------- Frontend notifications.

void Frontend::IssueAdded(std::unique_ptr<protocol::Audits::InspectorIssue> issue)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("issue"), issue);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Audits.issueAdded", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Audits.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->Enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Audits.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Audits"), SortedRedirects(), std::move(dispatcher));
}

} // Audits
} // namespace content
} // namespace protocol
