// content/common/agent_scheduling_group.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_H_
#define CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/agent_scheduling_group.mojom-shared.h"
#include "content/common/agent_scheduling_group.mojom-forward.h"
#include "content/common/document_scoped_interface_bundle.mojom.h"
#include "content/common/native_types.mojom.h"
#include "ipc/constants.mojom-forward.h"
#include "mojo/public/mojom/base/generic_pending_receiver.mojom-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom.h"
#include "third_party/blink/public/mojom/page/page.mojom.h"
#include "third_party/blink/public/mojom/page/widget.mojom.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class AgentSchedulingGroupHostProxy;

template <typename ImplRefTraits>
class AgentSchedulingGroupHostStub;

class AgentSchedulingGroupHostRequestValidator;


class CONTENT_EXPORT AgentSchedulingGroupHost
    : public AgentSchedulingGroupHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = AgentSchedulingGroupHostInterfaceBase;
  using Proxy_ = AgentSchedulingGroupHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = AgentSchedulingGroupHostStub<ImplRefTraits>;

  using RequestValidator_ = AgentSchedulingGroupHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };
  virtual ~AgentSchedulingGroupHost() {}
};

class AgentSchedulingGroupProxy;

template <typename ImplRefTraits>
class AgentSchedulingGroupStub;

class AgentSchedulingGroupRequestValidator;


class CONTENT_EXPORT AgentSchedulingGroup
    : public AgentSchedulingGroupInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = AgentSchedulingGroupInterfaceBase;
  using Proxy_ = AgentSchedulingGroupProxy;

  template <typename ImplRefTraits>
  using Stub_ = AgentSchedulingGroupStub<ImplRefTraits>;

  using RequestValidator_ = AgentSchedulingGroupRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateViewMinVersion = 0,
    kDestroyViewMinVersion = 0,
    kCreateFrameMinVersion = 0,
    kCreateFrameProxyMinVersion = 0,
  };
  virtual ~AgentSchedulingGroup() {}

  
  virtual void CreateView(CreateViewParamsPtr params) = 0;

  
  virtual void DestroyView(int32_t view_id) = 0;

  
  virtual void CreateFrame(CreateFrameParamsPtr params) = 0;

  
  virtual void CreateFrameProxy(int32_t routing_id, int32_t render_view_routing_id, const base::Optional<::base::UnguessableToken>& opener_frame_token, int32_t parent_routing_id, const ::content::FrameReplicationState& replication_state, const ::base::UnguessableToken& proxy_frame_token, const ::base::UnguessableToken& devtools_frame_token) = 0;
};



class CONTENT_EXPORT AgentSchedulingGroupHostProxy
    : public AgentSchedulingGroupHost {
 public:
  using InterfaceType = AgentSchedulingGroupHost;

  explicit AgentSchedulingGroupHostProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT AgentSchedulingGroupProxy
    : public AgentSchedulingGroup {
 public:
  using InterfaceType = AgentSchedulingGroup;

  explicit AgentSchedulingGroupProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateView(CreateViewParamsPtr params) final;
  
  void DestroyView(int32_t view_id) final;
  
  void CreateFrame(CreateFrameParamsPtr params) final;
  
  void CreateFrameProxy(int32_t routing_id, int32_t render_view_routing_id, const base::Optional<::base::UnguessableToken>& opener_frame_token, int32_t parent_routing_id, const ::content::FrameReplicationState& replication_state, const ::base::UnguessableToken& proxy_frame_token, const ::base::UnguessableToken& devtools_frame_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT AgentSchedulingGroupHostStubDispatch {
 public:
  static bool Accept(AgentSchedulingGroupHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AgentSchedulingGroupHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AgentSchedulingGroupHost>>
class AgentSchedulingGroupHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AgentSchedulingGroupHostStub() {}
  ~AgentSchedulingGroupHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AgentSchedulingGroupHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AgentSchedulingGroupHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT AgentSchedulingGroupStubDispatch {
 public:
  static bool Accept(AgentSchedulingGroup* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AgentSchedulingGroup* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AgentSchedulingGroup>>
class AgentSchedulingGroupStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AgentSchedulingGroupStub() {}
  ~AgentSchedulingGroupStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AgentSchedulingGroupStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AgentSchedulingGroupStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT AgentSchedulingGroupHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT AgentSchedulingGroupRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class CONTENT_EXPORT CreateViewParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateViewParams, T>::value>;
  using DataView = CreateViewParamsDataView;
  using Data_ = internal::CreateViewParams_Data;

  template <typename... Args>
  static CreateViewParamsPtr New(Args&&... args) {
    return CreateViewParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateViewParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateViewParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateViewParams>::Convert(*this);
  }


  CreateViewParams();

  CreateViewParams(
      ::blink::mojom::RendererPreferencesPtr renderer_preferences,
      const ::blink::web_pref::WebPreferences& web_preferences,
      int32_t view_id,
      int32_t main_frame_routing_id,
      int32_t main_frame_widget_routing_id,
      ::content::mojom::DocumentScopedInterfaceBundlePtr main_frame_interface_bundle,
      ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget,
      ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget,
      const std::string& session_storage_namespace_id,
      const base::Optional<::base::UnguessableToken>& opener_frame_token,
      const ::content::FrameReplicationState& replicated_frame_state,
      const ::base::UnguessableToken& main_frame_frame_token,
      const ::base::UnguessableToken& devtools_main_frame_token,
      int32_t proxy_routing_id,
      bool hidden,
      bool never_composited,
      bool window_was_created_with_opener,
      bool has_committed_real_load,
      const ::blink::VisualProperties& visual_properties,
      bool renderer_wide_named_frame_lookup,
      ViewWidgetType type,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast> blink_page_broadcast);

  ~CreateViewParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateViewParamsPtr>
  CreateViewParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateViewParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateViewParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateViewParams_UnserializedMessageContext<
            UserType, CreateViewParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CreateViewParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CreateViewParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateViewParams_UnserializedMessageContext<
            UserType, CreateViewParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateViewParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::mojom::RendererPreferencesPtr renderer_preferences;
  
  ::blink::web_pref::WebPreferences web_preferences;
  
  int32_t view_id;
  
  int32_t main_frame_routing_id;
  
  int32_t main_frame_widget_routing_id;
  
  ::content::mojom::DocumentScopedInterfaceBundlePtr main_frame_interface_bundle;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget;
  
  std::string session_storage_namespace_id;
  
  base::Optional<::base::UnguessableToken> opener_frame_token;
  
  ::content::FrameReplicationState replicated_frame_state;
  
  ::base::UnguessableToken main_frame_frame_token;
  
  ::base::UnguessableToken devtools_main_frame_token;
  
  int32_t proxy_routing_id;
  
  bool hidden;
  
  bool never_composited;
  
  bool window_was_created_with_opener;
  
  bool has_committed_real_load;
  
  ::blink::VisualProperties visual_properties;
  
  bool renderer_wide_named_frame_lookup;
  
  ViewWidgetType type;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::PageBroadcast> blink_page_broadcast;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CreateViewParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateViewParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CreateFrameWidgetParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateFrameWidgetParams, T>::value>;
  using DataView = CreateFrameWidgetParamsDataView;
  using Data_ = internal::CreateFrameWidgetParams_Data;

  template <typename... Args>
  static CreateFrameWidgetParamsPtr New(Args&&... args) {
    return CreateFrameWidgetParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateFrameWidgetParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateFrameWidgetParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateFrameWidgetParams>::Convert(*this);
  }


  CreateFrameWidgetParams();

  CreateFrameWidgetParams(
      int32_t routing_id,
      ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget,
      ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host,
      ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget,
      const ::blink::VisualProperties& visual_properties);

  ~CreateFrameWidgetParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateFrameWidgetParamsPtr>
  CreateFrameWidgetParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateFrameWidgetParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateFrameWidgetParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateFrameWidgetParams_UnserializedMessageContext<
            UserType, CreateFrameWidgetParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CreateFrameWidgetParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CreateFrameWidgetParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateFrameWidgetParams_UnserializedMessageContext<
            UserType, CreateFrameWidgetParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateFrameWidgetParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t routing_id;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::FrameWidgetHost> frame_widget_host;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::FrameWidget> frame_widget;
  
  ::mojo::PendingAssociatedRemote<::blink::mojom::WidgetHost> widget_host;
  
  ::mojo::PendingAssociatedReceiver<::blink::mojom::Widget> widget;
  
  ::blink::VisualProperties visual_properties;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CreateFrameWidgetParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateFrameWidgetParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT CreateFrameParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateFrameParams, T>::value>;
  using DataView = CreateFrameParamsDataView;
  using Data_ = internal::CreateFrameParams_Data;

  template <typename... Args>
  static CreateFrameParamsPtr New(Args&&... args) {
    return CreateFrameParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateFrameParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateFrameParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateFrameParams>::Convert(*this);
  }


  CreateFrameParams();

  CreateFrameParams(
      int32_t routing_id,
      int32_t previous_routing_id,
      const ::base::UnguessableToken& frame_token,
      const base::Optional<::base::UnguessableToken>& opener_frame_token,
      int32_t parent_routing_id,
      int32_t previous_sibling_routing_id,
      ::content::mojom::DocumentScopedInterfaceBundlePtr interface_bundle,
      const ::content::FrameReplicationState& replication_state,
      const ::base::UnguessableToken& devtools_frame_token,
      ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties,
      CreateFrameWidgetParamsPtr widget_params,
      bool has_committed_real_load);

  ~CreateFrameParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateFrameParamsPtr>
  CreateFrameParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateFrameParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateFrameParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateFrameParams_UnserializedMessageContext<
            UserType, CreateFrameParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CreateFrameParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CreateFrameParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateFrameParams_UnserializedMessageContext<
            UserType, CreateFrameParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateFrameParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t routing_id;
  
  int32_t previous_routing_id;
  
  ::base::UnguessableToken frame_token;
  
  base::Optional<::base::UnguessableToken> opener_frame_token;
  
  int32_t parent_routing_id;
  
  int32_t previous_sibling_routing_id;
  
  ::content::mojom::DocumentScopedInterfaceBundlePtr interface_bundle;
  
  ::content::FrameReplicationState replication_state;
  
  ::base::UnguessableToken devtools_frame_token;
  
  ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties;
  
  CreateFrameWidgetParamsPtr widget_params;
  
  bool has_committed_real_load;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CreateFrameParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateFrameParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CreateViewParamsPtr CreateViewParams::Clone() const {
  return New(
      mojo::Clone(renderer_preferences),
      mojo::Clone(web_preferences),
      mojo::Clone(view_id),
      mojo::Clone(main_frame_routing_id),
      mojo::Clone(main_frame_widget_routing_id),
      mojo::Clone(main_frame_interface_bundle),
      mojo::Clone(frame_widget_host),
      mojo::Clone(frame_widget),
      mojo::Clone(widget_host),
      mojo::Clone(widget),
      mojo::Clone(session_storage_namespace_id),
      mojo::Clone(opener_frame_token),
      mojo::Clone(replicated_frame_state),
      mojo::Clone(main_frame_frame_token),
      mojo::Clone(devtools_main_frame_token),
      mojo::Clone(proxy_routing_id),
      mojo::Clone(hidden),
      mojo::Clone(never_composited),
      mojo::Clone(window_was_created_with_opener),
      mojo::Clone(has_committed_real_load),
      mojo::Clone(visual_properties),
      mojo::Clone(renderer_wide_named_frame_lookup),
      mojo::Clone(type),
      mojo::Clone(blink_page_broadcast)
  );
}

template <typename T, CreateViewParams::EnableIfSame<T>*>
bool CreateViewParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->renderer_preferences, other_struct.renderer_preferences))
    return false;
  if (!mojo::Equals(this->web_preferences, other_struct.web_preferences))
    return false;
  if (!mojo::Equals(this->view_id, other_struct.view_id))
    return false;
  if (!mojo::Equals(this->main_frame_routing_id, other_struct.main_frame_routing_id))
    return false;
  if (!mojo::Equals(this->main_frame_widget_routing_id, other_struct.main_frame_widget_routing_id))
    return false;
  if (!mojo::Equals(this->main_frame_interface_bundle, other_struct.main_frame_interface_bundle))
    return false;
  if (!mojo::Equals(this->frame_widget_host, other_struct.frame_widget_host))
    return false;
  if (!mojo::Equals(this->frame_widget, other_struct.frame_widget))
    return false;
  if (!mojo::Equals(this->widget_host, other_struct.widget_host))
    return false;
  if (!mojo::Equals(this->widget, other_struct.widget))
    return false;
  if (!mojo::Equals(this->session_storage_namespace_id, other_struct.session_storage_namespace_id))
    return false;
  if (!mojo::Equals(this->opener_frame_token, other_struct.opener_frame_token))
    return false;
  if (!mojo::Equals(this->replicated_frame_state, other_struct.replicated_frame_state))
    return false;
  if (!mojo::Equals(this->main_frame_frame_token, other_struct.main_frame_frame_token))
    return false;
  if (!mojo::Equals(this->devtools_main_frame_token, other_struct.devtools_main_frame_token))
    return false;
  if (!mojo::Equals(this->proxy_routing_id, other_struct.proxy_routing_id))
    return false;
  if (!mojo::Equals(this->hidden, other_struct.hidden))
    return false;
  if (!mojo::Equals(this->never_composited, other_struct.never_composited))
    return false;
  if (!mojo::Equals(this->window_was_created_with_opener, other_struct.window_was_created_with_opener))
    return false;
  if (!mojo::Equals(this->has_committed_real_load, other_struct.has_committed_real_load))
    return false;
  if (!mojo::Equals(this->visual_properties, other_struct.visual_properties))
    return false;
  if (!mojo::Equals(this->renderer_wide_named_frame_lookup, other_struct.renderer_wide_named_frame_lookup))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->blink_page_broadcast, other_struct.blink_page_broadcast))
    return false;
  return true;
}

template <typename T, CreateViewParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.renderer_preferences, rhs.renderer_preferences))
    return true;
  if (std::less<>{}(rhs.renderer_preferences, lhs.renderer_preferences))
    return false;
  if (std::less<>{}(lhs.web_preferences, rhs.web_preferences))
    return true;
  if (std::less<>{}(rhs.web_preferences, lhs.web_preferences))
    return false;
  if (std::less<>{}(lhs.view_id, rhs.view_id))
    return true;
  if (std::less<>{}(rhs.view_id, lhs.view_id))
    return false;
  if (std::less<>{}(lhs.main_frame_routing_id, rhs.main_frame_routing_id))
    return true;
  if (std::less<>{}(rhs.main_frame_routing_id, lhs.main_frame_routing_id))
    return false;
  if (std::less<>{}(lhs.main_frame_widget_routing_id, rhs.main_frame_widget_routing_id))
    return true;
  if (std::less<>{}(rhs.main_frame_widget_routing_id, lhs.main_frame_widget_routing_id))
    return false;
  if (std::less<>{}(lhs.main_frame_interface_bundle, rhs.main_frame_interface_bundle))
    return true;
  if (std::less<>{}(rhs.main_frame_interface_bundle, lhs.main_frame_interface_bundle))
    return false;
  if (std::less<>{}(lhs.frame_widget_host, rhs.frame_widget_host))
    return true;
  if (std::less<>{}(rhs.frame_widget_host, lhs.frame_widget_host))
    return false;
  if (std::less<>{}(lhs.frame_widget, rhs.frame_widget))
    return true;
  if (std::less<>{}(rhs.frame_widget, lhs.frame_widget))
    return false;
  if (std::less<>{}(lhs.widget_host, rhs.widget_host))
    return true;
  if (std::less<>{}(rhs.widget_host, lhs.widget_host))
    return false;
  if (std::less<>{}(lhs.widget, rhs.widget))
    return true;
  if (std::less<>{}(rhs.widget, lhs.widget))
    return false;
  if (std::less<>{}(lhs.session_storage_namespace_id, rhs.session_storage_namespace_id))
    return true;
  if (std::less<>{}(rhs.session_storage_namespace_id, lhs.session_storage_namespace_id))
    return false;
  if (std::less<>{}(lhs.opener_frame_token, rhs.opener_frame_token))
    return true;
  if (std::less<>{}(rhs.opener_frame_token, lhs.opener_frame_token))
    return false;
  if (std::less<>{}(lhs.replicated_frame_state, rhs.replicated_frame_state))
    return true;
  if (std::less<>{}(rhs.replicated_frame_state, lhs.replicated_frame_state))
    return false;
  if (std::less<>{}(lhs.main_frame_frame_token, rhs.main_frame_frame_token))
    return true;
  if (std::less<>{}(rhs.main_frame_frame_token, lhs.main_frame_frame_token))
    return false;
  if (std::less<>{}(lhs.devtools_main_frame_token, rhs.devtools_main_frame_token))
    return true;
  if (std::less<>{}(rhs.devtools_main_frame_token, lhs.devtools_main_frame_token))
    return false;
  if (std::less<>{}(lhs.proxy_routing_id, rhs.proxy_routing_id))
    return true;
  if (std::less<>{}(rhs.proxy_routing_id, lhs.proxy_routing_id))
    return false;
  if (std::less<>{}(lhs.hidden, rhs.hidden))
    return true;
  if (std::less<>{}(rhs.hidden, lhs.hidden))
    return false;
  if (std::less<>{}(lhs.never_composited, rhs.never_composited))
    return true;
  if (std::less<>{}(rhs.never_composited, lhs.never_composited))
    return false;
  if (std::less<>{}(lhs.window_was_created_with_opener, rhs.window_was_created_with_opener))
    return true;
  if (std::less<>{}(rhs.window_was_created_with_opener, lhs.window_was_created_with_opener))
    return false;
  if (std::less<>{}(lhs.has_committed_real_load, rhs.has_committed_real_load))
    return true;
  if (std::less<>{}(rhs.has_committed_real_load, lhs.has_committed_real_load))
    return false;
  if (std::less<>{}(lhs.visual_properties, rhs.visual_properties))
    return true;
  if (std::less<>{}(rhs.visual_properties, lhs.visual_properties))
    return false;
  if (std::less<>{}(lhs.renderer_wide_named_frame_lookup, rhs.renderer_wide_named_frame_lookup))
    return true;
  if (std::less<>{}(rhs.renderer_wide_named_frame_lookup, lhs.renderer_wide_named_frame_lookup))
    return false;
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.blink_page_broadcast, rhs.blink_page_broadcast))
    return true;
  if (std::less<>{}(rhs.blink_page_broadcast, lhs.blink_page_broadcast))
    return false;
  return false;
}
template <typename StructPtrType>
CreateFrameWidgetParamsPtr CreateFrameWidgetParams::Clone() const {
  return New(
      mojo::Clone(routing_id),
      mojo::Clone(frame_widget_host),
      mojo::Clone(frame_widget),
      mojo::Clone(widget_host),
      mojo::Clone(widget),
      mojo::Clone(visual_properties)
  );
}

template <typename T, CreateFrameWidgetParams::EnableIfSame<T>*>
bool CreateFrameWidgetParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->routing_id, other_struct.routing_id))
    return false;
  if (!mojo::Equals(this->frame_widget_host, other_struct.frame_widget_host))
    return false;
  if (!mojo::Equals(this->frame_widget, other_struct.frame_widget))
    return false;
  if (!mojo::Equals(this->widget_host, other_struct.widget_host))
    return false;
  if (!mojo::Equals(this->widget, other_struct.widget))
    return false;
  if (!mojo::Equals(this->visual_properties, other_struct.visual_properties))
    return false;
  return true;
}

template <typename T, CreateFrameWidgetParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.routing_id, rhs.routing_id))
    return true;
  if (std::less<>{}(rhs.routing_id, lhs.routing_id))
    return false;
  if (std::less<>{}(lhs.frame_widget_host, rhs.frame_widget_host))
    return true;
  if (std::less<>{}(rhs.frame_widget_host, lhs.frame_widget_host))
    return false;
  if (std::less<>{}(lhs.frame_widget, rhs.frame_widget))
    return true;
  if (std::less<>{}(rhs.frame_widget, lhs.frame_widget))
    return false;
  if (std::less<>{}(lhs.widget_host, rhs.widget_host))
    return true;
  if (std::less<>{}(rhs.widget_host, lhs.widget_host))
    return false;
  if (std::less<>{}(lhs.widget, rhs.widget))
    return true;
  if (std::less<>{}(rhs.widget, lhs.widget))
    return false;
  if (std::less<>{}(lhs.visual_properties, rhs.visual_properties))
    return true;
  if (std::less<>{}(rhs.visual_properties, lhs.visual_properties))
    return false;
  return false;
}
template <typename StructPtrType>
CreateFrameParamsPtr CreateFrameParams::Clone() const {
  return New(
      mojo::Clone(routing_id),
      mojo::Clone(previous_routing_id),
      mojo::Clone(frame_token),
      mojo::Clone(opener_frame_token),
      mojo::Clone(parent_routing_id),
      mojo::Clone(previous_sibling_routing_id),
      mojo::Clone(interface_bundle),
      mojo::Clone(replication_state),
      mojo::Clone(devtools_frame_token),
      mojo::Clone(frame_owner_properties),
      mojo::Clone(widget_params),
      mojo::Clone(has_committed_real_load)
  );
}

template <typename T, CreateFrameParams::EnableIfSame<T>*>
bool CreateFrameParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->routing_id, other_struct.routing_id))
    return false;
  if (!mojo::Equals(this->previous_routing_id, other_struct.previous_routing_id))
    return false;
  if (!mojo::Equals(this->frame_token, other_struct.frame_token))
    return false;
  if (!mojo::Equals(this->opener_frame_token, other_struct.opener_frame_token))
    return false;
  if (!mojo::Equals(this->parent_routing_id, other_struct.parent_routing_id))
    return false;
  if (!mojo::Equals(this->previous_sibling_routing_id, other_struct.previous_sibling_routing_id))
    return false;
  if (!mojo::Equals(this->interface_bundle, other_struct.interface_bundle))
    return false;
  if (!mojo::Equals(this->replication_state, other_struct.replication_state))
    return false;
  if (!mojo::Equals(this->devtools_frame_token, other_struct.devtools_frame_token))
    return false;
  if (!mojo::Equals(this->frame_owner_properties, other_struct.frame_owner_properties))
    return false;
  if (!mojo::Equals(this->widget_params, other_struct.widget_params))
    return false;
  if (!mojo::Equals(this->has_committed_real_load, other_struct.has_committed_real_load))
    return false;
  return true;
}

template <typename T, CreateFrameParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.routing_id, rhs.routing_id))
    return true;
  if (std::less<>{}(rhs.routing_id, lhs.routing_id))
    return false;
  if (std::less<>{}(lhs.previous_routing_id, rhs.previous_routing_id))
    return true;
  if (std::less<>{}(rhs.previous_routing_id, lhs.previous_routing_id))
    return false;
  if (std::less<>{}(lhs.frame_token, rhs.frame_token))
    return true;
  if (std::less<>{}(rhs.frame_token, lhs.frame_token))
    return false;
  if (std::less<>{}(lhs.opener_frame_token, rhs.opener_frame_token))
    return true;
  if (std::less<>{}(rhs.opener_frame_token, lhs.opener_frame_token))
    return false;
  if (std::less<>{}(lhs.parent_routing_id, rhs.parent_routing_id))
    return true;
  if (std::less<>{}(rhs.parent_routing_id, lhs.parent_routing_id))
    return false;
  if (std::less<>{}(lhs.previous_sibling_routing_id, rhs.previous_sibling_routing_id))
    return true;
  if (std::less<>{}(rhs.previous_sibling_routing_id, lhs.previous_sibling_routing_id))
    return false;
  if (std::less<>{}(lhs.interface_bundle, rhs.interface_bundle))
    return true;
  if (std::less<>{}(rhs.interface_bundle, lhs.interface_bundle))
    return false;
  if (std::less<>{}(lhs.replication_state, rhs.replication_state))
    return true;
  if (std::less<>{}(rhs.replication_state, lhs.replication_state))
    return false;
  if (std::less<>{}(lhs.devtools_frame_token, rhs.devtools_frame_token))
    return true;
  if (std::less<>{}(rhs.devtools_frame_token, lhs.devtools_frame_token))
    return false;
  if (std::less<>{}(lhs.frame_owner_properties, rhs.frame_owner_properties))
    return true;
  if (std::less<>{}(rhs.frame_owner_properties, lhs.frame_owner_properties))
    return false;
  if (std::less<>{}(lhs.widget_params, rhs.widget_params))
    return true;
  if (std::less<>{}(rhs.widget_params, lhs.widget_params))
    return false;
  if (std::less<>{}(lhs.has_committed_real_load, rhs.has_committed_real_load))
    return true;
  if (std::less<>{}(rhs.has_committed_real_load, lhs.has_committed_real_load))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace content

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateViewParams::DataView,
                                         ::content::mojom::CreateViewParamsPtr> {
  static bool IsNull(const ::content::mojom::CreateViewParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateViewParamsPtr* output) { output->reset(); }

  static const decltype(::content::mojom::CreateViewParams::renderer_preferences)& renderer_preferences(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->renderer_preferences;
  }

  static const decltype(::content::mojom::CreateViewParams::web_preferences)& web_preferences(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->web_preferences;
  }

  static decltype(::content::mojom::CreateViewParams::view_id) view_id(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->view_id;
  }

  static decltype(::content::mojom::CreateViewParams::main_frame_routing_id) main_frame_routing_id(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->main_frame_routing_id;
  }

  static decltype(::content::mojom::CreateViewParams::main_frame_widget_routing_id) main_frame_widget_routing_id(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->main_frame_widget_routing_id;
  }

  static  decltype(::content::mojom::CreateViewParams::main_frame_interface_bundle)& main_frame_interface_bundle(
       ::content::mojom::CreateViewParamsPtr& input) {
    return input->main_frame_interface_bundle;
  }

  static  decltype(::content::mojom::CreateViewParams::frame_widget_host)& frame_widget_host(
       ::content::mojom::CreateViewParamsPtr& input) {
    return input->frame_widget_host;
  }

  static  decltype(::content::mojom::CreateViewParams::frame_widget)& frame_widget(
       ::content::mojom::CreateViewParamsPtr& input) {
    return input->frame_widget;
  }

  static  decltype(::content::mojom::CreateViewParams::widget_host)& widget_host(
       ::content::mojom::CreateViewParamsPtr& input) {
    return input->widget_host;
  }

  static  decltype(::content::mojom::CreateViewParams::widget)& widget(
       ::content::mojom::CreateViewParamsPtr& input) {
    return input->widget;
  }

  static const decltype(::content::mojom::CreateViewParams::session_storage_namespace_id)& session_storage_namespace_id(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->session_storage_namespace_id;
  }

  static const decltype(::content::mojom::CreateViewParams::opener_frame_token)& opener_frame_token(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->opener_frame_token;
  }

  static const decltype(::content::mojom::CreateViewParams::replicated_frame_state)& replicated_frame_state(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->replicated_frame_state;
  }

  static const decltype(::content::mojom::CreateViewParams::main_frame_frame_token)& main_frame_frame_token(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->main_frame_frame_token;
  }

  static const decltype(::content::mojom::CreateViewParams::devtools_main_frame_token)& devtools_main_frame_token(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->devtools_main_frame_token;
  }

  static decltype(::content::mojom::CreateViewParams::proxy_routing_id) proxy_routing_id(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->proxy_routing_id;
  }

  static decltype(::content::mojom::CreateViewParams::hidden) hidden(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->hidden;
  }

  static decltype(::content::mojom::CreateViewParams::never_composited) never_composited(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->never_composited;
  }

  static decltype(::content::mojom::CreateViewParams::window_was_created_with_opener) window_was_created_with_opener(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->window_was_created_with_opener;
  }

  static decltype(::content::mojom::CreateViewParams::has_committed_real_load) has_committed_real_load(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->has_committed_real_load;
  }

  static const decltype(::content::mojom::CreateViewParams::visual_properties)& visual_properties(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->visual_properties;
  }

  static decltype(::content::mojom::CreateViewParams::renderer_wide_named_frame_lookup) renderer_wide_named_frame_lookup(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->renderer_wide_named_frame_lookup;
  }

  static decltype(::content::mojom::CreateViewParams::type) type(
      const ::content::mojom::CreateViewParamsPtr& input) {
    return input->type;
  }

  static  decltype(::content::mojom::CreateViewParams::blink_page_broadcast)& blink_page_broadcast(
       ::content::mojom::CreateViewParamsPtr& input) {
    return input->blink_page_broadcast;
  }

  static bool Read(::content::mojom::CreateViewParams::DataView input, ::content::mojom::CreateViewParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateFrameWidgetParams::DataView,
                                         ::content::mojom::CreateFrameWidgetParamsPtr> {
  static bool IsNull(const ::content::mojom::CreateFrameWidgetParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateFrameWidgetParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::CreateFrameWidgetParams::routing_id) routing_id(
      const ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->routing_id;
  }

  static  decltype(::content::mojom::CreateFrameWidgetParams::frame_widget_host)& frame_widget_host(
       ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->frame_widget_host;
  }

  static  decltype(::content::mojom::CreateFrameWidgetParams::frame_widget)& frame_widget(
       ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->frame_widget;
  }

  static  decltype(::content::mojom::CreateFrameWidgetParams::widget_host)& widget_host(
       ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->widget_host;
  }

  static  decltype(::content::mojom::CreateFrameWidgetParams::widget)& widget(
       ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->widget;
  }

  static const decltype(::content::mojom::CreateFrameWidgetParams::visual_properties)& visual_properties(
      const ::content::mojom::CreateFrameWidgetParamsPtr& input) {
    return input->visual_properties;
  }

  static bool Read(::content::mojom::CreateFrameWidgetParams::DataView input, ::content::mojom::CreateFrameWidgetParamsPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::CreateFrameParams::DataView,
                                         ::content::mojom::CreateFrameParamsPtr> {
  static bool IsNull(const ::content::mojom::CreateFrameParamsPtr& input) { return !input; }
  static void SetToNull(::content::mojom::CreateFrameParamsPtr* output) { output->reset(); }

  static decltype(::content::mojom::CreateFrameParams::routing_id) routing_id(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->routing_id;
  }

  static decltype(::content::mojom::CreateFrameParams::previous_routing_id) previous_routing_id(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->previous_routing_id;
  }

  static const decltype(::content::mojom::CreateFrameParams::frame_token)& frame_token(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->frame_token;
  }

  static const decltype(::content::mojom::CreateFrameParams::opener_frame_token)& opener_frame_token(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->opener_frame_token;
  }

  static decltype(::content::mojom::CreateFrameParams::parent_routing_id) parent_routing_id(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->parent_routing_id;
  }

  static decltype(::content::mojom::CreateFrameParams::previous_sibling_routing_id) previous_sibling_routing_id(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->previous_sibling_routing_id;
  }

  static  decltype(::content::mojom::CreateFrameParams::interface_bundle)& interface_bundle(
       ::content::mojom::CreateFrameParamsPtr& input) {
    return input->interface_bundle;
  }

  static const decltype(::content::mojom::CreateFrameParams::replication_state)& replication_state(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->replication_state;
  }

  static const decltype(::content::mojom::CreateFrameParams::devtools_frame_token)& devtools_frame_token(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->devtools_frame_token;
  }

  static const decltype(::content::mojom::CreateFrameParams::frame_owner_properties)& frame_owner_properties(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->frame_owner_properties;
  }

  static  decltype(::content::mojom::CreateFrameParams::widget_params)& widget_params(
       ::content::mojom::CreateFrameParamsPtr& input) {
    return input->widget_params;
  }

  static decltype(::content::mojom::CreateFrameParams::has_committed_real_load) has_committed_real_load(
      const ::content::mojom::CreateFrameParamsPtr& input) {
    return input->has_committed_real_load;
  }

  static bool Read(::content::mojom::CreateFrameParams::DataView input, ::content::mojom::CreateFrameParamsPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_AGENT_SCHEDULING_GROUP_MOJOM_H_