// content/common/prefetched_signed_exchange_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_H_
#define CONTENT_COMMON_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/prefetched_signed_exchange_info.mojom-shared.h"
#include "content/common/prefetched_signed_exchange_info.mojom-forward.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "content/common/content_param_traits.h"
#include "content/common/navigation_params.h"
#include "content/public/common/impression.h"
#include "content/public/common/navigation_policy.h"
#include "content/public/common/page_state.h"
#include "third_party/blink/public/platform/web_mixed_content_context_type.h"
#include "ui/base/page_transition_types.h"
#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {










class CONTENT_EXPORT PrefetchedSignedExchangeInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrefetchedSignedExchangeInfo, T>::value>;
  using DataView = PrefetchedSignedExchangeInfoDataView;
  using Data_ = internal::PrefetchedSignedExchangeInfo_Data;

  template <typename... Args>
  static PrefetchedSignedExchangeInfoPtr New(Args&&... args) {
    return PrefetchedSignedExchangeInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrefetchedSignedExchangeInfoPtr From(const U& u) {
    return mojo::TypeConverter<PrefetchedSignedExchangeInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrefetchedSignedExchangeInfo>::Convert(*this);
  }


  PrefetchedSignedExchangeInfo();

  PrefetchedSignedExchangeInfo(
      const ::GURL& outer_url,
      const ::net::SHA256HashValue& header_integrity,
      const ::GURL& inner_url,
      ::network::mojom::URLResponseHeadPtr inner_response,
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> loader_factory_handle);

  ~PrefetchedSignedExchangeInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrefetchedSignedExchangeInfoPtr>
  PrefetchedSignedExchangeInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrefetchedSignedExchangeInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrefetchedSignedExchangeInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrefetchedSignedExchangeInfo_UnserializedMessageContext<
            UserType, PrefetchedSignedExchangeInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PrefetchedSignedExchangeInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PrefetchedSignedExchangeInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrefetchedSignedExchangeInfo_UnserializedMessageContext<
            UserType, PrefetchedSignedExchangeInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrefetchedSignedExchangeInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL outer_url;
  
  ::net::SHA256HashValue header_integrity;
  
  ::GURL inner_url;
  
  ::network::mojom::URLResponseHeadPtr inner_response;
  
  ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> loader_factory_handle;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PrefetchedSignedExchangeInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PrefetchedSignedExchangeInfoPtr PrefetchedSignedExchangeInfo::Clone() const {
  return New(
      mojo::Clone(outer_url),
      mojo::Clone(header_integrity),
      mojo::Clone(inner_url),
      mojo::Clone(inner_response),
      mojo::Clone(loader_factory_handle)
  );
}

template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>*>
bool PrefetchedSignedExchangeInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->outer_url, other_struct.outer_url))
    return false;
  if (!mojo::Equals(this->header_integrity, other_struct.header_integrity))
    return false;
  if (!mojo::Equals(this->inner_url, other_struct.inner_url))
    return false;
  if (!mojo::Equals(this->inner_response, other_struct.inner_response))
    return false;
  if (!mojo::Equals(this->loader_factory_handle, other_struct.loader_factory_handle))
    return false;
  return true;
}

template <typename T, PrefetchedSignedExchangeInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.outer_url, rhs.outer_url))
    return true;
  if (std::less<>{}(rhs.outer_url, lhs.outer_url))
    return false;
  if (std::less<>{}(lhs.header_integrity, rhs.header_integrity))
    return true;
  if (std::less<>{}(rhs.header_integrity, lhs.header_integrity))
    return false;
  if (std::less<>{}(lhs.inner_url, rhs.inner_url))
    return true;
  if (std::less<>{}(rhs.inner_url, lhs.inner_url))
    return false;
  if (std::less<>{}(lhs.inner_response, rhs.inner_response))
    return true;
  if (std::less<>{}(rhs.inner_response, lhs.inner_response))
    return false;
  if (std::less<>{}(lhs.loader_factory_handle, rhs.loader_factory_handle))
    return true;
  if (std::less<>{}(rhs.loader_factory_handle, lhs.loader_factory_handle))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace content

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::PrefetchedSignedExchangeInfo::DataView,
                                         ::content::mojom::PrefetchedSignedExchangeInfoPtr> {
  static bool IsNull(const ::content::mojom::PrefetchedSignedExchangeInfoPtr& input) { return !input; }
  static void SetToNull(::content::mojom::PrefetchedSignedExchangeInfoPtr* output) { output->reset(); }

  static const decltype(::content::mojom::PrefetchedSignedExchangeInfo::outer_url)& outer_url(
      const ::content::mojom::PrefetchedSignedExchangeInfoPtr& input) {
    return input->outer_url;
  }

  static const decltype(::content::mojom::PrefetchedSignedExchangeInfo::header_integrity)& header_integrity(
      const ::content::mojom::PrefetchedSignedExchangeInfoPtr& input) {
    return input->header_integrity;
  }

  static const decltype(::content::mojom::PrefetchedSignedExchangeInfo::inner_url)& inner_url(
      const ::content::mojom::PrefetchedSignedExchangeInfoPtr& input) {
    return input->inner_url;
  }

  static const decltype(::content::mojom::PrefetchedSignedExchangeInfo::inner_response)& inner_response(
      const ::content::mojom::PrefetchedSignedExchangeInfoPtr& input) {
    return input->inner_response;
  }

  static  decltype(::content::mojom::PrefetchedSignedExchangeInfo::loader_factory_handle)& loader_factory_handle(
       ::content::mojom::PrefetchedSignedExchangeInfoPtr& input) {
    return input->loader_factory_handle;
  }

  static bool Read(::content::mojom::PrefetchedSignedExchangeInfo::DataView input, ::content::mojom::PrefetchedSignedExchangeInfoPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_PREFETCHED_SIGNED_EXCHANGE_INFO_MOJOM_H_