// content/common/renderer_variations_configuration.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDERER_VARIATIONS_CONFIGURATION_MOJOM_H_
#define CONTENT_COMMON_RENDERER_VARIATIONS_CONFIGURATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/renderer_variations_configuration.mojom-shared.h"
#include "content/common/renderer_variations_configuration.mojom-forward.h"
#include "components/variations/variations.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class RendererVariationsConfigurationProxy;

template <typename ImplRefTraits>
class RendererVariationsConfigurationStub;

class RendererVariationsConfigurationRequestValidator;


class CONTENT_EXPORT RendererVariationsConfiguration
    : public RendererVariationsConfigurationInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RendererVariationsConfigurationInterfaceBase;
  using Proxy_ = RendererVariationsConfigurationProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererVariationsConfigurationStub<ImplRefTraits>;

  using RequestValidator_ = RendererVariationsConfigurationRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetVariationsHeadersMinVersion = 0,
    kSetFieldTrialGroupMinVersion = 0,
  };
  virtual ~RendererVariationsConfiguration() {}

  
  virtual void SetVariationsHeaders(::variations::mojom::VariationsHeadersPtr variations_headers) = 0;

  
  virtual void SetFieldTrialGroup(const std::string& trial_name, const std::string& group_name) = 0;
};



class CONTENT_EXPORT RendererVariationsConfigurationProxy
    : public RendererVariationsConfiguration {
 public:
  using InterfaceType = RendererVariationsConfiguration;

  explicit RendererVariationsConfigurationProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetVariationsHeaders(::variations::mojom::VariationsHeadersPtr variations_headers) final;
  
  void SetFieldTrialGroup(const std::string& trial_name, const std::string& group_name) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT RendererVariationsConfigurationStubDispatch {
 public:
  static bool Accept(RendererVariationsConfiguration* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererVariationsConfiguration* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererVariationsConfiguration>>
class RendererVariationsConfigurationStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererVariationsConfigurationStub() {}
  ~RendererVariationsConfigurationStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererVariationsConfigurationStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererVariationsConfigurationStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RendererVariationsConfigurationRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_RENDERER_VARIATIONS_CONFIGURATION_MOJOM_H_