// media/mojo/mojom/media_types.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SHARED_INTERNAL_H_
#define MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "gpu/ipc/common/mailbox_holder.mojom-shared-internal.h"
#include "gpu/ipc/common/vulkan_ycbcr_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared-internal.h"
#include "ui/gfx/mojom/color_space.mojom-shared-internal.h"
#include "ui/gl/mojom/hdr_metadata.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace media {
namespace mojom {
namespace internal {
using MediaLogRecord_Data = mojo::native::internal::NativeStruct_Data;
class VideoTransformation_Data;
class EncryptionPattern_Data;
class VideoColorSpace_Data;
class AudioDecoderConfig_Data;
class VideoDecoderConfig_Data;
using SubsampleEntry_Data = mojo::native::internal::NativeStruct_Data;
class DecryptConfig_Data;
class DecoderBuffer_Data;
class AudioBuffer_Data;
class AudioDataS16_Data;
class VideoFrameMetadata_Data;
class VideoFrame_Data;
class EosVideoFrameData_Data;
class SharedBufferVideoFrameData_Data;
class DmabufVideoFrameData_Data;
class GpuMemoryBufferVideoFrameData_Data;
class MailboxVideoFrameData_Data;
class PipelineStatistics_Data;
class PredictionFeatures_Data;
class PredictionTargets_Data;
class PipelineDecoderInfo_Data;
class Status_Data;
class VideoFrameData_Data;
using AudioCodec_Data =
    mojo::internal::NativeEnum_Data;
using AudioCodecProfile_Data =
    mojo::internal::NativeEnum_Data;
using BufferingState_Data =
    mojo::internal::NativeEnum_Data;
using BufferingStateChangeReason_Data =
    mojo::internal::NativeEnum_Data;
using ChannelLayout_Data =
    mojo::internal::NativeEnum_Data;
using DecodeStatus_Data =
    mojo::internal::NativeEnum_Data;
using StatusCode_Data =
    mojo::internal::NativeEnum_Data;
using OutputDeviceStatus_Data =
    mojo::internal::NativeEnum_Data;
using PipelineStatus_Data =
    mojo::internal::NativeEnum_Data;
using SampleFormat_Data =
    mojo::internal::NativeEnum_Data;
using VideoCodec_Data =
    mojo::internal::NativeEnum_Data;
using VideoCodecProfile_Data =
    mojo::internal::NativeEnum_Data;
using VideoPixelFormat_Data =
    mojo::internal::NativeEnum_Data;

struct VideoRotation_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct CopyMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};
using WaitingReason_Data =
    mojo::internal::NativeEnum_Data;
using WatchTimeKey_Data =
    mojo::internal::NativeEnum_Data;
using MediaContainerName_Data =
    mojo::internal::NativeEnum_Data;
using MediaStatusState_Data =
    mojo::internal::NativeEnum_Data;
using EncryptionScheme_Data =
    mojo::internal::NativeEnum_Data;
using VideoColorSpace_PrimaryID_Data =
    mojo::internal::NativeEnum_Data;
using VideoColorSpace_TransferID_Data =
    mojo::internal::NativeEnum_Data;
using VideoColorSpace_MatrixID_Data =
    mojo::internal::NativeEnum_Data;
using VideoColorSpace_RangeID_Data =
    mojo::internal::NativeEnum_Data;

#pragma pack(push, 1)


class  VideoFrameData_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  VideoFrameData_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~VideoFrameData_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrameData_Data));
      new (data()) VideoFrameData_Data();
    }

    void AllocateInline(mojo::internal::Buffer* serialization_buffer,
                        void* ptr) {
      const char* start = static_cast<const char*>(
          serialization_buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      serialization_buffer_ = serialization_buffer;
      index_ = slot - start;
      new (data()) VideoFrameData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrameData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrameData_Data>(index_);
    }
    VideoFrameData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<VideoFrameData_Tag>(0);
    data.unknown = 0U;
  }

  enum class VideoFrameData_Tag : uint32_t {

    
    EOS_DATA,
    
    SHARED_BUFFER_DATA,
    
    DMABUF_DATA,
    
    GPU_MEMORY_BUFFER_DATA,
    
    MAILBOX_DATA,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::EosVideoFrameData_Data> f_eos_data;
    mojo::internal::Pointer<internal::SharedBufferVideoFrameData_Data> f_shared_buffer_data;
    mojo::internal::Pointer<internal::DmabufVideoFrameData_Data> f_dmabuf_data;
    mojo::internal::Pointer<internal::GpuMemoryBufferVideoFrameData_Data> f_gpu_memory_buffer_data;
    mojo::internal::Pointer<internal::MailboxVideoFrameData_Data> f_mailbox_data;
    uint64_t unknown;
  };

  uint32_t size;
  VideoFrameData_Tag tag;
  Union_ data;
};
static_assert(sizeof(VideoFrameData_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(VideoFrameData_Data)");
class  VideoTransformation_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoTransformation_Data));
      new (data()) VideoTransformation_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoTransformation_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoTransformation_Data>(index_);
    }
    VideoTransformation_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t rotation;
  uint8_t mirrored : 1;
  uint8_t padfinal_[3];

 private:
  VideoTransformation_Data();
  ~VideoTransformation_Data() = delete;
};
static_assert(sizeof(VideoTransformation_Data) == 16,
              "Bad sizeof(VideoTransformation_Data)");
// Used by VideoTransformation::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoTransformation_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoTransformation_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoTransformation_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VideoTransformation_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoTransformation_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  EncryptionPattern_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(EncryptionPattern_Data));
      new (data()) EncryptionPattern_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    EncryptionPattern_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<EncryptionPattern_Data>(index_);
    }
    EncryptionPattern_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t crypt_byte_block;
  uint32_t skip_byte_block;

 private:
  EncryptionPattern_Data();
  ~EncryptionPattern_Data() = delete;
};
static_assert(sizeof(EncryptionPattern_Data) == 16,
              "Bad sizeof(EncryptionPattern_Data)");
// Used by EncryptionPattern::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct EncryptionPattern_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  EncryptionPattern_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~EncryptionPattern_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    EncryptionPattern_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    EncryptionPattern_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoColorSpace_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoColorSpace_Data));
      new (data()) VideoColorSpace_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoColorSpace_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoColorSpace_Data>(index_);
    }
    VideoColorSpace_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t primaries;
  int32_t transfer;
  int32_t matrix;
  int32_t range;

 private:
  VideoColorSpace_Data();
  ~VideoColorSpace_Data() = delete;
};
static_assert(sizeof(VideoColorSpace_Data) == 24,
              "Bad sizeof(VideoColorSpace_Data)");
// Used by VideoColorSpace::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoColorSpace_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoColorSpace_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoColorSpace_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VideoColorSpace_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoColorSpace_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AudioDecoderConfig_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(AudioDecoderConfig_Data));
      new (data()) AudioDecoderConfig_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    AudioDecoderConfig_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<AudioDecoderConfig_Data>(index_);
    }
    AudioDecoderConfig_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t codec;
  int32_t profile;
  int32_t sample_format;
  int32_t channel_layout;
  int32_t samples_per_second;
  int32_t codec_delay;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> extra_data;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> seek_preroll;
  int32_t encryption_scheme;
  uint8_t padfinal_[4];

 private:
  AudioDecoderConfig_Data();
  ~AudioDecoderConfig_Data() = delete;
};
static_assert(sizeof(AudioDecoderConfig_Data) == 56,
              "Bad sizeof(AudioDecoderConfig_Data)");
// Used by AudioDecoderConfig::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AudioDecoderConfig_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AudioDecoderConfig_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AudioDecoderConfig_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    AudioDecoderConfig_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AudioDecoderConfig_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoDecoderConfig_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoDecoderConfig_Data));
      new (data()) VideoDecoderConfig_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoDecoderConfig_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoDecoderConfig_Data>(index_);
    }
    VideoDecoderConfig_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t codec;
  int32_t profile;
  uint32_t level;
  uint8_t has_alpha : 1;
  uint8_t pad3_[3];
  mojo::internal::Pointer<internal::VideoTransformation_Data> transformation;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> coded_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> visible_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> natural_size;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> extra_data;
  int32_t encryption_scheme;
  uint8_t pad9_[4];
  mojo::internal::Pointer<internal::VideoColorSpace_Data> color_space_info;
  mojo::internal::Pointer<::gl::mojom::internal::HDRMetadata_Data> hdr_metadata;

 private:
  VideoDecoderConfig_Data();
  ~VideoDecoderConfig_Data() = delete;
};
static_assert(sizeof(VideoDecoderConfig_Data) == 88,
              "Bad sizeof(VideoDecoderConfig_Data)");
// Used by VideoDecoderConfig::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoDecoderConfig_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoDecoderConfig_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoDecoderConfig_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VideoDecoderConfig_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoDecoderConfig_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DecryptConfig_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DecryptConfig_Data));
      new (data()) DecryptConfig_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DecryptConfig_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DecryptConfig_Data>(index_);
    }
    DecryptConfig_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t encryption_scheme;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> key_id;
  mojo::internal::Pointer<mojo::internal::String_Data> iv;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::SubsampleEntry_Data>>> subsamples;
  mojo::internal::Pointer<internal::EncryptionPattern_Data> encryption_pattern;

 private:
  DecryptConfig_Data();
  ~DecryptConfig_Data() = delete;
};
static_assert(sizeof(DecryptConfig_Data) == 48,
              "Bad sizeof(DecryptConfig_Data)");
// Used by DecryptConfig::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DecryptConfig_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DecryptConfig_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DecryptConfig_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DecryptConfig_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DecryptConfig_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DecoderBuffer_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DecoderBuffer_Data));
      new (data()) DecoderBuffer_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DecoderBuffer_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DecoderBuffer_Data>(index_);
    }
    DecoderBuffer_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timestamp;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> duration;
  uint8_t is_end_of_stream : 1;
  uint8_t is_key_frame : 1;
  uint8_t pad3_[3];
  uint32_t data_size;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> side_data;
  mojo::internal::Pointer<internal::DecryptConfig_Data> decrypt_config;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> front_discard;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> back_discard;

 private:
  DecoderBuffer_Data();
  ~DecoderBuffer_Data() = delete;
};
static_assert(sizeof(DecoderBuffer_Data) == 64,
              "Bad sizeof(DecoderBuffer_Data)");
// Used by DecoderBuffer::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DecoderBuffer_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DecoderBuffer_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DecoderBuffer_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DecoderBuffer_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DecoderBuffer_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AudioBuffer_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(AudioBuffer_Data));
      new (data()) AudioBuffer_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    AudioBuffer_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<AudioBuffer_Data>(index_);
    }
    AudioBuffer_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t sample_format;
  int32_t channel_layout;
  int32_t channel_count;
  int32_t sample_rate;
  int32_t frame_count;
  uint8_t end_of_stream : 1;
  uint8_t pad5_[3];
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timestamp;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;

 private:
  AudioBuffer_Data();
  ~AudioBuffer_Data() = delete;
};
static_assert(sizeof(AudioBuffer_Data) == 48,
              "Bad sizeof(AudioBuffer_Data)");
// Used by AudioBuffer::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AudioBuffer_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AudioBuffer_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AudioBuffer_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    AudioBuffer_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AudioBuffer_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  AudioDataS16_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(AudioDataS16_Data));
      new (data()) AudioDataS16_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    AudioDataS16_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<AudioDataS16_Data>(index_);
    }
    AudioDataS16_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t channel_count;
  int32_t sample_rate;
  int32_t frame_count;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<int16_t>> data;

 private:
  AudioDataS16_Data();
  ~AudioDataS16_Data() = delete;
};
static_assert(sizeof(AudioDataS16_Data) == 32,
              "Bad sizeof(AudioDataS16_Data)");
// Used by AudioDataS16::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AudioDataS16_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AudioDataS16_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AudioDataS16_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    AudioDataS16_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AudioDataS16_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoFrameMetadata_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrameMetadata_Data));
      new (data()) VideoFrameMetadata_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrameMetadata_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrameMetadata_Data>(index_);
    }
    VideoFrameMetadata_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t allow_overlay : 1;
  uint8_t has_capture_counter : 1;
  uint8_t has_copy_mode : 1;
  uint8_t end_of_stream : 1;
  uint8_t has_frame_rate : 1;
  uint8_t interactive_content : 1;
  uint8_t read_lock_fences_enabled : 1;
  uint8_t has_rotation : 1;
  uint8_t texture_owner : 1;
  uint8_t wants_promotion_hint : 1;
  uint8_t protected_video : 1;
  uint8_t hw_protected : 1;
  uint8_t power_efficient : 1;
  uint8_t has_device_scale_factor : 1;
  uint8_t has_page_scale_factor : 1;
  uint8_t has_root_scroll_offset_x : 1;
  uint8_t has_root_scroll_offset_y : 1;
  uint8_t has_top_controls_visible_height : 1;
  uint8_t has_rtp_timestamp : 1;
  uint8_t pad18_[1];
  int32_t capture_counter;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> capture_begin_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> capture_end_time;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> capture_update_rect;
  int32_t copy_mode;
  int32_t rotation;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> frame_duration;
  double frame_rate;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> reference_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> overlay_plane_id;
  double device_scale_factor;
  double page_scale_factor;
  double root_scroll_offset_x;
  double root_scroll_offset_y;
  double top_controls_visible_height;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> decode_begin_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> decode_end_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> processing_time;
  double rtp_timestamp;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> receive_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> wallclock_frame_duration;

 private:
  VideoFrameMetadata_Data();
  ~VideoFrameMetadata_Data() = delete;
};
static_assert(sizeof(VideoFrameMetadata_Data) == 168,
              "Bad sizeof(VideoFrameMetadata_Data)");
// Used by VideoFrameMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoFrameMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoFrameMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoFrameMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VideoFrameMetadata_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoFrameMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoFrame_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoFrame_Data));
      new (data()) VideoFrame_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoFrame_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoFrame_Data>(index_);
    }
    VideoFrame_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t format;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> coded_size;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> visible_rect;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> natural_size;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timestamp;
  internal::VideoFrameData_Data data;
  mojo::internal::Pointer<internal::VideoFrameMetadata_Data> metadata;
  mojo::internal::Pointer<::gfx::mojom::internal::ColorSpace_Data> color_space;
  mojo::internal::Pointer<::gl::mojom::internal::HDRMetadata_Data> hdr_metadata;

 private:
  VideoFrame_Data();
  ~VideoFrame_Data() = delete;
};
static_assert(sizeof(VideoFrame_Data) == 88,
              "Bad sizeof(VideoFrame_Data)");
// Used by VideoFrame::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoFrame_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoFrame_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoFrame_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VideoFrame_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoFrame_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  EosVideoFrameData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(EosVideoFrameData_Data));
      new (data()) EosVideoFrameData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    EosVideoFrameData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<EosVideoFrameData_Data>(index_);
    }
    EosVideoFrameData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  EosVideoFrameData_Data();
  ~EosVideoFrameData_Data() = delete;
};
static_assert(sizeof(EosVideoFrameData_Data) == 8,
              "Bad sizeof(EosVideoFrameData_Data)");
// Used by EosVideoFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct EosVideoFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  EosVideoFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~EosVideoFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    EosVideoFrameData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    EosVideoFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SharedBufferVideoFrameData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SharedBufferVideoFrameData_Data));
      new (data()) SharedBufferVideoFrameData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SharedBufferVideoFrameData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SharedBufferVideoFrameData_Data>(index_);
    }
    SharedBufferVideoFrameData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data frame_data;
  uint8_t pad0_[4];
  uint64_t frame_data_size;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> strides;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> offsets;

 private:
  SharedBufferVideoFrameData_Data();
  ~SharedBufferVideoFrameData_Data() = delete;
};
static_assert(sizeof(SharedBufferVideoFrameData_Data) == 40,
              "Bad sizeof(SharedBufferVideoFrameData_Data)");
// Used by SharedBufferVideoFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SharedBufferVideoFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SharedBufferVideoFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SharedBufferVideoFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    SharedBufferVideoFrameData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SharedBufferVideoFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  DmabufVideoFrameData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DmabufVideoFrameData_Data));
      new (data()) DmabufVideoFrameData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DmabufVideoFrameData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DmabufVideoFrameData_Data>(index_);
    }
    DmabufVideoFrameData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Handle_Data>> dmabuf_fds;

 private:
  DmabufVideoFrameData_Data();
  ~DmabufVideoFrameData_Data() = delete;
};
static_assert(sizeof(DmabufVideoFrameData_Data) == 16,
              "Bad sizeof(DmabufVideoFrameData_Data)");
// Used by DmabufVideoFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DmabufVideoFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DmabufVideoFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DmabufVideoFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DmabufVideoFrameData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DmabufVideoFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  GpuMemoryBufferVideoFrameData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuMemoryBufferVideoFrameData_Data));
      new (data()) GpuMemoryBufferVideoFrameData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuMemoryBufferVideoFrameData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuMemoryBufferVideoFrameData_Data>(index_);
    }
    GpuMemoryBufferVideoFrameData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::GpuMemoryBufferHandle_Data> gpu_memory_buffer_handle;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::gpu::mojom::internal::MailboxHolder_Data>>> mailbox_holder;

 private:
  GpuMemoryBufferVideoFrameData_Data();
  ~GpuMemoryBufferVideoFrameData_Data() = delete;
};
static_assert(sizeof(GpuMemoryBufferVideoFrameData_Data) == 24,
              "Bad sizeof(GpuMemoryBufferVideoFrameData_Data)");
// Used by GpuMemoryBufferVideoFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GpuMemoryBufferVideoFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GpuMemoryBufferVideoFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GpuMemoryBufferVideoFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    GpuMemoryBufferVideoFrameData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GpuMemoryBufferVideoFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  MailboxVideoFrameData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MailboxVideoFrameData_Data));
      new (data()) MailboxVideoFrameData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MailboxVideoFrameData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MailboxVideoFrameData_Data>(index_);
    }
    MailboxVideoFrameData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::gpu::mojom::internal::MailboxHolder_Data>>> mailbox_holder;
  mojo::internal::Pointer<::gpu::mojom::internal::VulkanYCbCrInfo_Data> ycbcr_data;

 private:
  MailboxVideoFrameData_Data();
  ~MailboxVideoFrameData_Data() = delete;
};
static_assert(sizeof(MailboxVideoFrameData_Data) == 24,
              "Bad sizeof(MailboxVideoFrameData_Data)");
// Used by MailboxVideoFrameData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct MailboxVideoFrameData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  MailboxVideoFrameData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~MailboxVideoFrameData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    MailboxVideoFrameData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    MailboxVideoFrameData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PipelineStatistics_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PipelineStatistics_Data));
      new (data()) PipelineStatistics_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PipelineStatistics_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PipelineStatistics_Data>(index_);
    }
    PipelineStatistics_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t audio_bytes_decoded;
  uint64_t video_bytes_decoded;
  uint32_t video_frames_decoded;
  uint32_t video_frames_dropped;
  int64_t audio_memory_usage;
  int64_t video_memory_usage;

 private:
  PipelineStatistics_Data();
  ~PipelineStatistics_Data() = delete;
};
static_assert(sizeof(PipelineStatistics_Data) == 48,
              "Bad sizeof(PipelineStatistics_Data)");
// Used by PipelineStatistics::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PipelineStatistics_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PipelineStatistics_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PipelineStatistics_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PipelineStatistics_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PipelineStatistics_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PredictionFeatures_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PredictionFeatures_Data));
      new (data()) PredictionFeatures_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PredictionFeatures_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PredictionFeatures_Data>(index_);
    }
    PredictionFeatures_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t profile;
  uint8_t use_hw_secure_codecs : 1;
  uint8_t pad1_[3];
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> video_size;
  double frames_per_sec;
  mojo::internal::Pointer<mojo::internal::String_Data> key_system;

 private:
  PredictionFeatures_Data();
  ~PredictionFeatures_Data() = delete;
};
static_assert(sizeof(PredictionFeatures_Data) == 40,
              "Bad sizeof(PredictionFeatures_Data)");
// Used by PredictionFeatures::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PredictionFeatures_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PredictionFeatures_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PredictionFeatures_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PredictionFeatures_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PredictionFeatures_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PredictionTargets_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PredictionTargets_Data));
      new (data()) PredictionTargets_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PredictionTargets_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PredictionTargets_Data>(index_);
    }
    PredictionTargets_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t frames_decoded;
  uint32_t frames_dropped;
  uint32_t frames_power_efficient;
  uint8_t padfinal_[4];

 private:
  PredictionTargets_Data();
  ~PredictionTargets_Data() = delete;
};
static_assert(sizeof(PredictionTargets_Data) == 24,
              "Bad sizeof(PredictionTargets_Data)");
// Used by PredictionTargets::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PredictionTargets_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PredictionTargets_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PredictionTargets_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PredictionTargets_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PredictionTargets_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  PipelineDecoderInfo_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PipelineDecoderInfo_Data));
      new (data()) PipelineDecoderInfo_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PipelineDecoderInfo_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PipelineDecoderInfo_Data>(index_);
    }
    PipelineDecoderInfo_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> decoder_name;
  uint8_t is_platform_decoder : 1;
  uint8_t has_decrypting_demuxer_stream : 1;
  uint8_t padfinal_[7];

 private:
  PipelineDecoderInfo_Data();
  ~PipelineDecoderInfo_Data() = delete;
};
static_assert(sizeof(PipelineDecoderInfo_Data) == 24,
              "Bad sizeof(PipelineDecoderInfo_Data)");
// Used by PipelineDecoderInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PipelineDecoderInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PipelineDecoderInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PipelineDecoderInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    PipelineDecoderInfo_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PipelineDecoderInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Status_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Status_Data));
      new (data()) Status_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Status_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Status_Data>(index_);
    }
    Status_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t code;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> message;
  mojo::internal::Pointer<mojo::internal::Array_Data<::mojo_base::mojom::internal::Value_Data>> frames;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::Status_Data>>> causes;
  ::mojo_base::mojom::internal::Value_Data data;

 private:
  Status_Data();
  ~Status_Data() = delete;
};
static_assert(sizeof(Status_Data) == 56,
              "Bad sizeof(Status_Data)");
// Used by Status::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Status_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Status_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Status_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    Status_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Status_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace media

#endif  // MEDIA_MOJO_MOJOM_MEDIA_TYPES_MOJOM_SHARED_INTERNAL_H_