// services/network/public/mojom/network_isolation_key.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/network_isolation_key.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"







namespace network {
namespace mojom {
class NetworkIsolationKeyDataView;



}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::NetworkIsolationKeyDataView> {
  using Data = ::network::mojom::internal::NetworkIsolationKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {


class NetworkIsolationKeyDataView {
 public:
  NetworkIsolationKeyDataView() {}

  NetworkIsolationKeyDataView(
      internal::NetworkIsolationKey_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTopFrameOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `top_frame_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTopFrameOrigin` instead "
    "of `ReadTopFrameOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  inline void GetFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `frame_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameOrigin` instead "
    "of `ReadFrameOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, context_);
  }
  bool opaque_and_non_transient() const {
    return data_->opaque_and_non_transient;
  }
 private:
  internal::NetworkIsolationKey_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetworkIsolationKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkIsolationKeyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::NetworkIsolationKey_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::top_frame_origin(input)) in_top_frame_origin = Traits::top_frame_origin(input);
    typename decltype((*output)->top_frame_origin)::BaseType::BufferWriter
        top_frame_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_top_frame_origin, buffer, &top_frame_origin_writer, context);
    (*output)->top_frame_origin.Set(
        top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
    decltype(Traits::frame_origin(input)) in_frame_origin = Traits::frame_origin(input);
    typename decltype((*output)->frame_origin)::BaseType::BufferWriter
        frame_origin_writer;
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_frame_origin, buffer, &frame_origin_writer, context);
    (*output)->frame_origin.Set(
        frame_origin_writer.is_null() ? nullptr : frame_origin_writer.data());
    (*output)->opaque_and_non_transient = Traits::opaque_and_non_transient(input);
  }

  static bool Deserialize(::network::mojom::internal::NetworkIsolationKey_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NetworkIsolationKeyDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void NetworkIsolationKeyDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}
inline void NetworkIsolationKeyDataView::GetFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_SHARED_H_