// services/network/public/mojom/parsed_headers.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/parsed_headers.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "services/network/public/mojom/parsed_headers.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool ParsedHeaders_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ParsedHeaders_Data* object = static_cast<const ParsedHeaders_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 72 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_security_policy, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams content_security_policy_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->content_security_policy, validation_context,
                                         &content_security_policy_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->allow_csp_from, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cross_origin_embedder_policy, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cross_origin_embedder_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cross_origin_opener_policy, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cross_origin_opener_policy, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams accept_ch_validate_params(
      0, ::network::mojom::internal::WebClientHintsType_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->accept_ch, validation_context,
                                         &accept_ch_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accept_ch_lifetime, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->accept_ch_lifetime, validation_context))
    return false;

  return true;
}

ParsedHeaders_Data::ParsedHeaders_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network