// third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-shared.h"
#include "third_party/blink/public/mojom/bluetooth/web_bluetooth.mojom-blink-forward.h"
#include "device/bluetooth/public/mojom/uuid.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/mojo/bluetooth_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"




namespace WTF {
struct blink_mojom_internal_WebBluetoothResult_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::WebBluetoothResult& value) {
    using utype = std::underlying_type<::blink::mojom::WebBluetoothResult>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::WebBluetoothResult& left, const ::blink::mojom::WebBluetoothResult& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::WebBluetoothResult>
    : public GenericHashTraits<::blink::mojom::WebBluetoothResult> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::WebBluetoothResult& value) {
    return value == static_cast<::blink::mojom::WebBluetoothResult>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::WebBluetoothResult& slot, bool) {
    slot = static_cast<::blink::mojom::WebBluetoothResult>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::WebBluetoothResult& value) {
    return value == static_cast<::blink::mojom::WebBluetoothResult>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_WebBluetoothGATTQueryQuantity_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::WebBluetoothGATTQueryQuantity& value) {
    using utype = std::underlying_type<::blink::mojom::WebBluetoothGATTQueryQuantity>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::WebBluetoothGATTQueryQuantity& left, const ::blink::mojom::WebBluetoothGATTQueryQuantity& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::WebBluetoothGATTQueryQuantity>
    : public GenericHashTraits<::blink::mojom::WebBluetoothGATTQueryQuantity> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::WebBluetoothGATTQueryQuantity& value) {
    return value == static_cast<::blink::mojom::WebBluetoothGATTQueryQuantity>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::WebBluetoothGATTQueryQuantity& slot, bool) {
    slot = static_cast<::blink::mojom::WebBluetoothGATTQueryQuantity>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::WebBluetoothGATTQueryQuantity& value) {
    return value == static_cast<::blink::mojom::WebBluetoothGATTQueryQuantity>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_WebBluetoothWriteType_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::WebBluetoothWriteType& value) {
    using utype = std::underlying_type<::blink::mojom::WebBluetoothWriteType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::WebBluetoothWriteType& left, const ::blink::mojom::WebBluetoothWriteType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::WebBluetoothWriteType>
    : public GenericHashTraits<::blink::mojom::WebBluetoothWriteType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::WebBluetoothWriteType& value) {
    return value == static_cast<::blink::mojom::WebBluetoothWriteType>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::WebBluetoothWriteType& slot, bool) {
    slot = static_cast<::blink::mojom::WebBluetoothWriteType>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::WebBluetoothWriteType& value) {
    return value == static_cast<::blink::mojom::WebBluetoothWriteType>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class WebBluetoothServiceProxy;

template <typename ImplRefTraits>
class WebBluetoothServiceStub;

class WebBluetoothServiceRequestValidator;
class WebBluetoothServiceResponseValidator;


class BLINK_PLATFORM_EXPORT WebBluetoothService
    : public WebBluetoothServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WebBluetoothServiceInterfaceBase;
  using Proxy_ = WebBluetoothServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBluetoothServiceStub<ImplRefTraits>;

  using RequestValidator_ = WebBluetoothServiceRequestValidator;
  using ResponseValidator_ = WebBluetoothServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAvailabilityMinVersion = 0,
    kRequestDeviceMinVersion = 0,
    kGetDevicesMinVersion = 0,
    kRemoteServerConnectMinVersion = 0,
    kRemoteServerDisconnectMinVersion = 0,
    kRemoteServerGetPrimaryServicesMinVersion = 0,
    kRemoteServiceGetCharacteristicsMinVersion = 0,
    kRemoteCharacteristicReadValueMinVersion = 0,
    kRemoteCharacteristicWriteValueMinVersion = 0,
    kRemoteCharacteristicStartNotificationsMinVersion = 0,
    kRemoteCharacteristicStopNotificationsMinVersion = 0,
    kRemoteCharacteristicGetDescriptorsMinVersion = 0,
    kRemoteDescriptorReadValueMinVersion = 0,
    kRemoteDescriptorWriteValueMinVersion = 0,
    kRequestScanningStartMinVersion = 0,
    kWatchAdvertisementsForDeviceMinVersion = 0,
  };
  virtual ~WebBluetoothService() {}


  using GetAvailabilityCallback = base::OnceCallback<void(bool)>;
  
  virtual void GetAvailability(GetAvailabilityCallback callback) = 0;


  using RequestDeviceCallback = base::OnceCallback<void(WebBluetoothResult, WebBluetoothDevicePtr)>;
  
  virtual void RequestDevice(WebBluetoothRequestDeviceOptionsPtr options, RequestDeviceCallback callback) = 0;


  using GetDevicesCallback = base::OnceCallback<void(WTF::Vector<WebBluetoothDevicePtr>)>;
  
  virtual void GetDevices(GetDevicesCallback callback) = 0;


  using RemoteServerConnectCallback = base::OnceCallback<void(WebBluetoothResult)>;
  
  virtual void RemoteServerConnect(const ::WTF::String& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> client, RemoteServerConnectCallback callback) = 0;

  
  virtual void RemoteServerDisconnect(const ::WTF::String& device_id) = 0;


  using RemoteServerGetPrimaryServicesCallback = base::OnceCallback<void(WebBluetoothResult, base::Optional<WTF::Vector<WebBluetoothRemoteGATTServicePtr>>)>;
  
  virtual void RemoteServerGetPrimaryServices(const ::WTF::String& device_id, WebBluetoothGATTQueryQuantity quantity, const ::WTF::String& services_uuid, RemoteServerGetPrimaryServicesCallback callback) = 0;


  using RemoteServiceGetCharacteristicsCallback = base::OnceCallback<void(WebBluetoothResult, base::Optional<WTF::Vector<WebBluetoothRemoteGATTCharacteristicPtr>>)>;
  
  virtual void RemoteServiceGetCharacteristics(const WTF::String& service_instance_id, WebBluetoothGATTQueryQuantity quantity, const ::WTF::String& characteristics_uuid, RemoteServiceGetCharacteristicsCallback callback) = 0;


  using RemoteCharacteristicReadValueCallback = base::OnceCallback<void(WebBluetoothResult, const base::Optional<WTF::Vector<uint8_t>>&)>;
  
  virtual void RemoteCharacteristicReadValue(const WTF::String& characteristic_instance_id, RemoteCharacteristicReadValueCallback callback) = 0;


  using RemoteCharacteristicWriteValueCallback = base::OnceCallback<void(WebBluetoothResult)>;
  
  virtual void RemoteCharacteristicWriteValue(const WTF::String& characteristic_instance_id, const WTF::Vector<uint8_t>& value, WebBluetoothWriteType write_type, RemoteCharacteristicWriteValueCallback callback) = 0;


  using RemoteCharacteristicStartNotificationsCallback = base::OnceCallback<void(WebBluetoothResult)>;
  
  virtual void RemoteCharacteristicStartNotifications(const WTF::String& characteristic_instance_id, ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> client, RemoteCharacteristicStartNotificationsCallback callback) = 0;


  using RemoteCharacteristicStopNotificationsCallback = base::OnceCallback<void()>;
  
  virtual void RemoteCharacteristicStopNotifications(const WTF::String& characteristic_instance_id, RemoteCharacteristicStopNotificationsCallback callback) = 0;


  using RemoteCharacteristicGetDescriptorsCallback = base::OnceCallback<void(WebBluetoothResult, base::Optional<WTF::Vector<WebBluetoothRemoteGATTDescriptorPtr>>)>;
  
  virtual void RemoteCharacteristicGetDescriptors(const WTF::String& characteristics_instance_id, WebBluetoothGATTQueryQuantity quantity, const ::WTF::String& descriptor_uuid, RemoteCharacteristicGetDescriptorsCallback callback) = 0;


  using RemoteDescriptorReadValueCallback = base::OnceCallback<void(WebBluetoothResult, const base::Optional<WTF::Vector<uint8_t>>&)>;
  
  virtual void RemoteDescriptorReadValue(const WTF::String& descriptor_instance_id, RemoteDescriptorReadValueCallback callback) = 0;


  using RemoteDescriptorWriteValueCallback = base::OnceCallback<void(WebBluetoothResult)>;
  
  virtual void RemoteDescriptorWriteValue(const WTF::String& descriptor_instance_id, const WTF::Vector<uint8_t>& value, RemoteDescriptorWriteValueCallback callback) = 0;


  using RequestScanningStartCallback = base::OnceCallback<void(WebBluetoothResult)>;
  
  virtual void RequestScanningStart(::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothRequestLEScanOptionsPtr options, RequestScanningStartCallback callback) = 0;


  using WatchAdvertisementsForDeviceCallback = base::OnceCallback<void(WebBluetoothResult)>;
  
  virtual void WatchAdvertisementsForDevice(const ::WTF::String& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WatchAdvertisementsForDeviceCallback callback) = 0;
};

class WebBluetoothServerClientProxy;

template <typename ImplRefTraits>
class WebBluetoothServerClientStub;

class WebBluetoothServerClientRequestValidator;


class BLINK_PLATFORM_EXPORT WebBluetoothServerClient
    : public WebBluetoothServerClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WebBluetoothServerClientInterfaceBase;
  using Proxy_ = WebBluetoothServerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBluetoothServerClientStub<ImplRefTraits>;

  using RequestValidator_ = WebBluetoothServerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGATTServerDisconnectedMinVersion = 0,
  };
  virtual ~WebBluetoothServerClient() {}

  
  virtual void GATTServerDisconnected() = 0;
};

class WebBluetoothCharacteristicClientProxy;

template <typename ImplRefTraits>
class WebBluetoothCharacteristicClientStub;

class WebBluetoothCharacteristicClientRequestValidator;


class BLINK_PLATFORM_EXPORT WebBluetoothCharacteristicClient
    : public WebBluetoothCharacteristicClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WebBluetoothCharacteristicClientInterfaceBase;
  using Proxy_ = WebBluetoothCharacteristicClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBluetoothCharacteristicClientStub<ImplRefTraits>;

  using RequestValidator_ = WebBluetoothCharacteristicClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRemoteCharacteristicValueChangedMinVersion = 0,
  };
  virtual ~WebBluetoothCharacteristicClient() {}

  
  virtual void RemoteCharacteristicValueChanged(const WTF::Vector<uint8_t>& value) = 0;
};

class WebBluetoothAdvertisementClientProxy;

template <typename ImplRefTraits>
class WebBluetoothAdvertisementClientStub;

class WebBluetoothAdvertisementClientRequestValidator;


class BLINK_PLATFORM_EXPORT WebBluetoothAdvertisementClient
    : public WebBluetoothAdvertisementClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = WebBluetoothAdvertisementClientInterfaceBase;
  using Proxy_ = WebBluetoothAdvertisementClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebBluetoothAdvertisementClientStub<ImplRefTraits>;

  using RequestValidator_ = WebBluetoothAdvertisementClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAdvertisingEventMinVersion = 0,
  };
  virtual ~WebBluetoothAdvertisementClient() {}

  
  virtual void AdvertisingEvent(WebBluetoothAdvertisingEventPtr result) = 0;
};



class BLINK_PLATFORM_EXPORT WebBluetoothServiceProxy
    : public WebBluetoothService {
 public:
  using InterfaceType = WebBluetoothService;

  explicit WebBluetoothServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAvailability(GetAvailabilityCallback callback) final;
  
  void RequestDevice(WebBluetoothRequestDeviceOptionsPtr options, RequestDeviceCallback callback) final;
  
  void GetDevices(GetDevicesCallback callback) final;
  
  void RemoteServerConnect(const ::WTF::String& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothServerClient> client, RemoteServerConnectCallback callback) final;
  
  void RemoteServerDisconnect(const ::WTF::String& device_id) final;
  
  void RemoteServerGetPrimaryServices(const ::WTF::String& device_id, WebBluetoothGATTQueryQuantity quantity, const ::WTF::String& services_uuid, RemoteServerGetPrimaryServicesCallback callback) final;
  
  void RemoteServiceGetCharacteristics(const WTF::String& service_instance_id, WebBluetoothGATTQueryQuantity quantity, const ::WTF::String& characteristics_uuid, RemoteServiceGetCharacteristicsCallback callback) final;
  
  void RemoteCharacteristicReadValue(const WTF::String& characteristic_instance_id, RemoteCharacteristicReadValueCallback callback) final;
  
  void RemoteCharacteristicWriteValue(const WTF::String& characteristic_instance_id, const WTF::Vector<uint8_t>& value, WebBluetoothWriteType write_type, RemoteCharacteristicWriteValueCallback callback) final;
  
  void RemoteCharacteristicStartNotifications(const WTF::String& characteristic_instance_id, ::mojo::PendingAssociatedRemote<WebBluetoothCharacteristicClient> client, RemoteCharacteristicStartNotificationsCallback callback) final;
  
  void RemoteCharacteristicStopNotifications(const WTF::String& characteristic_instance_id, RemoteCharacteristicStopNotificationsCallback callback) final;
  
  void RemoteCharacteristicGetDescriptors(const WTF::String& characteristics_instance_id, WebBluetoothGATTQueryQuantity quantity, const ::WTF::String& descriptor_uuid, RemoteCharacteristicGetDescriptorsCallback callback) final;
  
  void RemoteDescriptorReadValue(const WTF::String& descriptor_instance_id, RemoteDescriptorReadValueCallback callback) final;
  
  void RemoteDescriptorWriteValue(const WTF::String& descriptor_instance_id, const WTF::Vector<uint8_t>& value, RemoteDescriptorWriteValueCallback callback) final;
  
  void RequestScanningStart(::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WebBluetoothRequestLEScanOptionsPtr options, RequestScanningStartCallback callback) final;
  
  void WatchAdvertisementsForDevice(const ::WTF::String& device_id, ::mojo::PendingAssociatedRemote<WebBluetoothAdvertisementClient> client, WatchAdvertisementsForDeviceCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT WebBluetoothServerClientProxy
    : public WebBluetoothServerClient {
 public:
  using InterfaceType = WebBluetoothServerClient;

  explicit WebBluetoothServerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GATTServerDisconnected() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT WebBluetoothCharacteristicClientProxy
    : public WebBluetoothCharacteristicClient {
 public:
  using InterfaceType = WebBluetoothCharacteristicClient;

  explicit WebBluetoothCharacteristicClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RemoteCharacteristicValueChanged(const WTF::Vector<uint8_t>& value) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT WebBluetoothAdvertisementClientProxy
    : public WebBluetoothAdvertisementClient {
 public:
  using InterfaceType = WebBluetoothAdvertisementClient;

  explicit WebBluetoothAdvertisementClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AdvertisingEvent(WebBluetoothAdvertisingEventPtr result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT WebBluetoothServiceStubDispatch {
 public:
  static bool Accept(WebBluetoothService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBluetoothService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBluetoothService>>
class WebBluetoothServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBluetoothServiceStub() {}
  ~WebBluetoothServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT WebBluetoothServerClientStubDispatch {
 public:
  static bool Accept(WebBluetoothServerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBluetoothServerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBluetoothServerClient>>
class WebBluetoothServerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBluetoothServerClientStub() {}
  ~WebBluetoothServerClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothServerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothServerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT WebBluetoothCharacteristicClientStubDispatch {
 public:
  static bool Accept(WebBluetoothCharacteristicClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBluetoothCharacteristicClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBluetoothCharacteristicClient>>
class WebBluetoothCharacteristicClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBluetoothCharacteristicClientStub() {}
  ~WebBluetoothCharacteristicClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothCharacteristicClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothCharacteristicClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT WebBluetoothAdvertisementClientStubDispatch {
 public:
  static bool Accept(WebBluetoothAdvertisementClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebBluetoothAdvertisementClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebBluetoothAdvertisementClient>>
class WebBluetoothAdvertisementClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebBluetoothAdvertisementClientStub() {}
  ~WebBluetoothAdvertisementClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothAdvertisementClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebBluetoothAdvertisementClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT WebBluetoothServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT WebBluetoothServerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT WebBluetoothCharacteristicClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT WebBluetoothAdvertisementClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT WebBluetoothServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT WebBluetoothDeviceId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothDeviceId, T>::value>;
  using DataView = WebBluetoothDeviceIdDataView;
  using Data_ = internal::WebBluetoothDeviceId_Data;

  template <typename... Args>
  static WebBluetoothDeviceIdPtr New(Args&&... args) {
    return WebBluetoothDeviceIdPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothDeviceIdPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothDeviceIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothDeviceId>::Convert(*this);
  }


  WebBluetoothDeviceId();

  explicit WebBluetoothDeviceId(
      const WTF::String& device_id);

  ~WebBluetoothDeviceId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothDeviceIdPtr>
  WebBluetoothDeviceIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothDeviceId::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothDeviceId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothDeviceId_UnserializedMessageContext<
            UserType, WebBluetoothDeviceId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebBluetoothDeviceId::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return WebBluetoothDeviceId::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothDeviceId_UnserializedMessageContext<
            UserType, WebBluetoothDeviceId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothDeviceId::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String device_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothDeviceId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class BLINK_PLATFORM_EXPORT WebBluetoothLeScanFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothLeScanFilter, T>::value>;
  using DataView = WebBluetoothLeScanFilterDataView;
  using Data_ = internal::WebBluetoothLeScanFilter_Data;

  template <typename... Args>
  static WebBluetoothLeScanFilterPtr New(Args&&... args) {
    return WebBluetoothLeScanFilterPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothLeScanFilterPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothLeScanFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothLeScanFilter>::Convert(*this);
  }


  WebBluetoothLeScanFilter();

  WebBluetoothLeScanFilter(
      base::Optional<WTF::Vector<::WTF::String>> services,
      const WTF::String& name,
      const WTF::String& name_prefix);

  ~WebBluetoothLeScanFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothLeScanFilterPtr>
  WebBluetoothLeScanFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothLeScanFilter::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothLeScanFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothLeScanFilter_UnserializedMessageContext<
            UserType, WebBluetoothLeScanFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebBluetoothLeScanFilter::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return WebBluetoothLeScanFilter::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothLeScanFilter_UnserializedMessageContext<
            UserType, WebBluetoothLeScanFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothLeScanFilter::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<WTF::Vector<::WTF::String>> services;
  
  WTF::String name;
  
  WTF::String name_prefix;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT WebBluetoothRequestDeviceOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothRequestDeviceOptions, T>::value>;
  using DataView = WebBluetoothRequestDeviceOptionsDataView;
  using Data_ = internal::WebBluetoothRequestDeviceOptions_Data;

  template <typename... Args>
  static WebBluetoothRequestDeviceOptionsPtr New(Args&&... args) {
    return WebBluetoothRequestDeviceOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothRequestDeviceOptionsPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothRequestDeviceOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothRequestDeviceOptions>::Convert(*this);
  }


  WebBluetoothRequestDeviceOptions();

  WebBluetoothRequestDeviceOptions(
      base::Optional<WTF::Vector<WebBluetoothLeScanFilterPtr>> filters,
      WTF::Vector<::WTF::String> optional_services,
      WTF::Vector<uint16_t> optional_manufacturer_data,
      bool accept_all_devices);

  ~WebBluetoothRequestDeviceOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothRequestDeviceOptionsPtr>
  WebBluetoothRequestDeviceOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRequestDeviceOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothRequestDeviceOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothRequestDeviceOptions_UnserializedMessageContext<
            UserType, WebBluetoothRequestDeviceOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebBluetoothRequestDeviceOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return WebBluetoothRequestDeviceOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothRequestDeviceOptions_UnserializedMessageContext<
            UserType, WebBluetoothRequestDeviceOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothRequestDeviceOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<WTF::Vector<WebBluetoothLeScanFilterPtr>> filters;
  
  WTF::Vector<::WTF::String> optional_services;
  
  WTF::Vector<uint16_t> optional_manufacturer_data;
  
  bool accept_all_devices;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(WebBluetoothRequestDeviceOptions);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT WebBluetoothRequestLEScanOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothRequestLEScanOptions, T>::value>;
  using DataView = WebBluetoothRequestLEScanOptionsDataView;
  using Data_ = internal::WebBluetoothRequestLEScanOptions_Data;

  template <typename... Args>
  static WebBluetoothRequestLEScanOptionsPtr New(Args&&... args) {
    return WebBluetoothRequestLEScanOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothRequestLEScanOptionsPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothRequestLEScanOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothRequestLEScanOptions>::Convert(*this);
  }


  WebBluetoothRequestLEScanOptions();

  WebBluetoothRequestLEScanOptions(
      base::Optional<WTF::Vector<WebBluetoothLeScanFilterPtr>> filters,
      bool keep_repeated_devices,
      bool accept_all_advertisements);

  ~WebBluetoothRequestLEScanOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothRequestLEScanOptionsPtr>
  WebBluetoothRequestLEScanOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRequestLEScanOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothRequestLEScanOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothRequestLEScanOptions_UnserializedMessageContext<
            UserType, WebBluetoothRequestLEScanOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebBluetoothRequestLEScanOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return WebBluetoothRequestLEScanOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothRequestLEScanOptions_UnserializedMessageContext<
            UserType, WebBluetoothRequestLEScanOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothRequestLEScanOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<WTF::Vector<WebBluetoothLeScanFilterPtr>> filters;
  
  bool keep_repeated_devices;
  
  bool accept_all_advertisements;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(WebBluetoothRequestLEScanOptions);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT WebBluetoothDevice {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothDevice, T>::value>;
  using DataView = WebBluetoothDeviceDataView;
  using Data_ = internal::WebBluetoothDevice_Data;

  template <typename... Args>
  static WebBluetoothDevicePtr New(Args&&... args) {
    return WebBluetoothDevicePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothDevicePtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothDevicePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothDevice>::Convert(*this);
  }


  WebBluetoothDevice();

  WebBluetoothDevice(
      const ::WTF::String& id,
      const WTF::String& name);

  ~WebBluetoothDevice();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothDevicePtr>
  WebBluetoothDevicePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothDevice::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothDevice::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothDevice_UnserializedMessageContext<
            UserType, WebBluetoothDevice::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebBluetoothDevice::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return WebBluetoothDevice::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothDevice_UnserializedMessageContext<
            UserType, WebBluetoothDevice::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothDevice::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::WTF::String id;
  
  WTF::String name;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothDevice::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT WebBluetoothRemoteGATTService {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothRemoteGATTService, T>::value>;
  using DataView = WebBluetoothRemoteGATTServiceDataView;
  using Data_ = internal::WebBluetoothRemoteGATTService_Data;

  template <typename... Args>
  static WebBluetoothRemoteGATTServicePtr New(Args&&... args) {
    return WebBluetoothRemoteGATTServicePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothRemoteGATTServicePtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothRemoteGATTServicePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothRemoteGATTService>::Convert(*this);
  }


  WebBluetoothRemoteGATTService();

  WebBluetoothRemoteGATTService(
      const WTF::String& instance_id,
      const ::WTF::String& uuid);

  ~WebBluetoothRemoteGATTService();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothRemoteGATTServicePtr>
  WebBluetoothRemoteGATTServicePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRemoteGATTService::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothRemoteGATTService::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothRemoteGATTService_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTService::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTService::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return WebBluetoothRemoteGATTService::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothRemoteGATTService_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTService::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTService::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String instance_id;
  
  ::WTF::String uuid;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT WebBluetoothRemoteGATTCharacteristic {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothRemoteGATTCharacteristic, T>::value>;
  using DataView = WebBluetoothRemoteGATTCharacteristicDataView;
  using Data_ = internal::WebBluetoothRemoteGATTCharacteristic_Data;

  template <typename... Args>
  static WebBluetoothRemoteGATTCharacteristicPtr New(Args&&... args) {
    return WebBluetoothRemoteGATTCharacteristicPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothRemoteGATTCharacteristicPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothRemoteGATTCharacteristicPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothRemoteGATTCharacteristic>::Convert(*this);
  }


  WebBluetoothRemoteGATTCharacteristic();

  WebBluetoothRemoteGATTCharacteristic(
      const WTF::String& instance_id,
      const ::WTF::String& uuid,
      uint32_t properties);

  ~WebBluetoothRemoteGATTCharacteristic();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothRemoteGATTCharacteristicPtr>
  WebBluetoothRemoteGATTCharacteristicPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRemoteGATTCharacteristic::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothRemoteGATTCharacteristic::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothRemoteGATTCharacteristic_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTCharacteristic::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTCharacteristic::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return WebBluetoothRemoteGATTCharacteristic::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothRemoteGATTCharacteristic_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTCharacteristic::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTCharacteristic::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String instance_id;
  
  ::WTF::String uuid;
  
  uint32_t properties;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT WebBluetoothAdvertisingEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothAdvertisingEvent, T>::value>;
  using DataView = WebBluetoothAdvertisingEventDataView;
  using Data_ = internal::WebBluetoothAdvertisingEvent_Data;

  template <typename... Args>
  static WebBluetoothAdvertisingEventPtr New(Args&&... args) {
    return WebBluetoothAdvertisingEventPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothAdvertisingEventPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothAdvertisingEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothAdvertisingEvent>::Convert(*this);
  }


  WebBluetoothAdvertisingEvent();

  WebBluetoothAdvertisingEvent(
      WebBluetoothDevicePtr device,
      const WTF::String& name,
      WTF::Vector<::WTF::String> uuids,
      bool appearance_is_set,
      uint16_t appearance,
      bool tx_power_is_set,
      uint8_t tx_power,
      bool rssi_is_set,
      uint8_t rssi,
      const WTF::HashMap<uint16_t, WTF::Vector<uint8_t>>& manufacturer_data,
      const WTF::HashMap<::WTF::String, WTF::Vector<uint8_t>>& service_data);

  ~WebBluetoothAdvertisingEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothAdvertisingEventPtr>
  WebBluetoothAdvertisingEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothAdvertisingEvent::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothAdvertisingEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothAdvertisingEvent_UnserializedMessageContext<
            UserType, WebBluetoothAdvertisingEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebBluetoothAdvertisingEvent::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return WebBluetoothAdvertisingEvent::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothAdvertisingEvent_UnserializedMessageContext<
            UserType, WebBluetoothAdvertisingEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothAdvertisingEvent::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WebBluetoothDevicePtr device;
  
  WTF::String name;
  
  WTF::Vector<::WTF::String> uuids;
  
  bool appearance_is_set;
  
  uint16_t appearance;
  
  bool tx_power_is_set;
  
  uint8_t tx_power;
  
  bool rssi_is_set;
  
  uint8_t rssi;
  
  WTF::HashMap<uint16_t, WTF::Vector<uint8_t>> manufacturer_data;
  
  WTF::HashMap<::WTF::String, WTF::Vector<uint8_t>> service_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(WebBluetoothAdvertisingEvent);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT WebBluetoothRemoteGATTDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebBluetoothRemoteGATTDescriptor, T>::value>;
  using DataView = WebBluetoothRemoteGATTDescriptorDataView;
  using Data_ = internal::WebBluetoothRemoteGATTDescriptor_Data;

  template <typename... Args>
  static WebBluetoothRemoteGATTDescriptorPtr New(Args&&... args) {
    return WebBluetoothRemoteGATTDescriptorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebBluetoothRemoteGATTDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<WebBluetoothRemoteGATTDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebBluetoothRemoteGATTDescriptor>::Convert(*this);
  }


  WebBluetoothRemoteGATTDescriptor();

  WebBluetoothRemoteGATTDescriptor(
      const WTF::String& instance_id,
      const ::WTF::String& uuid);

  ~WebBluetoothRemoteGATTDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebBluetoothRemoteGATTDescriptorPtr>
  WebBluetoothRemoteGATTDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebBluetoothRemoteGATTDescriptor::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebBluetoothRemoteGATTDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebBluetoothRemoteGATTDescriptor_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTDescriptor::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return WebBluetoothRemoteGATTDescriptor::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebBluetoothRemoteGATTDescriptor_UnserializedMessageContext<
            UserType, WebBluetoothRemoteGATTDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebBluetoothRemoteGATTDescriptor::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String instance_id;
  
  ::WTF::String uuid;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebBluetoothLeScanFilterPtr WebBluetoothLeScanFilter::Clone() const {
  return New(
      mojo::Clone(services),
      mojo::Clone(name),
      mojo::Clone(name_prefix)
  );
}

template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>*>
bool WebBluetoothLeScanFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->services, other_struct.services))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->name_prefix, other_struct.name_prefix))
    return false;
  return true;
}

template <typename T, WebBluetoothLeScanFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.services, rhs.services))
    return true;
  if (std::less<>{}(rhs.services, lhs.services))
    return false;
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.name_prefix, rhs.name_prefix))
    return true;
  if (std::less<>{}(rhs.name_prefix, lhs.name_prefix))
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothRequestDeviceOptionsPtr WebBluetoothRequestDeviceOptions::Clone() const {
  return New(
      mojo::Clone(filters),
      mojo::Clone(optional_services),
      mojo::Clone(optional_manufacturer_data),
      mojo::Clone(accept_all_devices)
  );
}

template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>*>
bool WebBluetoothRequestDeviceOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  if (!mojo::Equals(this->optional_services, other_struct.optional_services))
    return false;
  if (!mojo::Equals(this->optional_manufacturer_data, other_struct.optional_manufacturer_data))
    return false;
  if (!mojo::Equals(this->accept_all_devices, other_struct.accept_all_devices))
    return false;
  return true;
}

template <typename T, WebBluetoothRequestDeviceOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.filters, rhs.filters))
    return true;
  if (std::less<>{}(rhs.filters, lhs.filters))
    return false;
  if (std::less<>{}(lhs.optional_services, rhs.optional_services))
    return true;
  if (std::less<>{}(rhs.optional_services, lhs.optional_services))
    return false;
  if (std::less<>{}(lhs.optional_manufacturer_data, rhs.optional_manufacturer_data))
    return true;
  if (std::less<>{}(rhs.optional_manufacturer_data, lhs.optional_manufacturer_data))
    return false;
  if (std::less<>{}(lhs.accept_all_devices, rhs.accept_all_devices))
    return true;
  if (std::less<>{}(rhs.accept_all_devices, lhs.accept_all_devices))
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothRequestLEScanOptionsPtr WebBluetoothRequestLEScanOptions::Clone() const {
  return New(
      mojo::Clone(filters),
      mojo::Clone(keep_repeated_devices),
      mojo::Clone(accept_all_advertisements)
  );
}

template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>*>
bool WebBluetoothRequestLEScanOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  if (!mojo::Equals(this->keep_repeated_devices, other_struct.keep_repeated_devices))
    return false;
  if (!mojo::Equals(this->accept_all_advertisements, other_struct.accept_all_advertisements))
    return false;
  return true;
}

template <typename T, WebBluetoothRequestLEScanOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.filters, rhs.filters))
    return true;
  if (std::less<>{}(rhs.filters, lhs.filters))
    return false;
  if (std::less<>{}(lhs.keep_repeated_devices, rhs.keep_repeated_devices))
    return true;
  if (std::less<>{}(rhs.keep_repeated_devices, lhs.keep_repeated_devices))
    return false;
  if (std::less<>{}(lhs.accept_all_advertisements, rhs.accept_all_advertisements))
    return true;
  if (std::less<>{}(rhs.accept_all_advertisements, lhs.accept_all_advertisements))
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothDeviceIdPtr WebBluetoothDeviceId::Clone() const {
  return New(
      mojo::Clone(device_id)
  );
}

template <typename T, WebBluetoothDeviceId::EnableIfSame<T>*>
bool WebBluetoothDeviceId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_id, other_struct.device_id))
    return false;
  return true;
}

template <typename T, WebBluetoothDeviceId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.device_id, rhs.device_id))
    return true;
  if (std::less<>{}(rhs.device_id, lhs.device_id))
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothDevicePtr WebBluetoothDevice::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name)
  );
}

template <typename T, WebBluetoothDevice::EnableIfSame<T>*>
bool WebBluetoothDevice::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, WebBluetoothDevice::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothRemoteGATTServicePtr WebBluetoothRemoteGATTService::Clone() const {
  return New(
      mojo::Clone(instance_id),
      mojo::Clone(uuid)
  );
}

template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>*>
bool WebBluetoothRemoteGATTService::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->instance_id, other_struct.instance_id))
    return false;
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  return true;
}

template <typename T, WebBluetoothRemoteGATTService::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.instance_id, rhs.instance_id))
    return true;
  if (std::less<>{}(rhs.instance_id, lhs.instance_id))
    return false;
  if (std::less<>{}(lhs.uuid, rhs.uuid))
    return true;
  if (std::less<>{}(rhs.uuid, lhs.uuid))
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothRemoteGATTCharacteristicPtr WebBluetoothRemoteGATTCharacteristic::Clone() const {
  return New(
      mojo::Clone(instance_id),
      mojo::Clone(uuid),
      mojo::Clone(properties)
  );
}

template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>*>
bool WebBluetoothRemoteGATTCharacteristic::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->instance_id, other_struct.instance_id))
    return false;
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  if (!mojo::Equals(this->properties, other_struct.properties))
    return false;
  return true;
}

template <typename T, WebBluetoothRemoteGATTCharacteristic::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.instance_id, rhs.instance_id))
    return true;
  if (std::less<>{}(rhs.instance_id, lhs.instance_id))
    return false;
  if (std::less<>{}(lhs.uuid, rhs.uuid))
    return true;
  if (std::less<>{}(rhs.uuid, lhs.uuid))
    return false;
  if (std::less<>{}(lhs.properties, rhs.properties))
    return true;
  if (std::less<>{}(rhs.properties, lhs.properties))
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothAdvertisingEventPtr WebBluetoothAdvertisingEvent::Clone() const {
  return New(
      mojo::Clone(device),
      mojo::Clone(name),
      mojo::Clone(uuids),
      mojo::Clone(appearance_is_set),
      mojo::Clone(appearance),
      mojo::Clone(tx_power_is_set),
      mojo::Clone(tx_power),
      mojo::Clone(rssi_is_set),
      mojo::Clone(rssi),
      mojo::Clone(manufacturer_data),
      mojo::Clone(service_data)
  );
}

template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>*>
bool WebBluetoothAdvertisingEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device, other_struct.device))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->uuids, other_struct.uuids))
    return false;
  if (!mojo::Equals(this->appearance_is_set, other_struct.appearance_is_set))
    return false;
  if (!mojo::Equals(this->appearance, other_struct.appearance))
    return false;
  if (!mojo::Equals(this->tx_power_is_set, other_struct.tx_power_is_set))
    return false;
  if (!mojo::Equals(this->tx_power, other_struct.tx_power))
    return false;
  if (!mojo::Equals(this->rssi_is_set, other_struct.rssi_is_set))
    return false;
  if (!mojo::Equals(this->rssi, other_struct.rssi))
    return false;
  if (!mojo::Equals(this->manufacturer_data, other_struct.manufacturer_data))
    return false;
  if (!mojo::Equals(this->service_data, other_struct.service_data))
    return false;
  return true;
}

template <typename T, WebBluetoothAdvertisingEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.device, rhs.device))
    return true;
  if (std::less<>{}(rhs.device, lhs.device))
    return false;
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.uuids, rhs.uuids))
    return true;
  if (std::less<>{}(rhs.uuids, lhs.uuids))
    return false;
  if (std::less<>{}(lhs.appearance_is_set, rhs.appearance_is_set))
    return true;
  if (std::less<>{}(rhs.appearance_is_set, lhs.appearance_is_set))
    return false;
  if (std::less<>{}(lhs.appearance, rhs.appearance))
    return true;
  if (std::less<>{}(rhs.appearance, lhs.appearance))
    return false;
  if (std::less<>{}(lhs.tx_power_is_set, rhs.tx_power_is_set))
    return true;
  if (std::less<>{}(rhs.tx_power_is_set, lhs.tx_power_is_set))
    return false;
  if (std::less<>{}(lhs.tx_power, rhs.tx_power))
    return true;
  if (std::less<>{}(rhs.tx_power, lhs.tx_power))
    return false;
  if (std::less<>{}(lhs.rssi_is_set, rhs.rssi_is_set))
    return true;
  if (std::less<>{}(rhs.rssi_is_set, lhs.rssi_is_set))
    return false;
  if (std::less<>{}(lhs.rssi, rhs.rssi))
    return true;
  if (std::less<>{}(rhs.rssi, lhs.rssi))
    return false;
  if (std::less<>{}(lhs.manufacturer_data, rhs.manufacturer_data))
    return true;
  if (std::less<>{}(rhs.manufacturer_data, lhs.manufacturer_data))
    return false;
  if (std::less<>{}(lhs.service_data, rhs.service_data))
    return true;
  if (std::less<>{}(rhs.service_data, lhs.service_data))
    return false;
  return false;
}
template <typename StructPtrType>
WebBluetoothRemoteGATTDescriptorPtr WebBluetoothRemoteGATTDescriptor::Clone() const {
  return New(
      mojo::Clone(instance_id),
      mojo::Clone(uuid)
  );
}

template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>*>
bool WebBluetoothRemoteGATTDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->instance_id, other_struct.instance_id))
    return false;
  if (!mojo::Equals(this->uuid, other_struct.uuid))
    return false;
  return true;
}

template <typename T, WebBluetoothRemoteGATTDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.instance_id, rhs.instance_id))
    return true;
  if (std::less<>{}(rhs.instance_id, lhs.instance_id))
    return false;
  if (std::less<>{}(lhs.uuid, rhs.uuid))
    return true;
  if (std::less<>{}(rhs.uuid, lhs.uuid))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WebBluetoothLeScanFilter::DataView,
                                         ::blink::mojom::blink::WebBluetoothLeScanFilterPtr> {
  static bool IsNull(const ::blink::mojom::blink::WebBluetoothLeScanFilterPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WebBluetoothLeScanFilterPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WebBluetoothLeScanFilter::services)& services(
      const ::blink::mojom::blink::WebBluetoothLeScanFilterPtr& input) {
    return input->services;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothLeScanFilter::name)& name(
      const ::blink::mojom::blink::WebBluetoothLeScanFilterPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothLeScanFilter::name_prefix)& name_prefix(
      const ::blink::mojom::blink::WebBluetoothLeScanFilterPtr& input) {
    return input->name_prefix;
  }

  static bool Read(::blink::mojom::blink::WebBluetoothLeScanFilter::DataView input, ::blink::mojom::blink::WebBluetoothLeScanFilterPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WebBluetoothRequestDeviceOptions::DataView,
                                         ::blink::mojom::blink::WebBluetoothRequestDeviceOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::WebBluetoothRequestDeviceOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WebBluetoothRequestDeviceOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WebBluetoothRequestDeviceOptions::filters)& filters(
      const ::blink::mojom::blink::WebBluetoothRequestDeviceOptionsPtr& input) {
    return input->filters;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothRequestDeviceOptions::optional_services)& optional_services(
      const ::blink::mojom::blink::WebBluetoothRequestDeviceOptionsPtr& input) {
    return input->optional_services;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothRequestDeviceOptions::optional_manufacturer_data)& optional_manufacturer_data(
      const ::blink::mojom::blink::WebBluetoothRequestDeviceOptionsPtr& input) {
    return input->optional_manufacturer_data;
  }

  static decltype(::blink::mojom::blink::WebBluetoothRequestDeviceOptions::accept_all_devices) accept_all_devices(
      const ::blink::mojom::blink::WebBluetoothRequestDeviceOptionsPtr& input) {
    return input->accept_all_devices;
  }

  static bool Read(::blink::mojom::blink::WebBluetoothRequestDeviceOptions::DataView input, ::blink::mojom::blink::WebBluetoothRequestDeviceOptionsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WebBluetoothRequestLEScanOptions::DataView,
                                         ::blink::mojom::blink::WebBluetoothRequestLEScanOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::WebBluetoothRequestLEScanOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WebBluetoothRequestLEScanOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WebBluetoothRequestLEScanOptions::filters)& filters(
      const ::blink::mojom::blink::WebBluetoothRequestLEScanOptionsPtr& input) {
    return input->filters;
  }

  static decltype(::blink::mojom::blink::WebBluetoothRequestLEScanOptions::keep_repeated_devices) keep_repeated_devices(
      const ::blink::mojom::blink::WebBluetoothRequestLEScanOptionsPtr& input) {
    return input->keep_repeated_devices;
  }

  static decltype(::blink::mojom::blink::WebBluetoothRequestLEScanOptions::accept_all_advertisements) accept_all_advertisements(
      const ::blink::mojom::blink::WebBluetoothRequestLEScanOptionsPtr& input) {
    return input->accept_all_advertisements;
  }

  static bool Read(::blink::mojom::blink::WebBluetoothRequestLEScanOptions::DataView input, ::blink::mojom::blink::WebBluetoothRequestLEScanOptionsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WebBluetoothDeviceId::DataView,
                                         ::blink::mojom::blink::WebBluetoothDeviceIdPtr> {
  static bool IsNull(const ::blink::mojom::blink::WebBluetoothDeviceIdPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WebBluetoothDeviceIdPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WebBluetoothDeviceId::device_id)& device_id(
      const ::blink::mojom::blink::WebBluetoothDeviceIdPtr& input) {
    return input->device_id;
  }

  static bool Read(::blink::mojom::blink::WebBluetoothDeviceId::DataView input, ::blink::mojom::blink::WebBluetoothDeviceIdPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WebBluetoothDevice::DataView,
                                         ::blink::mojom::blink::WebBluetoothDevicePtr> {
  static bool IsNull(const ::blink::mojom::blink::WebBluetoothDevicePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WebBluetoothDevicePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WebBluetoothDevice::id)& id(
      const ::blink::mojom::blink::WebBluetoothDevicePtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothDevice::name)& name(
      const ::blink::mojom::blink::WebBluetoothDevicePtr& input) {
    return input->name;
  }

  static bool Read(::blink::mojom::blink::WebBluetoothDevice::DataView input, ::blink::mojom::blink::WebBluetoothDevicePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WebBluetoothRemoteGATTService::DataView,
                                         ::blink::mojom::blink::WebBluetoothRemoteGATTServicePtr> {
  static bool IsNull(const ::blink::mojom::blink::WebBluetoothRemoteGATTServicePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WebBluetoothRemoteGATTServicePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WebBluetoothRemoteGATTService::instance_id)& instance_id(
      const ::blink::mojom::blink::WebBluetoothRemoteGATTServicePtr& input) {
    return input->instance_id;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothRemoteGATTService::uuid)& uuid(
      const ::blink::mojom::blink::WebBluetoothRemoteGATTServicePtr& input) {
    return input->uuid;
  }

  static bool Read(::blink::mojom::blink::WebBluetoothRemoteGATTService::DataView input, ::blink::mojom::blink::WebBluetoothRemoteGATTServicePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristic::DataView,
                                         ::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristicPtr> {
  static bool IsNull(const ::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristicPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristicPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristic::instance_id)& instance_id(
      const ::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristicPtr& input) {
    return input->instance_id;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristic::uuid)& uuid(
      const ::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristicPtr& input) {
    return input->uuid;
  }

  static decltype(::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristic::properties) properties(
      const ::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristicPtr& input) {
    return input->properties;
  }

  static bool Read(::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristic::DataView input, ::blink::mojom::blink::WebBluetoothRemoteGATTCharacteristicPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WebBluetoothAdvertisingEvent::DataView,
                                         ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr> {
  static bool IsNull(const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WebBluetoothAdvertisingEventPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WebBluetoothAdvertisingEvent::device)& device(
      const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) {
    return input->device;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothAdvertisingEvent::name)& name(
      const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothAdvertisingEvent::uuids)& uuids(
      const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) {
    return input->uuids;
  }

  static decltype(::blink::mojom::blink::WebBluetoothAdvertisingEvent::appearance_is_set) appearance_is_set(
      const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) {
    return input->appearance_is_set;
  }

  static decltype(::blink::mojom::blink::WebBluetoothAdvertisingEvent::appearance) appearance(
      const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) {
    return input->appearance;
  }

  static decltype(::blink::mojom::blink::WebBluetoothAdvertisingEvent::tx_power_is_set) tx_power_is_set(
      const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) {
    return input->tx_power_is_set;
  }

  static decltype(::blink::mojom::blink::WebBluetoothAdvertisingEvent::tx_power) tx_power(
      const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) {
    return input->tx_power;
  }

  static decltype(::blink::mojom::blink::WebBluetoothAdvertisingEvent::rssi_is_set) rssi_is_set(
      const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) {
    return input->rssi_is_set;
  }

  static decltype(::blink::mojom::blink::WebBluetoothAdvertisingEvent::rssi) rssi(
      const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) {
    return input->rssi;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothAdvertisingEvent::manufacturer_data)& manufacturer_data(
      const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) {
    return input->manufacturer_data;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothAdvertisingEvent::service_data)& service_data(
      const ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr& input) {
    return input->service_data;
  }

  static bool Read(::blink::mojom::blink::WebBluetoothAdvertisingEvent::DataView input, ::blink::mojom::blink::WebBluetoothAdvertisingEventPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::blink::mojom::blink::WebBluetoothRemoteGATTDescriptor::DataView,
                                         ::blink::mojom::blink::WebBluetoothRemoteGATTDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::blink::WebBluetoothRemoteGATTDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::WebBluetoothRemoteGATTDescriptorPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::WebBluetoothRemoteGATTDescriptor::instance_id)& instance_id(
      const ::blink::mojom::blink::WebBluetoothRemoteGATTDescriptorPtr& input) {
    return input->instance_id;
  }

  static const decltype(::blink::mojom::blink::WebBluetoothRemoteGATTDescriptor::uuid)& uuid(
      const ::blink::mojom::blink::WebBluetoothRemoteGATTDescriptorPtr& input) {
    return input->uuid;
  }

  static bool Read(::blink::mojom::blink::WebBluetoothRemoteGATTDescriptor::DataView input, ::blink::mojom::blink::WebBluetoothRemoteGATTDescriptorPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_BLUETOOTH_WEB_BLUETOOTH_MOJOM_BLINK_H_