// third_party/blink/public/mojom/input/synchronous_compositor.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_SYNCHRONOUS_COMPOSITOR_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_SYNCHRONOUS_COMPOSITOR_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/input/synchronous_compositor.mojom-shared.h"
#include "third_party/blink/public/mojom/input/synchronous_compositor.mojom-blink-forward.h"
#include "mojo/public/mojom/base/shared_memory.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink-forward.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-blink.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-blink.h"
#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-blink.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-blink.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom-blink.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/transform.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class SynchronousCompositorProxy;

template <typename ImplRefTraits>
class SynchronousCompositorStub;

class SynchronousCompositorRequestValidator;
class SynchronousCompositorResponseValidator;


class PLATFORM_EXPORT SynchronousCompositor
    : public SynchronousCompositorInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = SynchronousCompositorInterfaceBase;
  using Proxy_ = SynchronousCompositorProxy;

  template <typename ImplRefTraits>
  using Stub_ = SynchronousCompositorStub<ImplRefTraits>;

  using RequestValidator_ = SynchronousCompositorRequestValidator;
  using ResponseValidator_ = SynchronousCompositorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDemandDrawHwAsyncMinVersion = 0,
    kDemandDrawHwMinVersion = 0,
    kSetSharedMemoryMinVersion = 0,
    kDemandDrawSwMinVersion = 0,
    kWillSkipDrawMinVersion = 0,
    kZeroSharedMemoryMinVersion = 0,
    kZoomByMinVersion = 0,
    kSetMemoryPolicyMinVersion = 0,
    kReclaimResourcesMinVersion = 0,
    kSetScrollMinVersion = 0,
    kBeginFrameMinVersion = 0,
    kSetBeginFrameSourcePausedMinVersion = 0,
  };
  virtual ~SynchronousCompositor() {}

  
  virtual void DemandDrawHwAsync(SyncCompositorDemandDrawHwParamsPtr draw_params) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DemandDrawHw(SyncCompositorDemandDrawHwParamsPtr draw_params, SyncCompositorCommonRendererParamsPtr* out_result, uint32_t* out_layer_tree_frame_sink_id, uint32_t* out_metadata_version, base::Optional<::viz::CompositorFrame>* out_frame, base::Optional<::viz::HitTestRegionList>* out_hit_test_region_list);

  using DemandDrawHwCallback = base::OnceCallback<void(SyncCompositorCommonRendererParamsPtr, uint32_t, uint32_t, base::Optional<::viz::CompositorFrame>, base::Optional<::viz::HitTestRegionList>)>;
  
  virtual void DemandDrawHw(SyncCompositorDemandDrawHwParamsPtr draw_params, DemandDrawHwCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetSharedMemory(::base::WritableSharedMemoryRegion shm_region, bool* out_success, SyncCompositorCommonRendererParamsPtr* out_result);

  using SetSharedMemoryCallback = base::OnceCallback<void(bool, SyncCompositorCommonRendererParamsPtr)>;
  
  virtual void SetSharedMemory(::base::WritableSharedMemoryRegion shm_region, SetSharedMemoryCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DemandDrawSw(SyncCompositorDemandDrawSwParamsPtr draw_params, SyncCompositorCommonRendererParamsPtr* out_result, uint32_t* out_metadata_version, base::Optional<::viz::CompositorFrameMetadata>* out_meta_data);

  using DemandDrawSwCallback = base::OnceCallback<void(SyncCompositorCommonRendererParamsPtr, uint32_t, base::Optional<::viz::CompositorFrameMetadata>)>;
  
  virtual void DemandDrawSw(SyncCompositorDemandDrawSwParamsPtr draw_params, DemandDrawSwCallback callback) = 0;

  
  virtual void WillSkipDraw() = 0;

  
  virtual void ZeroSharedMemory() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ZoomBy(float delta, const ::gfx::Point& anchor, SyncCompositorCommonRendererParamsPtr* out_result);

  using ZoomByCallback = base::OnceCallback<void(SyncCompositorCommonRendererParamsPtr)>;
  
  virtual void ZoomBy(float delta, const ::gfx::Point& anchor, ZoomByCallback callback) = 0;

  
  virtual void SetMemoryPolicy(uint32_t bytes_limit) = 0;

  
  virtual void ReclaimResources(uint32_t layer_tree_frame_sink_id, const WTF::Vector<::viz::ReturnedResource>& resources) = 0;

  
  virtual void SetScroll(const ::gfx::ScrollOffset& offset) = 0;

  
  virtual void BeginFrame(const ::viz::BeginFrameArgs& args, const WTF::HashMap<uint32_t, ::viz::FrameTimingDetails>& timing_details) = 0;

  
  virtual void SetBeginFrameSourcePaused(bool paused) = 0;
};

class SynchronousCompositorHostProxy;

template <typename ImplRefTraits>
class SynchronousCompositorHostStub;

class SynchronousCompositorHostRequestValidator;


class PLATFORM_EXPORT SynchronousCompositorHost
    : public SynchronousCompositorHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SynchronousCompositorHostInterfaceBase;
  using Proxy_ = SynchronousCompositorHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SynchronousCompositorHostStub<ImplRefTraits>;

  using RequestValidator_ = SynchronousCompositorHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kLayerTreeFrameSinkCreatedMinVersion = 0,
    kUpdateStateMinVersion = 0,
    kSetNeedsBeginFramesMinVersion = 0,
  };
  virtual ~SynchronousCompositorHost() {}

  
  virtual void LayerTreeFrameSinkCreated() = 0;

  
  virtual void UpdateState(SyncCompositorCommonRendererParamsPtr params) = 0;

  
  virtual void SetNeedsBeginFrames(bool needs_begin_frames) = 0;
};

class SynchronousCompositorControlHostProxy;

template <typename ImplRefTraits>
class SynchronousCompositorControlHostStub;

class SynchronousCompositorControlHostRequestValidator;


class PLATFORM_EXPORT SynchronousCompositorControlHost
    : public SynchronousCompositorControlHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SynchronousCompositorControlHostInterfaceBase;
  using Proxy_ = SynchronousCompositorControlHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SynchronousCompositorControlHostStub<ImplRefTraits>;

  using RequestValidator_ = SynchronousCompositorControlHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReturnFrameMinVersion = 0,
    kBeginFrameResponseMinVersion = 0,
  };
  virtual ~SynchronousCompositorControlHost() {}

  
  virtual void ReturnFrame(uint32_t layer_tree_frame_sink_id, uint32_t metadata_version, base::Optional<::viz::CompositorFrame> frame, base::Optional<::viz::HitTestRegionList> hit_test_region_list) = 0;

  
  virtual void BeginFrameResponse(SyncCompositorCommonRendererParamsPtr params) = 0;
};



class PLATFORM_EXPORT SynchronousCompositorProxy
    : public SynchronousCompositor {
 public:
  using InterfaceType = SynchronousCompositor;

  explicit SynchronousCompositorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DemandDrawHwAsync(SyncCompositorDemandDrawHwParamsPtr draw_params) final;
  
  bool DemandDrawHw(SyncCompositorDemandDrawHwParamsPtr draw_params, SyncCompositorCommonRendererParamsPtr* out_result, uint32_t* out_layer_tree_frame_sink_id, uint32_t* out_metadata_version, base::Optional<::viz::CompositorFrame>* out_frame, base::Optional<::viz::HitTestRegionList>* out_hit_test_region_list) final;
  
  void DemandDrawHw(SyncCompositorDemandDrawHwParamsPtr draw_params, DemandDrawHwCallback callback) final;
  
  bool SetSharedMemory(::base::WritableSharedMemoryRegion shm_region, bool* out_success, SyncCompositorCommonRendererParamsPtr* out_result) final;
  
  void SetSharedMemory(::base::WritableSharedMemoryRegion shm_region, SetSharedMemoryCallback callback) final;
  
  bool DemandDrawSw(SyncCompositorDemandDrawSwParamsPtr draw_params, SyncCompositorCommonRendererParamsPtr* out_result, uint32_t* out_metadata_version, base::Optional<::viz::CompositorFrameMetadata>* out_meta_data) final;
  
  void DemandDrawSw(SyncCompositorDemandDrawSwParamsPtr draw_params, DemandDrawSwCallback callback) final;
  
  void WillSkipDraw() final;
  
  void ZeroSharedMemory() final;
  
  bool ZoomBy(float delta, const ::gfx::Point& anchor, SyncCompositorCommonRendererParamsPtr* out_result) final;
  
  void ZoomBy(float delta, const ::gfx::Point& anchor, ZoomByCallback callback) final;
  
  void SetMemoryPolicy(uint32_t bytes_limit) final;
  
  void ReclaimResources(uint32_t layer_tree_frame_sink_id, const WTF::Vector<::viz::ReturnedResource>& resources) final;
  
  void SetScroll(const ::gfx::ScrollOffset& offset) final;
  
  void BeginFrame(const ::viz::BeginFrameArgs& args, const WTF::HashMap<uint32_t, ::viz::FrameTimingDetails>& timing_details) final;
  
  void SetBeginFrameSourcePaused(bool paused) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT SynchronousCompositorHostProxy
    : public SynchronousCompositorHost {
 public:
  using InterfaceType = SynchronousCompositorHost;

  explicit SynchronousCompositorHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void LayerTreeFrameSinkCreated() final;
  
  void UpdateState(SyncCompositorCommonRendererParamsPtr params) final;
  
  void SetNeedsBeginFrames(bool needs_begin_frames) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT SynchronousCompositorControlHostProxy
    : public SynchronousCompositorControlHost {
 public:
  using InterfaceType = SynchronousCompositorControlHost;

  explicit SynchronousCompositorControlHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReturnFrame(uint32_t layer_tree_frame_sink_id, uint32_t metadata_version, base::Optional<::viz::CompositorFrame> frame, base::Optional<::viz::HitTestRegionList> hit_test_region_list) final;
  
  void BeginFrameResponse(SyncCompositorCommonRendererParamsPtr params) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT SynchronousCompositorStubDispatch {
 public:
  static bool Accept(SynchronousCompositor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SynchronousCompositor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SynchronousCompositor>>
class SynchronousCompositorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SynchronousCompositorStub() {}
  ~SynchronousCompositorStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SynchronousCompositorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SynchronousCompositorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT SynchronousCompositorHostStubDispatch {
 public:
  static bool Accept(SynchronousCompositorHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SynchronousCompositorHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SynchronousCompositorHost>>
class SynchronousCompositorHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SynchronousCompositorHostStub() {}
  ~SynchronousCompositorHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SynchronousCompositorHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SynchronousCompositorHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT SynchronousCompositorControlHostStubDispatch {
 public:
  static bool Accept(SynchronousCompositorControlHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SynchronousCompositorControlHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SynchronousCompositorControlHost>>
class SynchronousCompositorControlHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SynchronousCompositorControlHostStub() {}
  ~SynchronousCompositorControlHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SynchronousCompositorControlHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SynchronousCompositorControlHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT SynchronousCompositorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT SynchronousCompositorHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT SynchronousCompositorControlHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT SynchronousCompositorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class PLATFORM_EXPORT SyncCompositorDemandDrawHwParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyncCompositorDemandDrawHwParams, T>::value>;
  using DataView = SyncCompositorDemandDrawHwParamsDataView;
  using Data_ = internal::SyncCompositorDemandDrawHwParams_Data;

  template <typename... Args>
  static SyncCompositorDemandDrawHwParamsPtr New(Args&&... args) {
    return SyncCompositorDemandDrawHwParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyncCompositorDemandDrawHwParamsPtr From(const U& u) {
    return mojo::TypeConverter<SyncCompositorDemandDrawHwParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyncCompositorDemandDrawHwParams>::Convert(*this);
  }


  SyncCompositorDemandDrawHwParams();

  SyncCompositorDemandDrawHwParams(
      const ::gfx::Size& viewport_size,
      const ::gfx::Rect& viewport_rect_for_tile_priority,
      const ::gfx::Transform& transform_for_tile_priority);

  ~SyncCompositorDemandDrawHwParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyncCompositorDemandDrawHwParamsPtr>
  SyncCompositorDemandDrawHwParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyncCompositorDemandDrawHwParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyncCompositorDemandDrawHwParams::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyncCompositorDemandDrawHwParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyncCompositorDemandDrawHwParams_UnserializedMessageContext<
            UserType, SyncCompositorDemandDrawHwParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SyncCompositorDemandDrawHwParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return SyncCompositorDemandDrawHwParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyncCompositorDemandDrawHwParams_UnserializedMessageContext<
            UserType, SyncCompositorDemandDrawHwParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyncCompositorDemandDrawHwParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Size viewport_size;
  
  ::gfx::Rect viewport_rect_for_tile_priority;
  
  ::gfx::Transform transform_for_tile_priority;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyncCompositorDemandDrawHwParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyncCompositorDemandDrawHwParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyncCompositorDemandDrawHwParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyncCompositorDemandDrawHwParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT SyncCompositorDemandDrawSwParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyncCompositorDemandDrawSwParams, T>::value>;
  using DataView = SyncCompositorDemandDrawSwParamsDataView;
  using Data_ = internal::SyncCompositorDemandDrawSwParams_Data;

  template <typename... Args>
  static SyncCompositorDemandDrawSwParamsPtr New(Args&&... args) {
    return SyncCompositorDemandDrawSwParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyncCompositorDemandDrawSwParamsPtr From(const U& u) {
    return mojo::TypeConverter<SyncCompositorDemandDrawSwParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyncCompositorDemandDrawSwParams>::Convert(*this);
  }


  SyncCompositorDemandDrawSwParams();

  SyncCompositorDemandDrawSwParams(
      const ::gfx::Size& size,
      const ::gfx::Rect& clip,
      const ::gfx::Transform& transform);

  ~SyncCompositorDemandDrawSwParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyncCompositorDemandDrawSwParamsPtr>
  SyncCompositorDemandDrawSwParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyncCompositorDemandDrawSwParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyncCompositorDemandDrawSwParams::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyncCompositorDemandDrawSwParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyncCompositorDemandDrawSwParams_UnserializedMessageContext<
            UserType, SyncCompositorDemandDrawSwParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SyncCompositorDemandDrawSwParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return SyncCompositorDemandDrawSwParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyncCompositorDemandDrawSwParams_UnserializedMessageContext<
            UserType, SyncCompositorDemandDrawSwParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyncCompositorDemandDrawSwParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Size size;
  
  ::gfx::Rect clip;
  
  ::gfx::Transform transform;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyncCompositorDemandDrawSwParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyncCompositorDemandDrawSwParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyncCompositorDemandDrawSwParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyncCompositorDemandDrawSwParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT SyncCompositorCommonRendererParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SyncCompositorCommonRendererParams, T>::value>;
  using DataView = SyncCompositorCommonRendererParamsDataView;
  using Data_ = internal::SyncCompositorCommonRendererParams_Data;

  template <typename... Args>
  static SyncCompositorCommonRendererParamsPtr New(Args&&... args) {
    return SyncCompositorCommonRendererParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SyncCompositorCommonRendererParamsPtr From(const U& u) {
    return mojo::TypeConverter<SyncCompositorCommonRendererParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SyncCompositorCommonRendererParams>::Convert(*this);
  }


  SyncCompositorCommonRendererParams();

  SyncCompositorCommonRendererParams(
      uint32_t version,
      const ::gfx::ScrollOffset& total_scroll_offset,
      const ::gfx::ScrollOffset& max_scroll_offset,
      const ::gfx::SizeF& scrollable_size,
      float page_scale_factor,
      float min_page_scale_factor,
      float max_page_scale_factor,
      uint32_t need_invalidate_count,
      bool invalidate_needs_draw,
      uint32_t did_activate_pending_tree_count);

  ~SyncCompositorCommonRendererParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SyncCompositorCommonRendererParamsPtr>
  SyncCompositorCommonRendererParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SyncCompositorCommonRendererParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SyncCompositorCommonRendererParams::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SyncCompositorCommonRendererParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SyncCompositorCommonRendererParams_UnserializedMessageContext<
            UserType, SyncCompositorCommonRendererParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SyncCompositorCommonRendererParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return SyncCompositorCommonRendererParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SyncCompositorCommonRendererParams_UnserializedMessageContext<
            UserType, SyncCompositorCommonRendererParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SyncCompositorCommonRendererParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t version;
  
  ::gfx::ScrollOffset total_scroll_offset;
  
  ::gfx::ScrollOffset max_scroll_offset;
  
  ::gfx::SizeF scrollable_size;
  
  float page_scale_factor;
  
  float min_page_scale_factor;
  
  float max_page_scale_factor;
  
  uint32_t need_invalidate_count;
  
  bool invalidate_needs_draw;
  
  uint32_t did_activate_pending_tree_count;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SyncCompositorCommonRendererParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SyncCompositorCommonRendererParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SyncCompositorCommonRendererParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SyncCompositorCommonRendererParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SyncCompositorDemandDrawHwParamsPtr SyncCompositorDemandDrawHwParams::Clone() const {
  return New(
      mojo::Clone(viewport_size),
      mojo::Clone(viewport_rect_for_tile_priority),
      mojo::Clone(transform_for_tile_priority)
  );
}

template <typename T, SyncCompositorDemandDrawHwParams::EnableIfSame<T>*>
bool SyncCompositorDemandDrawHwParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->viewport_size, other_struct.viewport_size))
    return false;
  if (!mojo::Equals(this->viewport_rect_for_tile_priority, other_struct.viewport_rect_for_tile_priority))
    return false;
  if (!mojo::Equals(this->transform_for_tile_priority, other_struct.transform_for_tile_priority))
    return false;
  return true;
}

template <typename T, SyncCompositorDemandDrawHwParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.viewport_size, rhs.viewport_size))
    return true;
  if (std::less<>{}(rhs.viewport_size, lhs.viewport_size))
    return false;
  if (std::less<>{}(lhs.viewport_rect_for_tile_priority, rhs.viewport_rect_for_tile_priority))
    return true;
  if (std::less<>{}(rhs.viewport_rect_for_tile_priority, lhs.viewport_rect_for_tile_priority))
    return false;
  if (std::less<>{}(lhs.transform_for_tile_priority, rhs.transform_for_tile_priority))
    return true;
  if (std::less<>{}(rhs.transform_for_tile_priority, lhs.transform_for_tile_priority))
    return false;
  return false;
}
template <typename StructPtrType>
SyncCompositorDemandDrawSwParamsPtr SyncCompositorDemandDrawSwParams::Clone() const {
  return New(
      mojo::Clone(size),
      mojo::Clone(clip),
      mojo::Clone(transform)
  );
}

template <typename T, SyncCompositorDemandDrawSwParams::EnableIfSame<T>*>
bool SyncCompositorDemandDrawSwParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->clip, other_struct.clip))
    return false;
  if (!mojo::Equals(this->transform, other_struct.transform))
    return false;
  return true;
}

template <typename T, SyncCompositorDemandDrawSwParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.size, rhs.size))
    return true;
  if (std::less<>{}(rhs.size, lhs.size))
    return false;
  if (std::less<>{}(lhs.clip, rhs.clip))
    return true;
  if (std::less<>{}(rhs.clip, lhs.clip))
    return false;
  if (std::less<>{}(lhs.transform, rhs.transform))
    return true;
  if (std::less<>{}(rhs.transform, lhs.transform))
    return false;
  return false;
}
template <typename StructPtrType>
SyncCompositorCommonRendererParamsPtr SyncCompositorCommonRendererParams::Clone() const {
  return New(
      mojo::Clone(version),
      mojo::Clone(total_scroll_offset),
      mojo::Clone(max_scroll_offset),
      mojo::Clone(scrollable_size),
      mojo::Clone(page_scale_factor),
      mojo::Clone(min_page_scale_factor),
      mojo::Clone(max_page_scale_factor),
      mojo::Clone(need_invalidate_count),
      mojo::Clone(invalidate_needs_draw),
      mojo::Clone(did_activate_pending_tree_count)
  );
}

template <typename T, SyncCompositorCommonRendererParams::EnableIfSame<T>*>
bool SyncCompositorCommonRendererParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->total_scroll_offset, other_struct.total_scroll_offset))
    return false;
  if (!mojo::Equals(this->max_scroll_offset, other_struct.max_scroll_offset))
    return false;
  if (!mojo::Equals(this->scrollable_size, other_struct.scrollable_size))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->min_page_scale_factor, other_struct.min_page_scale_factor))
    return false;
  if (!mojo::Equals(this->max_page_scale_factor, other_struct.max_page_scale_factor))
    return false;
  if (!mojo::Equals(this->need_invalidate_count, other_struct.need_invalidate_count))
    return false;
  if (!mojo::Equals(this->invalidate_needs_draw, other_struct.invalidate_needs_draw))
    return false;
  if (!mojo::Equals(this->did_activate_pending_tree_count, other_struct.did_activate_pending_tree_count))
    return false;
  return true;
}

template <typename T, SyncCompositorCommonRendererParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.version, rhs.version))
    return true;
  if (std::less<>{}(rhs.version, lhs.version))
    return false;
  if (std::less<>{}(lhs.total_scroll_offset, rhs.total_scroll_offset))
    return true;
  if (std::less<>{}(rhs.total_scroll_offset, lhs.total_scroll_offset))
    return false;
  if (std::less<>{}(lhs.max_scroll_offset, rhs.max_scroll_offset))
    return true;
  if (std::less<>{}(rhs.max_scroll_offset, lhs.max_scroll_offset))
    return false;
  if (std::less<>{}(lhs.scrollable_size, rhs.scrollable_size))
    return true;
  if (std::less<>{}(rhs.scrollable_size, lhs.scrollable_size))
    return false;
  if (std::less<>{}(lhs.page_scale_factor, rhs.page_scale_factor))
    return true;
  if (std::less<>{}(rhs.page_scale_factor, lhs.page_scale_factor))
    return false;
  if (std::less<>{}(lhs.min_page_scale_factor, rhs.min_page_scale_factor))
    return true;
  if (std::less<>{}(rhs.min_page_scale_factor, lhs.min_page_scale_factor))
    return false;
  if (std::less<>{}(lhs.max_page_scale_factor, rhs.max_page_scale_factor))
    return true;
  if (std::less<>{}(rhs.max_page_scale_factor, lhs.max_page_scale_factor))
    return false;
  if (std::less<>{}(lhs.need_invalidate_count, rhs.need_invalidate_count))
    return true;
  if (std::less<>{}(rhs.need_invalidate_count, lhs.need_invalidate_count))
    return false;
  if (std::less<>{}(lhs.invalidate_needs_draw, rhs.invalidate_needs_draw))
    return true;
  if (std::less<>{}(rhs.invalidate_needs_draw, lhs.invalidate_needs_draw))
    return false;
  if (std::less<>{}(lhs.did_activate_pending_tree_count, rhs.did_activate_pending_tree_count))
    return true;
  if (std::less<>{}(rhs.did_activate_pending_tree_count, lhs.did_activate_pending_tree_count))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SyncCompositorDemandDrawHwParams::DataView,
                                         ::blink::mojom::blink::SyncCompositorDemandDrawHwParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::SyncCompositorDemandDrawHwParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SyncCompositorDemandDrawHwParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SyncCompositorDemandDrawHwParams::viewport_size)& viewport_size(
      const ::blink::mojom::blink::SyncCompositorDemandDrawHwParamsPtr& input) {
    return input->viewport_size;
  }

  static const decltype(::blink::mojom::blink::SyncCompositorDemandDrawHwParams::viewport_rect_for_tile_priority)& viewport_rect_for_tile_priority(
      const ::blink::mojom::blink::SyncCompositorDemandDrawHwParamsPtr& input) {
    return input->viewport_rect_for_tile_priority;
  }

  static const decltype(::blink::mojom::blink::SyncCompositorDemandDrawHwParams::transform_for_tile_priority)& transform_for_tile_priority(
      const ::blink::mojom::blink::SyncCompositorDemandDrawHwParamsPtr& input) {
    return input->transform_for_tile_priority;
  }

  static bool Read(::blink::mojom::blink::SyncCompositorDemandDrawHwParams::DataView input, ::blink::mojom::blink::SyncCompositorDemandDrawHwParamsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SyncCompositorDemandDrawSwParams::DataView,
                                         ::blink::mojom::blink::SyncCompositorDemandDrawSwParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::SyncCompositorDemandDrawSwParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SyncCompositorDemandDrawSwParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SyncCompositorDemandDrawSwParams::size)& size(
      const ::blink::mojom::blink::SyncCompositorDemandDrawSwParamsPtr& input) {
    return input->size;
  }

  static const decltype(::blink::mojom::blink::SyncCompositorDemandDrawSwParams::clip)& clip(
      const ::blink::mojom::blink::SyncCompositorDemandDrawSwParamsPtr& input) {
    return input->clip;
  }

  static const decltype(::blink::mojom::blink::SyncCompositorDemandDrawSwParams::transform)& transform(
      const ::blink::mojom::blink::SyncCompositorDemandDrawSwParamsPtr& input) {
    return input->transform;
  }

  static bool Read(::blink::mojom::blink::SyncCompositorDemandDrawSwParams::DataView input, ::blink::mojom::blink::SyncCompositorDemandDrawSwParamsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SyncCompositorCommonRendererParams::DataView,
                                         ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::SyncCompositorCommonRendererParams::version) version(
      const ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr& input) {
    return input->version;
  }

  static const decltype(::blink::mojom::blink::SyncCompositorCommonRendererParams::total_scroll_offset)& total_scroll_offset(
      const ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr& input) {
    return input->total_scroll_offset;
  }

  static const decltype(::blink::mojom::blink::SyncCompositorCommonRendererParams::max_scroll_offset)& max_scroll_offset(
      const ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr& input) {
    return input->max_scroll_offset;
  }

  static const decltype(::blink::mojom::blink::SyncCompositorCommonRendererParams::scrollable_size)& scrollable_size(
      const ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr& input) {
    return input->scrollable_size;
  }

  static decltype(::blink::mojom::blink::SyncCompositorCommonRendererParams::page_scale_factor) page_scale_factor(
      const ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr& input) {
    return input->page_scale_factor;
  }

  static decltype(::blink::mojom::blink::SyncCompositorCommonRendererParams::min_page_scale_factor) min_page_scale_factor(
      const ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr& input) {
    return input->min_page_scale_factor;
  }

  static decltype(::blink::mojom::blink::SyncCompositorCommonRendererParams::max_page_scale_factor) max_page_scale_factor(
      const ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr& input) {
    return input->max_page_scale_factor;
  }

  static decltype(::blink::mojom::blink::SyncCompositorCommonRendererParams::need_invalidate_count) need_invalidate_count(
      const ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr& input) {
    return input->need_invalidate_count;
  }

  static decltype(::blink::mojom::blink::SyncCompositorCommonRendererParams::invalidate_needs_draw) invalidate_needs_draw(
      const ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr& input) {
    return input->invalidate_needs_draw;
  }

  static decltype(::blink::mojom::blink::SyncCompositorCommonRendererParams::did_activate_pending_tree_count) did_activate_pending_tree_count(
      const ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr& input) {
    return input->did_activate_pending_tree_count;
  }

  static bool Read(::blink::mojom::blink::SyncCompositorCommonRendererParams::DataView input, ::blink::mojom::blink::SyncCompositorCommonRendererParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_SYNCHRONOUS_COMPOSITOR_MOJOM_BLINK_H_