// third_party/blink/public/mojom/loader/resource_load_info.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-forward.h"
#include "services/network/public/mojom/ip_address.mojom-forward.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/load_timing_info.mojom.h"
#include "services/network/public/mojom/network_param.mojom-forward.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {










class BLINK_COMMON_EXPORT CommonNetworkInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CommonNetworkInfo, T>::value>;
  using DataView = CommonNetworkInfoDataView;
  using Data_ = internal::CommonNetworkInfo_Data;

  template <typename... Args>
  static CommonNetworkInfoPtr New(Args&&... args) {
    return CommonNetworkInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CommonNetworkInfoPtr From(const U& u) {
    return mojo::TypeConverter<CommonNetworkInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CommonNetworkInfo>::Convert(*this);
  }


  CommonNetworkInfo();

  CommonNetworkInfo(
      bool network_accessed,
      bool always_access_network,
      const base::Optional<::net::IPEndPoint>& remote_endpoint);

  ~CommonNetworkInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CommonNetworkInfoPtr>
  CommonNetworkInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CommonNetworkInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CommonNetworkInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CommonNetworkInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CommonNetworkInfo_UnserializedMessageContext<
            UserType, CommonNetworkInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CommonNetworkInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CommonNetworkInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CommonNetworkInfo_UnserializedMessageContext<
            UserType, CommonNetworkInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CommonNetworkInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool network_accessed;
  
  bool always_access_network;
  
  base::Optional<::net::IPEndPoint> remote_endpoint;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CommonNetworkInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CommonNetworkInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CommonNetworkInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CommonNetworkInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT RedirectInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RedirectInfo, T>::value>;
  using DataView = RedirectInfoDataView;
  using Data_ = internal::RedirectInfo_Data;

  template <typename... Args>
  static RedirectInfoPtr New(Args&&... args) {
    return RedirectInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RedirectInfoPtr From(const U& u) {
    return mojo::TypeConverter<RedirectInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RedirectInfo>::Convert(*this);
  }


  RedirectInfo();

  RedirectInfo(
      const ::url::Origin& origin_of_new_url,
      CommonNetworkInfoPtr network_info);

  ~RedirectInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RedirectInfoPtr>
  RedirectInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RedirectInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RedirectInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RedirectInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RedirectInfo_UnserializedMessageContext<
            UserType, RedirectInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RedirectInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RedirectInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RedirectInfo_UnserializedMessageContext<
            UserType, RedirectInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RedirectInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::url::Origin origin_of_new_url;
  
  CommonNetworkInfoPtr network_info;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(RedirectInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RedirectInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RedirectInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RedirectInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RedirectInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT ResourceLoadInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResourceLoadInfo, T>::value>;
  using DataView = ResourceLoadInfoDataView;
  using Data_ = internal::ResourceLoadInfo_Data;

  template <typename... Args>
  static ResourceLoadInfoPtr New(Args&&... args) {
    return ResourceLoadInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResourceLoadInfoPtr From(const U& u) {
    return mojo::TypeConverter<ResourceLoadInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResourceLoadInfo>::Convert(*this);
  }


  ResourceLoadInfo();

  ResourceLoadInfo(
      int64_t request_id,
      const ::GURL& final_url,
      const ::GURL& referrer,
      const ::GURL& original_url,
      const std::string& method,
      ::network::mojom::RequestDestination request_destination,
      ::net::RequestPriority request_priority,
      const std::string& mime_type,
      bool was_cached,
      CommonNetworkInfoPtr network_info,
      int32_t net_error,
      const ::net::LoadTimingInfo& load_timing_info,
      int64_t raw_body_bytes,
      int64_t total_received_bytes,
      std::vector<RedirectInfoPtr> redirect_info_chain);

  ~ResourceLoadInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResourceLoadInfoPtr>
  ResourceLoadInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResourceLoadInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResourceLoadInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResourceLoadInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResourceLoadInfo_UnserializedMessageContext<
            UserType, ResourceLoadInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ResourceLoadInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ResourceLoadInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResourceLoadInfo_UnserializedMessageContext<
            UserType, ResourceLoadInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResourceLoadInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int64_t request_id;
  
  ::GURL final_url;
  
  ::GURL referrer;
  
  ::GURL original_url;
  
  std::string method;
  
  ::network::mojom::RequestDestination request_destination;
  
  ::net::RequestPriority request_priority;
  
  std::string mime_type;
  
  bool was_cached;
  
  CommonNetworkInfoPtr network_info;
  
  int32_t net_error;
  
  ::net::LoadTimingInfo load_timing_info;
  
  int64_t raw_body_bytes;
  
  int64_t total_received_bytes;
  
  std::vector<RedirectInfoPtr> redirect_info_chain;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ResourceLoadInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResourceLoadInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResourceLoadInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResourceLoadInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResourceLoadInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CommonNetworkInfoPtr CommonNetworkInfo::Clone() const {
  return New(
      mojo::Clone(network_accessed),
      mojo::Clone(always_access_network),
      mojo::Clone(remote_endpoint)
  );
}

template <typename T, CommonNetworkInfo::EnableIfSame<T>*>
bool CommonNetworkInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->network_accessed, other_struct.network_accessed))
    return false;
  if (!mojo::Equals(this->always_access_network, other_struct.always_access_network))
    return false;
  if (!mojo::Equals(this->remote_endpoint, other_struct.remote_endpoint))
    return false;
  return true;
}

template <typename T, CommonNetworkInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.network_accessed, rhs.network_accessed))
    return true;
  if (std::less<>{}(rhs.network_accessed, lhs.network_accessed))
    return false;
  if (std::less<>{}(lhs.always_access_network, rhs.always_access_network))
    return true;
  if (std::less<>{}(rhs.always_access_network, lhs.always_access_network))
    return false;
  if (std::less<>{}(lhs.remote_endpoint, rhs.remote_endpoint))
    return true;
  if (std::less<>{}(rhs.remote_endpoint, lhs.remote_endpoint))
    return false;
  return false;
}
template <typename StructPtrType>
RedirectInfoPtr RedirectInfo::Clone() const {
  return New(
      mojo::Clone(origin_of_new_url),
      mojo::Clone(network_info)
  );
}

template <typename T, RedirectInfo::EnableIfSame<T>*>
bool RedirectInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin_of_new_url, other_struct.origin_of_new_url))
    return false;
  if (!mojo::Equals(this->network_info, other_struct.network_info))
    return false;
  return true;
}

template <typename T, RedirectInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.origin_of_new_url, rhs.origin_of_new_url))
    return true;
  if (std::less<>{}(rhs.origin_of_new_url, lhs.origin_of_new_url))
    return false;
  if (std::less<>{}(lhs.network_info, rhs.network_info))
    return true;
  if (std::less<>{}(rhs.network_info, lhs.network_info))
    return false;
  return false;
}
template <typename StructPtrType>
ResourceLoadInfoPtr ResourceLoadInfo::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(final_url),
      mojo::Clone(referrer),
      mojo::Clone(original_url),
      mojo::Clone(method),
      mojo::Clone(request_destination),
      mojo::Clone(request_priority),
      mojo::Clone(mime_type),
      mojo::Clone(was_cached),
      mojo::Clone(network_info),
      mojo::Clone(net_error),
      mojo::Clone(load_timing_info),
      mojo::Clone(raw_body_bytes),
      mojo::Clone(total_received_bytes),
      mojo::Clone(redirect_info_chain)
  );
}

template <typename T, ResourceLoadInfo::EnableIfSame<T>*>
bool ResourceLoadInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->final_url, other_struct.final_url))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->original_url, other_struct.original_url))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->request_destination, other_struct.request_destination))
    return false;
  if (!mojo::Equals(this->request_priority, other_struct.request_priority))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->was_cached, other_struct.was_cached))
    return false;
  if (!mojo::Equals(this->network_info, other_struct.network_info))
    return false;
  if (!mojo::Equals(this->net_error, other_struct.net_error))
    return false;
  if (!mojo::Equals(this->load_timing_info, other_struct.load_timing_info))
    return false;
  if (!mojo::Equals(this->raw_body_bytes, other_struct.raw_body_bytes))
    return false;
  if (!mojo::Equals(this->total_received_bytes, other_struct.total_received_bytes))
    return false;
  if (!mojo::Equals(this->redirect_info_chain, other_struct.redirect_info_chain))
    return false;
  return true;
}

template <typename T, ResourceLoadInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.request_id, rhs.request_id))
    return true;
  if (std::less<>{}(rhs.request_id, lhs.request_id))
    return false;
  if (std::less<>{}(lhs.final_url, rhs.final_url))
    return true;
  if (std::less<>{}(rhs.final_url, lhs.final_url))
    return false;
  if (std::less<>{}(lhs.referrer, rhs.referrer))
    return true;
  if (std::less<>{}(rhs.referrer, lhs.referrer))
    return false;
  if (std::less<>{}(lhs.original_url, rhs.original_url))
    return true;
  if (std::less<>{}(rhs.original_url, lhs.original_url))
    return false;
  if (std::less<>{}(lhs.method, rhs.method))
    return true;
  if (std::less<>{}(rhs.method, lhs.method))
    return false;
  if (std::less<>{}(lhs.request_destination, rhs.request_destination))
    return true;
  if (std::less<>{}(rhs.request_destination, lhs.request_destination))
    return false;
  if (std::less<>{}(lhs.request_priority, rhs.request_priority))
    return true;
  if (std::less<>{}(rhs.request_priority, lhs.request_priority))
    return false;
  if (std::less<>{}(lhs.mime_type, rhs.mime_type))
    return true;
  if (std::less<>{}(rhs.mime_type, lhs.mime_type))
    return false;
  if (std::less<>{}(lhs.was_cached, rhs.was_cached))
    return true;
  if (std::less<>{}(rhs.was_cached, lhs.was_cached))
    return false;
  if (std::less<>{}(lhs.network_info, rhs.network_info))
    return true;
  if (std::less<>{}(rhs.network_info, lhs.network_info))
    return false;
  if (std::less<>{}(lhs.net_error, rhs.net_error))
    return true;
  if (std::less<>{}(rhs.net_error, lhs.net_error))
    return false;
  if (std::less<>{}(lhs.load_timing_info, rhs.load_timing_info))
    return true;
  if (std::less<>{}(rhs.load_timing_info, lhs.load_timing_info))
    return false;
  if (std::less<>{}(lhs.raw_body_bytes, rhs.raw_body_bytes))
    return true;
  if (std::less<>{}(rhs.raw_body_bytes, lhs.raw_body_bytes))
    return false;
  if (std::less<>{}(lhs.total_received_bytes, rhs.total_received_bytes))
    return true;
  if (std::less<>{}(rhs.total_received_bytes, lhs.total_received_bytes))
    return false;
  if (std::less<>{}(lhs.redirect_info_chain, rhs.redirect_info_chain))
    return true;
  if (std::less<>{}(rhs.redirect_info_chain, lhs.redirect_info_chain))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::CommonNetworkInfo::DataView,
                                         ::blink::mojom::CommonNetworkInfoPtr> {
  static bool IsNull(const ::blink::mojom::CommonNetworkInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::CommonNetworkInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::CommonNetworkInfo::network_accessed) network_accessed(
      const ::blink::mojom::CommonNetworkInfoPtr& input) {
    return input->network_accessed;
  }

  static decltype(::blink::mojom::CommonNetworkInfo::always_access_network) always_access_network(
      const ::blink::mojom::CommonNetworkInfoPtr& input) {
    return input->always_access_network;
  }

  static const decltype(::blink::mojom::CommonNetworkInfo::remote_endpoint)& remote_endpoint(
      const ::blink::mojom::CommonNetworkInfoPtr& input) {
    return input->remote_endpoint;
  }

  static bool Read(::blink::mojom::CommonNetworkInfo::DataView input, ::blink::mojom::CommonNetworkInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::RedirectInfo::DataView,
                                         ::blink::mojom::RedirectInfoPtr> {
  static bool IsNull(const ::blink::mojom::RedirectInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::RedirectInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::RedirectInfo::origin_of_new_url)& origin_of_new_url(
      const ::blink::mojom::RedirectInfoPtr& input) {
    return input->origin_of_new_url;
  }

  static const decltype(::blink::mojom::RedirectInfo::network_info)& network_info(
      const ::blink::mojom::RedirectInfoPtr& input) {
    return input->network_info;
  }

  static bool Read(::blink::mojom::RedirectInfo::DataView input, ::blink::mojom::RedirectInfoPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ResourceLoadInfo::DataView,
                                         ::blink::mojom::ResourceLoadInfoPtr> {
  static bool IsNull(const ::blink::mojom::ResourceLoadInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ResourceLoadInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::ResourceLoadInfo::request_id) request_id(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->request_id;
  }

  static const decltype(::blink::mojom::ResourceLoadInfo::final_url)& final_url(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->final_url;
  }

  static const decltype(::blink::mojom::ResourceLoadInfo::referrer)& referrer(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->referrer;
  }

  static const decltype(::blink::mojom::ResourceLoadInfo::original_url)& original_url(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->original_url;
  }

  static const decltype(::blink::mojom::ResourceLoadInfo::method)& method(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->method;
  }

  static decltype(::blink::mojom::ResourceLoadInfo::request_destination) request_destination(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->request_destination;
  }

  static decltype(::blink::mojom::ResourceLoadInfo::request_priority) request_priority(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->request_priority;
  }

  static const decltype(::blink::mojom::ResourceLoadInfo::mime_type)& mime_type(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->mime_type;
  }

  static decltype(::blink::mojom::ResourceLoadInfo::was_cached) was_cached(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->was_cached;
  }

  static const decltype(::blink::mojom::ResourceLoadInfo::network_info)& network_info(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->network_info;
  }

  static decltype(::blink::mojom::ResourceLoadInfo::net_error) net_error(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->net_error;
  }

  static const decltype(::blink::mojom::ResourceLoadInfo::load_timing_info)& load_timing_info(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->load_timing_info;
  }

  static decltype(::blink::mojom::ResourceLoadInfo::raw_body_bytes) raw_body_bytes(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->raw_body_bytes;
  }

  static decltype(::blink::mojom::ResourceLoadInfo::total_received_bytes) total_received_bytes(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->total_received_bytes;
  }

  static const decltype(::blink::mojom::ResourceLoadInfo::redirect_info_chain)& redirect_info_chain(
      const ::blink::mojom::ResourceLoadInfoPtr& input) {
    return input->redirect_info_chain;
  }

  static bool Read(::blink::mojom::ResourceLoadInfo::DataView input, ::blink::mojom::ResourceLoadInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_H_