// third_party/blink/public/mojom/page/drag.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_SHARED_INTERNAL_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/file_path.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared-internal.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_drag_drop_token.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace blink {
namespace mojom {
namespace internal {
class AllowedDragOperations_Data;
class DragItemString_Data;
class DragItemFile_Data;
class DragItemBinary_Data;
class DragItemFileSystemFile_Data;
class DragData_Data;
class DragEventSourceInfo_Data;
class DragItem_Data;

struct DragOperation_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) DragItem_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  DragItem_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~DragItem_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DragItem_Data));
      new (data()) DragItem_Data();
    }

    void AllocateInline(mojo::internal::Buffer* serialization_buffer,
                        void* ptr) {
      const char* start = static_cast<const char*>(
          serialization_buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      serialization_buffer_ = serialization_buffer;
      index_ = slot - start;
      new (data()) DragItem_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DragItem_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DragItem_Data>(index_);
    }
    DragItem_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<DragItem_Tag>(0);
    data.unknown = 0U;
  }

  enum class DragItem_Tag : uint32_t {

    
    STRING,
    
    FILE,
    
    BINARY,
    
    FILE_SYSTEM_FILE,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::DragItemString_Data> f_string;
    mojo::internal::Pointer<internal::DragItemFile_Data> f_file;
    mojo::internal::Pointer<internal::DragItemBinary_Data> f_binary;
    mojo::internal::Pointer<internal::DragItemFileSystemFile_Data> f_file_system_file;
    uint64_t unknown;
  };

  uint32_t size;
  DragItem_Tag tag;
  Union_ data;
};
static_assert(sizeof(DragItem_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(DragItem_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) AllowedDragOperations_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(AllowedDragOperations_Data));
      new (data()) AllowedDragOperations_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    AllowedDragOperations_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<AllowedDragOperations_Data>(index_);
    }
    AllowedDragOperations_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t allow_copy : 1;
  uint8_t allow_link : 1;
  uint8_t allow_generic : 1;
  uint8_t allow_private : 1;
  uint8_t allow_move : 1;
  uint8_t allow_delete : 1;
  uint8_t padfinal_[7];

 private:
  AllowedDragOperations_Data();
  ~AllowedDragOperations_Data() = delete;
};
static_assert(sizeof(AllowedDragOperations_Data) == 16,
              "Bad sizeof(AllowedDragOperations_Data)");
// Used by AllowedDragOperations::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct AllowedDragOperations_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  AllowedDragOperations_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~AllowedDragOperations_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    AllowedDragOperations_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    AllowedDragOperations_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) DragItemString_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DragItemString_Data));
      new (data()) DragItemString_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DragItemString_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DragItemString_Data>(index_);
    }
    DragItemString_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> string_type;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> string_data;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> title;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> base_url;

 private:
  DragItemString_Data();
  ~DragItemString_Data() = delete;
};
static_assert(sizeof(DragItemString_Data) == 40,
              "Bad sizeof(DragItemString_Data)");
// Used by DragItemString::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DragItemString_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DragItemString_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DragItemString_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DragItemString_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DragItemString_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) DragItemFile_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DragItemFile_Data));
      new (data()) DragItemFile_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DragItemFile_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DragItemFile_Data>(index_);
    }
    DragItemFile_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> path;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> display_name;
  mojo::internal::Interface_Data native_file_system_token;

 private:
  DragItemFile_Data();
  ~DragItemFile_Data() = delete;
};
static_assert(sizeof(DragItemFile_Data) == 32,
              "Bad sizeof(DragItemFile_Data)");
// Used by DragItemFile::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DragItemFile_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DragItemFile_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DragItemFile_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DragItemFile_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DragItemFile_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) DragItemBinary_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DragItemBinary_Data));
      new (data()) DragItemBinary_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DragItemBinary_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DragItemBinary_Data>(index_);
    }
    DragItemBinary_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> source_url;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> filename_extension;
  mojo::internal::Pointer<mojo::internal::String_Data> content_disposition;

 private:
  DragItemBinary_Data();
  ~DragItemBinary_Data() = delete;
};
static_assert(sizeof(DragItemBinary_Data) == 40,
              "Bad sizeof(DragItemBinary_Data)");
// Used by DragItemBinary::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DragItemBinary_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DragItemBinary_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DragItemBinary_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DragItemBinary_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DragItemBinary_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) DragItemFileSystemFile_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DragItemFileSystemFile_Data));
      new (data()) DragItemFileSystemFile_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DragItemFileSystemFile_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DragItemFileSystemFile_Data>(index_);
    }
    DragItemFileSystemFile_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  int64_t size;
  mojo::internal::Pointer<mojo::internal::String_Data> file_system_id;

 private:
  DragItemFileSystemFile_Data();
  ~DragItemFileSystemFile_Data() = delete;
};
static_assert(sizeof(DragItemFileSystemFile_Data) == 32,
              "Bad sizeof(DragItemFileSystemFile_Data)");
// Used by DragItemFileSystemFile::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DragItemFileSystemFile_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DragItemFileSystemFile_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DragItemFileSystemFile_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DragItemFileSystemFile_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DragItemFileSystemFile_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) DragData_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DragData_Data));
      new (data()) DragData_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DragData_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DragData_Data>(index_);
    }
    DragData_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<internal::DragItem_Data>> items;
  mojo::internal::Pointer<mojo::internal::String_Data> file_system_id;
  int32_t referrer_policy;
  uint8_t padfinal_[4];

 private:
  DragData_Data();
  ~DragData_Data() = delete;
};
static_assert(sizeof(DragData_Data) == 32,
              "Bad sizeof(DragData_Data)");
// Used by DragData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DragData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DragData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DragData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DragData_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DragData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) DragEventSourceInfo_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(DragEventSourceInfo_Data));
      new (data()) DragEventSourceInfo_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    DragEventSourceInfo_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<DragEventSourceInfo_Data>(index_);
    }
    DragEventSourceInfo_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gfx::mojom::internal::Point_Data> location;
  int32_t source;
  uint8_t padfinal_[4];

 private:
  DragEventSourceInfo_Data();
  ~DragEventSourceInfo_Data() = delete;
};
static_assert(sizeof(DragEventSourceInfo_Data) == 24,
              "Bad sizeof(DragEventSourceInfo_Data)");
// Used by DragEventSourceInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct DragEventSourceInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  DragEventSourceInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~DragEventSourceInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    DragEventSourceInfo_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    DragEventSourceInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_DRAG_MOJOM_SHARED_INTERNAL_H_