// ui/accessibility/ax_enums.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_AX_ENUMS_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_AX_ENUMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/accessibility/ax_enums.mojom-shared-internal.h"



#include "base/component_export.h"




namespace ax {
namespace mojom {


}  // namespace mojom
}  // namespace ax

namespace mojo {
namespace internal {

}  // namespace internal
}  // namespace mojo


namespace ax {
namespace mojom {


enum class Event : int32_t {
  
  kNone = 0,
  
  kActiveDescendantChanged = 1,
  
  kAlert = 2,
  
  kAriaAttributeChanged = 3,
  
  kAutocorrectionOccured = 4,
  
  kBlur = 5,
  
  kCheckedStateChanged = 6,
  
  kChildrenChanged = 7,
  
  kClicked = 8,
  
  kControlsChanged = 9,
  
  kDocumentSelectionChanged = 10,
  
  kDocumentTitleChanged = 11,
  
  kEndOfTest = 12,
  
  kExpandedChanged = 13,
  
  kFocus = 14,
  
  kFocusAfterMenuClose = 15,
  
  kFocusContext = 16,
  
  kHide = 17,
  
  kHitTestResult = 18,
  
  kHover = 19,
  
  kImageFrameUpdated = 20,
  
  kInvalidStatusChanged = 21,
  
  kLayoutComplete = 22,
  
  kLiveRegionCreated = 23,
  
  kLiveRegionChanged = 24,
  
  kLoadComplete = 25,
  
  kLoadStart = 26,
  
  kLocationChanged = 27,
  
  kMediaStartedPlaying = 28,
  
  kMediaStoppedPlaying = 29,
  
  kMenuEnd = 30,
  
  kMenuListItemSelected = 31,
  
  kMenuListValueChanged = 32,
  
  kMenuPopupEnd = 33,
  
  kMenuPopupStart = 34,
  
  kMenuStart = 35,
  
  kMouseCanceled = 36,
  
  kMouseDragged = 37,
  
  kMouseMoved = 38,
  
  kMousePressed = 39,
  
  kMouseReleased = 40,
  
  kRowCollapsed = 41,
  
  kRowCountChanged = 42,
  
  kRowExpanded = 43,
  
  kScrollPositionChanged = 44,
  
  kScrolledToAnchor = 45,
  
  kSelectedChildrenChanged = 46,
  
  kSelection = 47,
  
  kSelectionAdd = 48,
  
  kSelectionRemove = 49,
  
  kShow = 50,
  
  kStateChanged = 51,
  
  kTextChanged = 52,
  
  kWindowActivated = 53,
  
  kWindowDeactivated = 54,
  
  kWindowVisibilityChanged = 55,
  
  kTextSelectionChanged = 56,
  
  kTooltipClosed = 57,
  
  kTooltipOpened = 58,
  
  kTreeChanged = 59,
  
  kValueChanged = 60,
  kMinValue = 0,
  kMaxValue = 60,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Event value);
inline bool IsKnownEnumValue(Event value) {
  return internal::Event_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Role : int32_t {
  
  kNone = 0,
  
  kAbbr = 1,
  
  kAlert = 2,
  
  kAlertDialog = 3,
  
  kAnchor = 4,
  
  kApplication = 5,
  
  kArticle = 6,
  
  kAudio = 7,
  
  kBanner = 8,
  
  kBlockquote = 9,
  
  kButton = 10,
  
  kCanvas = 11,
  
  kCaption = 12,
  
  kCaret = 13,
  
  kCell = 14,
  
  kCheckBox = 15,
  
  kClient = 16,
  
  kCode = 17,
  
  kColorWell = 18,
  
  kColumn = 19,
  
  kColumnHeader = 20,
  
  kComboBoxGrouping = 21,
  
  kComboBoxMenuButton = 22,
  
  kComplementary = 23,
  
  kComment = 24,
  
  kContentDeletion = 25,
  
  kContentInsertion = 26,
  
  kContentInfo = 27,
  
  kDate = 28,
  
  kDateTime = 29,
  
  kDefinition = 30,
  
  kDescriptionList = 31,
  
  kDescriptionListDetail = 32,
  
  kDescriptionListTerm = 33,
  
  kDesktop = 34,
  
  kDetails = 35,
  
  kDialog = 36,
  
  kDirectory = 37,
  
  kDisclosureTriangle = 38,
  
  kDocAbstract = 39,
  
  kDocAcknowledgments = 40,
  
  kDocAfterword = 41,
  
  kDocAppendix = 42,
  
  kDocBackLink = 43,
  
  kDocBiblioEntry = 44,
  
  kDocBibliography = 45,
  
  kDocBiblioRef = 46,
  
  kDocChapter = 47,
  
  kDocColophon = 48,
  
  kDocConclusion = 49,
  
  kDocCover = 50,
  
  kDocCredit = 51,
  
  kDocCredits = 52,
  
  kDocDedication = 53,
  
  kDocEndnote = 54,
  
  kDocEndnotes = 55,
  
  kDocEpigraph = 56,
  
  kDocEpilogue = 57,
  
  kDocErrata = 58,
  
  kDocExample = 59,
  
  kDocFootnote = 60,
  
  kDocForeword = 61,
  
  kDocGlossary = 62,
  
  kDocGlossRef = 63,
  
  kDocIndex = 64,
  
  kDocIntroduction = 65,
  
  kDocNoteRef = 66,
  
  kDocNotice = 67,
  
  kDocPageBreak = 68,
  
  kDocPageList = 69,
  
  kDocPart = 70,
  
  kDocPreface = 71,
  
  kDocPrologue = 72,
  
  kDocPullquote = 73,
  
  kDocQna = 74,
  
  kDocSubtitle = 75,
  
  kDocTip = 76,
  
  kDocToc = 77,
  
  kDocument = 78,
  
  kEmbeddedObject = 79,
  
  kEmphasis = 80,
  
  kFeed = 81,
  
  kFigcaption = 82,
  
  kFigure = 83,
  
  kFooter = 84,
  
  kFooterAsNonLandmark = 85,
  
  kForm = 86,
  
  kGenericContainer = 87,
  
  kGraphicsDocument = 88,
  
  kGraphicsObject = 89,
  
  kGraphicsSymbol = 90,
  
  kGrid = 91,
  
  kGroup = 92,
  
  kHeader = 93,
  
  kHeaderAsNonLandmark = 94,
  
  kHeading = 95,
  
  kIframe = 96,
  
  kIframePresentational = 97,
  
  kIgnored = 98,
  
  kImage = 99,
  
  kImageMap = 100,
  
  kImeCandidate = 101,
  
  kInlineTextBox = 102,
  
  kInputTime = 103,
  
  kKeyboard = 104,
  
  kLabelText = 105,
  
  kLayoutTable = 106,
  
  kLayoutTableCell = 107,
  
  kLayoutTableRow = 108,
  
  kLegend = 109,
  
  kLineBreak = 110,
  
  kLink = 111,
  
  kList = 112,
  
  kListBox = 113,
  
  kListBoxOption = 114,
  
  kListGrid = 115,
  
  kListItem = 116,
  
  kListMarker = 117,
  
  kLog = 118,
  
  kMain = 119,
  
  kMark = 120,
  
  kMarquee = 121,
  
  kMath = 122,
  
  kMenu = 123,
  
  kMenuBar = 124,
  
  kMenuItem = 125,
  
  kMenuItemCheckBox = 126,
  
  kMenuItemRadio = 127,
  
  kMenuListOption = 128,
  
  kMenuListPopup = 129,
  
  kMeter = 130,
  
  kNavigation = 131,
  
  kNote = 132,
  
  kPane = 133,
  
  kParagraph = 134,
  
  kPdfActionableHighlight = 135,
  
  kPluginObject = 136,
  
  kPopUpButton = 137,
  
  kPortal = 138,
  
  kPre = 139,
  
  kPresentational = 140,
  
  kProgressIndicator = 141,
  
  kRadioButton = 142,
  
  kRadioGroup = 143,
  
  kRegion = 144,
  
  kRootWebArea = 145,
  
  kRow = 146,
  
  kRowGroup = 147,
  
  kRowHeader = 148,
  
  kRuby = 149,
  
  kRubyAnnotation = 150,
  
  kScrollBar = 151,
  
  kScrollView = 152,
  
  kSearch = 153,
  
  kSearchBox = 154,
  
  kSection = 155,
  
  kSlider = 156,
  
  kSliderThumb = 157,
  
  kSpinButton = 158,
  
  kSplitter = 159,
  
  kStaticText = 160,
  
  kStatus = 161,
  
  kStrong = 162,
  
  kSuggestion = 163,
  
  kSvgRoot = 164,
  
  kSwitch = 165,
  
  kTab = 166,
  
  kTabList = 167,
  
  kTabPanel = 168,
  
  kTable = 169,
  
  kTableHeaderContainer = 170,
  
  kTerm = 171,
  
  kTextField = 172,
  
  kTextFieldWithComboBox = 173,
  
  kTime = 174,
  
  kTimer = 175,
  
  kTitleBar = 176,
  
  kToggleButton = 177,
  
  kToolbar = 178,
  
  kTooltip = 179,
  
  kTree = 180,
  
  kTreeGrid = 181,
  
  kTreeItem = 182,
  
  kUnknown = 183,
  
  kVideo = 184,
  
  kWebArea = 185,
  
  kWebView = 186,
  
  kWindow = 187,
  kMinValue = 0,
  kMaxValue = 187,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Role value);
inline bool IsKnownEnumValue(Role value) {
  return internal::Role_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class State : int32_t {
  
  kNone = 0,
  
  kAutofillAvailable = 1,
  
  kCollapsed = 2,
  
  kDefault = 3,
  
  kEditable = 4,
  
  kExpanded = 5,
  
  kFocusable = 6,
  
  kHorizontal = 7,
  
  kHovered = 8,
  
  kIgnored = 9,
  
  kInvisible = 10,
  
  kLinked = 11,
  
  kMultiline = 12,
  
  kMultiselectable = 13,
  
  kProtected = 14,
  
  kRequired = 15,
  
  kRichlyEditable = 16,
  
  kVertical = 17,
  
  kVisited = 18,
  kMinValue = 0,
  kMaxValue = 18,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, State value);
inline bool IsKnownEnumValue(State value) {
  return internal::State_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Action : int32_t {
  
  kNone = 0,
  
  kAnnotatePageImages = 1,
  
  kBlur = 2,
  
  kClearAccessibilityFocus = 3,
  
  kCollapse = 4,
  
  kCustomAction = 5,
  
  kDecrement = 6,
  
  kDoDefault = 7,
  
  kExpand = 8,
  
  kFocus = 9,
  
  kGetImageData = 10,
  
  kGetTextLocation = 11,
  
  kHideTooltip = 12,
  
  kHitTest = 13,
  
  kIncrement = 14,
  
  kInternalInvalidateTree = 15,
  
  kLoadInlineTextBoxes = 16,
  
  kReplaceSelectedText = 17,
  
  kScrollBackward = 18,
  
  kScrollDown = 19,
  
  kScrollForward = 20,
  
  kScrollLeft = 21,
  
  kScrollRight = 22,
  
  kScrollUp = 23,
  
  kScrollToMakeVisible = 24,
  
  kScrollToPoint = 25,
  
  kSetAccessibilityFocus = 26,
  
  kSetScrollOffset = 27,
  
  kSetSelection = 28,
  
  kSetSequentialFocusNavigationStartingPoint = 29,
  
  kSetValue = 30,
  
  kShowContextMenu = 31,
  
  kSignalEndOfTest = 32,
  
  kShowTooltip = 33,
  kMinValue = 0,
  kMaxValue = 33,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Action value);
inline bool IsKnownEnumValue(Action value) {
  return internal::Action_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ActionFlags : int32_t {
  
  kNone = 0,
  
  kRequestImages = 1,
  
  kRequestInlineTextBoxes = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ActionFlags value);
inline bool IsKnownEnumValue(ActionFlags value) {
  return internal::ActionFlags_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ScrollAlignment : int32_t {
  
  kNone = 0,
  
  kScrollAlignmentCenter = 1,
  
  kScrollAlignmentTop = 2,
  
  kScrollAlignmentBottom = 3,
  
  kScrollAlignmentLeft = 4,
  
  kScrollAlignmentRight = 5,
  
  kScrollAlignmentClosestEdge = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ScrollAlignment value);
inline bool IsKnownEnumValue(ScrollAlignment value) {
  return internal::ScrollAlignment_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ScrollBehavior : int32_t {
  
  kNone = 0,
  
  kDoNotScrollIfVisible = 1,
  
  kScrollIfVisible = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ScrollBehavior value);
inline bool IsKnownEnumValue(ScrollBehavior value) {
  return internal::ScrollBehavior_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DefaultActionVerb : int32_t {
  
  kNone = 0,
  
  kActivate = 1,
  
  kCheck = 2,
  
  kClick = 3,
  
  kClickAncestor = 4,
  
  kJump = 5,
  
  kOpen = 6,
  
  kPress = 7,
  
  kSelect = 8,
  
  kUncheck = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, DefaultActionVerb value);
inline bool IsKnownEnumValue(DefaultActionVerb value) {
  return internal::DefaultActionVerb_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Mutation : int32_t {
  
  kNone = 0,
  
  kNodeCreated = 1,
  
  kSubtreeCreated = 2,
  
  kNodeChanged = 3,
  
  kNodeRemoved = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Mutation value);
inline bool IsKnownEnumValue(Mutation value) {
  return internal::Mutation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class StringAttribute : int32_t {
  
  kNone = 0,
  
  kAccessKey = 1,
  
  kAriaInvalidValue = 2,
  
  kAutoComplete = 3,
  
  kChildTreeId = 4,
  
  kClassName = 5,
  
  kContainerLiveRelevant = 6,
  
  kContainerLiveStatus = 7,
  
  kDescription = 8,
  
  kDisplay = 9,
  
  kFontFamily = 10,
  
  kHtmlTag = 11,
  
  kImageAnnotation = 12,
  
  kImageDataUrl = 13,
  
  kInnerHtml = 14,
  
  kInputType = 15,
  
  kKeyShortcuts = 16,
  
  kLanguage = 17,
  
  kName = 18,
  
  kLiveRelevant = 19,
  
  kLiveStatus = 20,
  
  kPlaceholder = 21,
  
  kRole = 22,
  
  kRoleDescription = 23,
  
  kTooltip = 24,
  
  kUrl = 25,
  
  kValue = 26,
  kMinValue = 0,
  kMaxValue = 26,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, StringAttribute value);
inline bool IsKnownEnumValue(StringAttribute value) {
  return internal::StringAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IntAttribute : int32_t {
  
  kNone = 0,
  
  kDefaultActionVerb = 1,
  
  kScrollX = 2,
  
  kScrollXMin = 3,
  
  kScrollXMax = 4,
  
  kScrollY = 5,
  
  kScrollYMin = 6,
  
  kScrollYMax = 7,
  
  kTextSelStart = 8,
  
  kTextSelEnd = 9,
  
  kAriaColumnCount = 10,
  
  kAriaCellColumnIndex = 11,
  
  kAriaCellColumnSpan = 12,
  
  kAriaRowCount = 13,
  
  kAriaCellRowIndex = 14,
  
  kAriaCellRowSpan = 15,
  
  kTableRowCount = 16,
  
  kTableColumnCount = 17,
  
  kTableHeaderId = 18,
  
  kTableRowIndex = 19,
  
  kTableRowHeaderId = 20,
  
  kTableColumnIndex = 21,
  
  kTableColumnHeaderId = 22,
  
  kTableCellColumnIndex = 23,
  
  kTableCellColumnSpan = 24,
  
  kTableCellRowIndex = 25,
  
  kTableCellRowSpan = 26,
  
  kSortDirection = 27,
  
  kHierarchicalLevel = 28,
  
  kNameFrom = 29,
  
  kDescriptionFrom = 30,
  
  kActivedescendantId = 31,
  
  kErrormessageId = 32,
  
  kInPageLinkTargetId = 33,
  
  kMemberOfId = 34,
  
  kNextOnLineId = 35,
  
  kPopupForId = 36,
  
  kPreviousOnLineId = 37,
  
  kRestriction = 38,
  
  kSetSize = 39,
  
  kPosInSet = 40,
  
  kColorValue = 41,
  
  kAriaCurrentState = 42,
  
  kBackgroundColor = 43,
  
  kColor = 44,
  
  kHasPopup = 45,
  
  kImageAnnotationStatus = 46,
  
  kInvalidState = 47,
  
  kCheckedState = 48,
  
  kListStyle = 49,
  
  kTextAlign = 50,
  
  kTextDirection = 51,
  
  kTextPosition = 52,
  
  kTextStyle = 53,
  
  kTextOverlineStyle = 54,
  
  kTextStrikethroughStyle = 55,
  
  kTextUnderlineStyle = 56,
  
  kPreviousFocusId = 57,
  
  kNextFocusId = 58,
  
  kDropeffect = 59,
  
  kDOMNodeId = 60,
  kMinValue = 0,
  kMaxValue = 60,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, IntAttribute value);
inline bool IsKnownEnumValue(IntAttribute value) {
  return internal::IntAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FloatAttribute : int32_t {
  
  kNone = 0,
  
  kValueForRange = 1,
  
  kMinValueForRange = 2,
  
  kMaxValueForRange = 3,
  
  kStepValueForRange = 4,
  
  kFontSize = 5,
  
  kFontWeight = 6,
  
  kTextIndent = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, FloatAttribute value);
inline bool IsKnownEnumValue(FloatAttribute value) {
  return internal::FloatAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BoolAttribute : int32_t {
  
  kNone = 0,
  
  kBusy = 1,
  
  kEditableRoot = 2,
  
  kContainerLiveAtomic = 3,
  
  kContainerLiveBusy = 4,
  
  kLiveAtomic = 5,
  
  kModal = 6,
  
  kUpdateLocationOnly = 7,
  
  kCanvasHasFallback = 8,
  
  kScrollable = 9,
  
  kClickable = 10,
  
  kClipsChildren = 11,
  
  kNotUserSelectableStyle = 12,
  
  kSelected = 13,
  
  kSelectedFromFocus = 14,
  
  kSupportsTextLocation = 15,
  
  kGrabbed = 16,
  
  kIsLineBreakingObject = 17,
  
  kIsPageBreakingObject = 18,
  
  kHasAriaAttribute = 19,
  kMinValue = 0,
  kMaxValue = 19,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, BoolAttribute value);
inline bool IsKnownEnumValue(BoolAttribute value) {
  return internal::BoolAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class IntListAttribute : int32_t {
  
  kNone = 0,
  
  kIndirectChildIds = 1,
  
  kControlsIds = 2,
  
  kDetailsIds = 3,
  
  kDescribedbyIds = 4,
  
  kFlowtoIds = 5,
  
  kLabelledbyIds = 6,
  
  kRadioGroupIds = 7,
  
  kMarkerTypes = 8,
  
  kMarkerStarts = 9,
  
  kMarkerEnds = 10,
  
  kCharacterOffsets = 11,
  
  kCachedLineStarts = 12,
  
  kWordStarts = 13,
  
  kWordEnds = 14,
  
  kCustomActionIds = 15,
  kMinValue = 0,
  kMaxValue = 15,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, IntListAttribute value);
inline bool IsKnownEnumValue(IntListAttribute value) {
  return internal::IntListAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class StringListAttribute : int32_t {
  
  kNone = 0,
  
  kCustomActionDescriptions = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, StringListAttribute value);
inline bool IsKnownEnumValue(StringListAttribute value) {
  return internal::StringListAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ListStyle : int32_t {
  
  kNone = 0,
  
  kCircle = 1,
  
  kDisc = 2,
  
  kImage = 3,
  
  kNumeric = 4,
  
  kSquare = 5,
  
  kOther = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ListStyle value);
inline bool IsKnownEnumValue(ListStyle value) {
  return internal::ListStyle_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MarkerType : int32_t {
  
  kNone = 0,
  
  kSpelling = 1,
  
  kGrammar = 2,
  
  kTextMatch = 4,
  
  kActiveSuggestion = 16,
  
  kSuggestion = 32,
  kMinValue = 0,
  kMaxValue = 32,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, MarkerType value);
inline bool IsKnownEnumValue(MarkerType value) {
  return internal::MarkerType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MoveDirection : int32_t {
  
  kNone = 0,
  
  kBackward = 1,
  
  kForward = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, MoveDirection value);
inline bool IsKnownEnumValue(MoveDirection value) {
  return internal::MoveDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Command : int32_t {
  
  kNone = 0,
  
  kClearSelection = 1,
  
  kDelete = 2,
  
  kDictate = 3,
  
  kExtendSelection = 4,
  
  kFormat = 5,
  
  kHistory = 6,
  
  kInsert = 7,
  
  kMarker = 8,
  
  kMoveSelection = 9,
  
  kSetSelection = 10,
  kMinValue = 0,
  kMaxValue = 10,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Command value);
inline bool IsKnownEnumValue(Command value) {
  return internal::Command_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InputEventType : int32_t {
  
  kNone = 0,
  
  kInsertText = 1,
  
  kInsertLineBreak = 2,
  
  kInsertParagraph = 3,
  
  kInsertOrderedList = 4,
  
  kInsertUnorderedList = 5,
  
  kInsertHorizontalRule = 6,
  
  kInsertFromPaste = 7,
  
  kInsertFromDrop = 8,
  
  kInsertFromYank = 9,
  
  kInsertTranspose = 10,
  
  kInsertReplacementText = 11,
  
  kInsertCompositionText = 12,
  
  kDeleteWordBackward = 13,
  
  kDeleteWordForward = 14,
  
  kDeleteSoftLineBackward = 15,
  
  kDeleteSoftLineForward = 16,
  
  kDeleteHardLineBackward = 17,
  
  kDeleteHardLineForward = 18,
  
  kDeleteContentBackward = 19,
  
  kDeleteContentForward = 20,
  
  kDeleteByCut = 21,
  
  kDeleteByDrag = 22,
  
  kHistoryUndo = 23,
  
  kHistoryRedo = 24,
  
  kFormatBold = 25,
  
  kFormatItalic = 26,
  
  kFormatUnderline = 27,
  
  kFormatStrikeThrough = 28,
  
  kFormatSuperscript = 29,
  
  kFormatSubscript = 30,
  
  kFormatJustifyCenter = 31,
  
  kFormatJustifyFull = 32,
  
  kFormatJustifyRight = 33,
  
  kFormatJustifyLeft = 34,
  
  kFormatIndent = 35,
  
  kFormatOutdent = 36,
  
  kFormatRemove = 37,
  
  kFormatSetBlockTextDirection = 38,
  kMinValue = 0,
  kMaxValue = 38,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, InputEventType value);
inline bool IsKnownEnumValue(InputEventType value) {
  return internal::InputEventType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextBoundary : int32_t {
  
  kNone = 0,
  
  kCharacter = 1,
  
  kFormat = 2,
  
  kLineEnd = 3,
  
  kLineStart = 4,
  
  kLineStartOrEnd = 5,
  
  kObject = 6,
  
  kPageEnd = 7,
  
  kPageStart = 8,
  
  kPageStartOrEnd = 9,
  
  kParagraphEnd = 10,
  
  kParagraphStart = 11,
  
  kParagraphStartOrEnd = 12,
  
  kSentenceEnd = 13,
  
  kSentenceStart = 14,
  
  kSentenceStartOrEnd = 15,
  
  kWebPage = 16,
  
  kWordEnd = 17,
  
  kWordStart = 18,
  
  kWordStartOrEnd = 19,
  kMinValue = 0,
  kMaxValue = 19,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextBoundary value);
inline bool IsKnownEnumValue(TextBoundary value) {
  return internal::TextBoundary_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextAlign : int32_t {
  
  kNone = 0,
  
  kLeft = 1,
  
  kRight = 2,
  
  kCenter = 3,
  
  kJustify = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextAlign value);
inline bool IsKnownEnumValue(TextAlign value) {
  return internal::TextAlign_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WritingDirection : int32_t {
  
  kNone = 0,
  
  kLtr = 1,
  
  kRtl = 2,
  
  kTtb = 3,
  
  kBtt = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, WritingDirection value);
inline bool IsKnownEnumValue(WritingDirection value) {
  return internal::WritingDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextPosition : int32_t {
  
  kNone = 0,
  
  kSubscript = 1,
  
  kSuperscript = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextPosition value);
inline bool IsKnownEnumValue(TextPosition value) {
  return internal::TextPosition_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextStyle : int32_t {
  
  kBold = 0,
  
  kItalic = 1,
  
  kUnderline = 2,
  
  kLineThrough = 3,
  
  kOverline = 4,
  
  kNone = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextStyle value);
inline bool IsKnownEnumValue(TextStyle value) {
  return internal::TextStyle_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextDecorationStyle : int32_t {
  
  kNone = 0,
  
  kDotted = 1,
  
  kDashed = 2,
  
  kSolid = 3,
  
  kDouble = 4,
  
  kWavy = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextDecorationStyle value);
inline bool IsKnownEnumValue(TextDecorationStyle value) {
  return internal::TextDecorationStyle_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AriaCurrentState : int32_t {
  
  kNone = 0,
  
  kFalse = 1,
  
  kTrue = 2,
  
  kPage = 3,
  
  kStep = 4,
  
  kLocation = 5,
  
  kUnclippedLocation = 6,
  
  kDate = 7,
  
  kTime = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, AriaCurrentState value);
inline bool IsKnownEnumValue(AriaCurrentState value) {
  return internal::AriaCurrentState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class HasPopup : int32_t {
  
  kFalse = 0,
  
  kTrue = 1,
  
  kMenu = 2,
  
  kListbox = 3,
  
  kTree = 4,
  
  kGrid = 5,
  
  kDialog = 6,
  
  kNone = 0,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, HasPopup value);
inline bool IsKnownEnumValue(HasPopup value) {
  return internal::HasPopup_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InvalidState : int32_t {
  
  kNone = 0,
  
  kFalse = 1,
  
  kTrue = 2,
  
  kOther = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, InvalidState value);
inline bool IsKnownEnumValue(InvalidState value) {
  return internal::InvalidState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Restriction : int32_t {
  
  kNone = 0,
  
  kReadOnly = 1,
  
  kDisabled = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Restriction value);
inline bool IsKnownEnumValue(Restriction value) {
  return internal::Restriction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CheckedState : int32_t {
  
  kNone = 0,
  
  kFalse = 1,
  
  kTrue = 2,
  
  kMixed = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, CheckedState value);
inline bool IsKnownEnumValue(CheckedState value) {
  return internal::CheckedState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SortDirection : int32_t {
  
  kNone = 0,
  
  kUnsorted = 1,
  
  kAscending = 2,
  
  kDescending = 3,
  
  kOther = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, SortDirection value);
inline bool IsKnownEnumValue(SortDirection value) {
  return internal::SortDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NameFrom : int32_t {
  
  kNone = 0,
  
  kUninitialized = 1,
  
  kAttribute = 2,
  
  kAttributeExplicitlyEmpty = 3,
  
  kCaption = 4,
  
  kContents = 5,
  
  kPlaceholder = 6,
  
  kRelatedElement = 7,
  
  kTitle = 8,
  
  kValue = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, NameFrom value);
inline bool IsKnownEnumValue(NameFrom value) {
  return internal::NameFrom_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DescriptionFrom : int32_t {
  
  kNone = 0,
  
  kUninitialized = 1,
  
  kAttribute = 2,
  
  kContents = 3,
  
  kRelatedElement = 4,
  
  kTitle = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, DescriptionFrom value);
inline bool IsKnownEnumValue(DescriptionFrom value) {
  return internal::DescriptionFrom_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class EventFrom : int32_t {
  
  kNone = 0,
  
  kUser = 1,
  
  kPage = 2,
  
  kAction = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, EventFrom value);
inline bool IsKnownEnumValue(EventFrom value) {
  return internal::EventFrom_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Gesture : int32_t {
  
  kNone = 0,
  
  kClick = 1,
  
  kSwipeLeft1 = 2,
  
  kSwipeUp1 = 3,
  
  kSwipeRight1 = 4,
  
  kSwipeDown1 = 5,
  
  kSwipeLeft2 = 6,
  
  kSwipeUp2 = 7,
  
  kSwipeRight2 = 8,
  
  kSwipeDown2 = 9,
  
  kSwipeLeft3 = 10,
  
  kSwipeUp3 = 11,
  
  kSwipeRight3 = 12,
  
  kSwipeDown3 = 13,
  
  kSwipeLeft4 = 14,
  
  kSwipeUp4 = 15,
  
  kSwipeRight4 = 16,
  
  kSwipeDown4 = 17,
  
  kTap2 = 18,
  
  kTap3 = 19,
  
  kTap4 = 20,
  
  kTouchExplore = 21,
  kMinValue = 0,
  kMaxValue = 21,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Gesture value);
inline bool IsKnownEnumValue(Gesture value) {
  return internal::Gesture_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TextAffinity : int32_t {
  
  kNone = 0,
  
  kDownstream = 1,
  
  kUpstream = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TextAffinity value);
inline bool IsKnownEnumValue(TextAffinity value) {
  return internal::TextAffinity_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TreeOrder : int32_t {
  
  kNone = 0,
  
  kUndefined = 1,
  
  kBefore = 2,
  
  kEqual = 3,
  
  kAfter = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, TreeOrder value);
inline bool IsKnownEnumValue(TreeOrder value) {
  return internal::TreeOrder_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AXTreeIDType : int32_t {
  
  kUnknown = 0,
  
  kToken = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, AXTreeIDType value);
inline bool IsKnownEnumValue(AXTreeIDType value) {
  return internal::AXTreeIDType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ImageAnnotationStatus : int32_t {
  
  kNone = 0,
  
  kWillNotAnnotateDueToScheme = 1,
  
  kIneligibleForAnnotation = 2,
  
  kEligibleForAnnotation = 3,
  
  kSilentlyEligibleForAnnotation = 4,
  
  kAnnotationPending = 5,
  
  kAnnotationSucceeded = 6,
  
  kAnnotationEmpty = 7,
  
  kAnnotationAdult = 8,
  
  kAnnotationProcessFailed = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ImageAnnotationStatus value);
inline bool IsKnownEnumValue(ImageAnnotationStatus value) {
  return internal::ImageAnnotationStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Dropeffect : int32_t {
  
  kNone = 0,
  
  kCopy = 1,
  
  kExecute = 2,
  
  kLink = 3,
  
  kMove = 4,
  
  kPopup = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

COMPONENT_EXPORT(UI_ACCESSIBILITY_AX_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, Dropeffect value);
inline bool IsKnownEnumValue(Dropeffect value) {
  return internal::Dropeffect_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


}  // namespace mojom
}  // namespace ax

namespace std {

template <>
struct hash<::ax::mojom::Event>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Event> {};

template <>
struct hash<::ax::mojom::Role>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Role> {};

template <>
struct hash<::ax::mojom::State>
    : public mojo::internal::EnumHashImpl<::ax::mojom::State> {};

template <>
struct hash<::ax::mojom::Action>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Action> {};

template <>
struct hash<::ax::mojom::ActionFlags>
    : public mojo::internal::EnumHashImpl<::ax::mojom::ActionFlags> {};

template <>
struct hash<::ax::mojom::ScrollAlignment>
    : public mojo::internal::EnumHashImpl<::ax::mojom::ScrollAlignment> {};

template <>
struct hash<::ax::mojom::ScrollBehavior>
    : public mojo::internal::EnumHashImpl<::ax::mojom::ScrollBehavior> {};

template <>
struct hash<::ax::mojom::DefaultActionVerb>
    : public mojo::internal::EnumHashImpl<::ax::mojom::DefaultActionVerb> {};

template <>
struct hash<::ax::mojom::Mutation>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Mutation> {};

template <>
struct hash<::ax::mojom::StringAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::StringAttribute> {};

template <>
struct hash<::ax::mojom::IntAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::IntAttribute> {};

template <>
struct hash<::ax::mojom::FloatAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::FloatAttribute> {};

template <>
struct hash<::ax::mojom::BoolAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::BoolAttribute> {};

template <>
struct hash<::ax::mojom::IntListAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::IntListAttribute> {};

template <>
struct hash<::ax::mojom::StringListAttribute>
    : public mojo::internal::EnumHashImpl<::ax::mojom::StringListAttribute> {};

template <>
struct hash<::ax::mojom::ListStyle>
    : public mojo::internal::EnumHashImpl<::ax::mojom::ListStyle> {};

template <>
struct hash<::ax::mojom::MarkerType>
    : public mojo::internal::EnumHashImpl<::ax::mojom::MarkerType> {};

template <>
struct hash<::ax::mojom::MoveDirection>
    : public mojo::internal::EnumHashImpl<::ax::mojom::MoveDirection> {};

template <>
struct hash<::ax::mojom::Command>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Command> {};

template <>
struct hash<::ax::mojom::InputEventType>
    : public mojo::internal::EnumHashImpl<::ax::mojom::InputEventType> {};

template <>
struct hash<::ax::mojom::TextBoundary>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextBoundary> {};

template <>
struct hash<::ax::mojom::TextAlign>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextAlign> {};

template <>
struct hash<::ax::mojom::WritingDirection>
    : public mojo::internal::EnumHashImpl<::ax::mojom::WritingDirection> {};

template <>
struct hash<::ax::mojom::TextPosition>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextPosition> {};

template <>
struct hash<::ax::mojom::TextStyle>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextStyle> {};

template <>
struct hash<::ax::mojom::TextDecorationStyle>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextDecorationStyle> {};

template <>
struct hash<::ax::mojom::AriaCurrentState>
    : public mojo::internal::EnumHashImpl<::ax::mojom::AriaCurrentState> {};

template <>
struct hash<::ax::mojom::HasPopup>
    : public mojo::internal::EnumHashImpl<::ax::mojom::HasPopup> {};

template <>
struct hash<::ax::mojom::InvalidState>
    : public mojo::internal::EnumHashImpl<::ax::mojom::InvalidState> {};

template <>
struct hash<::ax::mojom::Restriction>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Restriction> {};

template <>
struct hash<::ax::mojom::CheckedState>
    : public mojo::internal::EnumHashImpl<::ax::mojom::CheckedState> {};

template <>
struct hash<::ax::mojom::SortDirection>
    : public mojo::internal::EnumHashImpl<::ax::mojom::SortDirection> {};

template <>
struct hash<::ax::mojom::NameFrom>
    : public mojo::internal::EnumHashImpl<::ax::mojom::NameFrom> {};

template <>
struct hash<::ax::mojom::DescriptionFrom>
    : public mojo::internal::EnumHashImpl<::ax::mojom::DescriptionFrom> {};

template <>
struct hash<::ax::mojom::EventFrom>
    : public mojo::internal::EnumHashImpl<::ax::mojom::EventFrom> {};

template <>
struct hash<::ax::mojom::Gesture>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Gesture> {};

template <>
struct hash<::ax::mojom::TextAffinity>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TextAffinity> {};

template <>
struct hash<::ax::mojom::TreeOrder>
    : public mojo::internal::EnumHashImpl<::ax::mojom::TreeOrder> {};

template <>
struct hash<::ax::mojom::AXTreeIDType>
    : public mojo::internal::EnumHashImpl<::ax::mojom::AXTreeIDType> {};

template <>
struct hash<::ax::mojom::ImageAnnotationStatus>
    : public mojo::internal::EnumHashImpl<::ax::mojom::ImageAnnotationStatus> {};

template <>
struct hash<::ax::mojom::Dropeffect>
    : public mojo::internal::EnumHashImpl<::ax::mojom::Dropeffect> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::ax::mojom::Event, ::ax::mojom::Event> {
  static ::ax::mojom::Event ToMojom(::ax::mojom::Event input) { return input; }
  static bool FromMojom(::ax::mojom::Event input, ::ax::mojom::Event* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Event, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Event, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::Event>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::Role, ::ax::mojom::Role> {
  static ::ax::mojom::Role ToMojom(::ax::mojom::Role input) { return input; }
  static bool FromMojom(::ax::mojom::Role input, ::ax::mojom::Role* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Role, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Role, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::Role>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::State, ::ax::mojom::State> {
  static ::ax::mojom::State ToMojom(::ax::mojom::State input) { return input; }
  static bool FromMojom(::ax::mojom::State input, ::ax::mojom::State* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::State, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::State, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::State>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::Action, ::ax::mojom::Action> {
  static ::ax::mojom::Action ToMojom(::ax::mojom::Action input) { return input; }
  static bool FromMojom(::ax::mojom::Action input, ::ax::mojom::Action* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Action, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Action, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::Action>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::ActionFlags, ::ax::mojom::ActionFlags> {
  static ::ax::mojom::ActionFlags ToMojom(::ax::mojom::ActionFlags input) { return input; }
  static bool FromMojom(::ax::mojom::ActionFlags input, ::ax::mojom::ActionFlags* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::ActionFlags, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::ActionFlags, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::ActionFlags>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::ScrollAlignment, ::ax::mojom::ScrollAlignment> {
  static ::ax::mojom::ScrollAlignment ToMojom(::ax::mojom::ScrollAlignment input) { return input; }
  static bool FromMojom(::ax::mojom::ScrollAlignment input, ::ax::mojom::ScrollAlignment* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::ScrollAlignment, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::ScrollAlignment, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::ScrollAlignment>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::ScrollBehavior, ::ax::mojom::ScrollBehavior> {
  static ::ax::mojom::ScrollBehavior ToMojom(::ax::mojom::ScrollBehavior input) { return input; }
  static bool FromMojom(::ax::mojom::ScrollBehavior input, ::ax::mojom::ScrollBehavior* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::ScrollBehavior, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::ScrollBehavior, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::ScrollBehavior>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::DefaultActionVerb, ::ax::mojom::DefaultActionVerb> {
  static ::ax::mojom::DefaultActionVerb ToMojom(::ax::mojom::DefaultActionVerb input) { return input; }
  static bool FromMojom(::ax::mojom::DefaultActionVerb input, ::ax::mojom::DefaultActionVerb* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::DefaultActionVerb, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::DefaultActionVerb, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::DefaultActionVerb>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::Mutation, ::ax::mojom::Mutation> {
  static ::ax::mojom::Mutation ToMojom(::ax::mojom::Mutation input) { return input; }
  static bool FromMojom(::ax::mojom::Mutation input, ::ax::mojom::Mutation* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Mutation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Mutation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::Mutation>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::StringAttribute, ::ax::mojom::StringAttribute> {
  static ::ax::mojom::StringAttribute ToMojom(::ax::mojom::StringAttribute input) { return input; }
  static bool FromMojom(::ax::mojom::StringAttribute input, ::ax::mojom::StringAttribute* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::StringAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::StringAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::StringAttribute>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::IntAttribute, ::ax::mojom::IntAttribute> {
  static ::ax::mojom::IntAttribute ToMojom(::ax::mojom::IntAttribute input) { return input; }
  static bool FromMojom(::ax::mojom::IntAttribute input, ::ax::mojom::IntAttribute* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::IntAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::IntAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::IntAttribute>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::FloatAttribute, ::ax::mojom::FloatAttribute> {
  static ::ax::mojom::FloatAttribute ToMojom(::ax::mojom::FloatAttribute input) { return input; }
  static bool FromMojom(::ax::mojom::FloatAttribute input, ::ax::mojom::FloatAttribute* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::FloatAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::FloatAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::FloatAttribute>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::BoolAttribute, ::ax::mojom::BoolAttribute> {
  static ::ax::mojom::BoolAttribute ToMojom(::ax::mojom::BoolAttribute input) { return input; }
  static bool FromMojom(::ax::mojom::BoolAttribute input, ::ax::mojom::BoolAttribute* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::BoolAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::BoolAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::BoolAttribute>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::IntListAttribute, ::ax::mojom::IntListAttribute> {
  static ::ax::mojom::IntListAttribute ToMojom(::ax::mojom::IntListAttribute input) { return input; }
  static bool FromMojom(::ax::mojom::IntListAttribute input, ::ax::mojom::IntListAttribute* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::IntListAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::IntListAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::IntListAttribute>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::StringListAttribute, ::ax::mojom::StringListAttribute> {
  static ::ax::mojom::StringListAttribute ToMojom(::ax::mojom::StringListAttribute input) { return input; }
  static bool FromMojom(::ax::mojom::StringListAttribute input, ::ax::mojom::StringListAttribute* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::StringListAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::StringListAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::StringListAttribute>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::ListStyle, ::ax::mojom::ListStyle> {
  static ::ax::mojom::ListStyle ToMojom(::ax::mojom::ListStyle input) { return input; }
  static bool FromMojom(::ax::mojom::ListStyle input, ::ax::mojom::ListStyle* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::ListStyle, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::ListStyle, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::ListStyle>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::MarkerType, ::ax::mojom::MarkerType> {
  static ::ax::mojom::MarkerType ToMojom(::ax::mojom::MarkerType input) { return input; }
  static bool FromMojom(::ax::mojom::MarkerType input, ::ax::mojom::MarkerType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::MarkerType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::MarkerType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::MarkerType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::MoveDirection, ::ax::mojom::MoveDirection> {
  static ::ax::mojom::MoveDirection ToMojom(::ax::mojom::MoveDirection input) { return input; }
  static bool FromMojom(::ax::mojom::MoveDirection input, ::ax::mojom::MoveDirection* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::MoveDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::MoveDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::MoveDirection>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::Command, ::ax::mojom::Command> {
  static ::ax::mojom::Command ToMojom(::ax::mojom::Command input) { return input; }
  static bool FromMojom(::ax::mojom::Command input, ::ax::mojom::Command* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Command, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Command, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::Command>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::InputEventType, ::ax::mojom::InputEventType> {
  static ::ax::mojom::InputEventType ToMojom(::ax::mojom::InputEventType input) { return input; }
  static bool FromMojom(::ax::mojom::InputEventType input, ::ax::mojom::InputEventType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::InputEventType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::InputEventType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::InputEventType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::TextBoundary, ::ax::mojom::TextBoundary> {
  static ::ax::mojom::TextBoundary ToMojom(::ax::mojom::TextBoundary input) { return input; }
  static bool FromMojom(::ax::mojom::TextBoundary input, ::ax::mojom::TextBoundary* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextBoundary, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextBoundary, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::TextBoundary>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::TextAlign, ::ax::mojom::TextAlign> {
  static ::ax::mojom::TextAlign ToMojom(::ax::mojom::TextAlign input) { return input; }
  static bool FromMojom(::ax::mojom::TextAlign input, ::ax::mojom::TextAlign* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextAlign, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextAlign, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::TextAlign>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::WritingDirection, ::ax::mojom::WritingDirection> {
  static ::ax::mojom::WritingDirection ToMojom(::ax::mojom::WritingDirection input) { return input; }
  static bool FromMojom(::ax::mojom::WritingDirection input, ::ax::mojom::WritingDirection* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::WritingDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::WritingDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::WritingDirection>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::TextPosition, ::ax::mojom::TextPosition> {
  static ::ax::mojom::TextPosition ToMojom(::ax::mojom::TextPosition input) { return input; }
  static bool FromMojom(::ax::mojom::TextPosition input, ::ax::mojom::TextPosition* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextPosition, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextPosition, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::TextPosition>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::TextStyle, ::ax::mojom::TextStyle> {
  static ::ax::mojom::TextStyle ToMojom(::ax::mojom::TextStyle input) { return input; }
  static bool FromMojom(::ax::mojom::TextStyle input, ::ax::mojom::TextStyle* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextStyle, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextStyle, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::TextStyle>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::TextDecorationStyle, ::ax::mojom::TextDecorationStyle> {
  static ::ax::mojom::TextDecorationStyle ToMojom(::ax::mojom::TextDecorationStyle input) { return input; }
  static bool FromMojom(::ax::mojom::TextDecorationStyle input, ::ax::mojom::TextDecorationStyle* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextDecorationStyle, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextDecorationStyle, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::TextDecorationStyle>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::AriaCurrentState, ::ax::mojom::AriaCurrentState> {
  static ::ax::mojom::AriaCurrentState ToMojom(::ax::mojom::AriaCurrentState input) { return input; }
  static bool FromMojom(::ax::mojom::AriaCurrentState input, ::ax::mojom::AriaCurrentState* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AriaCurrentState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::AriaCurrentState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::AriaCurrentState>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::HasPopup, ::ax::mojom::HasPopup> {
  static ::ax::mojom::HasPopup ToMojom(::ax::mojom::HasPopup input) { return input; }
  static bool FromMojom(::ax::mojom::HasPopup input, ::ax::mojom::HasPopup* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::HasPopup, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::HasPopup, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::HasPopup>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::InvalidState, ::ax::mojom::InvalidState> {
  static ::ax::mojom::InvalidState ToMojom(::ax::mojom::InvalidState input) { return input; }
  static bool FromMojom(::ax::mojom::InvalidState input, ::ax::mojom::InvalidState* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::InvalidState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::InvalidState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::InvalidState>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::Restriction, ::ax::mojom::Restriction> {
  static ::ax::mojom::Restriction ToMojom(::ax::mojom::Restriction input) { return input; }
  static bool FromMojom(::ax::mojom::Restriction input, ::ax::mojom::Restriction* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Restriction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Restriction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::Restriction>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::CheckedState, ::ax::mojom::CheckedState> {
  static ::ax::mojom::CheckedState ToMojom(::ax::mojom::CheckedState input) { return input; }
  static bool FromMojom(::ax::mojom::CheckedState input, ::ax::mojom::CheckedState* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::CheckedState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::CheckedState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::CheckedState>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::SortDirection, ::ax::mojom::SortDirection> {
  static ::ax::mojom::SortDirection ToMojom(::ax::mojom::SortDirection input) { return input; }
  static bool FromMojom(::ax::mojom::SortDirection input, ::ax::mojom::SortDirection* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::SortDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::SortDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::SortDirection>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::NameFrom, ::ax::mojom::NameFrom> {
  static ::ax::mojom::NameFrom ToMojom(::ax::mojom::NameFrom input) { return input; }
  static bool FromMojom(::ax::mojom::NameFrom input, ::ax::mojom::NameFrom* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::NameFrom, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::NameFrom, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::NameFrom>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::DescriptionFrom, ::ax::mojom::DescriptionFrom> {
  static ::ax::mojom::DescriptionFrom ToMojom(::ax::mojom::DescriptionFrom input) { return input; }
  static bool FromMojom(::ax::mojom::DescriptionFrom input, ::ax::mojom::DescriptionFrom* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::DescriptionFrom, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::DescriptionFrom, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::DescriptionFrom>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::EventFrom, ::ax::mojom::EventFrom> {
  static ::ax::mojom::EventFrom ToMojom(::ax::mojom::EventFrom input) { return input; }
  static bool FromMojom(::ax::mojom::EventFrom input, ::ax::mojom::EventFrom* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::EventFrom, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::EventFrom, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::EventFrom>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::Gesture, ::ax::mojom::Gesture> {
  static ::ax::mojom::Gesture ToMojom(::ax::mojom::Gesture input) { return input; }
  static bool FromMojom(::ax::mojom::Gesture input, ::ax::mojom::Gesture* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Gesture, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Gesture, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::Gesture>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::TextAffinity, ::ax::mojom::TextAffinity> {
  static ::ax::mojom::TextAffinity ToMojom(::ax::mojom::TextAffinity input) { return input; }
  static bool FromMojom(::ax::mojom::TextAffinity input, ::ax::mojom::TextAffinity* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TextAffinity, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TextAffinity, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::TextAffinity>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::TreeOrder, ::ax::mojom::TreeOrder> {
  static ::ax::mojom::TreeOrder ToMojom(::ax::mojom::TreeOrder input) { return input; }
  static bool FromMojom(::ax::mojom::TreeOrder input, ::ax::mojom::TreeOrder* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::TreeOrder, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::TreeOrder, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::TreeOrder>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::AXTreeIDType, ::ax::mojom::AXTreeIDType> {
  static ::ax::mojom::AXTreeIDType ToMojom(::ax::mojom::AXTreeIDType input) { return input; }
  static bool FromMojom(::ax::mojom::AXTreeIDType input, ::ax::mojom::AXTreeIDType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXTreeIDType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::AXTreeIDType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::AXTreeIDType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::ImageAnnotationStatus, ::ax::mojom::ImageAnnotationStatus> {
  static ::ax::mojom::ImageAnnotationStatus ToMojom(::ax::mojom::ImageAnnotationStatus input) { return input; }
  static bool FromMojom(::ax::mojom::ImageAnnotationStatus input, ::ax::mojom::ImageAnnotationStatus* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::ImageAnnotationStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::ImageAnnotationStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::ImageAnnotationStatus>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::ax::mojom::Dropeffect, ::ax::mojom::Dropeffect> {
  static ::ax::mojom::Dropeffect ToMojom(::ax::mojom::Dropeffect input) { return input; }
  static bool FromMojom(::ax::mojom::Dropeffect input, ::ax::mojom::Dropeffect* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::Dropeffect, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::ax::mojom::Dropeffect, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::ax::mojom::Dropeffect>(input), output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax {
namespace mojom {


}  // namespace mojom
}  // namespace ax

#endif  // UI_ACCESSIBILITY_AX_ENUMS_MOJOM_SHARED_H_