// ui/gfx/mojom/selection_bound.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/gfx/mojom/selection_bound.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace gfx {
namespace mojom {
class SelectionBoundDataView;



}  // namespace mojom
}  // namespace gfx

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::SelectionBoundDataView> {
  using Data = ::gfx::mojom::internal::SelectionBound_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx {
namespace mojom {


enum class SelectionBoundType : int32_t {
  
  LEFT = 0,
  
  RIGHT = 1,
  
  CENTER = 2,
  
  EMPTY = 3,
  
  LAST = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, SelectionBoundType value);
inline bool IsKnownEnumValue(SelectionBoundType value) {
  return internal::SelectionBoundType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SelectionBoundDataView {
 public:
  SelectionBoundDataView() {}

  SelectionBoundDataView(
      internal::SelectionBound_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::gfx::mojom::SelectionBoundType>(
        data_value, output);
  }

  SelectionBoundType type() const {
    return static_cast<SelectionBoundType>(data_->type);
  }
  inline void GetEdgeStartDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEdgeStart(UserType* output) {
    
    auto* pointer = data_->edge_start.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  inline void GetEdgeEndDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEdgeEnd(UserType* output) {
    
    auto* pointer = data_->edge_end.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  inline void GetVisibleEdgeStartDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVisibleEdgeStart(UserType* output) {
    
    auto* pointer = data_->visible_edge_start.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  inline void GetVisibleEdgeEndDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVisibleEdgeEnd(UserType* output) {
    
    auto* pointer = data_->visible_edge_end.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, context_);
  }
  bool visible() const {
    return data_->visible;
  }
 private:
  internal::SelectionBound_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace gfx

namespace std {

template <>
struct hash<::gfx::mojom::SelectionBoundType>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::SelectionBoundType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::gfx::mojom::SelectionBoundType, ::gfx::mojom::SelectionBoundType> {
  static ::gfx::mojom::SelectionBoundType ToMojom(::gfx::mojom::SelectionBoundType input) { return input; }
  static bool FromMojom(::gfx::mojom::SelectionBoundType input, ::gfx::mojom::SelectionBoundType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::SelectionBoundType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::SelectionBoundType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::gfx::mojom::SelectionBoundType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::SelectionBoundDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::SelectionBoundDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gfx::mojom::internal::SelectionBound_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::gfx::mojom::SelectionBoundType>(
        Traits::type(input), &(*output)->type);
    decltype(Traits::edge_start(input)) in_edge_start = Traits::edge_start(input);
    typename decltype((*output)->edge_start)::BaseType::BufferWriter
        edge_start_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_edge_start, buffer, &edge_start_writer, context);
    (*output)->edge_start.Set(
        edge_start_writer.is_null() ? nullptr : edge_start_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->edge_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null edge_start in SelectionBound struct");
    decltype(Traits::edge_end(input)) in_edge_end = Traits::edge_end(input);
    typename decltype((*output)->edge_end)::BaseType::BufferWriter
        edge_end_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_edge_end, buffer, &edge_end_writer, context);
    (*output)->edge_end.Set(
        edge_end_writer.is_null() ? nullptr : edge_end_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->edge_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null edge_end in SelectionBound struct");
    decltype(Traits::visible_edge_start(input)) in_visible_edge_start = Traits::visible_edge_start(input);
    typename decltype((*output)->visible_edge_start)::BaseType::BufferWriter
        visible_edge_start_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_visible_edge_start, buffer, &visible_edge_start_writer, context);
    (*output)->visible_edge_start.Set(
        visible_edge_start_writer.is_null() ? nullptr : visible_edge_start_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->visible_edge_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_edge_start in SelectionBound struct");
    decltype(Traits::visible_edge_end(input)) in_visible_edge_end = Traits::visible_edge_end(input);
    typename decltype((*output)->visible_edge_end)::BaseType::BufferWriter
        visible_edge_end_writer;
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_visible_edge_end, buffer, &visible_edge_end_writer, context);
    (*output)->visible_edge_end.Set(
        visible_edge_end_writer.is_null() ? nullptr : visible_edge_end_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->visible_edge_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_edge_end in SelectionBound struct");
    (*output)->visible = Traits::visible(input);
  }

  static bool Deserialize(::gfx::mojom::internal::SelectionBound_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::SelectionBoundDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx {
namespace mojom {

inline void SelectionBoundDataView::GetEdgeStartDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->edge_start.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void SelectionBoundDataView::GetEdgeEndDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->edge_end.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void SelectionBoundDataView::GetVisibleEdgeStartDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->visible_edge_start.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}
inline void SelectionBoundDataView::GetVisibleEdgeEndDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->visible_edge_end.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace gfx

#endif  // UI_GFX_MOJOM_SELECTION_BOUND_MOJOM_SHARED_H_