'use strict';

var ta = require('./tassembly.js');
var assert = require('assert');

var startTime = new Date(),
	vars = {},
	template = ta.compile(['<div',['attr',{id:"rm.echo('a [m.foo')"}],'>',['text','m.body'],'</div>']);
	vars.echo = function(e) {
		return e;
	};
for (var n = 0; n <= 100000; ++n ) {
	vars.id = "divid";
	vars.body = 'my div\'s body';
	var html = template(vars);
}
console.log("time: " + ((new Date() - startTime) / 1000));
console.log(html);


var cases = [
    {
        name: 'Backslashes',
        input: [['raw',"'foo\\\\.bar'"]],
        output: 'foo\\\\.bar',
    },
    {
        name: 'Backslashes, 2',
        input: [['raw',"'foo\\'.bar'"]],
        output: "foo'.bar",
    },
];

function makeTests() {
    var tests = {};
    cases.forEach(function(c) {
        tests[c.name] = function() {
            assert.deepEqual(c.output, ta.compile(c.input)());
        };
    });
    return tests;
}


module.exports = {
    "cases": makeTests()
};



